/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfiguration.Builder, NotificationConfiguration> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(NotificationConfiguration::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicARN").getter(getter(NotificationConfiguration::topicARN)).setter(setter(Builder::topicARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicARN").build()).build();

    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationType").getter(getter(NotificationConfiguration::notificationType))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            TOPIC_ARN_FIELD, NOTIFICATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoScalingGroupName;

    private final String topicARN;

    private final String notificationType;

    private NotificationConfiguration(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationType = builder.notificationType;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic.
     */
    public final String topicARN() {
        return topicARN;
    }

    /**
     * <p>
     * One of the following event notification types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:TEST_NOTIFICATION</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following event notification types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:TEST_NOTIFICATION</code>
     *         </p>
     *         </li>
     */
    public final String notificationType() {
        return notificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(notificationType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(topicARN(), other.topicARN()) && Objects.equals(notificationType(), other.notificationType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfiguration").add("AutoScalingGroupName", autoScalingGroupName())
                .add("TopicARN", topicARN()).add("NotificationType", notificationType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "TopicARN":
            return Optional.ofNullable(clazz.cast(topicARN()));
        case "NotificationType":
            return Optional.ofNullable(clazz.cast(notificationType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfiguration> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic.
         * </p>
         * 
         * @param topicARN
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);

        /**
         * <p>
         * One of the following event notification types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:TEST_NOTIFICATION</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        One of the following event notification types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:TEST_NOTIFICATION</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationType(String notificationType);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String topicARN;

        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            autoScalingGroupName(model.autoScalingGroupName);
            topicARN(model.topicARN);
            notificationType(model.notificationType);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getTopicARN() {
            return topicARN;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        @Override
        @Transient
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        @Transient
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
