/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePoliciesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DescribePoliciesRequest.Builder, DescribePoliciesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(DescribePoliciesRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyNames")
            .getter(getter(DescribePoliciesRequest::policyNames))
            .setter(setter(Builder::policyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> POLICY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyTypes")
            .getter(getter(DescribePoliciesRequest::policyTypes))
            .setter(setter(Builder::policyTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePoliciesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribePoliciesRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            POLICY_NAMES_FIELD, POLICY_TYPES_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD));

    private final String autoScalingGroupName;

    private final List<String> policyNames;

    private final List<String> policyTypes;

    private final String nextToken;

    private final Integer maxRecords;

    private DescribePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyNames = builder.policyNames;
        this.policyTypes = builder.policyTypes;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyNames() {
        return policyNames != null && !(policyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of one or more policies. If you omit this parameter, all policies are described. If a group name is
     * provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no
     * error.
     * </p>
     * <p>
     * Array Members: Maximum number of 50 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyNames} method.
     * </p>
     * 
     * @return The names of one or more policies. If you omit this parameter, all policies are described. If a group
     *         name is provided, the results are limited to that group. If you specify an unknown policy name, it is
     *         ignored with no error.</p>
     *         <p>
     *         Array Members: Maximum number of 50 items.
     */
    public final List<String> policyNames() {
        return policyNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyTypes() {
        return policyTypes != null && !(policyTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>,
     * <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyTypes} method.
     * </p>
     * 
     * @return One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>,
     *         <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.
     */
    public final List<String> policyTypes() {
        return policyTypes;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be returned with each call. The default value is <code>50</code> and the maximum
     * value is <code>100</code>.
     * </p>
     * 
     * @return The maximum number of items to be returned with each call. The default value is <code>50</code> and the
     *         maximum value is <code>100</code>.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyNames() ? policyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyTypes() ? policyTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoliciesRequest)) {
            return false;
        }
        DescribePoliciesRequest other = (DescribePoliciesRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName()) && hasPolicyNames() == other.hasPolicyNames()
                && Objects.equals(policyNames(), other.policyNames()) && hasPolicyTypes() == other.hasPolicyTypes()
                && Objects.equals(policyTypes(), other.policyTypes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePoliciesRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("PolicyNames", hasPolicyNames() ? policyNames() : null)
                .add("PolicyTypes", hasPolicyTypes() ? policyTypes() : null).add("NextToken", nextToken())
                .add("MaxRecords", maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "PolicyNames":
            return Optional.ofNullable(clazz.cast(policyNames()));
        case "PolicyTypes":
            return Optional.ofNullable(clazz.cast(policyTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePoliciesRequest, T> g) {
        return obj -> g.apply((DescribePoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePoliciesRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The names of one or more policies. If you omit this parameter, all policies are described. If a group name is
         * provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no
         * error.
         * </p>
         * <p>
         * Array Members: Maximum number of 50 items.
         * </p>
         * 
         * @param policyNames
         *        The names of one or more policies. If you omit this parameter, all policies are described. If a group
         *        name is provided, the results are limited to that group. If you specify an unknown policy name, it is
         *        ignored with no error.</p>
         *        <p>
         *        Array Members: Maximum number of 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(Collection<String> policyNames);

        /**
         * <p>
         * The names of one or more policies. If you omit this parameter, all policies are described. If a group name is
         * provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no
         * error.
         * </p>
         * <p>
         * Array Members: Maximum number of 50 items.
         * </p>
         * 
         * @param policyNames
         *        The names of one or more policies. If you omit this parameter, all policies are described. If a group
         *        name is provided, the results are limited to that group. If you specify an unknown policy name, it is
         *        ignored with no error.</p>
         *        <p>
         *        Array Members: Maximum number of 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(String... policyNames);

        /**
         * <p>
         * One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>,
         * <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.
         * </p>
         * 
         * @param policyTypes
         *        One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>,
         *        <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypes(Collection<String> policyTypes);

        /**
         * <p>
         * One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>,
         * <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.
         * </p>
         * 
         * @param policyTypes
         *        One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>,
         *        <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypes(String... policyTypes);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be returned with each call. The default value is <code>50</code> and the
         * maximum value is <code>100</code>.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to be returned with each call. The default value is <code>50</code> and
         *        the maximum value is <code>100</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> policyTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoliciesRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            policyNames(model.policyNames);
            policyTypes(model.policyTypes);
            nextToken(model.nextToken);
            maxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Collection<String> getPolicyNames() {
            if (policyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return policyNames;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String... policyNames) {
            policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final Collection<String> getPolicyTypes() {
            if (policyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return policyTypes;
        }

        public final void setPolicyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
        }

        @Override
        public final Builder policyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(String... policyTypes) {
            policyTypes(Arrays.asList(policyTypes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePoliciesRequest build() {
            return new DescribePoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
