/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutWarmPoolRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutWarmPoolRequest.Builder, PutWarmPoolRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(PutWarmPoolRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<Integer> MAX_GROUP_PREPARED_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxGroupPreparedCapacity")
            .getter(getter(PutWarmPoolRequest::maxGroupPreparedCapacity)).setter(setter(Builder::maxGroupPreparedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxGroupPreparedCapacity").build())
            .build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(PutWarmPoolRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<String> POOL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolState").getter(getter(PutWarmPoolRequest::poolStateAsString)).setter(setter(Builder::poolState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolState").build()).build();

    private static final SdkField<InstanceReusePolicy> INSTANCE_REUSE_POLICY_FIELD = SdkField
            .<InstanceReusePolicy> builder(MarshallingType.SDK_POJO).memberName("InstanceReusePolicy")
            .getter(getter(PutWarmPoolRequest::instanceReusePolicy)).setter(setter(Builder::instanceReusePolicy))
            .constructor(InstanceReusePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceReusePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            MAX_GROUP_PREPARED_CAPACITY_FIELD, MIN_SIZE_FIELD, POOL_STATE_FIELD, INSTANCE_REUSE_POLICY_FIELD));

    private final String autoScalingGroupName;

    private final Integer maxGroupPreparedCapacity;

    private final Integer minSize;

    private final String poolState;

    private final InstanceReusePolicy instanceReusePolicy;

    private PutWarmPoolRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.maxGroupPreparedCapacity = builder.maxGroupPreparedCapacity;
        this.minSize = builder.minSize;
        this.poolState = builder.poolState;
        this.instanceReusePolicy = builder.instanceReusePolicy;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except
     * <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you do not
     * want the warm pool size to be determined by the difference between the group's maximum capacity and its desired
     * capacity.
     * </p>
     * <important>
     * <p>
     * If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and
     * maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value
     * for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference between the
     * <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
     * </p>
     * <p>
     * The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code>
     * are set to the same value does the warm pool have an absolute size.
     * </p>
     * </important>
     * <p>
     * If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code>, the
     * capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code>. To remove a value that you
     * previously set, include the property but specify -1 for the value.
     * </p>
     * 
     * @return Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except
     *         <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you
     *         do not want the warm pool size to be determined by the difference between the group's maximum capacity
     *         and its desired capacity. </p> <important>
     *         <p>
     *         If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches
     *         and maintains the difference between the group's maximum capacity and its desired capacity. If you
     *         specify a value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference
     *         between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
     *         </p>
     *         <p>
     *         The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and
     *         <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
     *         </p>
     *         </important>
     *         <p>
     *         If the desired capacity of the Auto Scaling group is higher than the
     *         <code>MaxGroupPreparedCapacity</code>, the capacity of the warm pool is 0, unless you specify a value for
     *         <code>MinSize</code>. To remove a value that you previously set, include the property but specify -1 for
     *         the value.
     */
    public final Integer maxGroupPreparedCapacity() {
        return maxGroupPreparedCapacity;
    }

    /**
     * <p>
     * Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is
     * always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
     * </p>
     * 
     * @return Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that
     *         there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if
     *         not specified.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * Sets the instance state to transition to after the lifecycle actions are complete. Default is
     * <code>Stopped</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolState} will
     * return {@link WarmPoolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #poolStateAsString}.
     * </p>
     * 
     * @return Sets the instance state to transition to after the lifecycle actions are complete. Default is
     *         <code>Stopped</code>.
     * @see WarmPoolState
     */
    public final WarmPoolState poolState() {
        return WarmPoolState.fromValue(poolState);
    }

    /**
     * <p>
     * Sets the instance state to transition to after the lifecycle actions are complete. Default is
     * <code>Stopped</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolState} will
     * return {@link WarmPoolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #poolStateAsString}.
     * </p>
     * 
     * @return Sets the instance state to transition to after the lifecycle actions are complete. Default is
     *         <code>Stopped</code>.
     * @see WarmPoolState
     */
    public final String poolStateAsString() {
        return poolState;
    }

    /**
     * <p>
     * Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default
     * is to terminate instances in the Auto Scaling group when the group scales in.
     * </p>
     * 
     * @return Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The
     *         default is to terminate instances in the Auto Scaling group when the group scales in.
     */
    public final InstanceReusePolicy instanceReusePolicy() {
        return instanceReusePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(maxGroupPreparedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(poolStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceReusePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutWarmPoolRequest)) {
            return false;
        }
        PutWarmPoolRequest other = (PutWarmPoolRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(maxGroupPreparedCapacity(), other.maxGroupPreparedCapacity())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(poolStateAsString(), other.poolStateAsString())
                && Objects.equals(instanceReusePolicy(), other.instanceReusePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutWarmPoolRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("MaxGroupPreparedCapacity", maxGroupPreparedCapacity()).add("MinSize", minSize())
                .add("PoolState", poolStateAsString()).add("InstanceReusePolicy", instanceReusePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "MaxGroupPreparedCapacity":
            return Optional.ofNullable(clazz.cast(maxGroupPreparedCapacity()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "PoolState":
            return Optional.ofNullable(clazz.cast(poolStateAsString()));
        case "InstanceReusePolicy":
            return Optional.ofNullable(clazz.cast(instanceReusePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutWarmPoolRequest, T> g) {
        return obj -> g.apply((PutWarmPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutWarmPoolRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except
         * <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you do
         * not want the warm pool size to be determined by the difference between the group's maximum capacity and its
         * desired capacity.
         * </p>
         * <important>
         * <p>
         * If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and
         * maintains the difference between the group's maximum capacity and its desired capacity. If you specify a
         * value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference between the
         * <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
         * </p>
         * <p>
         * The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and
         * <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
         * </p>
         * </important>
         * <p>
         * If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code>,
         * the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code>. To remove a value
         * that you previously set, include the property but specify -1 for the value.
         * </p>
         * 
         * @param maxGroupPreparedCapacity
         *        Specifies the maximum number of instances that are allowed to be in the warm pool or in any state
         *        except <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it
         *        only if you do not want the warm pool size to be determined by the difference between the group's
         *        maximum capacity and its desired capacity. </p> <important>
         *        <p>
         *        If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling
         *        launches and maintains the difference between the group's maximum capacity and its desired capacity.
         *        If you specify a value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the
         *        difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
         *        </p>
         *        <p>
         *        The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and
         *        <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
         *        </p>
         *        </important>
         *        <p>
         *        If the desired capacity of the Auto Scaling group is higher than the
         *        <code>MaxGroupPreparedCapacity</code>, the capacity of the warm pool is 0, unless you specify a value
         *        for <code>MinSize</code>. To remove a value that you previously set, include the property but specify
         *        -1 for the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxGroupPreparedCapacity(Integer maxGroupPreparedCapacity);

        /**
         * <p>
         * Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there
         * is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not
         * specified.
         * </p>
         * 
         * @param minSize
         *        Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that
         *        there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0
         *        if not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * Sets the instance state to transition to after the lifecycle actions are complete. Default is
         * <code>Stopped</code>.
         * </p>
         * 
         * @param poolState
         *        Sets the instance state to transition to after the lifecycle actions are complete. Default is
         *        <code>Stopped</code>.
         * @see WarmPoolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolState
         */
        Builder poolState(String poolState);

        /**
         * <p>
         * Sets the instance state to transition to after the lifecycle actions are complete. Default is
         * <code>Stopped</code>.
         * </p>
         * 
         * @param poolState
         *        Sets the instance state to transition to after the lifecycle actions are complete. Default is
         *        <code>Stopped</code>.
         * @see WarmPoolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolState
         */
        Builder poolState(WarmPoolState poolState);

        /**
         * <p>
         * Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The
         * default is to terminate instances in the Auto Scaling group when the group scales in.
         * </p>
         * 
         * @param instanceReusePolicy
         *        Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
         *        The default is to terminate instances in the Auto Scaling group when the group scales in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceReusePolicy(InstanceReusePolicy instanceReusePolicy);

        /**
         * <p>
         * Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The
         * default is to terminate instances in the Auto Scaling group when the group scales in.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceReusePolicy.Builder} avoiding the
         * need to create one manually via {@link InstanceReusePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceReusePolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceReusePolicy(InstanceReusePolicy)}.
         * 
         * @param instanceReusePolicy
         *        a consumer that will call methods on {@link InstanceReusePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceReusePolicy(InstanceReusePolicy)
         */
        default Builder instanceReusePolicy(Consumer<InstanceReusePolicy.Builder> instanceReusePolicy) {
            return instanceReusePolicy(InstanceReusePolicy.builder().applyMutation(instanceReusePolicy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private Integer maxGroupPreparedCapacity;

        private Integer minSize;

        private String poolState;

        private InstanceReusePolicy instanceReusePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutWarmPoolRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            maxGroupPreparedCapacity(model.maxGroupPreparedCapacity);
            minSize(model.minSize);
            poolState(model.poolState);
            instanceReusePolicy(model.instanceReusePolicy);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Integer getMaxGroupPreparedCapacity() {
            return maxGroupPreparedCapacity;
        }

        public final void setMaxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
        }

        @Override
        public final Builder maxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final String getPoolState() {
            return poolState;
        }

        public final void setPoolState(String poolState) {
            this.poolState = poolState;
        }

        @Override
        public final Builder poolState(String poolState) {
            this.poolState = poolState;
            return this;
        }

        @Override
        public final Builder poolState(WarmPoolState poolState) {
            this.poolState(poolState == null ? null : poolState.toString());
            return this;
        }

        public final InstanceReusePolicy.Builder getInstanceReusePolicy() {
            return instanceReusePolicy != null ? instanceReusePolicy.toBuilder() : null;
        }

        public final void setInstanceReusePolicy(InstanceReusePolicy.BuilderImpl instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy != null ? instanceReusePolicy.build() : null;
        }

        @Override
        public final Builder instanceReusePolicy(InstanceReusePolicy instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutWarmPoolRequest build() {
            return new PutWarmPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
