/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockDeviceMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockDeviceMapping.Builder, BlockDeviceMapping> {
    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualName").getter(getter(BlockDeviceMapping::virtualName)).setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(BlockDeviceMapping::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<Ebs> EBS_FIELD = SdkField.<Ebs> builder(MarshallingType.SDK_POJO).memberName("Ebs")
            .getter(getter(BlockDeviceMapping::ebs)).setter(setter(Builder::ebs)).constructor(Ebs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").build()).build();

    private static final SdkField<Boolean> NO_DEVICE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoDevice").getter(getter(BlockDeviceMapping::noDevice)).setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_NAME_FIELD,
            DEVICE_NAME_FIELD, EBS_FIELD, NO_DEVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualName;

    private final String deviceName;

    private final Ebs ebs;

    private final Boolean noDevice;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.virtualName = builder.virtualName;
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    /**
     * <p>
     * The name of the virtual device (for example, <code>ephemeral0</code>).
     * </p>
     * <p>
     * You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
     * </p>
     * 
     * @return The name of the virtual device (for example, <code>ephemeral0</code>).</p>
     *         <p>
     *         You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
     */
    public final String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>). For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming
     * on Linux Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming on Linux
     *         Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters used to automatically set up EBS volumes when an instance is launched.
     * </p>
     * <p>
     * You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
     * </p>
     * 
     * @return Parameters used to automatically set up EBS volumes when an instance is launched.</p>
     *         <p>
     *         You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
     */
    public final Ebs ebs() {
        return ebs;
    }

    /**
     * <p>
     * Setting this value to <code>true</code> suppresses the specified device included in the block device mapping of
     * the AMI.
     * </p>
     * <p>
     * If <code>NoDevice</code> is <code>true</code> for the root device, instances might fail the EC2 health check. In
     * that case, Amazon EC2 Auto Scaling launches replacement instances.
     * </p>
     * <p>
     * If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.
     * </p>
     * 
     * @return Setting this value to <code>true</code> suppresses the specified device included in the block device
     *         mapping of the AMI.</p>
     *         <p>
     *         If <code>NoDevice</code> is <code>true</code> for the root device, instances might fail the EC2 health
     *         check. In that case, Amazon EC2 Auto Scaling launches replacement instances.
     *         </p>
     *         <p>
     *         If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.
     */
    public final Boolean noDevice() {
        return noDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping) obj;
        return Objects.equals(virtualName(), other.virtualName()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(ebs(), other.ebs()) && Objects.equals(noDevice(), other.noDevice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockDeviceMapping").add("VirtualName", virtualName()).add("DeviceName", deviceName())
                .add("Ebs", ebs()).add("NoDevice", noDevice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockDeviceMapping, T> g) {
        return obj -> g.apply((BlockDeviceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockDeviceMapping> {
        /**
         * <p>
         * The name of the virtual device (for example, <code>ephemeral0</code>).
         * </p>
         * <p>
         * You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
         * </p>
         * 
         * @param virtualName
         *        The name of the virtual device (for example, <code>ephemeral0</code>).</p>
         *        <p>
         *        You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>). For
         * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device
         * Naming on Linux Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param deviceName
         *        The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming on Linux
         *        Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when an instance is launched.
         * </p>
         * <p>
         * You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up EBS volumes when an instance is launched.</p>
         *        <p>
         *        You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(Ebs ebs);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when an instance is launched.
         * </p>
         * <p>
         * You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ebs.Builder} avoiding the need to create
         * one manually via {@link Ebs#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ebs.Builder#build()} is called immediately and its result is
         * passed to {@link #ebs(Ebs)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link Ebs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(Ebs)
         */
        default Builder ebs(Consumer<Ebs.Builder> ebs) {
            return ebs(Ebs.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * Setting this value to <code>true</code> suppresses the specified device included in the block device mapping
         * of the AMI.
         * </p>
         * <p>
         * If <code>NoDevice</code> is <code>true</code> for the root device, instances might fail the EC2 health check.
         * In that case, Amazon EC2 Auto Scaling launches replacement instances.
         * </p>
         * <p>
         * If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.
         * </p>
         * 
         * @param noDevice
         *        Setting this value to <code>true</code> suppresses the specified device included in the block device
         *        mapping of the AMI.</p>
         *        <p>
         *        If <code>NoDevice</code> is <code>true</code> for the root device, instances might fail the EC2 health
         *        check. In that case, Amazon EC2 Auto Scaling launches replacement instances.
         *        </p>
         *        <p>
         *        If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(Boolean noDevice);
    }

    static final class BuilderImpl implements Builder {
        private String virtualName;

        private String deviceName;

        private Ebs ebs;

        private Boolean noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            virtualName(model.virtualName);
            deviceName(model.deviceName);
            ebs(model.ebs);
            noDevice(model.noDevice);
        }

        public final String getVirtualName() {
            return virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Ebs.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        public final void setEbs(Ebs.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(Ebs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final Boolean getNoDevice() {
            return noDevice;
        }

        public final void setNoDevice(Boolean noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public final Builder noDevice(Boolean noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        @Override
        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
