/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a warm pool configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarmPoolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WarmPoolConfiguration.Builder, WarmPoolConfiguration> {
    private static final SdkField<Integer> MAX_GROUP_PREPARED_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxGroupPreparedCapacity")
            .getter(getter(WarmPoolConfiguration::maxGroupPreparedCapacity)).setter(setter(Builder::maxGroupPreparedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxGroupPreparedCapacity").build())
            .build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(WarmPoolConfiguration::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<String> POOL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolState").getter(getter(WarmPoolConfiguration::poolStateAsString)).setter(setter(Builder::poolState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolState").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(WarmPoolConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<InstanceReusePolicy> INSTANCE_REUSE_POLICY_FIELD = SdkField
            .<InstanceReusePolicy> builder(MarshallingType.SDK_POJO).memberName("InstanceReusePolicy")
            .getter(getter(WarmPoolConfiguration::instanceReusePolicy)).setter(setter(Builder::instanceReusePolicy))
            .constructor(InstanceReusePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceReusePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_GROUP_PREPARED_CAPACITY_FIELD, MIN_SIZE_FIELD, POOL_STATE_FIELD, STATUS_FIELD, INSTANCE_REUSE_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxGroupPreparedCapacity;

    private final Integer minSize;

    private final String poolState;

    private final String status;

    private final InstanceReusePolicy instanceReusePolicy;

    private WarmPoolConfiguration(BuilderImpl builder) {
        this.maxGroupPreparedCapacity = builder.maxGroupPreparedCapacity;
        this.minSize = builder.minSize;
        this.poolState = builder.poolState;
        this.status = builder.status;
        this.instanceReusePolicy = builder.instanceReusePolicy;
    }

    /**
     * <p>
     * The maximum number of instances that are allowed to be in the warm pool or in any state except
     * <code>Terminated</code> for the Auto Scaling group.
     * </p>
     * 
     * @return The maximum number of instances that are allowed to be in the warm pool or in any state except
     *         <code>Terminated</code> for the Auto Scaling group.
     */
    public final Integer maxGroupPreparedCapacity() {
        return maxGroupPreparedCapacity;
    }

    /**
     * <p>
     * The minimum number of instances to maintain in the warm pool.
     * </p>
     * 
     * @return The minimum number of instances to maintain in the warm pool.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The instance state to transition to after the lifecycle actions are complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolState} will
     * return {@link WarmPoolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #poolStateAsString}.
     * </p>
     * 
     * @return The instance state to transition to after the lifecycle actions are complete.
     * @see WarmPoolState
     */
    public final WarmPoolState poolState() {
        return WarmPoolState.fromValue(poolState);
    }

    /**
     * <p>
     * The instance state to transition to after the lifecycle actions are complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolState} will
     * return {@link WarmPoolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #poolStateAsString}.
     * </p>
     * 
     * @return The instance state to transition to after the lifecycle actions are complete.
     * @see WarmPoolState
     */
    public final String poolStateAsString() {
        return poolState;
    }

    /**
     * <p>
     * The status of a warm pool that is marked for deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WarmPoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a warm pool that is marked for deletion.
     * @see WarmPoolStatus
     */
    public final WarmPoolStatus status() {
        return WarmPoolStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a warm pool that is marked for deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WarmPoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a warm pool that is marked for deletion.
     * @see WarmPoolStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The instance reuse policy.
     * </p>
     * 
     * @return The instance reuse policy.
     */
    public final InstanceReusePolicy instanceReusePolicy() {
        return instanceReusePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxGroupPreparedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(poolStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceReusePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarmPoolConfiguration)) {
            return false;
        }
        WarmPoolConfiguration other = (WarmPoolConfiguration) obj;
        return Objects.equals(maxGroupPreparedCapacity(), other.maxGroupPreparedCapacity())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(poolStateAsString(), other.poolStateAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(instanceReusePolicy(), other.instanceReusePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarmPoolConfiguration").add("MaxGroupPreparedCapacity", maxGroupPreparedCapacity())
                .add("MinSize", minSize()).add("PoolState", poolStateAsString()).add("Status", statusAsString())
                .add("InstanceReusePolicy", instanceReusePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxGroupPreparedCapacity":
            return Optional.ofNullable(clazz.cast(maxGroupPreparedCapacity()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "PoolState":
            return Optional.ofNullable(clazz.cast(poolStateAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InstanceReusePolicy":
            return Optional.ofNullable(clazz.cast(instanceReusePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WarmPoolConfiguration, T> g) {
        return obj -> g.apply((WarmPoolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarmPoolConfiguration> {
        /**
         * <p>
         * The maximum number of instances that are allowed to be in the warm pool or in any state except
         * <code>Terminated</code> for the Auto Scaling group.
         * </p>
         * 
         * @param maxGroupPreparedCapacity
         *        The maximum number of instances that are allowed to be in the warm pool or in any state except
         *        <code>Terminated</code> for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxGroupPreparedCapacity(Integer maxGroupPreparedCapacity);

        /**
         * <p>
         * The minimum number of instances to maintain in the warm pool.
         * </p>
         * 
         * @param minSize
         *        The minimum number of instances to maintain in the warm pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The instance state to transition to after the lifecycle actions are complete.
         * </p>
         * 
         * @param poolState
         *        The instance state to transition to after the lifecycle actions are complete.
         * @see WarmPoolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolState
         */
        Builder poolState(String poolState);

        /**
         * <p>
         * The instance state to transition to after the lifecycle actions are complete.
         * </p>
         * 
         * @param poolState
         *        The instance state to transition to after the lifecycle actions are complete.
         * @see WarmPoolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolState
         */
        Builder poolState(WarmPoolState poolState);

        /**
         * <p>
         * The status of a warm pool that is marked for deletion.
         * </p>
         * 
         * @param status
         *        The status of a warm pool that is marked for deletion.
         * @see WarmPoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a warm pool that is marked for deletion.
         * </p>
         * 
         * @param status
         *        The status of a warm pool that is marked for deletion.
         * @see WarmPoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolStatus
         */
        Builder status(WarmPoolStatus status);

        /**
         * <p>
         * The instance reuse policy.
         * </p>
         * 
         * @param instanceReusePolicy
         *        The instance reuse policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceReusePolicy(InstanceReusePolicy instanceReusePolicy);

        /**
         * <p>
         * The instance reuse policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceReusePolicy.Builder} avoiding the
         * need to create one manually via {@link InstanceReusePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceReusePolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceReusePolicy(InstanceReusePolicy)}.
         * 
         * @param instanceReusePolicy
         *        a consumer that will call methods on {@link InstanceReusePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceReusePolicy(InstanceReusePolicy)
         */
        default Builder instanceReusePolicy(Consumer<InstanceReusePolicy.Builder> instanceReusePolicy) {
            return instanceReusePolicy(InstanceReusePolicy.builder().applyMutation(instanceReusePolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer maxGroupPreparedCapacity;

        private Integer minSize;

        private String poolState;

        private String status;

        private InstanceReusePolicy instanceReusePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(WarmPoolConfiguration model) {
            maxGroupPreparedCapacity(model.maxGroupPreparedCapacity);
            minSize(model.minSize);
            poolState(model.poolState);
            status(model.status);
            instanceReusePolicy(model.instanceReusePolicy);
        }

        public final Integer getMaxGroupPreparedCapacity() {
            return maxGroupPreparedCapacity;
        }

        public final void setMaxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
        }

        @Override
        public final Builder maxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final String getPoolState() {
            return poolState;
        }

        public final void setPoolState(String poolState) {
            this.poolState = poolState;
        }

        @Override
        public final Builder poolState(String poolState) {
            this.poolState = poolState;
            return this;
        }

        @Override
        public final Builder poolState(WarmPoolState poolState) {
            this.poolState(poolState == null ? null : poolState.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WarmPoolStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final InstanceReusePolicy.Builder getInstanceReusePolicy() {
            return instanceReusePolicy != null ? instanceReusePolicy.toBuilder() : null;
        }

        public final void setInstanceReusePolicy(InstanceReusePolicy.BuilderImpl instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy != null ? instanceReusePolicy.build() : null;
        }

        @Override
        public final Builder instanceReusePolicy(InstanceReusePolicy instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy;
            return this;
        }

        @Override
        public WarmPoolConfiguration build() {
            return new WarmPoolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
