/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutoScalingGroupRequest extends AutoScalingRequest implements
        ToCopyableBuilder<UpdateAutoScalingGroupRequest.Builder, UpdateAutoScalingGroupRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(UpdateAutoScalingGroupRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(UpdateAutoScalingGroupRequest::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(UpdateAutoScalingGroupRequest::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField
            .<MixedInstancesPolicy> builder(MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy")
            .getter(getter(UpdateAutoScalingGroupRequest::mixedInstancesPolicy)).setter(setter(Builder::mixedInstancesPolicy))
            .constructor(MixedInstancesPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build())
            .build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(UpdateAutoScalingGroupRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(UpdateAutoScalingGroupRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredCapacity").getter(getter(UpdateAutoScalingGroupRequest::desiredCapacity))
            .setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultCooldown").getter(getter(UpdateAutoScalingGroupRequest::defaultCooldown))
            .setter(setter(Builder::defaultCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(UpdateAutoScalingGroupRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckType").getter(getter(UpdateAutoScalingGroupRequest::healthCheckType))
            .setter(setter(Builder::healthCheckType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckGracePeriod").getter(getter(UpdateAutoScalingGroupRequest::healthCheckGracePeriod))
            .setter(setter(Builder::healthCheckGracePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build())
            .build();

    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementGroup").getter(getter(UpdateAutoScalingGroupRequest::placementGroup))
            .setter(setter(Builder::placementGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()).build();

    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCZoneIdentifier").getter(getter(UpdateAutoScalingGroupRequest::vpcZoneIdentifier))
            .setter(setter(Builder::vpcZoneIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()).build();

    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TerminationPolicies")
            .getter(getter(UpdateAutoScalingGroupRequest::terminationPolicies))
            .setter(setter(Builder::terminationPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NewInstancesProtectedFromScaleIn")
            .getter(getter(UpdateAutoScalingGroupRequest::newInstancesProtectedFromScaleIn))
            .setter(setter(Builder::newInstancesProtectedFromScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn")
                    .build()).build();

    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceLinkedRoleARN").getter(getter(UpdateAutoScalingGroupRequest::serviceLinkedRoleARN))
            .setter(setter(Builder::serviceLinkedRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build())
            .build();

    private static final SdkField<Integer> MAX_INSTANCE_LIFETIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInstanceLifetime").getter(getter(UpdateAutoScalingGroupRequest::maxInstanceLifetime))
            .setter(setter(Builder::maxInstanceLifetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceLifetime").build())
            .build();

    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CapacityRebalance").getter(getter(UpdateAutoScalingGroupRequest::capacityRebalance))
            .setter(setter(Builder::capacityRebalance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Context")
            .getter(getter(UpdateAutoScalingGroupRequest::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()).build();

    private static final SdkField<String> DESIRED_CAPACITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredCapacityType").getter(getter(UpdateAutoScalingGroupRequest::desiredCapacityType))
            .setter(setter(Builder::desiredCapacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacityType").build())
            .build();

    private static final SdkField<Integer> DEFAULT_INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultInstanceWarmup").getter(getter(UpdateAutoScalingGroupRequest::defaultInstanceWarmup))
            .setter(setter(Builder::defaultInstanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceWarmup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIXED_INSTANCES_POLICY_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD,
            DESIRED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD, AVAILABILITY_ZONES_FIELD, HEALTH_CHECK_TYPE_FIELD,
            HEALTH_CHECK_GRACE_PERIOD_FIELD, PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, TERMINATION_POLICIES_FIELD,
            NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD, MAX_INSTANCE_LIFETIME_FIELD,
            CAPACITY_REBALANCE_FIELD, CONTEXT_FIELD, DESIRED_CAPACITY_TYPE_FIELD, DEFAULT_INSTANCE_WARMUP_FIELD));

    private final String autoScalingGroupName;

    private final String launchConfigurationName;

    private final LaunchTemplateSpecification launchTemplate;

    private final MixedInstancesPolicy mixedInstancesPolicy;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final Integer defaultCooldown;

    private final List<String> availabilityZones;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final String placementGroup;

    private final String vpcZoneIdentifier;

    private final List<String> terminationPolicies;

    private final Boolean newInstancesProtectedFromScaleIn;

    private final String serviceLinkedRoleARN;

    private final Integer maxInstanceLifetime;

    private final Boolean capacityRebalance;

    private final String context;

    private final String desiredCapacityType;

    private final Integer defaultInstanceWarmup;

    private UpdateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
        this.maxInstanceLifetime = builder.maxInstanceLifetime;
        this.capacityRebalance = builder.capacityRebalance;
        this.context = builder.context;
        this.desiredCapacityType = builder.desiredCapacityType;
        this.defaultInstanceWarmup = builder.defaultInstanceWarmup;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update request,
     * you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.
     * </p>
     * 
     * @return The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update
     *         request, you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in your
     * update request, you can't specify <code>LaunchConfigurationName</code> or <code>MixedInstancesPolicy</code>.
     * </p>
     * 
     * @return The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code>
     *         in your update request, you can't specify <code>LaunchConfigurationName</code> or
     *         <code>MixedInstancesPolicy</code>.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * An embedded object that specifies a mixed instances policy. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto
     * Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * 
     * @return An embedded object that specifies a mixed instances policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
     *         >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto
     *         Scaling User Guide</i>.
     */
    public final MixedInstancesPolicy mixedInstancesPolicy() {
        return mixedInstancesPolicy;
    }

    /**
     * <p>
     * The minimum size of the Auto Scaling group.
     * </p>
     * 
     * @return The minimum size of the Auto Scaling group.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the Auto Scaling group.
     * </p>
     * <note>
     * <p>
     * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
     * <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go
     * above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each
     * instance contributes to the desired capacity of the group).
     * </p>
     * </note>
     * 
     * @return The maximum size of the Auto Scaling group.</p> <note>
     *         <p>
     *         With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
     *         <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will
     *         never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how
     *         many units each instance contributes to the desired capacity of the group).
     *         </p>
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the
     * capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and
     * less than or equal to the maximum size of the group.
     * </p>
     * 
     * @return The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and
     *         the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of
     *         the group and less than or equal to the maximum size of the group.
     */
    public final Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * <i>Only needed if you use simple scaling policies.</i>
     * </p>
     * <p>
     * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple
     * scaling policies. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto
     * Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return <i>Only needed if you use simple scaling policies.</i> </p>
     *         <p>
     *         The amount of time, in seconds, between one scaling activity ending and another one starting due to
     *         simple scaling policies. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon
     *         EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Integer defaultCooldown() {
        return defaultCooldown;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Availability Zones for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return One or more Availability Zones for the group.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you
     * configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if it
     * fails either the EC2 status checks or the load balancer health checks.
     * </p>
     * 
     * @return The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If
     *         you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance
     *         unhealthy if it fails either the EC2 status checks or the load balancer health checks.
     */
    public final String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2
     * instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom
     * health check. This is useful if your instances do not immediately pass these health checks after they enter the
     * <code>InService</code> state. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health
     * check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of
     *         an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load
     *         Balancing or custom health check. This is useful if your instances do not immediately pass these health
     *         checks after they enter the <code>InService</code> state. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period"
     *         >Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * The name of an existing placement group into which to launch your instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <note>
     * <p>
     * A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot
     * specify multiple Availability Zones and a cluster placement group.
     * </p>
     * </note>
     * 
     * @return The name of an existing placement group into which to launch your instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in
     *         the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
     *         <p>
     *         A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone.
     *         You cannot specify multiple Availability Zones and a cluster placement group.
     *         </p>
     */
    public final String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify
     * <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify must reside in
     * those Availability Zones.
     * </p>
     * 
     * @return A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify
     *         <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify must
     *         reside in those Availability Zones.
     */
    public final String vpcZoneIdentifier() {
        return vpcZoneIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerminationPolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerminationPolicies() {
        return terminationPolicies != null && !(terminationPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A policy or a list of policies that are used to select the instances to terminate. The policies are executed in
     * the order that you list them. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Work with
     * Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Valid values: <code>Default</code> | <code>AllocationStrategy</code> | <code>ClosestToNextInstanceHour</code> |
     * <code>NewestInstance</code> | <code>OldestInstance</code> | <code>OldestLaunchConfiguration</code> |
     * <code>OldestLaunchTemplate</code> | <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerminationPolicies} method.
     * </p>
     * 
     * @return A policy or a list of policies that are used to select the instances to terminate. The policies are
     *         executed in the order that you list them. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
     *         >Work with Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.</p>
     *         <p>
     *         Valid values: <code>Default</code> | <code>AllocationStrategy</code> |
     *         <code>ClosestToNextInstanceHour</code> | <code>NewestInstance</code> | <code>OldestInstance</code> |
     *         <code>OldestLaunchConfiguration</code> | <code>OldestLaunchTemplate</code> |
     *         <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
     */
    public final List<String> terminationPolicies() {
        return terminationPolicies;
    }

    /**
     * <p>
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling
     * in. For more information about preventing instances from terminating on scale in, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using
     * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
     *         scaling in. For more information about preventing instances from terminating on scale in, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html"
     *         >Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean newInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon
     * Web Services on your behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked
     * roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other
     *         Amazon Web Services on your behalf. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html"
     *         >Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String serviceLinkedRoleARN() {
        return serviceLinkedRoleARN;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified,
     * the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set
     * value, specify a new value of 0. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto
     * Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
     *         specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To
     *         clear a previously set value, specify a new value of 0. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing
     *         Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final Integer maxInstanceLifetime() {
        return maxInstanceLifetime;
    }

    /**
     * <p>
     * Enables or disables Capacity Rebalancing. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Use
     * Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * 
     * @return Enables or disables Capacity Rebalancing. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html"
     *         >Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the <i>Amazon EC2 Auto Scaling
     *         User Guide</i>.
     */
    public final Boolean capacityRebalance() {
        return capacityRebalance;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
     * <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating
     * an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * <p>
     * By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.
     * </p>
     * <p>
     * Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
     * </p>
     * 
     * @return The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
     *         <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html"
     *         >Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2
     *         Auto Scaling User Guide</i>.</p>
     *         <p>
     *         By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
     *         instances.
     *         </p>
     *         <p>
     *         Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
     */
    public final String desiredCapacityType() {
        return desiredCapacityType;
    }

    /**
     * <p>
     * The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics.
     * This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics,
     * resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource
     * consumption to become stable after an instance reaches the <code>InService</code> state. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set
     * the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To manage your warm-up settings at the group level, we recommend that you set the default instance warmup,
     * <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale
     * continuously, such as target tracking and step scaling policies.
     * </p>
     * <p>
     * If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the
     * value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value
     * of <code>0</code>.
     * </p>
     * </important>
     * 
     * @return The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch
     *         metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates
     *         instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that
     *         it takes for resource consumption to become stable after an instance reaches the <code>InService</code>
     *         state. For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set
     *         the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.</p> <important>
     *         <p>
     *         To manage your warm-up settings at the group level, we recommend that you set the default instance
     *         warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling
     *         policies that scale continuously, such as target tracking and step scaling policies.
     *         </p>
     *         <p>
     *         If you need to remove a value that you previously set, include the property but specify <code>-1</code>
     *         for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a
     *         minimum value of <code>0</code>.
     *         </p>
     */
    public final Integer defaultInstanceWarmup() {
        return defaultInstanceWarmup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminationPolicies() ? terminationPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceLinkedRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(maxInstanceLifetime());
        hashCode = 31 * hashCode + Objects.hashCode(capacityRebalance());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacityType());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceWarmup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutoScalingGroupRequest)) {
            return false;
        }
        UpdateAutoScalingGroupRequest other = (UpdateAutoScalingGroupRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(mixedInstancesPolicy(), other.mixedInstancesPolicy())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(maxSize(), other.maxSize())
                && Objects.equals(desiredCapacity(), other.desiredCapacity())
                && Objects.equals(defaultCooldown(), other.defaultCooldown())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(healthCheckType(), other.healthCheckType())
                && Objects.equals(healthCheckGracePeriod(), other.healthCheckGracePeriod())
                && Objects.equals(placementGroup(), other.placementGroup())
                && Objects.equals(vpcZoneIdentifier(), other.vpcZoneIdentifier())
                && hasTerminationPolicies() == other.hasTerminationPolicies()
                && Objects.equals(terminationPolicies(), other.terminationPolicies())
                && Objects.equals(newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn())
                && Objects.equals(serviceLinkedRoleARN(), other.serviceLinkedRoleARN())
                && Objects.equals(maxInstanceLifetime(), other.maxInstanceLifetime())
                && Objects.equals(capacityRebalance(), other.capacityRebalance()) && Objects.equals(context(), other.context())
                && Objects.equals(desiredCapacityType(), other.desiredCapacityType())
                && Objects.equals(defaultInstanceWarmup(), other.defaultInstanceWarmup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutoScalingGroupRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("LaunchConfigurationName", launchConfigurationName()).add("LaunchTemplate", launchTemplate())
                .add("MixedInstancesPolicy", mixedInstancesPolicy()).add("MinSize", minSize()).add("MaxSize", maxSize())
                .add("DesiredCapacity", desiredCapacity()).add("DefaultCooldown", defaultCooldown())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("HealthCheckType", healthCheckType()).add("HealthCheckGracePeriod", healthCheckGracePeriod())
                .add("PlacementGroup", placementGroup()).add("VPCZoneIdentifier", vpcZoneIdentifier())
                .add("TerminationPolicies", hasTerminationPolicies() ? terminationPolicies() : null)
                .add("NewInstancesProtectedFromScaleIn", newInstancesProtectedFromScaleIn())
                .add("ServiceLinkedRoleARN", serviceLinkedRoleARN()).add("MaxInstanceLifetime", maxInstanceLifetime())
                .add("CapacityRebalance", capacityRebalance()).add("Context", context())
                .add("DesiredCapacityType", desiredCapacityType()).add("DefaultInstanceWarmup", defaultInstanceWarmup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "MixedInstancesPolicy":
            return Optional.ofNullable(clazz.cast(mixedInstancesPolicy()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "DefaultCooldown":
            return Optional.ofNullable(clazz.cast(defaultCooldown()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "HealthCheckType":
            return Optional.ofNullable(clazz.cast(healthCheckType()));
        case "HealthCheckGracePeriod":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriod()));
        case "PlacementGroup":
            return Optional.ofNullable(clazz.cast(placementGroup()));
        case "VPCZoneIdentifier":
            return Optional.ofNullable(clazz.cast(vpcZoneIdentifier()));
        case "TerminationPolicies":
            return Optional.ofNullable(clazz.cast(terminationPolicies()));
        case "NewInstancesProtectedFromScaleIn":
            return Optional.ofNullable(clazz.cast(newInstancesProtectedFromScaleIn()));
        case "ServiceLinkedRoleARN":
            return Optional.ofNullable(clazz.cast(serviceLinkedRoleARN()));
        case "MaxInstanceLifetime":
            return Optional.ofNullable(clazz.cast(maxInstanceLifetime()));
        case "CapacityRebalance":
            return Optional.ofNullable(clazz.cast(capacityRebalance()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "DesiredCapacityType":
            return Optional.ofNullable(clazz.cast(desiredCapacityType()));
        case "DefaultInstanceWarmup":
            return Optional.ofNullable(clazz.cast(defaultInstanceWarmup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutoScalingGroupRequest, T> g) {
        return obj -> g.apply((UpdateAutoScalingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAutoScalingGroupRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update
         * request, you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your
         *        update request, you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in
         * your update request, you can't specify <code>LaunchConfigurationName</code> or
         * <code>MixedInstancesPolicy</code>.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template and version to use to specify the updates. If you specify
         *        <code>LaunchTemplate</code> in your update request, you can't specify
         *        <code>LaunchConfigurationName</code> or <code>MixedInstancesPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in
         * your update request, you can't specify <code>LaunchConfigurationName</code> or
         * <code>MixedInstancesPolicy</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * An embedded object that specifies a mixed instances policy. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         * >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling
         * User Guide</i>.
         * </p>
         * 
         * @param mixedInstancesPolicy
         *        An embedded object that specifies a mixed instances policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         *        >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto
         *        Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy);

        /**
         * <p>
         * An embedded object that specifies a mixed instances policy. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         * >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling
         * User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MixedInstancesPolicy.Builder} avoiding
         * the need to create one manually via {@link MixedInstancesPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link MixedInstancesPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #mixedInstancesPolicy(MixedInstancesPolicy)}.
         * 
         * @param mixedInstancesPolicy
         *        a consumer that will call methods on {@link MixedInstancesPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedInstancesPolicy(MixedInstancesPolicy)
         */
        default Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return mixedInstancesPolicy(MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy).build());
        }

        /**
         * <p>
         * The minimum size of the Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the Auto Scaling group.
         * </p>
         * <note>
         * <p>
         * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
         * <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go
         * above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each
         * instance contributes to the desired capacity of the group).
         * </p>
         * </note>
         * 
         * @param maxSize
         *        The maximum size of the Auto Scaling group.</p> <note>
         *        <p>
         *        With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go
         *        above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling
         *        will never go above <code>MaxSize</code> by more than your largest instance weight (weights that
         *        define how many units each instance contributes to the desired capacity of the group).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the
         * capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group
         * and less than or equal to the maximum size of the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired capacity is the initial capacity of the Auto Scaling group after this operation completes
         *        and the capacity it attempts to maintain. This number must be greater than or equal to the minimum
         *        size of the group and less than or equal to the maximum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * <i>Only needed if you use simple scaling policies.</i>
         * </p>
         * <p>
         * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple
         * scaling policies. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2
         * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param defaultCooldown
         *        <i>Only needed if you use simple scaling policies.</i> </p>
         *        <p>
         *        The amount of time, in seconds, between one scaling activity ending and another one starting due to
         *        simple scaling policies. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for
         *        Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCooldown(Integer defaultCooldown);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you
         * configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if
         * it fails either the EC2 status checks or the load balancer health checks.
         * </p>
         * 
         * @param healthCheckType
         *        The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
         *        If you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the
         *        instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an
         * EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or
         * custom health check. This is useful if your instances do not immediately pass these health checks after they
         * enter the <code>InService</code> state. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period"
         * >Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status
         *        of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load
         *        Balancing or custom health check. This is useful if your instances do not immediately pass these
         *        health checks after they enter the <code>InService</code> state. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period"
         *        >Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * The name of an existing placement group into which to launch your instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * <note>
         * <p>
         * A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You
         * cannot specify multiple Availability Zones and a cluster placement group.
         * </p>
         * </note>
         * 
         * @param placementGroup
         *        The name of an existing placement group into which to launch your instances. For more information, see
         *        <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement
         *        groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
         *        <p>
         *        A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone.
         *        You cannot specify multiple Availability Zones and a cluster placement group.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify
         * <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify must reside
         * in those Availability Zones.
         * </p>
         * 
         * @param vpcZoneIdentifier
         *        A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify
         *        <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify must
         *        reside in those Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcZoneIdentifier(String vpcZoneIdentifier);

        /**
         * <p>
         * A policy or a list of policies that are used to select the instances to terminate. The policies are executed
         * in the order that you list them. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Work
         * with Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>Default</code> | <code>AllocationStrategy</code> | <code>ClosestToNextInstanceHour</code>
         * | <code>NewestInstance</code> | <code>OldestInstance</code> | <code>OldestLaunchConfiguration</code> |
         * <code>OldestLaunchTemplate</code> |
         * <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * </p>
         * 
         * @param terminationPolicies
         *        A policy or a list of policies that are used to select the instances to terminate. The policies are
         *        executed in the order that you list them. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
         *        >Work with Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.</p>
         *        <p>
         *        Valid values: <code>Default</code> | <code>AllocationStrategy</code> |
         *        <code>ClosestToNextInstanceHour</code> | <code>NewestInstance</code> | <code>OldestInstance</code> |
         *        <code>OldestLaunchConfiguration</code> | <code>OldestLaunchTemplate</code> |
         *        <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(Collection<String> terminationPolicies);

        /**
         * <p>
         * A policy or a list of policies that are used to select the instances to terminate. The policies are executed
         * in the order that you list them. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Work
         * with Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>Default</code> | <code>AllocationStrategy</code> | <code>ClosestToNextInstanceHour</code>
         * | <code>NewestInstance</code> | <code>OldestInstance</code> | <code>OldestLaunchConfiguration</code> |
         * <code>OldestLaunchTemplate</code> |
         * <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * </p>
         * 
         * @param terminationPolicies
         *        A policy or a list of policies that are used to select the instances to terminate. The policies are
         *        executed in the order that you list them. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
         *        >Work with Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.</p>
         *        <p>
         *        Valid values: <code>Default</code> | <code>AllocationStrategy</code> |
         *        <code>ClosestToNextInstanceHour</code> | <code>NewestInstance</code> | <code>OldestInstance</code> |
         *        <code>OldestLaunchConfiguration</code> | <code>OldestLaunchTemplate</code> |
         *        <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(String... terminationPolicies);

        /**
         * <p>
         * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
         * scaling in. For more information about preventing instances from terminating on scale in, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using
         * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param newInstancesProtectedFromScaleIn
         *        Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
         *        when scaling in. For more information about preventing instances from terminating on scale in, see <a
         *        href
         *        ="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">
         *        Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other
         * Amazon Web Services on your behalf. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html"
         * >Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param serviceLinkedRoleARN
         *        The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call
         *        other Amazon Web Services on your behalf. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html"
         *        >Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkedRoleARN(String serviceLinkedRoleARN);

        /**
         * <p>
         * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
         * specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a
         * previously set value, specify a new value of 0. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto
         * Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param maxInstanceLifetime
         *        The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
         *        specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To
         *        clear a previously set value, specify a new value of 0. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing
         *        Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceLifetime(Integer maxInstanceLifetime);

        /**
         * <p>
         * Enables or disables Capacity Rebalancing. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Use
         * Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * 
         * @param capacityRebalance
         *        Enables or disables Capacity Rebalancing. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Use
         *        Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the <i>Amazon EC2 Auto Scaling
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRebalance(Boolean capacityRebalance);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param context
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
         * <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see
         * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">
         * Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto
         * Scaling User Guide</i>.
         * </p>
         * <p>
         * By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.
         * </p>
         * <p>
         * Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
         * </p>
         * 
         * @param desiredCapacityType
         *        The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
         *        <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html"
         *        >Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2
         *        Auto Scaling User Guide</i>.</p>
         *        <p>
         *        By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
         *        instances.
         *        </p>
         *        <p>
         *        Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacityType(String desiredCapacityType);

        /**
         * <p>
         * The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch
         * metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance
         * metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for
         * resource consumption to become stable after an instance reaches the <code>InService</code> state. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html"
         * >Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * <important>
         * <p>
         * To manage your warm-up settings at the group level, we recommend that you set the default instance warmup,
         * <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that
         * scale continuously, such as target tracking and step scaling policies.
         * </p>
         * <p>
         * If you need to remove a value that you previously set, include the property but specify <code>-1</code> for
         * the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum
         * value of <code>0</code>.
         * </p>
         * </important>
         * 
         * @param defaultInstanceWarmup
         *        The amount of time, in seconds, until a newly launched instance can contribute to the Amazon
         *        CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling
         *        aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount
         *        of time that it takes for resource consumption to become stable after an instance reaches the
         *        <code>InService</code> state. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html"
         *        >Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.</p> <important>
         *        <p>
         *        To manage your warm-up settings at the group level, we recommend that you set the default instance
         *        warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling
         *        policies that scale continuously, such as target tracking and step scaling policies.
         *        </p>
         *        <p>
         *        If you need to remove a value that you previously set, include the property but specify
         *        <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup
         *        enabled by specifying a minimum value of <code>0</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceWarmup(Integer defaultInstanceWarmup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String launchConfigurationName;

        private LaunchTemplateSpecification launchTemplate;

        private MixedInstancesPolicy mixedInstancesPolicy;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private Integer defaultCooldown;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private String placementGroup;

        private String vpcZoneIdentifier;

        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();

        private Boolean newInstancesProtectedFromScaleIn;

        private String serviceLinkedRoleARN;

        private Integer maxInstanceLifetime;

        private Boolean capacityRebalance;

        private String context;

        private String desiredCapacityType;

        private Integer defaultInstanceWarmup;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutoScalingGroupRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            launchConfigurationName(model.launchConfigurationName);
            launchTemplate(model.launchTemplate);
            mixedInstancesPolicy(model.mixedInstancesPolicy);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
            defaultCooldown(model.defaultCooldown);
            availabilityZones(model.availabilityZones);
            healthCheckType(model.healthCheckType);
            healthCheckGracePeriod(model.healthCheckGracePeriod);
            placementGroup(model.placementGroup);
            vpcZoneIdentifier(model.vpcZoneIdentifier);
            terminationPolicies(model.terminationPolicies);
            newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            serviceLinkedRoleARN(model.serviceLinkedRoleARN);
            maxInstanceLifetime(model.maxInstanceLifetime);
            capacityRebalance(model.capacityRebalance);
            context(model.context);
            desiredCapacityType(model.desiredCapacityType);
            defaultInstanceWarmup(model.defaultInstanceWarmup);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return mixedInstancesPolicy != null ? mixedInstancesPolicy.toBuilder() : null;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final Integer getDefaultCooldown() {
            return defaultCooldown;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final String getVpcZoneIdentifier() {
            return vpcZoneIdentifier;
        }

        public final void setVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final Collection<String> getTerminationPolicies() {
            if (terminationPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return terminationPolicies;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return newInstancesProtectedFromScaleIn;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final String getServiceLinkedRoleARN() {
            return serviceLinkedRoleARN;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final Integer getMaxInstanceLifetime() {
            return maxInstanceLifetime;
        }

        public final void setMaxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
        }

        @Override
        public final Builder maxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public final Boolean getCapacityRebalance() {
            return capacityRebalance;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getDesiredCapacityType() {
            return desiredCapacityType;
        }

        public final void setDesiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
        }

        @Override
        public final Builder desiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
            return this;
        }

        public final Integer getDefaultInstanceWarmup() {
            return defaultInstanceWarmup;
        }

        public final void setDefaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
        }

        @Override
        public final Builder defaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutoScalingGroupRequest build() {
            return new UpdateAutoScalingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
