/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountLimitsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeAccountLimitsResponse.Builder, DescribeAccountLimitsResponse> {
    private static final SdkField<Integer> MAX_NUMBER_OF_AUTO_SCALING_GROUPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxNumberOfAutoScalingGroups")
            .getter(getter(DescribeAccountLimitsResponse::maxNumberOfAutoScalingGroups))
            .setter(setter(Builder::maxNumberOfAutoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfAutoScalingGroups")
                    .build()).build();

    private static final SdkField<Integer> MAX_NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxNumberOfLaunchConfigurations")
            .getter(getter(DescribeAccountLimitsResponse::maxNumberOfLaunchConfigurations))
            .setter(setter(Builder::maxNumberOfLaunchConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfLaunchConfigurations")
                    .build()).build();

    private static final SdkField<Integer> NUMBER_OF_AUTO_SCALING_GROUPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("NumberOfAutoScalingGroups")
            .getter(getter(DescribeAccountLimitsResponse::numberOfAutoScalingGroups))
            .setter(setter(Builder::numberOfAutoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAutoScalingGroups").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfLaunchConfigurations")
            .getter(getter(DescribeAccountLimitsResponse::numberOfLaunchConfigurations))
            .setter(setter(Builder::numberOfLaunchConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLaunchConfigurations")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_NUMBER_OF_AUTO_SCALING_GROUPS_FIELD, MAX_NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD,
            NUMBER_OF_AUTO_SCALING_GROUPS_FIELD, NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD));

    private final Integer maxNumberOfAutoScalingGroups;

    private final Integer maxNumberOfLaunchConfigurations;

    private final Integer numberOfAutoScalingGroups;

    private final Integer numberOfLaunchConfigurations;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.maxNumberOfAutoScalingGroups = builder.maxNumberOfAutoScalingGroups;
        this.maxNumberOfLaunchConfigurations = builder.maxNumberOfLaunchConfigurations;
        this.numberOfAutoScalingGroups = builder.numberOfAutoScalingGroups;
        this.numberOfLaunchConfigurations = builder.numberOfLaunchConfigurations;
    }

    /**
     * <p>
     * The maximum number of groups allowed for your account. The default is 200 groups per Region.
     * </p>
     * 
     * @return The maximum number of groups allowed for your account. The default is 200 groups per Region.
     */
    public final Integer maxNumberOfAutoScalingGroups() {
        return maxNumberOfAutoScalingGroups;
    }

    /**
     * <p>
     * The maximum number of launch configurations allowed for your account. The default is 200 launch configurations
     * per Region.
     * </p>
     * 
     * @return The maximum number of launch configurations allowed for your account. The default is 200 launch
     *         configurations per Region.
     */
    public final Integer maxNumberOfLaunchConfigurations() {
        return maxNumberOfLaunchConfigurations;
    }

    /**
     * <p>
     * The current number of groups for your account.
     * </p>
     * 
     * @return The current number of groups for your account.
     */
    public final Integer numberOfAutoScalingGroups() {
        return numberOfAutoScalingGroups;
    }

    /**
     * <p>
     * The current number of launch configurations for your account.
     * </p>
     * 
     * @return The current number of launch configurations for your account.
     */
    public final Integer numberOfLaunchConfigurations() {
        return numberOfLaunchConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfLaunchConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfLaunchConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse) obj;
        return Objects.equals(maxNumberOfAutoScalingGroups(), other.maxNumberOfAutoScalingGroups())
                && Objects.equals(maxNumberOfLaunchConfigurations(), other.maxNumberOfLaunchConfigurations())
                && Objects.equals(numberOfAutoScalingGroups(), other.numberOfAutoScalingGroups())
                && Objects.equals(numberOfLaunchConfigurations(), other.numberOfLaunchConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountLimitsResponse")
                .add("MaxNumberOfAutoScalingGroups", maxNumberOfAutoScalingGroups())
                .add("MaxNumberOfLaunchConfigurations", maxNumberOfLaunchConfigurations())
                .add("NumberOfAutoScalingGroups", numberOfAutoScalingGroups())
                .add("NumberOfLaunchConfigurations", numberOfLaunchConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxNumberOfAutoScalingGroups":
            return Optional.ofNullable(clazz.cast(maxNumberOfAutoScalingGroups()));
        case "MaxNumberOfLaunchConfigurations":
            return Optional.ofNullable(clazz.cast(maxNumberOfLaunchConfigurations()));
        case "NumberOfAutoScalingGroups":
            return Optional.ofNullable(clazz.cast(numberOfAutoScalingGroups()));
        case "NumberOfLaunchConfigurations":
            return Optional.ofNullable(clazz.cast(numberOfLaunchConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountLimitsResponse, T> g) {
        return obj -> g.apply((DescribeAccountLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        /**
         * <p>
         * The maximum number of groups allowed for your account. The default is 200 groups per Region.
         * </p>
         * 
         * @param maxNumberOfAutoScalingGroups
         *        The maximum number of groups allowed for your account. The default is 200 groups per Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups);

        /**
         * <p>
         * The maximum number of launch configurations allowed for your account. The default is 200 launch
         * configurations per Region.
         * </p>
         * 
         * @param maxNumberOfLaunchConfigurations
         *        The maximum number of launch configurations allowed for your account. The default is 200 launch
         *        configurations per Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations);

        /**
         * <p>
         * The current number of groups for your account.
         * </p>
         * 
         * @param numberOfAutoScalingGroups
         *        The current number of groups for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups);

        /**
         * <p>
         * The current number of launch configurations for your account.
         * </p>
         * 
         * @param numberOfLaunchConfigurations
         *        The current number of launch configurations for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private Integer maxNumberOfAutoScalingGroups;

        private Integer maxNumberOfLaunchConfigurations;

        private Integer numberOfAutoScalingGroups;

        private Integer numberOfLaunchConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            super(model);
            maxNumberOfAutoScalingGroups(model.maxNumberOfAutoScalingGroups);
            maxNumberOfLaunchConfigurations(model.maxNumberOfLaunchConfigurations);
            numberOfAutoScalingGroups(model.numberOfAutoScalingGroups);
            numberOfLaunchConfigurations(model.numberOfLaunchConfigurations);
        }

        public final Integer getMaxNumberOfAutoScalingGroups() {
            return maxNumberOfAutoScalingGroups;
        }

        public final void setMaxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
        }

        @Override
        @Transient
        public final Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
            return this;
        }

        public final Integer getMaxNumberOfLaunchConfigurations() {
            return maxNumberOfLaunchConfigurations;
        }

        public final void setMaxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
        }

        @Override
        @Transient
        public final Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
            return this;
        }

        public final Integer getNumberOfAutoScalingGroups() {
            return numberOfAutoScalingGroups;
        }

        public final void setNumberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
        }

        @Override
        @Transient
        public final Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
            return this;
        }

        public final Integer getNumberOfLaunchConfigurations() {
            return numberOfLaunchConfigurations;
        }

        public final void setNumberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
        }

        @Override
        @Transient
        public final Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
            return this;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
