/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure specifies the metrics and target utilization settings for a predictive scaling policy.
 * </p>
 * <p>
 * You must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair
 * instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric
 * pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the
 * scaling metric.
 * </p>
 * <p>
 * Example
 * </p>
 * <ul>
 * <li>
 * <p>
 * You create a predictive scaling policy and specify <code>ALBRequestCount</code> as the value for the metric pair and
 * <code>1000.0</code> as the target value. For this type of metric, you must provide the metric dimension for the
 * corresponding target group, so you also provide a resource label for the Application Load Balancer target group that
 * is attached to your Auto Scaling group.
 * </p>
 * </li>
 * <li>
 * <p>
 * The number of requests the target group receives per minute provides the load metric, and the request count averaged
 * between the members of the target group provides the scaling metric. In CloudWatch, this refers to the
 * <code>RequestCount</code> and <code>RequestCountPerTarget</code> metrics, respectively.
 * </p>
 * </li>
 * <li>
 * <p>
 * For optimal use of predictive scaling, you adhere to the best practice of using a dynamic scaling policy to
 * automatically scale between the minimum capacity and maximum capacity in response to real-time changes in resource
 * utilization.
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon EC2 Auto Scaling consumes data points for the load metric over the last 14 days and creates an hourly load
 * forecast for predictive scaling. (A minimum of 24 hours of data is required.)
 * </p>
 * </li>
 * <li>
 * <p>
 * After creating the load forecast, Amazon EC2 Auto Scaling determines when to reduce or increase the capacity of your
 * Auto Scaling group in each hour of the forecast period so that the average number of requests received by each
 * instance is as close to 1000 requests per minute as possible at all times.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictiveScalingMetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictiveScalingMetricSpecification.Builder, PredictiveScalingMetricSpecification> {
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(PredictiveScalingMetricSpecification::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final SdkField<PredictiveScalingPredefinedMetricPair> PREDEFINED_METRIC_PAIR_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingPredefinedMetricPair> builder(MarshallingType.SDK_POJO)
            .memberName("PredefinedMetricPairSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::predefinedMetricPairSpecification))
            .setter(setter(Builder::predefinedMetricPairSpecification))
            .constructor(PredictiveScalingPredefinedMetricPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricPairSpecification")
                    .build()).build();

    private static final SdkField<PredictiveScalingPredefinedScalingMetric> PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingPredefinedScalingMetric> builder(MarshallingType.SDK_POJO)
            .memberName("PredefinedScalingMetricSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::predefinedScalingMetricSpecification))
            .setter(setter(Builder::predefinedScalingMetricSpecification))
            .constructor(PredictiveScalingPredefinedScalingMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PredefinedScalingMetricSpecification").build()).build();

    private static final SdkField<PredictiveScalingPredefinedLoadMetric> PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingPredefinedLoadMetric> builder(MarshallingType.SDK_POJO)
            .memberName("PredefinedLoadMetricSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::predefinedLoadMetricSpecification))
            .setter(setter(Builder::predefinedLoadMetricSpecification))
            .constructor(PredictiveScalingPredefinedLoadMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedLoadMetricSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VALUE_FIELD,
            PREDEFINED_METRIC_PAIR_SPECIFICATION_FIELD, PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD,
            PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double targetValue;

    private final PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification;

    private final PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification;

    private final PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification;

    private PredictiveScalingMetricSpecification(BuilderImpl builder) {
        this.targetValue = builder.targetValue;
        this.predefinedMetricPairSpecification = builder.predefinedMetricPairSpecification;
        this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
        this.predefinedLoadMetricSpecification = builder.predefinedLoadMetricSpecification;
    }

    /**
     * <p>
     * Specifies the target utilization.
     * </p>
     * 
     * @return Specifies the target utilization.
     */
    public final Double targetValue() {
        return targetValue;
    }

    /**
     * <p>
     * The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and
     * load metric to use.
     * </p>
     * 
     * @return The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling
     *         metric and load metric to use.
     */
    public final PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification() {
        return predefinedMetricPairSpecification;
    }

    /**
     * <p>
     * The scaling metric specification.
     * </p>
     * 
     * @return The scaling metric specification.
     */
    public final PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification() {
        return predefinedScalingMetricSpecification;
    }

    /**
     * <p>
     * The load metric specification.
     * </p>
     * 
     * @return The load metric specification.
     */
    public final PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification() {
        return predefinedLoadMetricSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricPairSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(predefinedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(predefinedLoadMetricSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingMetricSpecification)) {
            return false;
        }
        PredictiveScalingMetricSpecification other = (PredictiveScalingMetricSpecification) obj;
        return Objects.equals(targetValue(), other.targetValue())
                && Objects.equals(predefinedMetricPairSpecification(), other.predefinedMetricPairSpecification())
                && Objects.equals(predefinedScalingMetricSpecification(), other.predefinedScalingMetricSpecification())
                && Objects.equals(predefinedLoadMetricSpecification(), other.predefinedLoadMetricSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictiveScalingMetricSpecification").add("TargetValue", targetValue())
                .add("PredefinedMetricPairSpecification", predefinedMetricPairSpecification())
                .add("PredefinedScalingMetricSpecification", predefinedScalingMetricSpecification())
                .add("PredefinedLoadMetricSpecification", predefinedLoadMetricSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        case "PredefinedMetricPairSpecification":
            return Optional.ofNullable(clazz.cast(predefinedMetricPairSpecification()));
        case "PredefinedScalingMetricSpecification":
            return Optional.ofNullable(clazz.cast(predefinedScalingMetricSpecification()));
        case "PredefinedLoadMetricSpecification":
            return Optional.ofNullable(clazz.cast(predefinedLoadMetricSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingMetricSpecification, T> g) {
        return obj -> g.apply((PredictiveScalingMetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictiveScalingMetricSpecification> {
        /**
         * <p>
         * Specifies the target utilization.
         * </p>
         * 
         * @param targetValue
         *        Specifies the target utilization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);

        /**
         * <p>
         * The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric
         * and load metric to use.
         * </p>
         * 
         * @param predefinedMetricPairSpecification
         *        The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling
         *        metric and load metric to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification);

        /**
         * <p>
         * The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric
         * and load metric to use.
         * </p>
         * This is a convenience that creates an instance of the {@link PredictiveScalingPredefinedMetricPair.Builder}
         * avoiding the need to create one manually via {@link PredictiveScalingPredefinedMetricPair#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredictiveScalingPredefinedMetricPair.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPair)}.
         * 
         * @param predefinedMetricPairSpecification
         *        a consumer that will call methods on {@link PredictiveScalingPredefinedMetricPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPair)
         */
        default Builder predefinedMetricPairSpecification(
                Consumer<PredictiveScalingPredefinedMetricPair.Builder> predefinedMetricPairSpecification) {
            return predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPair.builder()
                    .applyMutation(predefinedMetricPairSpecification).build());
        }

        /**
         * <p>
         * The scaling metric specification.
         * </p>
         * 
         * @param predefinedScalingMetricSpecification
         *        The scaling metric specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification);

        /**
         * <p>
         * The scaling metric specification.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link PredictiveScalingPredefinedScalingMetric.Builder} avoiding the need to create one manually via
         * {@link PredictiveScalingPredefinedScalingMetric#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredictiveScalingPredefinedScalingMetric.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetric)}.
         * 
         * @param predefinedScalingMetricSpecification
         *        a consumer that will call methods on {@link PredictiveScalingPredefinedScalingMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetric)
         */
        default Builder predefinedScalingMetricSpecification(
                Consumer<PredictiveScalingPredefinedScalingMetric.Builder> predefinedScalingMetricSpecification) {
            return predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetric.builder()
                    .applyMutation(predefinedScalingMetricSpecification).build());
        }

        /**
         * <p>
         * The load metric specification.
         * </p>
         * 
         * @param predefinedLoadMetricSpecification
         *        The load metric specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification);

        /**
         * <p>
         * The load metric specification.
         * </p>
         * This is a convenience that creates an instance of the {@link PredictiveScalingPredefinedLoadMetric.Builder}
         * avoiding the need to create one manually via {@link PredictiveScalingPredefinedLoadMetric#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredictiveScalingPredefinedLoadMetric.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetric)}.
         * 
         * @param predefinedLoadMetricSpecification
         *        a consumer that will call methods on {@link PredictiveScalingPredefinedLoadMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetric)
         */
        default Builder predefinedLoadMetricSpecification(
                Consumer<PredictiveScalingPredefinedLoadMetric.Builder> predefinedLoadMetricSpecification) {
            return predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetric.builder()
                    .applyMutation(predefinedLoadMetricSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double targetValue;

        private PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification;

        private PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification;

        private PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingMetricSpecification model) {
            targetValue(model.targetValue);
            predefinedMetricPairSpecification(model.predefinedMetricPairSpecification);
            predefinedScalingMetricSpecification(model.predefinedScalingMetricSpecification);
            predefinedLoadMetricSpecification(model.predefinedLoadMetricSpecification);
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        @Transient
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final PredictiveScalingPredefinedMetricPair.Builder getPredefinedMetricPairSpecification() {
            return predefinedMetricPairSpecification != null ? predefinedMetricPairSpecification.toBuilder() : null;
        }

        public final void setPredefinedMetricPairSpecification(
                PredictiveScalingPredefinedMetricPair.BuilderImpl predefinedMetricPairSpecification) {
            this.predefinedMetricPairSpecification = predefinedMetricPairSpecification != null ? predefinedMetricPairSpecification
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder predefinedMetricPairSpecification(
                PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification) {
            this.predefinedMetricPairSpecification = predefinedMetricPairSpecification;
            return this;
        }

        public final PredictiveScalingPredefinedScalingMetric.Builder getPredefinedScalingMetricSpecification() {
            return predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification.toBuilder() : null;
        }

        public final void setPredefinedScalingMetricSpecification(
                PredictiveScalingPredefinedScalingMetric.BuilderImpl predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder predefinedScalingMetricSpecification(
                PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
            return this;
        }

        public final PredictiveScalingPredefinedLoadMetric.Builder getPredefinedLoadMetricSpecification() {
            return predefinedLoadMetricSpecification != null ? predefinedLoadMetricSpecification.toBuilder() : null;
        }

        public final void setPredefinedLoadMetricSpecification(
                PredictiveScalingPredefinedLoadMetric.BuilderImpl predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification != null ? predefinedLoadMetricSpecification
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder predefinedLoadMetricSpecification(
                PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
            return this;
        }

        @Override
        public PredictiveScalingMetricSpecification build() {
            return new PredictiveScalingMetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
