/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutNotificationConfigurationRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutNotificationConfigurationRequest.Builder, PutNotificationConfigurationRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(PutNotificationConfigurationRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicARN").getter(getter(PutNotificationConfigurationRequest::topicARN))
            .setter(setter(Builder::topicARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicARN").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationTypes")
            .getter(getter(PutNotificationConfigurationRequest::notificationTypes))
            .setter(setter(Builder::notificationTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            TOPIC_ARN_FIELD, NOTIFICATION_TYPES_FIELD));

    private final String autoScalingGroupName;

    private final String topicARN;

    private final List<String> notificationTypes;

    private PutNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationTypes = builder.notificationTypes;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
     */
    public final String topicARN() {
        return topicARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationTypes() {
        return notificationTypes != null && !(notificationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of event that causes the notification to be sent. To query the notification types supported by Amazon
     * EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationTypes} method.
     * </p>
     * 
     * @return The type of event that causes the notification to be sent. To query the notification types supported by
     *         Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
     */
    public final List<String> notificationTypes() {
        return notificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationTypes() ? notificationTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationConfigurationRequest)) {
            return false;
        }
        PutNotificationConfigurationRequest other = (PutNotificationConfigurationRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(topicARN(), other.topicARN()) && hasNotificationTypes() == other.hasNotificationTypes()
                && Objects.equals(notificationTypes(), other.notificationTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutNotificationConfigurationRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("TopicARN", topicARN()).add("NotificationTypes", hasNotificationTypes() ? notificationTypes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "TopicARN":
            return Optional.ofNullable(clazz.cast(topicARN()));
        case "NotificationTypes":
            return Optional.ofNullable(clazz.cast(notificationTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutNotificationConfigurationRequest, T> g) {
        return obj -> g.apply((PutNotificationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutNotificationConfigurationRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
         * </p>
         * 
         * @param topicARN
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);

        /**
         * <p>
         * The type of event that causes the notification to be sent. To query the notification types supported by
         * Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that causes the notification to be sent. To query the notification types supported
         *        by Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(Collection<String> notificationTypes);

        /**
         * <p>
         * The type of event that causes the notification to be sent. To query the notification types supported by
         * Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that causes the notification to be sent. To query the notification types supported
         *        by Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(String... notificationTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String topicARN;

        private List<String> notificationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationConfigurationRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            topicARN(model.topicARN);
            notificationTypes(model.notificationTypes);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getTopicARN() {
            return topicARN;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        @Override
        @Transient
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final Collection<String> getNotificationTypes() {
            if (notificationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationTypes;
        }

        public final void setNotificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
        }

        @Override
        @Transient
        public final Builder notificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationTypes(String... notificationTypes) {
            notificationTypes(Arrays.asList(notificationTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutNotificationConfigurationRequest build() {
            return new PutNotificationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
