/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResumeProcessesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<ResumeProcessesRequest.Builder, ResumeProcessesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(ResumeProcessesRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<List<String>> SCALING_PROCESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScalingProcesses")
            .getter(getter(ResumeProcessesRequest::scalingProcesses))
            .setter(setter(Builder::scalingProcesses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingProcesses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            SCALING_PROCESSES_FIELD));

    private final String autoScalingGroupName;

    private final List<String> scalingProcesses;

    private ResumeProcessesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scalingProcesses = builder.scalingProcesses;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalingProcesses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalingProcesses() {
        return scalingProcesses != null && !(scalingProcesses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more of the following processes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Launch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AddToLoadBalancer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AlarmNotification</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AZRebalance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HealthCheck</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InstanceRefresh</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceUnhealthy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActions</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you omit this parameter, all processes are specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalingProcesses} method.
     * </p>
     * 
     * @return One or more of the following processes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Launch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminate</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AddToLoadBalancer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AlarmNotification</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AZRebalance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HealthCheck</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InstanceRefresh</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReplaceUnhealthy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActions</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you omit this parameter, all processes are specified.
     */
    public final List<String> scalingProcesses() {
        return scalingProcesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingProcesses() ? scalingProcesses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeProcessesRequest)) {
            return false;
        }
        ResumeProcessesRequest other = (ResumeProcessesRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && hasScalingProcesses() == other.hasScalingProcesses()
                && Objects.equals(scalingProcesses(), other.scalingProcesses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResumeProcessesRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ScalingProcesses", hasScalingProcesses() ? scalingProcesses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "ScalingProcesses":
            return Optional.ofNullable(clazz.cast(scalingProcesses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResumeProcessesRequest, T> g) {
        return obj -> g.apply((ResumeProcessesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResumeProcessesRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more of the following processes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InstanceRefresh</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you omit this parameter, all processes are specified.
         * </p>
         * 
         * @param scalingProcesses
         *        One or more of the following processes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InstanceRefresh</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you omit this parameter, all processes are specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(Collection<String> scalingProcesses);

        /**
         * <p>
         * One or more of the following processes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InstanceRefresh</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you omit this parameter, all processes are specified.
         * </p>
         * 
         * @param scalingProcesses
         *        One or more of the following processes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InstanceRefresh</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you omit this parameter, all processes are specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(String... scalingProcesses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> scalingProcesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeProcessesRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            scalingProcesses(model.scalingProcesses);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Collection<String> getScalingProcesses() {
            if (scalingProcesses instanceof SdkAutoConstructList) {
                return null;
            }
            return scalingProcesses;
        }

        public final void setScalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
        }

        @Override
        @Transient
        public final Builder scalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scalingProcesses(String... scalingProcesses) {
            scalingProcesses(Arrays.asList(scalingProcesses));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResumeProcessesRequest build() {
            return new ResumeProcessesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
