/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLifecycleHookTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeLifecycleHookTypesResponse.Builder, DescribeLifecycleHookTypesResponse> {
    private static final SdkField<List<String>> LIFECYCLE_HOOK_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LifecycleHookTypes")
            .getter(getter(DescribeLifecycleHookTypesResponse::lifecycleHookTypes))
            .setter(setter(Builder::lifecycleHookTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_TYPES_FIELD));

    private final List<String> lifecycleHookTypes;

    private DescribeLifecycleHookTypesResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookTypes = builder.lifecycleHookTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecycleHookTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifecycleHookTypes() {
        return lifecycleHookTypes != null && !(lifecycleHookTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The lifecycle hook types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecycleHookTypes} method.
     * </p>
     * 
     * @return The lifecycle hook types.
     */
    public final List<String> lifecycleHookTypes() {
        return lifecycleHookTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecycleHookTypes() ? lifecycleHookTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHookTypesResponse)) {
            return false;
        }
        DescribeLifecycleHookTypesResponse other = (DescribeLifecycleHookTypesResponse) obj;
        return hasLifecycleHookTypes() == other.hasLifecycleHookTypes()
                && Objects.equals(lifecycleHookTypes(), other.lifecycleHookTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLifecycleHookTypesResponse")
                .add("LifecycleHookTypes", hasLifecycleHookTypes() ? lifecycleHookTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHookTypes":
            return Optional.ofNullable(clazz.cast(lifecycleHookTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLifecycleHookTypesResponse, T> g) {
        return obj -> g.apply((DescribeLifecycleHookTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLifecycleHookTypesResponse> {
        /**
         * <p>
         * The lifecycle hook types.
         * </p>
         * 
         * @param lifecycleHookTypes
         *        The lifecycle hook types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookTypes(Collection<String> lifecycleHookTypes);

        /**
         * <p>
         * The lifecycle hook types.
         * </p>
         * 
         * @param lifecycleHookTypes
         *        The lifecycle hook types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookTypes(String... lifecycleHookTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<String> lifecycleHookTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHookTypesResponse model) {
            super(model);
            lifecycleHookTypes(model.lifecycleHookTypes);
        }

        public final Collection<String> getLifecycleHookTypes() {
            if (lifecycleHookTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return lifecycleHookTypes;
        }

        public final void setLifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
        }

        @Override
        @Transient
        public final Builder lifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lifecycleHookTypes(String... lifecycleHookTypes) {
            lifecycleHookTypes(Arrays.asList(lifecycleHookTypes));
            return this;
        }

        @Override
        public DescribeLifecycleHookTypesResponse build() {
            return new DescribeLifecycleHookTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
