/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reports the progress of an instance refresh on instances that are in the warm pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceRefreshWarmPoolProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceRefreshWarmPoolProgress.Builder, InstanceRefreshWarmPoolProgress> {
    private static final SdkField<Integer> PERCENTAGE_COMPLETE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentageComplete").getter(getter(InstanceRefreshWarmPoolProgress::percentageComplete))
            .setter(setter(Builder::percentageComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build())
            .build();

    private static final SdkField<Integer> INSTANCES_TO_UPDATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstancesToUpdate").getter(getter(InstanceRefreshWarmPoolProgress::instancesToUpdate))
            .setter(setter(Builder::instancesToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTAGE_COMPLETE_FIELD,
            INSTANCES_TO_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer percentageComplete;

    private final Integer instancesToUpdate;

    private InstanceRefreshWarmPoolProgress(BuilderImpl builder) {
        this.percentageComplete = builder.percentageComplete;
        this.instancesToUpdate = builder.instancesToUpdate;
    }

    /**
     * <p>
     * The percentage of instances in the warm pool that have been replaced. For each instance replacement, Amazon EC2
     * Auto Scaling tracks the instance's health status and warm-up time. When the instance's health status changes to
     * healthy and the specified warm-up time passes, the instance is considered updated and is added to the percentage
     * complete.
     * </p>
     * 
     * @return The percentage of instances in the warm pool that have been replaced. For each instance replacement,
     *         Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the instance's health
     *         status changes to healthy and the specified warm-up time passes, the instance is considered updated and
     *         is added to the percentage complete.
     */
    public final Integer percentageComplete() {
        return percentageComplete;
    }

    /**
     * <p>
     * The number of instances remaining to update.
     * </p>
     * 
     * @return The number of instances remaining to update.
     */
    public final Integer instancesToUpdate() {
        return instancesToUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(instancesToUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRefreshWarmPoolProgress)) {
            return false;
        }
        InstanceRefreshWarmPoolProgress other = (InstanceRefreshWarmPoolProgress) obj;
        return Objects.equals(percentageComplete(), other.percentageComplete())
                && Objects.equals(instancesToUpdate(), other.instancesToUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceRefreshWarmPoolProgress").add("PercentageComplete", percentageComplete())
                .add("InstancesToUpdate", instancesToUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentageComplete":
            return Optional.ofNullable(clazz.cast(percentageComplete()));
        case "InstancesToUpdate":
            return Optional.ofNullable(clazz.cast(instancesToUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRefreshWarmPoolProgress, T> g) {
        return obj -> g.apply((InstanceRefreshWarmPoolProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceRefreshWarmPoolProgress> {
        /**
         * <p>
         * The percentage of instances in the warm pool that have been replaced. For each instance replacement, Amazon
         * EC2 Auto Scaling tracks the instance's health status and warm-up time. When the instance's health status
         * changes to healthy and the specified warm-up time passes, the instance is considered updated and is added to
         * the percentage complete.
         * </p>
         * 
         * @param percentageComplete
         *        The percentage of instances in the warm pool that have been replaced. For each instance replacement,
         *        Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the instance's
         *        health status changes to healthy and the specified warm-up time passes, the instance is considered
         *        updated and is added to the percentage complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageComplete(Integer percentageComplete);

        /**
         * <p>
         * The number of instances remaining to update.
         * </p>
         * 
         * @param instancesToUpdate
         *        The number of instances remaining to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToUpdate(Integer instancesToUpdate);
    }

    static final class BuilderImpl implements Builder {
        private Integer percentageComplete;

        private Integer instancesToUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRefreshWarmPoolProgress model) {
            percentageComplete(model.percentageComplete);
            instancesToUpdate(model.instancesToUpdate);
        }

        public final Integer getPercentageComplete() {
            return percentageComplete;
        }

        public final void setPercentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        @Override
        @Transient
        public final Builder percentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final Integer getInstancesToUpdate() {
            return instancesToUpdate;
        }

        public final void setInstancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
        }

        @Override
        @Transient
        public final Builder instancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
            return this;
        }

        @Override
        public InstanceRefreshWarmPoolProgress build() {
            return new InstanceRefreshWarmPoolProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
