/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information used for one or more scheduled scaling action updates in a
 * <a>BatchPutScheduledUpdateGroupAction</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledUpdateGroupActionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledUpdateGroupActionRequest.Builder, ScheduledUpdateGroupActionRequest> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduledActionName").getter(getter(ScheduledUpdateGroupActionRequest::scheduledActionName))
            .setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ScheduledUpdateGroupActionRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ScheduledUpdateGroupActionRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> RECURRENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Recurrence").getter(getter(ScheduledUpdateGroupActionRequest::recurrence))
            .setter(setter(Builder::recurrence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(ScheduledUpdateGroupActionRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(ScheduledUpdateGroupActionRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredCapacity").getter(getter(ScheduledUpdateGroupActionRequest::desiredCapacity))
            .setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(ScheduledUpdateGroupActionRequest::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, RECURRENCE_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD,
            TIME_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduledActionName;

    private final Instant startTime;

    private final Instant endTime;

    private final String recurrence;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final String timeZone;

    private ScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        this.scheduledActionName = builder.scheduledActionName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recurrence = builder.recurrence;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.timeZone = builder.timeZone;
    }

    /**
     * <p>
     * The name of the scaling action.
     * </p>
     * 
     * @return The name of the scaling action.
     */
    public final String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for
     * example, <code>"2019-06-01T00:00:00Z"</code>).
     * </p>
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at
     * this time, and then performs the action based on the specified recurrence.
     * </p>
     * <p>
     * If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
     * </p>
     * 
     * @return The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes
     *         (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
     *         <p>
     *         If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the
     *         action at this time, and then performs the action based on the specified recurrence.
     *         </p>
     *         <p>
     *         If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time for the recurring schedule to end, in UTC.
     * </p>
     * 
     * @return The date and time for the recurring schedule to end, in UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The recurring schedule for the action, in Unix cron syntax format. This format consists of five fields separated
     * by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for
     * example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a
     * href="http://crontab.org">Crontab</a>.
     * </p>
     * <p>
     * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the
     * boundaries of when the recurring action starts and stops.
     * </p>
     * <p>
     * Cron expressions use Universal Coordinated Time (UTC) by default.
     * </p>
     * 
     * @return The recurring schedule for the action, in Unix cron syntax format. This format consists of five fields
     *         separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must
     *         be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see
     *         <a href="http://crontab.org">Crontab</a>.</p>
     *         <p>
     *         When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they
     *         form the boundaries of when the recurring action starts and stops.
     *         </p>
     *         <p>
     *         Cron expressions use Universal Coordinated Time (UTC) by default.
     */
    public final String recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The minimum size of the Auto Scaling group.
     * </p>
     * 
     * @return The minimum size of the Auto Scaling group.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the Auto Scaling group.
     * </p>
     * 
     * @return The maximum size of the Auto Scaling group.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the
     * capacity it attempts to maintain.
     * </p>
     * 
     * @return The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs
     *         and the capacity it attempts to maintain.
     */
    public final Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
     * </p>
     * <p>
     * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as
     * <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a
     * href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones"
     * >https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.
     * </p>
     * 
     * @return Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
     *         </p>
     *         <p>
     *         Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database
     *         (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a
     *         href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones"
     *         >https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.
     */
    public final String timeZone() {
        return timeZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledUpdateGroupActionRequest)) {
            return false;
        }
        ScheduledUpdateGroupActionRequest other = (ScheduledUpdateGroupActionRequest) obj;
        return Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(recurrence(), other.recurrence()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(desiredCapacity(), other.desiredCapacity())
                && Objects.equals(timeZone(), other.timeZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledUpdateGroupActionRequest").add("ScheduledActionName", scheduledActionName())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Recurrence", recurrence())
                .add("MinSize", minSize()).add("MaxSize", maxSize()).add("DesiredCapacity", desiredCapacity())
                .add("TimeZone", timeZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledUpdateGroupActionRequest, T> g) {
        return obj -> g.apply((ScheduledUpdateGroupActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledUpdateGroupActionRequest> {
        /**
         * <p>
         * The name of the scaling action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scaling action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for
         * example, <code>"2019-06-01T00:00:00Z"</code>).
         * </p>
         * <p>
         * If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the
         * action at this time, and then performs the action based on the specified recurrence.
         * </p>
         * <p>
         * If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
         * </p>
         * 
         * @param startTime
         *        The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in
         *        quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
         *        <p>
         *        If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs
         *        the action at this time, and then performs the action based on the specified recurrence.
         *        </p>
         *        <p>
         *        If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time for the recurring schedule to end, in UTC.
         * </p>
         * 
         * @param endTime
         *        The date and time for the recurring schedule to end, in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The recurring schedule for the action, in Unix cron syntax format. This format consists of five fields
         * separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in
         * quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a
         * href="http://crontab.org">Crontab</a>.
         * </p>
         * <p>
         * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form
         * the boundaries of when the recurring action starts and stops.
         * </p>
         * <p>
         * Cron expressions use Universal Coordinated Time (UTC) by default.
         * </p>
         * 
         * @param recurrence
         *        The recurring schedule for the action, in Unix cron syntax format. This format consists of five fields
         *        separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value
         *        must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this
         *        format, see <a href="http://crontab.org">Crontab</a>.</p>
         *        <p>
         *        When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they
         *        form the boundaries of when the recurring action starts and stops.
         *        </p>
         *        <p>
         *        Cron expressions use Universal Coordinated Time (UTC) by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(String recurrence);

        /**
         * <p>
         * The minimum size of the Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the Auto Scaling group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and
         * the capacity it attempts to maintain.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs
         *        and the capacity it attempts to maintain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
         * </p>
         * <p>
         * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such
         * as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a
         * href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones"
         * >https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.
         * </p>
         * 
         * @param timeZone
         *        Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
         *        </p>
         *        <p>
         *        Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database
         *        (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a
         *        href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones"
         *        >https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);
    }

    static final class BuilderImpl implements Builder {
        private String scheduledActionName;

        private Instant startTime;

        private Instant endTime;

        private String recurrence;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledUpdateGroupActionRequest model) {
            scheduledActionName(model.scheduledActionName);
            startTime(model.startTime);
            endTime(model.endTime);
            recurrence(model.recurrence);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
            timeZone(model.timeZone);
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        @Transient
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRecurrence() {
            return recurrence;
        }

        public final void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        @Override
        @Transient
        public final Builder recurrence(String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        @Transient
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        @Transient
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        @Transient
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        @Transient
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public ScheduledUpdateGroupActionRequest build() {
            return new ScheduledUpdateGroupActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
