/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartInstanceRefreshRequest extends AutoScalingRequest implements
        ToCopyableBuilder<StartInstanceRefreshRequest.Builder, StartInstanceRefreshRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(StartInstanceRefreshRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strategy").getter(getter(StartInstanceRefreshRequest::strategyAsString))
            .setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()).build();

    private static final SdkField<DesiredConfiguration> DESIRED_CONFIGURATION_FIELD = SdkField
            .<DesiredConfiguration> builder(MarshallingType.SDK_POJO).memberName("DesiredConfiguration")
            .getter(getter(StartInstanceRefreshRequest::desiredConfiguration)).setter(setter(Builder::desiredConfiguration))
            .constructor(DesiredConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredConfiguration").build())
            .build();

    private static final SdkField<RefreshPreferences> PREFERENCES_FIELD = SdkField
            .<RefreshPreferences> builder(MarshallingType.SDK_POJO).memberName("Preferences")
            .getter(getter(StartInstanceRefreshRequest::preferences)).setter(setter(Builder::preferences))
            .constructor(RefreshPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferences").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            STRATEGY_FIELD, DESIRED_CONFIGURATION_FIELD, PREFERENCES_FIELD));

    private final String autoScalingGroupName;

    private final String strategy;

    private final DesiredConfiguration desiredConfiguration;

    private final RefreshPreferences preferences;

    private StartInstanceRefreshRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.strategy = builder.strategy;
        this.desiredConfiguration = builder.desiredConfiguration;
        this.preferences = builder.preferences;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.
     * </p>
     * <p>
     * A rolling update helps you update your instances gradually. A rolling update can fail due to failed health checks
     * or if instances are on standby or are protected from scale in. If the rolling update process fails, any instances
     * that are replaced are not rolled back to their previous configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link RefreshStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
     *         <p>
     *         A rolling update helps you update your instances gradually. A rolling update can fail due to failed
     *         health checks or if instances are on standby or are protected from scale in. If the rolling update
     *         process fails, any instances that are replaced are not rolled back to their previous configuration.
     * @see RefreshStrategy
     */
    public final RefreshStrategy strategy() {
        return RefreshStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.
     * </p>
     * <p>
     * A rolling update helps you update your instances gradually. A rolling update can fail due to failed health checks
     * or if instances are on standby or are protected from scale in. If the rolling update process fails, any instances
     * that are replaced are not rolled back to their previous configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link RefreshStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
     *         <p>
     *         A rolling update helps you update your instances gradually. A rolling update can fail due to failed
     *         health checks or if instances are on standby or are protected from scale in. If the rolling update
     *         process fails, any instances that are replaced are not rolled back to their previous configuration.
     * @see RefreshStrategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * The desired configuration. For example, the desired configuration can specify a new launch template or a new
     * version of the current launch template.
     * </p>
     * <p>
     * Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to
     * reflect the new desired configuration.
     * </p>
     * <note>
     * <p>
     * When you specify a new launch template or a new version of the current launch template for your desired
     * configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled, Amazon
     * EC2 Auto Scaling skips replacing instances that already use the specified launch template and version. This can
     * help you reduce the number of replacements that are required to apply updates.
     * </p>
     * </note>
     * 
     * @return The desired configuration. For example, the desired configuration can specify a new launch template or a
     *         new version of the current launch template.</p>
     *         <p>
     *         Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling
     *         group to reflect the new desired configuration.
     *         </p>
     *         <note>
     *         <p>
     *         When you specify a new launch template or a new version of the current launch template for your desired
     *         configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled,
     *         Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and
     *         version. This can help you reduce the number of replacements that are required to apply updates.
     *         </p>
     */
    public final DesiredConfiguration desiredConfiguration() {
        return desiredConfiguration;
    }

    /**
     * <p>
     * Set of preferences associated with the instance refresh request. If not provided, the default values are used.
     * </p>
     * 
     * @return Set of preferences associated with the instance refresh request. If not provided, the default values are
     *         used.
     */
    public final RefreshPreferences preferences() {
        return preferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(desiredConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(preferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstanceRefreshRequest)) {
            return false;
        }
        StartInstanceRefreshRequest other = (StartInstanceRefreshRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(strategyAsString(), other.strategyAsString())
                && Objects.equals(desiredConfiguration(), other.desiredConfiguration())
                && Objects.equals(preferences(), other.preferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartInstanceRefreshRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("Strategy", strategyAsString()).add("DesiredConfiguration", desiredConfiguration())
                .add("Preferences", preferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "DesiredConfiguration":
            return Optional.ofNullable(clazz.cast(desiredConfiguration()));
        case "Preferences":
            return Optional.ofNullable(clazz.cast(preferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartInstanceRefreshRequest, T> g) {
        return obj -> g.apply((StartInstanceRefreshRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartInstanceRefreshRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.
         * </p>
         * <p>
         * A rolling update helps you update your instances gradually. A rolling update can fail due to failed health
         * checks or if instances are on standby or are protected from scale in. If the rolling update process fails,
         * any instances that are replaced are not rolled back to their previous configuration.
         * </p>
         * 
         * @param strategy
         *        The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
         *        <p>
         *        A rolling update helps you update your instances gradually. A rolling update can fail due to failed
         *        health checks or if instances are on standby or are protected from scale in. If the rolling update
         *        process fails, any instances that are replaced are not rolled back to their previous configuration.
         * @see RefreshStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.
         * </p>
         * <p>
         * A rolling update helps you update your instances gradually. A rolling update can fail due to failed health
         * checks or if instances are on standby or are protected from scale in. If the rolling update process fails,
         * any instances that are replaced are not rolled back to their previous configuration.
         * </p>
         * 
         * @param strategy
         *        The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
         *        <p>
         *        A rolling update helps you update your instances gradually. A rolling update can fail due to failed
         *        health checks or if instances are on standby or are protected from scale in. If the rolling update
         *        process fails, any instances that are replaced are not rolled back to their previous configuration.
         * @see RefreshStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshStrategy
         */
        Builder strategy(RefreshStrategy strategy);

        /**
         * <p>
         * The desired configuration. For example, the desired configuration can specify a new launch template or a new
         * version of the current launch template.
         * </p>
         * <p>
         * Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to
         * reflect the new desired configuration.
         * </p>
         * <note>
         * <p>
         * When you specify a new launch template or a new version of the current launch template for your desired
         * configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled,
         * Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and version.
         * This can help you reduce the number of replacements that are required to apply updates.
         * </p>
         * </note>
         * 
         * @param desiredConfiguration
         *        The desired configuration. For example, the desired configuration can specify a new launch template or
         *        a new version of the current launch template.</p>
         *        <p>
         *        Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling
         *        group to reflect the new desired configuration.
         *        </p>
         *        <note>
         *        <p>
         *        When you specify a new launch template or a new version of the current launch template for your
         *        desired configuration, consider enabling the <code>SkipMatching</code> property in preferences. If
         *        it's enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch
         *        template and version. This can help you reduce the number of replacements that are required to apply
         *        updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredConfiguration(DesiredConfiguration desiredConfiguration);

        /**
         * <p>
         * The desired configuration. For example, the desired configuration can specify a new launch template or a new
         * version of the current launch template.
         * </p>
         * <p>
         * Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to
         * reflect the new desired configuration.
         * </p>
         * <note>
         * <p>
         * When you specify a new launch template or a new version of the current launch template for your desired
         * configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled,
         * Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and version.
         * This can help you reduce the number of replacements that are required to apply updates.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link DesiredConfiguration.Builder}
         * avoiding the need to create one manually via {@link DesiredConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DesiredConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #desiredConfiguration(DesiredConfiguration)}.
         * 
         * @param desiredConfiguration
         *        a consumer that will call methods on {@link DesiredConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #desiredConfiguration(DesiredConfiguration)
         */
        default Builder desiredConfiguration(Consumer<DesiredConfiguration.Builder> desiredConfiguration) {
            return desiredConfiguration(DesiredConfiguration.builder().applyMutation(desiredConfiguration).build());
        }

        /**
         * <p>
         * Set of preferences associated with the instance refresh request. If not provided, the default values are
         * used.
         * </p>
         * 
         * @param preferences
         *        Set of preferences associated with the instance refresh request. If not provided, the default values
         *        are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferences(RefreshPreferences preferences);

        /**
         * <p>
         * Set of preferences associated with the instance refresh request. If not provided, the default values are
         * used.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshPreferences.Builder} avoiding the
         * need to create one manually via {@link RefreshPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshPreferences.Builder#build()} is called immediately and its
         * result is passed to {@link #preferences(RefreshPreferences)}.
         * 
         * @param preferences
         *        a consumer that will call methods on {@link RefreshPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preferences(RefreshPreferences)
         */
        default Builder preferences(Consumer<RefreshPreferences.Builder> preferences) {
            return preferences(RefreshPreferences.builder().applyMutation(preferences).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String strategy;

        private DesiredConfiguration desiredConfiguration;

        private RefreshPreferences preferences;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstanceRefreshRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            strategy(model.strategy);
            desiredConfiguration(model.desiredConfiguration);
            preferences(model.preferences);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(RefreshStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final DesiredConfiguration.Builder getDesiredConfiguration() {
            return desiredConfiguration != null ? desiredConfiguration.toBuilder() : null;
        }

        public final void setDesiredConfiguration(DesiredConfiguration.BuilderImpl desiredConfiguration) {
            this.desiredConfiguration = desiredConfiguration != null ? desiredConfiguration.build() : null;
        }

        @Override
        public final Builder desiredConfiguration(DesiredConfiguration desiredConfiguration) {
            this.desiredConfiguration = desiredConfiguration;
            return this;
        }

        public final RefreshPreferences.Builder getPreferences() {
            return preferences != null ? preferences.toBuilder() : null;
        }

        public final void setPreferences(RefreshPreferences.BuilderImpl preferences) {
            this.preferences = preferences != null ? preferences.build() : null;
        }

        @Override
        public final Builder preferences(RefreshPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartInstanceRefreshRequest build() {
            return new StartInstanceRefreshRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
