/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a traffic source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficSourceState implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficSourceState.Builder, TrafficSourceState> {
    private static final SdkField<String> TRAFFIC_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficSource").getter(getter(TrafficSourceState::trafficSource)).setter(setter(Builder::trafficSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSource").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(TrafficSourceState::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_SOURCE_FIELD,
            STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trafficSource;

    private final String state;

    private TrafficSourceState(BuilderImpl builder) {
        this.trafficSource = builder.trafficSource;
        this.state = builder.state;
    }

    /**
     * <p>
     * The unique identifier of the traffic source. Currently, this is the Amazon Resource Name (ARN) for a VPC Lattice
     * target group.
     * </p>
     * 
     * @return The unique identifier of the traffic source. Currently, this is the Amazon Resource Name (ARN) for a VPC
     *         Lattice target group.
     */
    public final String trafficSource() {
        return trafficSource;
    }

    /**
     * <p>
     * The following are the possible states for a VPC Lattice target group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Added</code> - All Auto Scaling instances are registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InService</code> - At least one Auto Scaling instance passed the <code>VPC_LATTICE</code> health check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If connection
     * draining is enabled, VPC Lattice waits for in-flight requests to complete before deregistering the instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The following are the possible states for a VPC Lattice target group:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Added</code> - All Auto Scaling instances are registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InService</code> - At least one Auto Scaling instance passed the <code>VPC_LATTICE</code> health
     *         check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
     *         connection draining is enabled, VPC Lattice waits for in-flight requests to complete before deregistering
     *         the instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficSource());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficSourceState)) {
            return false;
        }
        TrafficSourceState other = (TrafficSourceState) obj;
        return Objects.equals(trafficSource(), other.trafficSource()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficSourceState").add("TrafficSource", trafficSource()).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficSource":
            return Optional.ofNullable(clazz.cast(trafficSource()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficSourceState, T> g) {
        return obj -> g.apply((TrafficSourceState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficSourceState> {
        /**
         * <p>
         * The unique identifier of the traffic source. Currently, this is the Amazon Resource Name (ARN) for a VPC
         * Lattice target group.
         * </p>
         * 
         * @param trafficSource
         *        The unique identifier of the traffic source. Currently, this is the Amazon Resource Name (ARN) for a
         *        VPC Lattice target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSource(String trafficSource);

        /**
         * <p>
         * The following are the possible states for a VPC Lattice target group:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Added</code> - All Auto Scaling instances are registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InService</code> - At least one Auto Scaling instance passed the <code>VPC_LATTICE</code> health check.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
         * connection draining is enabled, VPC Lattice waits for in-flight requests to complete before deregistering the
         * instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The following are the possible states for a VPC Lattice target group:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Added</code> - All Auto Scaling instances are registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InService</code> - At least one Auto Scaling instance passed the <code>VPC_LATTICE</code> health
         *        check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
         *        connection draining is enabled, VPC Lattice waits for in-flight requests to complete before
         *        deregistering the instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String trafficSource;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficSourceState model) {
            trafficSource(model.trafficSource);
            state(model.state);
        }

        public final String getTrafficSource() {
            return trafficSource;
        }

        public final void setTrafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
        }

        @Override
        public final Builder trafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public TrafficSourceState build() {
            return new TrafficSourceState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
