/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the CloudWatch alarm specification to use in an instance refresh.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmSpecification.Builder, AlarmSpecification> {
    private static final SdkField<List<String>> ALARMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Alarms")
            .getter(getter(AlarmSpecification::alarms))
            .setter(setter(Builder::alarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> alarms;

    private AlarmSpecification(BuilderImpl builder) {
        this.alarms = builder.alarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Alarms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlarms() {
        return alarms != null && !(alarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of one or more CloudWatch alarms to monitor for the instance refresh.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarms} method.
     * </p>
     * 
     * @return The names of one or more CloudWatch alarms to monitor for the instance refresh.
     */
    public final List<String> alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarms() ? alarms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmSpecification)) {
            return false;
        }
        AlarmSpecification other = (AlarmSpecification) obj;
        return hasAlarms() == other.hasAlarms() && Objects.equals(alarms(), other.alarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmSpecification").add("Alarms", hasAlarms() ? alarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmSpecification, T> g) {
        return obj -> g.apply((AlarmSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmSpecification> {
        /**
         * <p>
         * The names of one or more CloudWatch alarms to monitor for the instance refresh.
         * </p>
         * 
         * @param alarms
         *        The names of one or more CloudWatch alarms to monitor for the instance refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<String> alarms);

        /**
         * <p>
         * The names of one or more CloudWatch alarms to monitor for the instance refresh.
         * </p>
         * 
         * @param alarms
         *        The names of one or more CloudWatch alarms to monitor for the instance refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(String... alarms);
    }

    static final class BuilderImpl implements Builder {
        private List<String> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmSpecification model) {
            alarms(model.alarms);
        }

        public final Collection<String> getAlarms() {
            if (alarms instanceof SdkAutoConstructList) {
                return null;
            }
            return alarms;
        }

        public final void setAlarms(Collection<String> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
        }

        @Override
        public final Builder alarms(Collection<String> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(String... alarms) {
            alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        public AlarmSpecification build() {
            return new AlarmSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
