/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.MetricType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredefinedMetricSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredefinedMetricSpecification> {
    private static final SdkField<String> PREDEFINED_METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredefinedMetricType").getter(PredefinedMetricSpecification.getter(PredefinedMetricSpecification::predefinedMetricTypeAsString)).setter(PredefinedMetricSpecification.setter(Builder::predefinedMetricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricType").build()}).build();
    private static final SdkField<String> RESOURCE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceLabel").getter(PredefinedMetricSpecification.getter(PredefinedMetricSpecification::resourceLabel)).setter(PredefinedMetricSpecification.setter(Builder::resourceLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_TYPE_FIELD, RESOURCE_LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String predefinedMetricType;
    private final String resourceLabel;

    private PredefinedMetricSpecification(BuilderImpl builder) {
        this.predefinedMetricType = builder.predefinedMetricType;
        this.resourceLabel = builder.resourceLabel;
    }

    public final MetricType predefinedMetricType() {
        return MetricType.fromValue(this.predefinedMetricType);
    }

    public final String predefinedMetricTypeAsString() {
        return this.predefinedMetricType;
    }

    public final String resourceLabel() {
        return this.resourceLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedMetricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedMetricSpecification)) {
            return false;
        }
        PredefinedMetricSpecification other = (PredefinedMetricSpecification)obj;
        return Objects.equals(this.predefinedMetricTypeAsString(), other.predefinedMetricTypeAsString()) && Objects.equals(this.resourceLabel(), other.resourceLabel());
    }

    public final String toString() {
        return ToString.builder((String)"PredefinedMetricSpecification").add("PredefinedMetricType", (Object)this.predefinedMetricTypeAsString()).add("ResourceLabel", (Object)this.resourceLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredefinedMetricType": {
                return Optional.ofNullable(clazz.cast(this.predefinedMetricTypeAsString()));
            }
            case "ResourceLabel": {
                return Optional.ofNullable(clazz.cast(this.resourceLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredefinedMetricSpecification, T> g) {
        return obj -> g.apply((PredefinedMetricSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String predefinedMetricType;
        private String resourceLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedMetricSpecification model) {
            this.predefinedMetricType(model.predefinedMetricType);
            this.resourceLabel(model.resourceLabel);
        }

        public final String getPredefinedMetricType() {
            return this.predefinedMetricType;
        }

        public final void setPredefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
        }

        @Override
        public final Builder predefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
            return this;
        }

        @Override
        public final Builder predefinedMetricType(MetricType predefinedMetricType) {
            this.predefinedMetricType(predefinedMetricType == null ? null : predefinedMetricType.toString());
            return this;
        }

        public final String getResourceLabel() {
            return this.resourceLabel;
        }

        public final void setResourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
        }

        @Override
        public final Builder resourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        public PredefinedMetricSpecification build() {
            return new PredefinedMetricSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredefinedMetricSpecification> {
        public Builder predefinedMetricType(String var1);

        public Builder predefinedMetricType(MetricType var1);

        public Builder resourceLabel(String var1);
    }
}

