/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficSourceState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficSourceState> {
    private static final SdkField<String> TRAFFIC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficSource").getter(TrafficSourceState.getter(TrafficSourceState::trafficSource)).setter(TrafficSourceState.setter(Builder::trafficSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSource").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TrafficSourceState.getter(TrafficSourceState::state)).setter(TrafficSourceState.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_SOURCE_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trafficSource;
    private final String state;

    private TrafficSourceState(BuilderImpl builder) {
        this.trafficSource = builder.trafficSource;
        this.state = builder.state;
    }

    public final String trafficSource() {
        return this.trafficSource;
    }

    public final String state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficSourceState)) {
            return false;
        }
        TrafficSourceState other = (TrafficSourceState)obj;
        return Objects.equals(this.trafficSource(), other.trafficSource()) && Objects.equals(this.state(), other.state());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficSourceState").add("TrafficSource", (Object)this.trafficSource()).add("State", (Object)this.state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficSource": {
                return Optional.ofNullable(clazz.cast(this.trafficSource()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficSourceState, T> g) {
        return obj -> g.apply((TrafficSourceState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficSource;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficSourceState model) {
            this.trafficSource(model.trafficSource);
            this.state(model.state);
        }

        public final String getTrafficSource() {
            return this.trafficSource;
        }

        public final void setTrafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
        }

        @Override
        public final Builder trafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public TrafficSourceState build() {
            return new TrafficSourceState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficSourceState> {
        public Builder trafficSource(String var1);

        public Builder state(String var1);
    }
}

