/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance maintenance policy.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html">Set
 * instance maintenance policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMaintenancePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMaintenancePolicy.Builder, InstanceMaintenancePolicy> {
    private static final SdkField<Integer> MIN_HEALTHY_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinHealthyPercentage").getter(getter(InstanceMaintenancePolicy::minHealthyPercentage))
            .setter(setter(Builder::minHealthyPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinHealthyPercentage").build())
            .build();

    private static final SdkField<Integer> MAX_HEALTHY_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxHealthyPercentage").getter(getter(InstanceMaintenancePolicy::maxHealthyPercentage))
            .setter(setter(Builder::maxHealthyPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHealthyPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_HEALTHY_PERCENTAGE_FIELD,
            MAX_HEALTHY_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minHealthyPercentage;

    private final Integer maxHealthyPercentage;

    private InstanceMaintenancePolicy(BuilderImpl builder) {
        this.minHealthyPercentage = builder.minHealthyPercentage;
        this.maxHealthyPercentage = builder.maxHealthyPercentage;
    }

    /**
     * <p>
     * Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents
     * the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when
     * replacing instances. Value range is 0 to 100. After it's set, a value of <code>-1</code> will clear the
     * previously set value.
     * </p>
     * 
     * @return Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It
     *         represents the minimum percentage of the group to keep in service, healthy, and ready to use to support
     *         your workload when replacing instances. Value range is 0 to 100. After it's set, a value of
     *         <code>-1</code> will clear the previously set value.
     */
    public final Integer minHealthyPercentage() {
        return minHealthyPercentage;
    }

    /**
     * <p>
     * Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents
     * the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when
     * replacing instances. Value range is 100 to 200. After it's set, a value of <code>-1</code> will clear the
     * previously set value.
     * </p>
     * <p>
     * Both <code>MinHealthyPercentage</code> and <code>MaxHealthyPercentage</code> must be specified, and the
     * difference between them cannot be greater than 100. A large range increases the number of instances that can be
     * replaced at the same time.
     * </p>
     * 
     * @return Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It
     *         represents the maximum percentage of the group that can be in service and healthy, or pending, to support
     *         your workload when replacing instances. Value range is 100 to 200. After it's set, a value of
     *         <code>-1</code> will clear the previously set value. </p>
     *         <p>
     *         Both <code>MinHealthyPercentage</code> and <code>MaxHealthyPercentage</code> must be specified, and the
     *         difference between them cannot be greater than 100. A large range increases the number of instances that
     *         can be replaced at the same time.
     */
    public final Integer maxHealthyPercentage() {
        return maxHealthyPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxHealthyPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMaintenancePolicy)) {
            return false;
        }
        InstanceMaintenancePolicy other = (InstanceMaintenancePolicy) obj;
        return Objects.equals(minHealthyPercentage(), other.minHealthyPercentage())
                && Objects.equals(maxHealthyPercentage(), other.maxHealthyPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMaintenancePolicy").add("MinHealthyPercentage", minHealthyPercentage())
                .add("MaxHealthyPercentage", maxHealthyPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinHealthyPercentage":
            return Optional.ofNullable(clazz.cast(minHealthyPercentage()));
        case "MaxHealthyPercentage":
            return Optional.ofNullable(clazz.cast(maxHealthyPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMaintenancePolicy, T> g) {
        return obj -> g.apply((InstanceMaintenancePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMaintenancePolicy> {
        /**
         * <p>
         * Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It
         * represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your
         * workload when replacing instances. Value range is 0 to 100. After it's set, a value of <code>-1</code> will
         * clear the previously set value.
         * </p>
         * 
         * @param minHealthyPercentage
         *        Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It
         *        represents the minimum percentage of the group to keep in service, healthy, and ready to use to
         *        support your workload when replacing instances. Value range is 0 to 100. After it's set, a value of
         *        <code>-1</code> will clear the previously set value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minHealthyPercentage(Integer minHealthyPercentage);

        /**
         * <p>
         * Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It
         * represents the maximum percentage of the group that can be in service and healthy, or pending, to support
         * your workload when replacing instances. Value range is 100 to 200. After it's set, a value of <code>-1</code>
         * will clear the previously set value.
         * </p>
         * <p>
         * Both <code>MinHealthyPercentage</code> and <code>MaxHealthyPercentage</code> must be specified, and the
         * difference between them cannot be greater than 100. A large range increases the number of instances that can
         * be replaced at the same time.
         * </p>
         * 
         * @param maxHealthyPercentage
         *        Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It
         *        represents the maximum percentage of the group that can be in service and healthy, or pending, to
         *        support your workload when replacing instances. Value range is 100 to 200. After it's set, a value of
         *        <code>-1</code> will clear the previously set value. </p>
         *        <p>
         *        Both <code>MinHealthyPercentage</code> and <code>MaxHealthyPercentage</code> must be specified, and
         *        the difference between them cannot be greater than 100. A large range increases the number of
         *        instances that can be replaced at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHealthyPercentage(Integer maxHealthyPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer minHealthyPercentage;

        private Integer maxHealthyPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMaintenancePolicy model) {
            minHealthyPercentage(model.minHealthyPercentage);
            maxHealthyPercentage(model.maxHealthyPercentage);
        }

        public final Integer getMinHealthyPercentage() {
            return minHealthyPercentage;
        }

        public final void setMinHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
        }

        @Override
        public final Builder minHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
            return this;
        }

        public final Integer getMaxHealthyPercentage() {
            return maxHealthyPercentage;
        }

        public final void setMaxHealthyPercentage(Integer maxHealthyPercentage) {
            this.maxHealthyPercentage = maxHealthyPercentage;
        }

        @Override
        public final Builder maxHealthyPercentage(Integer maxHealthyPercentage) {
            this.maxHealthyPercentage = maxHealthyPercentage;
            return this;
        }

        @Override
        public InstanceMaintenancePolicy build() {
            return new InstanceMaintenancePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
