/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.autoscaling.model.ActiveInstanceRefreshNotFoundException;
import software.amazon.awssdk.services.autoscaling.model.AlreadyExistsException;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastRequest;
import software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastResponse;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshInProgressException;
import software.amazon.awssdk.services.autoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscaling.model.IrreversibleInstanceRefreshException;
import software.amazon.awssdk.services.autoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.PutWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.PutWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResourceContentionException;
import software.amazon.awssdk.services.autoscaling.model.ResourceInUseException;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityInProgressException;
import software.amazon.awssdk.services.autoscaling.model.ServiceLinkedRoleFailureException;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolIterable;
import software.amazon.awssdk.services.autoscaling.waiters.AutoScalingWaiter;

/**
 * Service client for accessing Auto Scaling. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon EC2 Auto Scaling</fullname>
 * <p>
 * Amazon EC2 Auto Scaling is designed to automatically launch and terminate EC2 instances based on user-defined scaling
 * policies, scheduled actions, and health checks.
 * </p>
 * <p>
 * For more information, see the <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/">Amazon EC2 Auto
 * Scaling User Guide</a> and the <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/Welcome.html">Amazon
 * EC2 Auto Scaling API Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AutoScalingClient extends AwsClient {
    String SERVICE_NAME = "autoscaling";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "autoscaling";

    /**
     * <p>
     * Attaches one or more EC2 instances to the specified Auto Scaling group.
     * </p>
     * <p>
     * When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of
     * instances being attached. If the number of instances being attached plus the desired capacity of the group
     * exceeds the maximum size of the group, the operation fails.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with
     * the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also
     * registered with the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html">Attach EC2 instances to
     * your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param attachInstancesRequest
     * @return Result of the AttachInstances operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default AttachInstancesResponse attachInstances(AttachInstancesRequest attachInstancesRequest)
            throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more EC2 instances to the specified Auto Scaling group.
     * </p>
     * <p>
     * When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of
     * instances being attached. If the number of instances being attached plus the desired capacity of the group
     * exceeds the maximum size of the group, the operation fails.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with
     * the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also
     * registered with the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html">Attach EC2 instances to
     * your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link AttachInstancesRequest#builder()}
     * </p>
     *
     * @param attachInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the AttachInstances operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default AttachInstancesResponse attachInstances(Consumer<AttachInstancesRequest.Builder> attachInstancesRequest)
            throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return attachInstances(AttachInstancesRequest.builder().applyMutation(attachInstancesRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>AttachLoadBalancerTargetGroups</code> API operation and <code>AttachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more target groups to the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation is used with the following load balancer types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer - Operates at the network layer (layer 3).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To describe the target groups for an Auto Scaling group, call the <a>DescribeLoadBalancerTargetGroups</a> API. To
     * detach the target group from the Auto Scaling group, call the <a>DetachLoadBalancerTargetGroups</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing target groups or Classic Load Balancers from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     *
     * @param attachLoadBalancerTargetGroupsRequest
     * @return Result of the AttachLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroups(
            AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) throws ResourceContentionException,
            ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>AttachLoadBalancerTargetGroups</code> API operation and <code>AttachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more target groups to the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation is used with the following load balancer types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer - Operates at the network layer (layer 3).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To describe the target groups for an Auto Scaling group, call the <a>DescribeLoadBalancerTargetGroups</a> API. To
     * detach the target group from the Auto Scaling group, call the <a>DetachLoadBalancerTargetGroups</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing target groups or Classic Load Balancers from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link AttachLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param attachLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the AttachLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroups(
            Consumer<AttachLoadBalancerTargetGroupsRequest.Builder> attachLoadBalancerTargetGroupsRequest)
            throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return attachLoadBalancerTargetGroups(AttachLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(attachLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancers</code>. You can use both the original
     * <code>AttachLoadBalancers</code> API operation and <code>AttachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more Classic Load Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling
     * registers the running instances with these Classic Load Balancers.
     * </p>
     * <p>
     * To describe the load balancers for an Auto Scaling group, call the <a>DescribeLoadBalancers</a> API. To detach a
     * load balancer from the Auto Scaling group, call the <a>DetachLoadBalancers</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing Classic Load Balancers or target groups from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     *
     * @param attachLoadBalancersRequest
     * @return Result of the AttachLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancersResponse attachLoadBalancers(AttachLoadBalancersRequest attachLoadBalancersRequest)
            throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancers</code>. You can use both the original
     * <code>AttachLoadBalancers</code> API operation and <code>AttachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more Classic Load Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling
     * registers the running instances with these Classic Load Balancers.
     * </p>
     * <p>
     * To describe the load balancers for an Auto Scaling group, call the <a>DescribeLoadBalancers</a> API. To detach a
     * load balancer from the Auto Scaling group, call the <a>DetachLoadBalancers</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing Classic Load Balancers or target groups from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link AttachLoadBalancersRequest#builder()}
     * </p>
     *
     * @param attachLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest.Builder} to create a
     *        request.
     * @return Result of the AttachLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancersResponse attachLoadBalancers(
            Consumer<AttachLoadBalancersRequest.Builder> attachLoadBalancersRequest) throws ResourceContentionException,
            ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        return attachLoadBalancers(AttachLoadBalancersRequest.builder().applyMutation(attachLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Attaches one or more traffic sources to the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use any of the following as traffic sources for an Auto Scaling group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Classic Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * VPC Lattice
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is additive and does not detach existing traffic sources from the Auto Scaling group.
     * </p>
     * <p>
     * After the operation completes, use the <a>DescribeTrafficSources</a> API to return details about the state of the
     * attachments between traffic sources and your Auto Scaling group. To detach a traffic source from the Auto Scaling
     * group, call the <a>DetachTrafficSources</a> API.
     * </p>
     *
     * @param attachTrafficSourcesRequest
     * @return Result of the AttachTrafficSources operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachTrafficSourcesResponse attachTrafficSources(AttachTrafficSourcesRequest attachTrafficSourcesRequest)
            throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more traffic sources to the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use any of the following as traffic sources for an Auto Scaling group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Classic Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * VPC Lattice
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is additive and does not detach existing traffic sources from the Auto Scaling group.
     * </p>
     * <p>
     * After the operation completes, use the <a>DescribeTrafficSources</a> API to return details about the state of the
     * attachments between traffic sources and your Auto Scaling group. To detach a traffic source from the Auto Scaling
     * group, call the <a>DetachTrafficSources</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link AttachTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param attachTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the AttachTrafficSources operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.AttachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachTrafficSourcesResponse attachTrafficSources(
            Consumer<AttachTrafficSourcesRequest.Builder> attachTrafficSourcesRequest) throws ResourceContentionException,
            ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        return attachTrafficSources(AttachTrafficSourcesRequest.builder().applyMutation(attachTrafficSourcesRequest).build());
    }

    /**
     * <p>
     * Deletes one or more scheduled actions for the specified Auto Scaling group.
     * </p>
     *
     * @param batchDeleteScheduledActionRequest
     * @return Result of the BatchDeleteScheduledAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.BatchDeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchDeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteScheduledActionResponse batchDeleteScheduledAction(
            BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more scheduled actions for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteScheduledActionRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteScheduledActionRequest#builder()}
     * </p>
     *
     * @param batchDeleteScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDeleteScheduledAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.BatchDeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchDeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteScheduledActionResponse batchDeleteScheduledAction(
            Consumer<BatchDeleteScheduledActionRequest.Builder> batchDeleteScheduledActionRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return batchDeleteScheduledAction(BatchDeleteScheduledActionRequest.builder()
                .applyMutation(batchDeleteScheduledActionRequest).build());
    }

    /**
     * <p>
     * Creates or updates one or more scheduled scaling actions for an Auto Scaling group.
     * </p>
     *
     * @param batchPutScheduledUpdateGroupActionRequest
     * @return Result of the BatchPutScheduledUpdateGroupAction operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.BatchPutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutScheduledUpdateGroupActionResponse batchPutScheduledUpdateGroupAction(
            BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) throws AlreadyExistsException,
            LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates one or more scheduled scaling actions for an Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutScheduledUpdateGroupActionRequest.Builder}
     * avoiding the need to create one manually via {@link BatchPutScheduledUpdateGroupActionRequest#builder()}
     * </p>
     *
     * @param batchPutScheduledUpdateGroupActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest.Builder}
     *        to create a request.
     * @return Result of the BatchPutScheduledUpdateGroupAction operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.BatchPutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutScheduledUpdateGroupActionResponse batchPutScheduledUpdateGroupAction(
            Consumer<BatchPutScheduledUpdateGroupActionRequest.Builder> batchPutScheduledUpdateGroupActionRequest)
            throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return batchPutScheduledUpdateGroupAction(BatchPutScheduledUpdateGroupActionRequest.builder()
                .applyMutation(batchPutScheduledUpdateGroupActionRequest).build());
    }

    /**
     * <p>
     * Cancels an instance refresh or rollback that is in progress. If an instance refresh or rollback is not in
     * progress, an <code>ActiveInstanceRefreshNotFound</code> error occurs.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * When you cancel an instance refresh, this does not roll back any changes that it made. Use the
     * <a>RollbackInstanceRefresh</a> API to roll back instead.
     * </p>
     *
     * @param cancelInstanceRefreshRequest
     * @return Result of the CancelInstanceRefresh operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ActiveInstanceRefreshNotFoundException
     *         The request failed because an active instance refresh or rollback for the specified Auto Scaling group
     *         was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CancelInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CancelInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelInstanceRefreshResponse cancelInstanceRefresh(CancelInstanceRefreshRequest cancelInstanceRefreshRequest)
            throws LimitExceededException, ResourceContentionException, ActiveInstanceRefreshNotFoundException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an instance refresh or rollback that is in progress. If an instance refresh or rollback is not in
     * progress, an <code>ActiveInstanceRefreshNotFound</code> error occurs.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * When you cancel an instance refresh, this does not roll back any changes that it made. Use the
     * <a>RollbackInstanceRefresh</a> API to roll back instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelInstanceRefreshRequest.Builder} avoiding the
     * need to create one manually via {@link CancelInstanceRefreshRequest#builder()}
     * </p>
     *
     * @param cancelInstanceRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshRequest.Builder} to create a
     *        request.
     * @return Result of the CancelInstanceRefresh operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ActiveInstanceRefreshNotFoundException
     *         The request failed because an active instance refresh or rollback for the specified Auto Scaling group
     *         was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CancelInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CancelInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelInstanceRefreshResponse cancelInstanceRefresh(
            Consumer<CancelInstanceRefreshRequest.Builder> cancelInstanceRefreshRequest) throws LimitExceededException,
            ResourceContentionException, ActiveInstanceRefreshNotFoundException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return cancelInstanceRefresh(CancelInstanceRefreshRequest.builder().applyMutation(cancelInstanceRefreshRequest).build());
    }

    /**
     * <p>
     * Completes the lifecycle action for the specified token or instance with the specified result.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.</b>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/completing-lifecycle-hooks.html">Complete a lifecycle
     * action</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param completeLifecycleActionRequest
     * @return Result of the CompleteLifecycleAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CompleteLifecycleAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompleteLifecycleActionResponse completeLifecycleAction(CompleteLifecycleActionRequest completeLifecycleActionRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Completes the lifecycle action for the specified token or instance with the specified result.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.</b>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/completing-lifecycle-hooks.html">Complete a lifecycle
     * action</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteLifecycleActionRequest.Builder} avoiding
     * the need to create one manually via {@link CompleteLifecycleActionRequest#builder()}
     * </p>
     *
     * @param completeLifecycleActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest.Builder} to create
     *        a request.
     * @return Result of the CompleteLifecycleAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CompleteLifecycleAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompleteLifecycleActionResponse completeLifecycleAction(
            Consumer<CompleteLifecycleActionRequest.Builder> completeLifecycleActionRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return completeLifecycleAction(CompleteLifecycleActionRequest.builder().applyMutation(completeLifecycleActionRequest)
                .build());
    }

    /**
     * <p>
     * <b>We strongly recommend using a launch template when calling this operation to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Creates an Auto Scaling group with the specified name and attributes.
     * </p>
     * <p>
     * If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For introductory exercises for creating an Auto Scaling group, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html">Getting started with
     * Amazon EC2 Auto Scaling</a> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html">Tutorial: Set up a
     * scaled and load-balanced application</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html">Auto Scaling groups</a>
     * in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Every Auto Scaling group has three size properties (<code>DesiredCapacity</code>, <code>MaxSize</code>, and
     * <code>MinSize</code>). Usually, you set these sizes based on a specific number of instances. However, if you
     * configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with
     * the same units that you use for weighting instances.
     * </p>
     *
     * @param createAutoScalingGroupRequest
     * @return Result of the CreateAutoScalingGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CreateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAutoScalingGroupResponse createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest)
            throws AlreadyExistsException, LimitExceededException, ResourceContentionException,
            ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>We strongly recommend using a launch template when calling this operation to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Creates an Auto Scaling group with the specified name and attributes.
     * </p>
     * <p>
     * If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For introductory exercises for creating an Auto Scaling group, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html">Getting started with
     * Amazon EC2 Auto Scaling</a> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html">Tutorial: Set up a
     * scaled and load-balanced application</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html">Auto Scaling groups</a>
     * in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Every Auto Scaling group has three size properties (<code>DesiredCapacity</code>, <code>MaxSize</code>, and
     * <code>MinSize</code>). Usually, you set these sizes based on a specific number of instances. However, if you
     * configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with
     * the same units that you use for weighting instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutoScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param createAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest.Builder} to create
     *        a request.
     * @return Result of the CreateAutoScalingGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CreateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAutoScalingGroupResponse createAutoScalingGroup(
            Consumer<CreateAutoScalingGroupRequest.Builder> createAutoScalingGroupRequest) throws AlreadyExistsException,
            LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return createAutoScalingGroup(CreateAutoScalingGroupRequest.builder().applyMutation(createAutoScalingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a launch configuration.
     * </p>
     * <p>
     * If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html">Launch configurations</a>
     * in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a launch
     * template or a launch configuration. We strongly recommend that you do not use launch configurations. They do not
     * provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For information about using launch
     * templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch
     * templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * </note>
     *
     * @param createLaunchConfigurationRequest
     * @return Result of the CreateLaunchConfiguration operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CreateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchConfigurationResponse createLaunchConfiguration(
            CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AlreadyExistsException,
            LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a launch configuration.
     * </p>
     * <p>
     * If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html">Launch configurations</a>
     * in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a launch
     * template or a launch configuration. We strongly recommend that you do not use launch configurations. They do not
     * provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For information about using launch
     * templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch
     * templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param createLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLaunchConfiguration operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CreateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchConfigurationResponse createLaunchConfiguration(
            Consumer<CreateLaunchConfigurationRequest.Builder> createLaunchConfigurationRequest) throws AlreadyExistsException,
            LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return createLaunchConfiguration(CreateLaunchConfigurationRequest.builder()
                .applyMutation(createLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates tags for the specified Auto Scaling group.
     * </p>
     * <p>
     * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and
     * you do not get an error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param createOrUpdateTagsRequest
     * @return Result of the CreateOrUpdateTags operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CreateOrUpdateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOrUpdateTagsResponse createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest)
            throws LimitExceededException, AlreadyExistsException, ResourceContentionException, ResourceInUseException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates tags for the specified Auto Scaling group.
     * </p>
     * <p>
     * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and
     * you do not get an error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrUpdateTagsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOrUpdateTagsRequest#builder()}
     * </p>
     *
     * @param createOrUpdateTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest.Builder} to create a
     *        request.
     * @return Result of the CreateOrUpdateTags operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.CreateOrUpdateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOrUpdateTagsResponse createOrUpdateTags(Consumer<CreateOrUpdateTagsRequest.Builder> createOrUpdateTagsRequest)
            throws LimitExceededException, AlreadyExistsException, ResourceContentionException, ResourceInUseException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return createOrUpdateTags(CreateOrUpdateTagsRequest.builder().applyMutation(createOrUpdateTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling group.
     * </p>
     * <p>
     * If the group has instances or scaling activities in progress, you must specify the option to force the deletion
     * in order for it to succeed. The force delete operation will also terminate the EC2 instances. If the group has a
     * warm pool, the force delete option also deletes the warm pool.
     * </p>
     * <p>
     * To remove instances from the Auto Scaling group before deleting it, call the <a>DetachInstances</a> API with the
     * list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling
     * does not launch replacement instances.
     * </p>
     * <p>
     * To terminate all instances before deleting the Auto Scaling group, call the <a>UpdateAutoScalingGroup</a> API and
     * set the minimum size and desired capacity of the Auto Scaling group to zero.
     * </p>
     * <p>
     * If the group has scaling policies, deleting the group deletes the policies, the underlying alarm actions, and any
     * alarm that no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html">Delete your Auto Scaling
     * infrastructure</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param deleteAutoScalingGroupRequest
     * @return Result of the DeleteAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAutoScalingGroupResponse deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceInUseException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling group.
     * </p>
     * <p>
     * If the group has instances or scaling activities in progress, you must specify the option to force the deletion
     * in order for it to succeed. The force delete operation will also terminate the EC2 instances. If the group has a
     * warm pool, the force delete option also deletes the warm pool.
     * </p>
     * <p>
     * To remove instances from the Auto Scaling group before deleting it, call the <a>DetachInstances</a> API with the
     * list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling
     * does not launch replacement instances.
     * </p>
     * <p>
     * To terminate all instances before deleting the Auto Scaling group, call the <a>UpdateAutoScalingGroup</a> API and
     * set the minimum size and desired capacity of the Auto Scaling group to zero.
     * </p>
     * <p>
     * If the group has scaling policies, deleting the group deletes the policies, the underlying alarm actions, and any
     * alarm that no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html">Delete your Auto Scaling
     * infrastructure</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAutoScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param deleteAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAutoScalingGroupResponse deleteAutoScalingGroup(
            Consumer<DeleteAutoScalingGroupRequest.Builder> deleteAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceInUseException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return deleteAutoScalingGroup(DeleteAutoScalingGroupRequest.builder().applyMutation(deleteAutoScalingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified launch configuration.
     * </p>
     * <p>
     * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch
     * configuration is no longer available for use.
     * </p>
     *
     * @param deleteLaunchConfigurationRequest
     * @return Result of the DeleteLaunchConfiguration operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchConfigurationResponse deleteLaunchConfiguration(
            DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws ResourceInUseException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified launch configuration.
     * </p>
     * <p>
     * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch
     * configuration is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLaunchConfiguration operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchConfigurationResponse deleteLaunchConfiguration(
            Consumer<DeleteLaunchConfigurationRequest.Builder> deleteLaunchConfigurationRequest) throws ResourceInUseException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return deleteLaunchConfiguration(DeleteLaunchConfigurationRequest.builder()
                .applyMutation(deleteLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified lifecycle hook.
     * </p>
     * <p>
     * If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching
     * instances, <code>CONTINUE</code> for terminating instances).
     * </p>
     *
     * @param deleteLifecycleHookRequest
     * @return Result of the DeleteLifecycleHook operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLifecycleHookResponse deleteLifecycleHook(DeleteLifecycleHookRequest deleteLifecycleHookRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified lifecycle hook.
     * </p>
     * <p>
     * If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching
     * instances, <code>CONTINUE</code> for terminating instances).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLifecycleHookRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLifecycleHookRequest#builder()}
     * </p>
     *
     * @param deleteLifecycleHookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLifecycleHook operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLifecycleHookResponse deleteLifecycleHook(
            Consumer<DeleteLifecycleHookRequest.Builder> deleteLifecycleHookRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return deleteLifecycleHook(DeleteLifecycleHookRequest.builder().applyMutation(deleteLifecycleHookRequest).build());
    }

    /**
     * <p>
     * Deletes the specified notification.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            Consumer<DeleteNotificationConfigurationRequest.Builder> deleteNotificationConfigurationRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return deleteNotificationConfiguration(DeleteNotificationConfigurationRequest.builder()
                .applyMutation(deleteNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scaling policy.
     * </p>
     * <p>
     * Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does
     * not delete the alarm, even if it no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html">Deleting a scaling
     * policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param deletePolicyRequest
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ResourceContentionException,
            ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scaling policy.
     * </p>
     * <p>
     * Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does
     * not delete the alarm, even if it no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html">Deleting a scaling
     * policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest.Builder} to create a request.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest)
            throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scheduled action.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return Result of the DeleteScheduledAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteScheduledActionResponse deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scheduled action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduledActionRequest#builder()}
     * </p>
     *
     * @param deleteScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteScheduledAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteScheduledActionResponse deleteScheduledAction(
            Consumer<DeleteScheduledActionRequest.Builder> deleteScheduledActionRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return deleteScheduledAction(DeleteScheduledActionRequest.builder().applyMutation(deleteScheduledActionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceContentionException,
            ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest)
            throws ResourceContentionException, ResourceInUseException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the warm pool for the specified Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param deleteWarmPoolRequest
     * @return Result of the DeleteWarmPool operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWarmPoolResponse deleteWarmPool(DeleteWarmPoolRequest deleteWarmPoolRequest) throws LimitExceededException,
            ResourceContentionException, ScalingActivityInProgressException, ResourceInUseException, AwsServiceException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the warm pool for the specified Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWarmPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWarmPoolRequest#builder()}
     * </p>
     *
     * @param deleteWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWarmPool operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DeleteWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWarmPoolResponse deleteWarmPool(Consumer<DeleteWarmPoolRequest.Builder> deleteWarmPoolRequest)
            throws LimitExceededException, ResourceContentionException, ScalingActivityInProgressException,
            ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        return deleteWarmPool(DeleteWarmPoolRequest.builder().applyMutation(deleteWarmPoolRequest).build());
    }

    /**
     * <p>
     * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto
     * Scaling groups and launch configurations that you can create in a given Region. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto
     * Scaling groups and launch configurations that you can create in a given Region. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto
     * Scaling groups and launch configurations that you can create in a given Region. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAccountLimits
     * @see #describeAccountLimits(DescribeAccountLimitsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits() throws ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available adjustment types for step scaling and simple scaling policies.
     * </p>
     * <p>
     * The following adjustment types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChangeInCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExactCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PercentChangeInCapacity</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAdjustmentTypesRequest
     * @return Result of the DescribeAdjustmentTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAdjustmentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAdjustmentTypesResponse describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available adjustment types for step scaling and simple scaling policies.
     * </p>
     * <p>
     * The following adjustment types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChangeInCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExactCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PercentChangeInCapacity</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAdjustmentTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAdjustmentTypesRequest#builder()}
     * </p>
     *
     * @param describeAdjustmentTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeAdjustmentTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAdjustmentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAdjustmentTypesResponse describeAdjustmentTypes(
            Consumer<DescribeAdjustmentTypesRequest.Builder> describeAdjustmentTypesRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeAdjustmentTypes(DescribeAdjustmentTypesRequest.builder().applyMutation(describeAdjustmentTypesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the available adjustment types for step scaling and simple scaling policies.
     * </p>
     * <p>
     * The following adjustment types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChangeInCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExactCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PercentChangeInCapacity</code>
     * </p>
     * </li>
     * </ul>
     *
     * @return Result of the DescribeAdjustmentTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAdjustmentTypes
     * @see #describeAdjustmentTypes(DescribeAdjustmentTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAdjustmentTypesResponse describeAdjustmentTypes() throws ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return describeAdjustmentTypes(DescribeAdjustmentTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling groups in the account and Region.
     * </p>
     * <p>
     * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling
     * groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the
     * filter criteria. If you do not specify group names or filters, the output includes information for all Auto
     * Scaling groups.
     * </p>
     * <p>
     * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the
     * instances in a warm pool, you must call the <a>DescribeWarmPool</a> API.
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     * @return Result of the DescribeAutoScalingGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsResponse describeAutoScalingGroups(
            DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Auto Scaling groups in the account and Region.
     * </p>
     * <p>
     * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling
     * groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the
     * filter criteria. If you do not specify group names or filters, the output includes information for all Auto
     * Scaling groups.
     * </p>
     * <p>
     * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the
     * instances in a warm pool, you must call the <a>DescribeWarmPool</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAutoScalingGroupsRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAutoScalingGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsResponse describeAutoScalingGroups(
            Consumer<DescribeAutoScalingGroupsRequest.Builder> describeAutoScalingGroupsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeAutoScalingGroups(DescribeAutoScalingGroupsRequest.builder()
                .applyMutation(describeAutoScalingGroupsRequest).build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling groups in the account and Region.
     * </p>
     * <p>
     * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling
     * groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the
     * filter criteria. If you do not specify group names or filters, the output includes information for all Auto
     * Scaling groups.
     * </p>
     * <p>
     * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the
     * instances in a warm pool, you must call the <a>DescribeWarmPool</a> API.
     * </p>
     *
     * @return Result of the DescribeAutoScalingGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see #describeAutoScalingGroups(DescribeAutoScalingGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsResponse describeAutoScalingGroups() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeAutoScalingGroups(DescribeAutoScalingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client.describeAutoScalingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client
     *             .describeAutoScalingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client.describeAutoScalingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see #describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsIterable describeAutoScalingGroupsPaginator() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client.describeAutoScalingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client
     *             .describeAutoScalingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client.describeAutoScalingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsIterable describeAutoScalingGroupsPaginator(
            DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeAutoScalingGroupsIterable(this, describeAutoScalingGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client.describeAutoScalingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client
     *             .describeAutoScalingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable responses = client.describeAutoScalingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAutoScalingGroupsRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsIterable describeAutoScalingGroupsPaginator(
            Consumer<DescribeAutoScalingGroupsRequest.Builder> describeAutoScalingGroupsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest.builder()
                .applyMutation(describeAutoScalingGroupsRequest).build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling instances in the account and Region.
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     * @return Result of the DescribeAutoScalingInstances operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesResponse describeAutoScalingInstances(
            DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Auto Scaling instances in the account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutoScalingInstancesRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAutoScalingInstances operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesResponse describeAutoScalingInstances(
            Consumer<DescribeAutoScalingInstancesRequest.Builder> describeAutoScalingInstancesRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeAutoScalingInstances(DescribeAutoScalingInstancesRequest.builder()
                .applyMutation(describeAutoScalingInstancesRequest).build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling instances in the account and Region.
     * </p>
     *
     * @return Result of the DescribeAutoScalingInstances operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see #describeAutoScalingInstances(DescribeAutoScalingInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesResponse describeAutoScalingInstances() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeAutoScalingInstances(DescribeAutoScalingInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client.describeAutoScalingInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client
     *             .describeAutoScalingInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client.describeAutoScalingInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see #describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesIterable describeAutoScalingInstancesPaginator() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client.describeAutoScalingInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client
     *             .describeAutoScalingInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client.describeAutoScalingInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesIterable describeAutoScalingInstancesPaginator(
            DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeAutoScalingInstancesIterable(this, describeAutoScalingInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client.describeAutoScalingInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client
     *             .describeAutoScalingInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable responses = client.describeAutoScalingInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutoScalingInstancesRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesIterable describeAutoScalingInstancesPaginator(
            Consumer<DescribeAutoScalingInstancesRequest.Builder> describeAutoScalingInstancesRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest.builder()
                .applyMutation(describeAutoScalingInstancesRequest).build());
    }

    /**
     * <p>
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     * </p>
     *
     * @param describeAutoScalingNotificationTypesRequest
     * @return Result of the DescribeAutoScalingNotificationTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingNotificationTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes(
            DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAutoScalingNotificationTypesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAutoScalingNotificationTypesRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingNotificationTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeAutoScalingNotificationTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingNotificationTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes(
            Consumer<DescribeAutoScalingNotificationTypesRequest.Builder> describeAutoScalingNotificationTypesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest.builder()
                .applyMutation(describeAutoScalingNotificationTypesRequest).build());
    }

    /**
     * <p>
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     * </p>
     *
     * @return Result of the DescribeAutoScalingNotificationTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeAutoScalingNotificationTypes
     * @see #describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest)
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes()
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the instance refreshes for the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * To help you determine the status of an instance refresh, Amazon EC2 Auto Scaling returns information about the
     * instance refreshes you previously initiated, including their status, start time, end time, the percentage of the
     * instance refresh that is complete, and the number of instances remaining to update before the instance refresh is
     * complete. If a rollback is initiated while an instance refresh is in progress, Amazon EC2 Auto Scaling also
     * returns information about the rollback of the instance refresh.
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     * @return Result of the DescribeInstanceRefreshes operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceRefreshesResponse describeInstanceRefreshes(
            DescribeInstanceRefreshesRequest describeInstanceRefreshesRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the instance refreshes for the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * To help you determine the status of an instance refresh, Amazon EC2 Auto Scaling returns information about the
     * instance refreshes you previously initiated, including their status, start time, end time, the percentage of the
     * instance refresh that is complete, and the number of instances remaining to update before the instance refresh is
     * complete. If a rollback is initiated while an instance refresh is in progress, Amazon EC2 Auto Scaling also
     * returns information about the rollback of the instance refresh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRefreshesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceRefreshesRequest#builder()}
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeInstanceRefreshes operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceRefreshesResponse describeInstanceRefreshes(
            Consumer<DescribeInstanceRefreshesRequest.Builder> describeInstanceRefreshesRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeInstanceRefreshes(DescribeInstanceRefreshesRequest.builder()
                .applyMutation(describeInstanceRefreshesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesIterable responses = client.describeInstanceRefreshesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesIterable responses = client
     *             .describeInstanceRefreshesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesIterable responses = client.describeInstanceRefreshesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceRefreshesIterable describeInstanceRefreshesPaginator(
            DescribeInstanceRefreshesRequest describeInstanceRefreshesRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeInstanceRefreshesIterable(this, describeInstanceRefreshesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesIterable responses = client.describeInstanceRefreshesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesIterable responses = client
     *             .describeInstanceRefreshesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesIterable responses = client.describeInstanceRefreshesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRefreshesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceRefreshesRequest#builder()}
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceRefreshesIterable describeInstanceRefreshesPaginator(
            Consumer<DescribeInstanceRefreshesRequest.Builder> describeInstanceRefreshesRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeInstanceRefreshesPaginator(DescribeInstanceRefreshesRequest.builder()
                .applyMutation(describeInstanceRefreshesRequest).build());
    }

    /**
     * <p>
     * Gets information about the launch configurations in the account and Region.
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     * @return Result of the DescribeLaunchConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsResponse describeLaunchConfigurations(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the launch configurations in the account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLaunchConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLaunchConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeLaunchConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsResponse describeLaunchConfigurations(
            Consumer<DescribeLaunchConfigurationsRequest.Builder> describeLaunchConfigurationsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeLaunchConfigurations(DescribeLaunchConfigurationsRequest.builder()
                .applyMutation(describeLaunchConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the launch configurations in the account and Region.
     * </p>
     *
     * @return Result of the DescribeLaunchConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see #describeLaunchConfigurations(DescribeLaunchConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsResponse describeLaunchConfigurations() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeLaunchConfigurations(DescribeLaunchConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client.describeLaunchConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client
     *             .describeLaunchConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client.describeLaunchConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see #describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsIterable describeLaunchConfigurationsPaginator() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client.describeLaunchConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client
     *             .describeLaunchConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client.describeLaunchConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsIterable describeLaunchConfigurationsPaginator(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeLaunchConfigurationsIterable(this, describeLaunchConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client.describeLaunchConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client
     *             .describeLaunchConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable responses = client.describeLaunchConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLaunchConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLaunchConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsIterable describeLaunchConfigurationsPaginator(
            Consumer<DescribeLaunchConfigurationsRequest.Builder> describeLaunchConfigurationsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest.builder()
                .applyMutation(describeLaunchConfigurationsRequest).build());
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * <p>
     * The following hook types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATING</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeLifecycleHookTypesRequest
     * @return Result of the DescribeLifecycleHookTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLifecycleHookTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHookTypesResponse describeLifecycleHookTypes(
            DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * <p>
     * The following hook types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATING</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLifecycleHookTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLifecycleHookTypesRequest#builder()}
     * </p>
     *
     * @param describeLifecycleHookTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeLifecycleHookTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLifecycleHookTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHookTypesResponse describeLifecycleHookTypes(
            Consumer<DescribeLifecycleHookTypesRequest.Builder> describeLifecycleHookTypesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest.builder()
                .applyMutation(describeLifecycleHookTypesRequest).build());
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * <p>
     * The following hook types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATING</code>
     * </p>
     * </li>
     * </ul>
     *
     * @return Result of the DescribeLifecycleHookTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLifecycleHookTypes
     * @see #describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHookTypesResponse describeLifecycleHookTypes() throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the lifecycle hooks for the specified Auto Scaling group.
     * </p>
     *
     * @param describeLifecycleHooksRequest
     * @return Result of the DescribeLifecycleHooks operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLifecycleHooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHooksResponse describeLifecycleHooks(DescribeLifecycleHooksRequest describeLifecycleHooksRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the lifecycle hooks for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLifecycleHooksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLifecycleHooksRequest#builder()}
     * </p>
     *
     * @param describeLifecycleHooksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeLifecycleHooks operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLifecycleHooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHooksResponse describeLifecycleHooks(
            Consumer<DescribeLifecycleHooksRequest.Builder> describeLifecycleHooksRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeLifecycleHooks(DescribeLifecycleHooksRequest.builder().applyMutation(describeLifecycleHooksRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However,
     * we continue to support <code>DescribeLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DescribeLoadBalancerTargetGroups</code> API operation and <code>DescribeTrafficSources</code> on the same
     * Auto Scaling group.
     * </p>
     * </note>
     * <p>
     * Gets information about the Elastic Load Balancing target groups for the specified Auto Scaling group.
     * </p>
     * <p>
     * To determine the attachment status of the target group, use the <code>State</code> element in the response. When
     * you attach a target group to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the target
     * group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to
     * <code>InService</code> after at least one Auto Scaling instance passes the health check. When the target group is
     * in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances that are
     * reported as unhealthy. If no registered instances pass the health checks, the target group doesn't enter the
     * <code>InService</code> state.
     * </p>
     * <p>
     * Target groups also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your target group state is <code>InService</code>, but it is not working properly, check the scaling
     * activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can use this operation to describe target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     * @return Result of the DescribeLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroups(
            DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) throws ResourceContentionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However,
     * we continue to support <code>DescribeLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DescribeLoadBalancerTargetGroups</code> API operation and <code>DescribeTrafficSources</code> on the same
     * Auto Scaling group.
     * </p>
     * </note>
     * <p>
     * Gets information about the Elastic Load Balancing target groups for the specified Auto Scaling group.
     * </p>
     * <p>
     * To determine the attachment status of the target group, use the <code>State</code> element in the response. When
     * you attach a target group to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the target
     * group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to
     * <code>InService</code> after at least one Auto Scaling instance passes the health check. When the target group is
     * in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances that are
     * reported as unhealthy. If no registered instances pass the health checks, the target group doesn't enter the
     * <code>InService</code> state.
     * </p>
     * <p>
     * Target groups also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your target group state is <code>InService</code>, but it is not working properly, check the scaling
     * activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can use this operation to describe target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroups(
            Consumer<DescribeLoadBalancerTargetGroupsRequest.Builder> describeLoadBalancerTargetGroupsRequest)
            throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(describeLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsIterable responses = client.describeLoadBalancerTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsIterable responses = client
     *             .describeLoadBalancerTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsIterable responses = client.describeLoadBalancerTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerTargetGroupsIterable describeLoadBalancerTargetGroupsPaginator(
            DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) throws ResourceContentionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeLoadBalancerTargetGroupsIterable(this, describeLoadBalancerTargetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsIterable responses = client.describeLoadBalancerTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsIterable responses = client
     *             .describeLoadBalancerTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsIterable responses = client.describeLoadBalancerTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerTargetGroupsIterable describeLoadBalancerTargetGroupsPaginator(
            Consumer<DescribeLoadBalancerTargetGroupsRequest.Builder> describeLoadBalancerTargetGroupsRequest)
            throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeLoadBalancerTargetGroupsPaginator(DescribeLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(describeLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DescribeTrafficSources</code> to simplify how you manage traffic sources.
     * However, we continue to support <code>DescribeLoadBalancers</code>. You can use both the original
     * <code>DescribeLoadBalancers</code> API operation and <code>DescribeTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Gets information about the load balancers for the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation describes only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DescribeLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * To determine the attachment status of the load balancer, use the <code>State</code> element in the response. When
     * you attach a load balancer to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the load
     * balancer. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions
     * to <code>InService</code> after at least one Auto Scaling instance passes the health check. When the load
     * balancer is in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances
     * that are reported as unhealthy. If no registered instances pass the health checks, the load balancer doesn't
     * enter the <code>InService</code> state.
     * </p>
     * <p>
     * Load balancers also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your load balancer state is <code>InService</code>, but it is not working properly, check the
     * scaling activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return Result of the DescribeLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest)
            throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DescribeTrafficSources</code> to simplify how you manage traffic sources.
     * However, we continue to support <code>DescribeLoadBalancers</code>. You can use both the original
     * <code>DescribeLoadBalancers</code> API operation and <code>DescribeTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Gets information about the load balancers for the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation describes only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DescribeLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * To determine the attachment status of the load balancer, use the <code>State</code> element in the response. When
     * you attach a load balancer to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the load
     * balancer. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions
     * to <code>InService</code> after at least one Auto Scaling instance passes the health check. When the load
     * balancer is in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances
     * that are reported as unhealthy. If no registered instances pass the health checks, the load balancer doesn't
     * enter the <code>InService</code> state.
     * </p>
     * <p>
     * Load balancers also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your load balancer state is <code>InService</code>, but it is not working properly, check the
     * scaling activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersResponse describeLoadBalancers(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) throws ResourceContentionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeLoadBalancers(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersIterable responses = client
     *             .describeLoadBalancersPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersIterable describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest)
            throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return new DescribeLoadBalancersIterable(this, describeLoadBalancersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersIterable responses = client
     *             .describeLoadBalancersPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersIterable describeLoadBalancersPaginator(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) throws ResourceContentionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeLoadBalancersPaginator(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)
                .build());
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     * </p>
     *
     * @param describeMetricCollectionTypesRequest
     * @return Result of the DescribeMetricCollectionTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeMetricCollectionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetricCollectionTypesResponse describeMetricCollectionTypes(
            DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetricCollectionTypesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetricCollectionTypesRequest#builder()}
     * </p>
     *
     * @param describeMetricCollectionTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMetricCollectionTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeMetricCollectionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetricCollectionTypesResponse describeMetricCollectionTypes(
            Consumer<DescribeMetricCollectionTypesRequest.Builder> describeMetricCollectionTypesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest.builder()
                .applyMutation(describeMetricCollectionTypesRequest).build());
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     * </p>
     *
     * @return Result of the DescribeMetricCollectionTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeMetricCollectionTypes
     * @see #describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetricCollectionTypesResponse describeMetricCollectionTypes() throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     * @return Result of the DescribeNotificationConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsResponse describeNotificationConfigurations(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeNotificationConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsResponse describeNotificationConfigurations(
            Consumer<DescribeNotificationConfigurationsRequest.Builder> describeNotificationConfigurationsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeNotificationConfigurations(DescribeNotificationConfigurationsRequest.builder()
                .applyMutation(describeNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
     * </p>
     *
     * @return Result of the DescribeNotificationConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see #describeNotificationConfigurations(DescribeNotificationConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsResponse describeNotificationConfigurations() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeNotificationConfigurations(DescribeNotificationConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client.describeNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client
     *             .describeNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client.describeNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see #describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsIterable describeNotificationConfigurationsPaginator()
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client.describeNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client
     *             .describeNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client.describeNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsIterable describeNotificationConfigurationsPaginator(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return new DescribeNotificationConfigurationsIterable(this, describeNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client.describeNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client
     *             .describeNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable responses = client.describeNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsIterable describeNotificationConfigurationsPaginator(
            Consumer<DescribeNotificationConfigurationsRequest.Builder> describeNotificationConfigurationsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest.builder()
                .applyMutation(describeNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling policies in the account and Region.
     * </p>
     *
     * @param describePoliciesRequest
     * @return Result of the DescribePolicies operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesResponse describePolicies(DescribePoliciesRequest describePoliciesRequest)
            throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scaling policies in the account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePoliciesRequest#builder()}
     * </p>
     *
     * @param describePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePolicies operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesResponse describePolicies(Consumer<DescribePoliciesRequest.Builder> describePoliciesRequest)
            throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describePolicies(DescribePoliciesRequest.builder().applyMutation(describePoliciesRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling policies in the account and Region.
     * </p>
     *
     * @return Result of the DescribePolicies operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribePolicies
     * @see #describePolicies(DescribePoliciesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesResponse describePolicies() throws InvalidNextTokenException, ResourceContentionException,
            ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        return describePolicies(DescribePoliciesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client.describePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client
     *             .describePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client.describePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribePolicies
     * @see #describePoliciesPaginator(DescribePoliciesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesIterable describePoliciesPaginator() throws InvalidNextTokenException, ResourceContentionException,
            ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        return describePoliciesPaginator(DescribePoliciesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client.describePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client
     *             .describePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client.describePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesIterable describePoliciesPaginator(DescribePoliciesRequest describePoliciesRequest)
            throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribePoliciesIterable(this, describePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client.describePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client
     *             .describePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable responses = client.describePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePoliciesRequest#builder()}
     * </p>
     *
     * @param describePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesIterable describePoliciesPaginator(Consumer<DescribePoliciesRequest.Builder> describePoliciesRequest)
            throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describePoliciesPaginator(DescribePoliciesRequest.builder().applyMutation(describePoliciesRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling activities in the account and Region.
     * </p>
     * <p>
     * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html">Verifying a scaling
     * activity for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the scaling event succeeds, the value of the <code>StatusCode</code> element in the response is
     * <code>Successful</code>. If an attempt to launch instances failed, the <code>StatusCode</code> value is
     * <code>Failed</code> or <code>Cancelled</code> and the <code>StatusMessage</code> element in the response
     * indicates the cause of the failure. For help interpreting the <code>StatusMessage</code>, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html">Troubleshooting Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return Result of the DescribeScalingActivities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesResponse describeScalingActivities(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scaling activities in the account and Region.
     * </p>
     * <p>
     * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html">Verifying a scaling
     * activity for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the scaling event succeeds, the value of the <code>StatusCode</code> element in the response is
     * <code>Successful</code>. If an attempt to launch instances failed, the <code>StatusCode</code> value is
     * <code>Failed</code> or <code>Cancelled</code> and the <code>StatusMessage</code> element in the response
     * indicates the cause of the failure. For help interpreting the <code>StatusMessage</code>, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html">Troubleshooting Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingActivitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingActivitiesRequest#builder()}
     * </p>
     *
     * @param describeScalingActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeScalingActivities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesResponse describeScalingActivities(
            Consumer<DescribeScalingActivitiesRequest.Builder> describeScalingActivitiesRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeScalingActivities(DescribeScalingActivitiesRequest.builder()
                .applyMutation(describeScalingActivitiesRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling activities in the account and Region.
     * </p>
     * <p>
     * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html">Verifying a scaling
     * activity for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the scaling event succeeds, the value of the <code>StatusCode</code> element in the response is
     * <code>Successful</code>. If an attempt to launch instances failed, the <code>StatusCode</code> value is
     * <code>Failed</code> or <code>Cancelled</code> and the <code>StatusMessage</code> element in the response
     * indicates the cause of the failure. For help interpreting the <code>StatusMessage</code>, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html">Troubleshooting Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeScalingActivities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see #describeScalingActivities(DescribeScalingActivitiesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesResponse describeScalingActivities() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeScalingActivities(DescribeScalingActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client.describeScalingActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client
     *             .describeScalingActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client.describeScalingActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see #describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesIterable describeScalingActivitiesPaginator() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client.describeScalingActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client
     *             .describeScalingActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client.describeScalingActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesIterable describeScalingActivitiesPaginator(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeScalingActivitiesIterable(this, describeScalingActivitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client.describeScalingActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client
     *             .describeScalingActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable responses = client.describeScalingActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingActivitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingActivitiesRequest#builder()}
     * </p>
     *
     * @param describeScalingActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesIterable describeScalingActivitiesPaginator(
            Consumer<DescribeScalingActivitiesRequest.Builder> describeScalingActivitiesRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest.builder()
                .applyMutation(describeScalingActivitiesRequest).build());
    }

    /**
     * <p>
     * Describes the scaling process types for use with the <a>ResumeProcesses</a> and <a>SuspendProcesses</a> APIs.
     * </p>
     *
     * @param describeScalingProcessTypesRequest
     * @return Result of the DescribeScalingProcessTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingProcessTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingProcessTypesResponse describeScalingProcessTypes(
            DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the scaling process types for use with the <a>ResumeProcesses</a> and <a>SuspendProcesses</a> APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingProcessTypesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeScalingProcessTypesRequest#builder()}
     * </p>
     *
     * @param describeScalingProcessTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeScalingProcessTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingProcessTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingProcessTypesResponse describeScalingProcessTypes(
            Consumer<DescribeScalingProcessTypesRequest.Builder> describeScalingProcessTypesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeScalingProcessTypes(DescribeScalingProcessTypesRequest.builder()
                .applyMutation(describeScalingProcessTypesRequest).build());
    }

    /**
     * <p>
     * Describes the scaling process types for use with the <a>ResumeProcesses</a> and <a>SuspendProcesses</a> APIs.
     * </p>
     *
     * @return Result of the DescribeScalingProcessTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScalingProcessTypes
     * @see #describeScalingProcessTypes(DescribeScalingProcessTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingProcessTypesResponse describeScalingProcessTypes() throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeScalingProcessTypes(DescribeScalingProcessTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the scheduled actions that haven't run or that have not reached their end time.
     * </p>
     * <p>
     * To describe the scaling activities for scheduled actions that have already run, call the
     * <a>DescribeScalingActivities</a> API.
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return Result of the DescribeScheduledActions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsResponse describeScheduledActions(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scheduled actions that haven't run or that have not reached their end time.
     * </p>
     * <p>
     * To describe the scaling activities for scheduled actions that have already run, call the
     * <a>DescribeScalingActivities</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeScheduledActions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsResponse describeScheduledActions(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeScheduledActions(DescribeScheduledActionsRequest.builder().applyMutation(describeScheduledActionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the scheduled actions that haven't run or that have not reached their end time.
     * </p>
     * <p>
     * To describe the scaling activities for scheduled actions that have already run, call the
     * <a>DescribeScalingActivities</a> API.
     * </p>
     *
     * @return Result of the DescribeScheduledActions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see #describeScheduledActions(DescribeScheduledActionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsResponse describeScheduledActions() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeScheduledActions(DescribeScheduledActionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client.describeScheduledActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client
     *             .describeScheduledActionsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client.describeScheduledActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see #describeScheduledActionsPaginator(DescribeScheduledActionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsIterable describeScheduledActionsPaginator() throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeScheduledActionsPaginator(DescribeScheduledActionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client.describeScheduledActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client
     *             .describeScheduledActionsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client.describeScheduledActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsIterable describeScheduledActionsPaginator(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeScheduledActionsIterable(this, describeScheduledActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client.describeScheduledActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client
     *             .describeScheduledActionsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable responses = client.describeScheduledActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsIterable describeScheduledActionsPaginator(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeScheduledActionsPaginator(DescribeScheduledActionsRequest.builder()
                .applyMutation(describeScheduledActionsRequest).build());
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest.Builder} to create a request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeTags operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTags
     * @see #describeTags(DescribeTagsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags() throws InvalidNextTokenException, ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeTags(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTags
     * @see #describeTagsPaginator(DescribeTagsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsIterable describeTagsPaginator() throws InvalidNextTokenException, ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeTagsPaginator(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @param describeTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsIterable describeTagsPaginator(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeTagsIterable(this, describeTagsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsIterable describeTagsPaginator(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return describeTagsPaginator(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Work with
     * Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeTerminationPolicyTypesRequest
     * @return Result of the DescribeTerminationPolicyTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTerminationPolicyTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes(
            DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Work with
     * Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTerminationPolicyTypesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTerminationPolicyTypesRequest#builder()}
     * </p>
     *
     * @param describeTerminationPolicyTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeTerminationPolicyTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTerminationPolicyTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes(
            Consumer<DescribeTerminationPolicyTypesRequest.Builder> describeTerminationPolicyTypesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest.builder()
                .applyMutation(describeTerminationPolicyTypesRequest).build());
    }

    /**
     * <p>
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Work with
     * Amazon EC2 Auto Scaling termination policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeTerminationPolicyTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTerminationPolicyTypes
     * @see #describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes() throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the traffic sources for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can optionally provide a traffic source type. If you provide a traffic source type, then the results only
     * include that traffic source type.
     * </p>
     * <p>
     * If you do not provide a traffic source type, then the results include all the traffic sources for the specified
     * Auto Scaling group.
     * </p>
     *
     * @param describeTrafficSourcesRequest
     * @return Result of the DescribeTrafficSources operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficSourcesResponse describeTrafficSources(DescribeTrafficSourcesRequest describeTrafficSourcesRequest)
            throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the traffic sources for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can optionally provide a traffic source type. If you provide a traffic source type, then the results only
     * include that traffic source type.
     * </p>
     * <p>
     * If you do not provide a traffic source type, then the results include all the traffic sources for the specified
     * Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param describeTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeTrafficSources operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficSourcesResponse describeTrafficSources(
            Consumer<DescribeTrafficSourcesRequest.Builder> describeTrafficSourcesRequest) throws ResourceContentionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeTrafficSources(DescribeTrafficSourcesRequest.builder().applyMutation(describeTrafficSourcesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesIterable responses = client.describeTrafficSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesIterable responses = client
     *             .describeTrafficSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesIterable responses = client.describeTrafficSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTrafficSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficSourcesIterable describeTrafficSourcesPaginator(
            DescribeTrafficSourcesRequest describeTrafficSourcesRequest) throws ResourceContentionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeTrafficSourcesIterable(this, describeTrafficSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesIterable responses = client.describeTrafficSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesIterable responses = client
     *             .describeTrafficSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesIterable responses = client.describeTrafficSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param describeTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficSourcesIterable describeTrafficSourcesPaginator(
            Consumer<DescribeTrafficSourcesRequest.Builder> describeTrafficSourcesRequest) throws ResourceContentionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        return describeTrafficSourcesPaginator(DescribeTrafficSourcesRequest.builder()
                .applyMutation(describeTrafficSourcesRequest).build());
    }

    /**
     * <p>
     * Gets information about a warm pool and its instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeWarmPoolRequest
     * @return Result of the DescribeWarmPool operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWarmPoolResponse describeWarmPool(DescribeWarmPoolRequest describeWarmPoolRequest)
            throws InvalidNextTokenException, LimitExceededException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a warm pool and its instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWarmPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWarmPoolRequest#builder()}
     * </p>
     *
     * @param describeWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWarmPool operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWarmPoolResponse describeWarmPool(Consumer<DescribeWarmPoolRequest.Builder> describeWarmPoolRequest)
            throws InvalidNextTokenException, LimitExceededException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return describeWarmPool(DescribeWarmPoolRequest.builder().applyMutation(describeWarmPoolRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolIterable responses = client.describeWarmPoolPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolIterable responses = client
     *             .describeWarmPoolPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolIterable responses = client.describeWarmPoolPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWarmPoolRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWarmPoolIterable describeWarmPoolPaginator(DescribeWarmPoolRequest describeWarmPoolRequest)
            throws InvalidNextTokenException, LimitExceededException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return new DescribeWarmPoolIterable(this, describeWarmPoolRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolIterable responses = client.describeWarmPoolPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolIterable responses = client
     *             .describeWarmPoolPaginator(request);
     *     for (software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolIterable responses = client.describeWarmPoolPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWarmPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWarmPoolRequest#builder()}
     * </p>
     *
     * @param describeWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWarmPoolIterable describeWarmPoolPaginator(Consumer<DescribeWarmPoolRequest.Builder> describeWarmPoolRequest)
            throws InvalidNextTokenException, LimitExceededException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return describeWarmPoolPaginator(DescribeWarmPoolRequest.builder().applyMutation(describeWarmPoolRequest).build());
    }

    /**
     * <p>
     * Removes one or more instances from the specified Auto Scaling group.
     * </p>
     * <p>
     * After the instances are detached, you can manage them independent of the Auto Scaling group.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are detached.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the
     * load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from
     * the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html">Detach EC2 instances from
     * your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param detachInstancesRequest
     * @return Result of the DetachInstances operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DetachInstancesResponse detachInstances(DetachInstancesRequest detachInstancesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more instances from the specified Auto Scaling group.
     * </p>
     * <p>
     * After the instances are detached, you can manage them independent of the Auto Scaling group.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are detached.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the
     * load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from
     * the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html">Detach EC2 instances from
     * your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link DetachInstancesRequest#builder()}
     * </p>
     *
     * @param detachInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the DetachInstances operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DetachInstancesResponse detachInstances(Consumer<DetachInstancesRequest.Builder> detachInstancesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return detachInstances(DetachInstancesRequest.builder().applyMutation(detachInstancesRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DetachLoadBalancerTargetGroups</code> API operation and <code>DetachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more target groups from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a target group, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the target group using the
     * <a>DescribeLoadBalancerTargetGroups</a> API call. The instances remain running.
     * </p>
     * <note>
     * <p>
     * You can use this operation to detach target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note>
     *
     * @param detachLoadBalancerTargetGroupsRequest
     * @return Result of the DetachLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroups(
            DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DetachLoadBalancerTargetGroups</code> API operation and <code>DetachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more target groups from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a target group, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the target group using the
     * <a>DescribeLoadBalancerTargetGroups</a> API call. The instances remain running.
     * </p>
     * <note>
     * <p>
     * You can use this operation to detach target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DetachLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param detachLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the DetachLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroups(
            Consumer<DetachLoadBalancerTargetGroupsRequest.Builder> detachLoadBalancerTargetGroupsRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return detachLoadBalancerTargetGroups(DetachLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(detachLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancers</code>. You can use both the original
     * <code>DetachLoadBalancers</code> API operation and <code>DetachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation detaches only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DetachLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the load balancer using the
     * <a>DescribeLoadBalancers</a> API call. The instances remain running.
     * </p>
     *
     * @param detachLoadBalancersRequest
     * @return Result of the DetachLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachLoadBalancersResponse detachLoadBalancers(DetachLoadBalancersRequest detachLoadBalancersRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancers</code>. You can use both the original
     * <code>DetachLoadBalancers</code> API operation and <code>DetachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation detaches only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DetachLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the load balancer using the
     * <a>DescribeLoadBalancers</a> API call. The instances remain running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DetachLoadBalancersRequest#builder()}
     * </p>
     *
     * @param detachLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest.Builder} to create a
     *        request.
     * @return Result of the DetachLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachLoadBalancersResponse detachLoadBalancers(
            Consumer<DetachLoadBalancersRequest.Builder> detachLoadBalancersRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return detachLoadBalancers(DetachLoadBalancersRequest.builder().applyMutation(detachLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Detaches one or more traffic sources from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a traffic source, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the traffic source using the
     * <a>DescribeTrafficSources</a> API call. The instances continue to run.
     * </p>
     *
     * @param detachTrafficSourcesRequest
     * @return Result of the DetachTrafficSources operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachTrafficSourcesResponse detachTrafficSources(DetachTrafficSourcesRequest detachTrafficSourcesRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches one or more traffic sources from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a traffic source, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the traffic source using the
     * <a>DescribeTrafficSources</a> API call. The instances continue to run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DetachTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param detachTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the DetachTrafficSources operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DetachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachTrafficSourcesResponse detachTrafficSources(
            Consumer<DetachTrafficSourcesRequest.Builder> detachTrafficSourcesRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return detachTrafficSources(DetachTrafficSourcesRequest.builder().applyMutation(detachTrafficSourcesRequest).build());
    }

    /**
     * <p>
     * Disables group metrics collection for the specified Auto Scaling group.
     * </p>
     *
     * @param disableMetricsCollectionRequest
     * @return Result of the DisableMetricsCollection operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DisableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableMetricsCollectionResponse disableMetricsCollection(
            DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables group metrics collection for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableMetricsCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link DisableMetricsCollectionRequest#builder()}
     * </p>
     *
     * @param disableMetricsCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest.Builder} to
     *        create a request.
     * @return Result of the DisableMetricsCollection operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.DisableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableMetricsCollectionResponse disableMetricsCollection(
            Consumer<DisableMetricsCollectionRequest.Builder> disableMetricsCollectionRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return disableMetricsCollection(DisableMetricsCollectionRequest.builder().applyMutation(disableMetricsCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Enables group metrics collection for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use these metrics to track changes in an Auto Scaling group and to set alarms on threshold values. You
     * can view group metrics using the Amazon EC2 Auto Scaling console or the CloudWatch console. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html">
     * Monitor CloudWatch metrics for your Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     *
     * @param enableMetricsCollectionRequest
     * @return Result of the EnableMetricsCollection operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.EnableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableMetricsCollectionResponse enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables group metrics collection for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use these metrics to track changes in an Auto Scaling group and to set alarms on threshold values. You
     * can view group metrics using the Amazon EC2 Auto Scaling console or the CloudWatch console. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html">
     * Monitor CloudWatch metrics for your Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableMetricsCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link EnableMetricsCollectionRequest#builder()}
     * </p>
     *
     * @param enableMetricsCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest.Builder} to create
     *        a request.
     * @return Result of the EnableMetricsCollection operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.EnableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableMetricsCollectionResponse enableMetricsCollection(
            Consumer<EnableMetricsCollectionRequest.Builder> enableMetricsCollectionRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return enableMetricsCollection(EnableMetricsCollectionRequest.builder().applyMutation(enableMetricsCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Moves the specified instances into the standby state.
     * </p>
     * <p>
     * If you choose to decrement the desired capacity of the Auto Scaling group, the instances can enter standby as
     * long as the desired capacity of the Auto Scaling group after the instances are placed into standby is equal to or
     * greater than the minimum capacity of the group.
     * </p>
     * <p>
     * If you choose not to decrement the desired capacity of the Auto Scaling group, the Auto Scaling group launches
     * new instances to replace the instances on standby.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param enterStandbyRequest
     * @return Result of the EnterStandby operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.EnterStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default EnterStandbyResponse enterStandby(EnterStandbyRequest enterStandbyRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified instances into the standby state.
     * </p>
     * <p>
     * If you choose to decrement the desired capacity of the Auto Scaling group, the instances can enter standby as
     * long as the desired capacity of the Auto Scaling group after the instances are placed into standby is equal to or
     * greater than the minimum capacity of the group.
     * </p>
     * <p>
     * If you choose not to decrement the desired capacity of the Auto Scaling group, the Auto Scaling group launches
     * new instances to replace the instances on standby.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnterStandbyRequest.Builder} avoiding the need to
     * create one manually via {@link EnterStandbyRequest#builder()}
     * </p>
     *
     * @param enterStandbyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest.Builder} to create a request.
     * @return Result of the EnterStandby operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.EnterStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default EnterStandbyResponse enterStandby(Consumer<EnterStandbyRequest.Builder> enterStandbyRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return enterStandby(EnterStandbyRequest.builder().applyMutation(enterStandbyRequest).build());
    }

    /**
     * <p>
     * Executes the specified policy. This can be useful for testing the design of your scaling policy.
     * </p>
     *
     * @param executePolicyRequest
     * @return Result of the ExecutePolicy operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.ExecutePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecutePolicyResponse executePolicy(ExecutePolicyRequest executePolicyRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes the specified policy. This can be useful for testing the design of your scaling policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecutePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link ExecutePolicyRequest#builder()}
     * </p>
     *
     * @param executePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the ExecutePolicy operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.ExecutePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecutePolicyResponse executePolicy(Consumer<ExecutePolicyRequest.Builder> executePolicyRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return executePolicy(ExecutePolicyRequest.builder().applyMutation(executePolicyRequest).build());
    }

    /**
     * <p>
     * Moves the specified instances out of the standby state.
     * </p>
     * <p>
     * After you put the instances back in service, the desired capacity is incremented.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param exitStandbyRequest
     * @return Result of the ExitStandby operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.ExitStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default ExitStandbyResponse exitStandby(ExitStandbyRequest exitStandbyRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified instances out of the standby state.
     * </p>
     * <p>
     * After you put the instances back in service, the desired capacity is incremented.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExitStandbyRequest.Builder} avoiding the need to
     * create one manually via {@link ExitStandbyRequest#builder()}
     * </p>
     *
     * @param exitStandbyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest.Builder} to create a request.
     * @return Result of the ExitStandby operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.ExitStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default ExitStandbyResponse exitStandby(Consumer<ExitStandbyRequest.Builder> exitStandbyRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return exitStandby(ExitStandbyRequest.builder().applyMutation(exitStandbyRequest).build());
    }

    /**
     * <p>
     * Retrieves the forecast data for a predictive scaling policy.
     * </p>
     * <p>
     * Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an
     * analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity
     * that is needed on an hourly basis, based on the hourly load forecast.
     * </p>
     * <p>
     * A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of
     * historical data results in more accurate forecasts.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param getPredictiveScalingForecastRequest
     * @return Result of the GetPredictiveScalingForecast operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.GetPredictiveScalingForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/GetPredictiveScalingForecast"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPredictiveScalingForecastResponse getPredictiveScalingForecast(
            GetPredictiveScalingForecastRequest getPredictiveScalingForecastRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the forecast data for a predictive scaling policy.
     * </p>
     * <p>
     * Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an
     * analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity
     * that is needed on an hourly basis, based on the hourly load forecast.
     * </p>
     * <p>
     * A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of
     * historical data results in more accurate forecasts.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPredictiveScalingForecastRequest.Builder}
     * avoiding the need to create one manually via {@link GetPredictiveScalingForecastRequest#builder()}
     * </p>
     *
     * @param getPredictiveScalingForecastRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastRequest.Builder} to
     *        create a request.
     * @return Result of the GetPredictiveScalingForecast operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.GetPredictiveScalingForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/GetPredictiveScalingForecast"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPredictiveScalingForecastResponse getPredictiveScalingForecast(
            Consumer<GetPredictiveScalingForecastRequest.Builder> getPredictiveScalingForecastRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return getPredictiveScalingForecast(GetPredictiveScalingForecastRequest.builder()
                .applyMutation(getPredictiveScalingForecastRequest).build());
    }

    /**
     * <p>
     * Creates or updates a lifecycle hook for the specified Auto Scaling group.
     * </p>
     * <p>
     * Lifecycle hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and
     * then perform a custom action on instances when the corresponding lifecycle event occurs.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state using the
     * <a>RecordLifecycleActionHeartbeat</a> API call.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call
     * fails.
     * </p>
     * <p>
     * You can view the lifecycle hooks for an Auto Scaling group using the <a>DescribeLifecycleHooks</a> API call. If
     * you are no longer using a lifecycle hook, you can delete it by calling the <a>DeleteLifecycleHook</a> API.
     * </p>
     *
     * @param putLifecycleHookRequest
     * @return Result of the PutLifecycleHook operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLifecycleHookResponse putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest)
            throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a lifecycle hook for the specified Auto Scaling group.
     * </p>
     * <p>
     * Lifecycle hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and
     * then perform a custom action on instances when the corresponding lifecycle event occurs.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state using the
     * <a>RecordLifecycleActionHeartbeat</a> API call.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call
     * fails.
     * </p>
     * <p>
     * You can view the lifecycle hooks for an Auto Scaling group using the <a>DescribeLifecycleHooks</a> API call. If
     * you are no longer using a lifecycle hook, you can delete it by calling the <a>DeleteLifecycleHook</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLifecycleHookRequest.Builder} avoiding the need
     * to create one manually via {@link PutLifecycleHookRequest#builder()}
     * </p>
     *
     * @param putLifecycleHookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest.Builder} to create a
     *        request.
     * @return Result of the PutLifecycleHook operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLifecycleHookResponse putLifecycleHook(Consumer<PutLifecycleHookRequest.Builder> putLifecycleHookRequest)
            throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return putLifecycleHook(PutLifecycleHookRequest.builder().applyMutation(putLifecycleHookRequest).build());
    }

    /**
     * <p>
     * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the
     * specified topic can have messages delivered to an endpoint such as a web server or an email address.
     * </p>
     * <p>
     * This configuration overwrites any existing configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html">Getting Amazon SNS
     * notifications when your Auto Scaling group scales</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.
     * </p>
     *
     * @param putNotificationConfigurationRequest
     * @return Result of the PutNotificationConfiguration operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutNotificationConfigurationResponse putNotificationConfiguration(
            PutNotificationConfigurationRequest putNotificationConfigurationRequest) throws LimitExceededException,
            ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the
     * specified topic can have messages delivered to an endpoint such as a web server or an email address.
     * </p>
     * <p>
     * This configuration overwrites any existing configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html">Getting Amazon SNS
     * notifications when your Auto Scaling group scales</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param putNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutNotificationConfiguration operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutNotificationConfigurationResponse putNotificationConfiguration(
            Consumer<PutNotificationConfigurationRequest.Builder> putNotificationConfigurationRequest)
            throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return putNotificationConfiguration(PutNotificationConfigurationRequest.builder()
                .applyMutation(putNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling
     * group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling
     * features are not used.
     * </p>
     * <p>
     * For more information about using dynamic scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
     * scaling policies</a> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
     * policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information about using predictive scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scaling policies for an Auto Scaling group using the <a>DescribePolicies</a> API call. If you
     * are no longer using a scaling policy, you can delete it by calling the <a>DeletePolicy</a> API.
     * </p>
     *
     * @param putScalingPolicyRequest
     * @return Result of the PutScalingPolicy operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest)
            throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling
     * group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling
     * features are not used.
     * </p>
     * <p>
     * For more information about using dynamic scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
     * scaling policies</a> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
     * policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information about using predictive scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scaling policies for an Auto Scaling group using the <a>DescribePolicies</a> API call. If you
     * are no longer using a scaling policy, you can delete it by calling the <a>DeletePolicy</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScalingPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putScalingPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutScalingPolicy operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutScalingPolicyResponse putScalingPolicy(Consumer<PutScalingPolicyRequest.Builder> putScalingPolicyRequest)
            throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return putScalingPolicy(PutScalingPolicyRequest.builder().applyMutation(putScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a scheduled scaling action for an Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html">Scheduled scaling</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scheduled actions for an Auto Scaling group using the <a>DescribeScheduledActions</a> API call.
     * If you are no longer using a scheduled action, you can delete it by calling the <a>DeleteScheduledAction</a> API.
     * </p>
     * <p>
     * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
     * </p>
     *
     * @param putScheduledUpdateGroupActionRequest
     * @return Result of the PutScheduledUpdateGroupAction operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupAction(
            PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AlreadyExistsException,
            LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scheduled scaling action for an Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html">Scheduled scaling</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scheduled actions for an Auto Scaling group using the <a>DescribeScheduledActions</a> API call.
     * If you are no longer using a scheduled action, you can delete it by calling the <a>DeleteScheduledAction</a> API.
     * </p>
     * <p>
     * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScheduledUpdateGroupActionRequest.Builder}
     * avoiding the need to create one manually via {@link PutScheduledUpdateGroupActionRequest#builder()}
     * </p>
     *
     * @param putScheduledUpdateGroupActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest.Builder} to
     *        create a request.
     * @return Result of the PutScheduledUpdateGroupAction operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupAction(
            Consumer<PutScheduledUpdateGroupActionRequest.Builder> putScheduledUpdateGroupActionRequest)
            throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException,
            SdkClientException, AutoScalingException {
        return putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest.builder()
                .applyMutation(putScheduledUpdateGroupActionRequest).build());
    }

    /**
     * <p>
     * Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2
     * instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto
     * Scaling group can draw on the warm pool to meet its new desired capacity. For more information and example
     * configurations, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * This operation must be called from the Region in which the Auto Scaling group was created. This operation cannot
     * be called on an Auto Scaling group that has a mixed instances policy or a launch template or launch configuration
     * that requests Spot Instances.
     * </p>
     * <p>
     * You can view the instances in the warm pool using the <a>DescribeWarmPool</a> API call. If you are no longer
     * using a warm pool, you can delete it by calling the <a>DeleteWarmPool</a> API.
     * </p>
     *
     * @param putWarmPoolRequest
     * @return Result of the PutWarmPool operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutWarmPool" target="_top">AWS API
     *      Documentation</a>
     */
    default PutWarmPoolResponse putWarmPool(PutWarmPoolRequest putWarmPoolRequest) throws LimitExceededException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2
     * instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto
     * Scaling group can draw on the warm pool to meet its new desired capacity. For more information and example
     * configurations, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * This operation must be called from the Region in which the Auto Scaling group was created. This operation cannot
     * be called on an Auto Scaling group that has a mixed instances policy or a launch template or launch configuration
     * that requests Spot Instances.
     * </p>
     * <p>
     * You can view the instances in the warm pool using the <a>DescribeWarmPool</a> API call. If you are no longer
     * using a warm pool, you can delete it by calling the <a>DeleteWarmPool</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutWarmPoolRequest.Builder} avoiding the need to
     * create one manually via {@link PutWarmPoolRequest#builder()}
     * </p>
     *
     * @param putWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutWarmPoolRequest.Builder} to create a request.
     * @return Result of the PutWarmPool operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.PutWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutWarmPool" target="_top">AWS API
     *      Documentation</a>
     */
    default PutWarmPoolResponse putWarmPool(Consumer<PutWarmPoolRequest.Builder> putWarmPoolRequest)
            throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return putWarmPool(PutWarmPoolRequest.builder().applyMutation(putWarmPoolRequest).build());
    }

    /**
     * <p>
     * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the
     * timeout by the length of time defined using the <a>PutLifecycleHook</a> API call.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param recordLifecycleActionHeartbeatRequest
     * @return Result of the RecordLifecycleActionHeartbeat operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.RecordLifecycleActionHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    default RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeat(
            RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) throws ResourceContentionException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the
     * timeout by the length of time defined using the <a>PutLifecycleHook</a> API call.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecordLifecycleActionHeartbeatRequest.Builder}
     * avoiding the need to create one manually via {@link RecordLifecycleActionHeartbeatRequest#builder()}
     * </p>
     *
     * @param recordLifecycleActionHeartbeatRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest.Builder} to
     *        create a request.
     * @return Result of the RecordLifecycleActionHeartbeat operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.RecordLifecycleActionHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    default RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeat(
            Consumer<RecordLifecycleActionHeartbeatRequest.Builder> recordLifecycleActionHeartbeatRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return recordLifecycleActionHeartbeat(RecordLifecycleActionHeartbeatRequest.builder()
                .applyMutation(recordLifecycleActionHeartbeatRequest).build());
    }

    /**
     * <p>
     * Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling
     * group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and
     * resuming scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param resumeProcessesRequest
     * @return Result of the ResumeProcesses operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.ResumeProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default ResumeProcessesResponse resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) throws ResourceInUseException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling
     * group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and
     * resuming scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeProcessesRequest.Builder} avoiding the need
     * to create one manually via {@link ResumeProcessesRequest#builder()}
     * </p>
     *
     * @param resumeProcessesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest.Builder} to create a
     *        request.
     * @return Result of the ResumeProcesses operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.ResumeProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default ResumeProcessesResponse resumeProcesses(Consumer<ResumeProcessesRequest.Builder> resumeProcessesRequest)
            throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return resumeProcesses(ResumeProcessesRequest.builder().applyMutation(resumeProcessesRequest).build());
    }

    /**
     * <p>
     * Cancels an instance refresh that is in progress and rolls back any changes that it made. Amazon EC2 Auto Scaling
     * replaces any instances that were replaced during the instance refresh. This restores your Auto Scaling group to
     * the configuration that it was using before the start of the instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * A rollback is not supported in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * There is no desired configuration specified for the instance refresh.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead
     * of an AMI ID for the <code>ImageId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group uses the launch template's <code>&#36Latest</code> or <code>&#36Default</code> version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you receive a successful response from this operation, Amazon EC2 Auto Scaling immediately begins replacing
     * instances. You can check the status of this operation through the <a>DescribeInstanceRefreshes</a> API operation.
     * </p>
     *
     * @param rollbackInstanceRefreshRequest
     * @return Result of the RollbackInstanceRefresh operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ActiveInstanceRefreshNotFoundException
     *         The request failed because an active instance refresh or rollback for the specified Auto Scaling group
     *         was not found.
     * @throws IrreversibleInstanceRefreshException
     *         The request failed because a desired configuration was not found or an incompatible launch template (uses
     *         a Systems Manager parameter instead of an AMI ID) or launch template version (<code>&#36Latest</code> or
     *         <code>&#36Default</code>) is present on the Auto Scaling group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.RollbackInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RollbackInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default RollbackInstanceRefreshResponse rollbackInstanceRefresh(RollbackInstanceRefreshRequest rollbackInstanceRefreshRequest)
            throws LimitExceededException, ResourceContentionException, ActiveInstanceRefreshNotFoundException,
            IrreversibleInstanceRefreshException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an instance refresh that is in progress and rolls back any changes that it made. Amazon EC2 Auto Scaling
     * replaces any instances that were replaced during the instance refresh. This restores your Auto Scaling group to
     * the configuration that it was using before the start of the instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * A rollback is not supported in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * There is no desired configuration specified for the instance refresh.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead
     * of an AMI ID for the <code>ImageId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group uses the launch template's <code>&#36Latest</code> or <code>&#36Default</code> version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you receive a successful response from this operation, Amazon EC2 Auto Scaling immediately begins replacing
     * instances. You can check the status of this operation through the <a>DescribeInstanceRefreshes</a> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackInstanceRefreshRequest.Builder} avoiding
     * the need to create one manually via {@link RollbackInstanceRefreshRequest#builder()}
     * </p>
     *
     * @param rollbackInstanceRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshRequest.Builder} to create
     *        a request.
     * @return Result of the RollbackInstanceRefresh operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ActiveInstanceRefreshNotFoundException
     *         The request failed because an active instance refresh or rollback for the specified Auto Scaling group
     *         was not found.
     * @throws IrreversibleInstanceRefreshException
     *         The request failed because a desired configuration was not found or an incompatible launch template (uses
     *         a Systems Manager parameter instead of an AMI ID) or launch template version (<code>&#36Latest</code> or
     *         <code>&#36Default</code>) is present on the Auto Scaling group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.RollbackInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RollbackInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default RollbackInstanceRefreshResponse rollbackInstanceRefresh(
            Consumer<RollbackInstanceRefreshRequest.Builder> rollbackInstanceRefreshRequest) throws LimitExceededException,
            ResourceContentionException, ActiveInstanceRefreshNotFoundException, IrreversibleInstanceRefreshException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return rollbackInstanceRefresh(RollbackInstanceRefreshRequest.builder().applyMutation(rollbackInstanceRefreshRequest)
                .build());
    }

    /**
     * <p>
     * Sets the size of the specified Auto Scaling group.
     * </p>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html">Manual scaling</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param setDesiredCapacityRequest
     * @return Result of the SetDesiredCapacity operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SetDesiredCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDesiredCapacityResponse setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the size of the specified Auto Scaling group.
     * </p>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html">Manual scaling</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDesiredCapacityRequest.Builder} avoiding the
     * need to create one manually via {@link SetDesiredCapacityRequest#builder()}
     * </p>
     *
     * @param setDesiredCapacityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest.Builder} to create a
     *        request.
     * @return Result of the SetDesiredCapacity operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SetDesiredCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDesiredCapacityResponse setDesiredCapacity(Consumer<SetDesiredCapacityRequest.Builder> setDesiredCapacityRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return setDesiredCapacity(SetDesiredCapacityRequest.builder().applyMutation(setDesiredCapacityRequest).build());
    }

    /**
     * <p>
     * Sets the health status of the specified instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health
     * checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param setInstanceHealthRequest
     * @return Result of the SetInstanceHealth operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SetInstanceHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth" target="_top">AWS
     *      API Documentation</a>
     */
    default SetInstanceHealthResponse setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the health status of the specified instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health
     * checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetInstanceHealthRequest.Builder} avoiding the need
     * to create one manually via {@link SetInstanceHealthRequest#builder()}
     * </p>
     *
     * @param setInstanceHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest.Builder} to create a
     *        request.
     * @return Result of the SetInstanceHealth operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SetInstanceHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth" target="_top">AWS
     *      API Documentation</a>
     */
    default SetInstanceHealthResponse setInstanceHealth(Consumer<SetInstanceHealthRequest.Builder> setInstanceHealthRequest)
            throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return setInstanceHealth(SetInstanceHealthRequest.builder().applyMutation(setInstanceHealthRequest).build());
    }

    /**
     * <p>
     * Updates the instance protection settings of the specified instances. This operation cannot be called on instances
     * in a warm pool.
     * </p>
     * <p>
     * For more information about preventing instances that are part of an Auto Scaling group from terminating on scale
     * in, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using
     * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.
     * </p>
     *
     * @param setInstanceProtectionRequest
     * @return Result of the SetInstanceProtection operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SetInstanceProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default SetInstanceProtectionResponse setInstanceProtection(SetInstanceProtectionRequest setInstanceProtectionRequest)
            throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the instance protection settings of the specified instances. This operation cannot be called on instances
     * in a warm pool.
     * </p>
     * <p>
     * For more information about preventing instances that are part of an Auto Scaling group from terminating on scale
     * in, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using
     * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetInstanceProtectionRequest.Builder} avoiding the
     * need to create one manually via {@link SetInstanceProtectionRequest#builder()}
     * </p>
     *
     * @param setInstanceProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest.Builder} to create a
     *        request.
     * @return Result of the SetInstanceProtection operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SetInstanceProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default SetInstanceProtectionResponse setInstanceProtection(
            Consumer<SetInstanceProtectionRequest.Builder> setInstanceProtectionRequest) throws LimitExceededException,
            ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return setInstanceProtection(SetInstanceProtectionRequest.builder().applyMutation(setInstanceProtectionRequest).build());
    }

    /**
     * <p>
     * Starts an instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group. This feature
     * is helpful, for example, when you have a new AMI or a new user data script. You just need to create a new launch
     * template that specifies the new AMI or user data script. Then start an instance refresh to immediately begin the
     * process of updating instances in the group.
     * </p>
     * <p>
     * If successful, the request's response contains a unique ID that you can use to track the progress of the instance
     * refresh. To query its status, call the <a>DescribeInstanceRefreshes</a> API. To describe the instance refreshes
     * that have already run, call the <a>DescribeInstanceRefreshes</a> API. To cancel an instance refresh that is in
     * progress, use the <a>CancelInstanceRefresh</a> API.
     * </p>
     * <p>
     * An instance refresh might fail for several reasons, such as EC2 launch failures, misconfigured health checks, or
     * not ignoring or allowing the termination of instances that are in <code>Standby</code> state or protected from
     * scale in. You can monitor for failed EC2 launches using the scaling activities. To find the scaling activities,
     * call the <a>DescribeScalingActivities</a> API.
     * </p>
     * <p>
     * If you enable auto rollback, your Auto Scaling group will be rolled back automatically when the instance refresh
     * fails. You can enable this feature before starting an instance refresh by specifying the
     * <code>AutoRollback</code> property in the instance refresh preferences. Otherwise, to roll back an instance
     * refresh before it finishes, use the <a>RollbackInstanceRefresh</a> API.
     * </p>
     *
     * @param startInstanceRefreshRequest
     * @return Result of the StartInstanceRefresh operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InstanceRefreshInProgressException
     *         The request failed because an active instance refresh already exists for the specified Auto Scaling
     *         group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.StartInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/StartInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInstanceRefreshResponse startInstanceRefresh(StartInstanceRefreshRequest startInstanceRefreshRequest)
            throws LimitExceededException, ResourceContentionException, InstanceRefreshInProgressException, AwsServiceException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group. This feature
     * is helpful, for example, when you have a new AMI or a new user data script. You just need to create a new launch
     * template that specifies the new AMI or user data script. Then start an instance refresh to immediately begin the
     * process of updating instances in the group.
     * </p>
     * <p>
     * If successful, the request's response contains a unique ID that you can use to track the progress of the instance
     * refresh. To query its status, call the <a>DescribeInstanceRefreshes</a> API. To describe the instance refreshes
     * that have already run, call the <a>DescribeInstanceRefreshes</a> API. To cancel an instance refresh that is in
     * progress, use the <a>CancelInstanceRefresh</a> API.
     * </p>
     * <p>
     * An instance refresh might fail for several reasons, such as EC2 launch failures, misconfigured health checks, or
     * not ignoring or allowing the termination of instances that are in <code>Standby</code> state or protected from
     * scale in. You can monitor for failed EC2 launches using the scaling activities. To find the scaling activities,
     * call the <a>DescribeScalingActivities</a> API.
     * </p>
     * <p>
     * If you enable auto rollback, your Auto Scaling group will be rolled back automatically when the instance refresh
     * fails. You can enable this feature before starting an instance refresh by specifying the
     * <code>AutoRollback</code> property in the instance refresh preferences. Otherwise, to roll back an instance
     * refresh before it finishes, use the <a>RollbackInstanceRefresh</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInstanceRefreshRequest.Builder} avoiding the
     * need to create one manually via {@link StartInstanceRefreshRequest#builder()}
     * </p>
     *
     * @param startInstanceRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshRequest.Builder} to create a
     *        request.
     * @return Result of the StartInstanceRefresh operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling
     *         groups, launch configurations, or lifecycle hooks). For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html"
     *         >DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws InstanceRefreshInProgressException
     *         The request failed because an active instance refresh already exists for the specified Auto Scaling
     *         group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.StartInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/StartInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInstanceRefreshResponse startInstanceRefresh(
            Consumer<StartInstanceRefreshRequest.Builder> startInstanceRefreshRequest) throws LimitExceededException,
            ResourceContentionException, InstanceRefreshInProgressException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return startInstanceRefresh(StartInstanceRefreshRequest.builder().applyMutation(startInstanceRefreshRequest).build());
    }

    /**
     * <p>
     * Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.
     * </p>
     * <p>
     * If you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent other
     * process types from functioning properly. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and
     * resuming scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * To resume processes that have been suspended, call the <a>ResumeProcesses</a> API.
     * </p>
     *
     * @param suspendProcessesRequest
     * @return Result of the SuspendProcesses operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SuspendProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default SuspendProcessesResponse suspendProcesses(SuspendProcessesRequest suspendProcessesRequest)
            throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.
     * </p>
     * <p>
     * If you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent other
     * process types from functioning properly. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and
     * resuming scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * To resume processes that have been suspended, call the <a>ResumeProcesses</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SuspendProcessesRequest.Builder} avoiding the need
     * to create one manually via {@link SuspendProcessesRequest#builder()}
     * </p>
     *
     * @param suspendProcessesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest.Builder} to create a
     *        request.
     * @return Result of the SuspendProcesses operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.SuspendProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default SuspendProcessesResponse suspendProcesses(Consumer<SuspendProcessesRequest.Builder> suspendProcessesRequest)
            throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return suspendProcesses(SuspendProcessesRequest.builder().applyMutation(suspendProcessesRequest).build());
    }

    /**
     * <p>
     * Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called
     * on instances in a warm pool.
     * </p>
     * <p>
     * This call simply makes a termination request. The instance is not terminated immediately. When an instance is
     * terminated, the instance status changes to <code>terminated</code>. You can't connect to or start an instance
     * after you've terminated it.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are terminated.
     * </p>
     * <p>
     * By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the
     * desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto
     * Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage"
     * >Rebalancing activities</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param terminateInstanceInAutoScalingGroupRequest
     * @return Result of the TerminateInstanceInAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.TerminateInstanceInAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroup(
            TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called
     * on instances in a warm pool.
     * </p>
     * <p>
     * This call simply makes a termination request. The instance is not terminated immediately. When an instance is
     * terminated, the instance status changes to <code>terminated</code>. You can't connect to or start an instance
     * after you've terminated it.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are terminated.
     * </p>
     * <p>
     * By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the
     * desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto
     * Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage"
     * >Rebalancing activities</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateInstanceInAutoScalingGroupRequest.Builder}
     * avoiding the need to create one manually via {@link TerminateInstanceInAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param terminateInstanceInAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest.Builder}
     *        to create a request.
     * @return Result of the TerminateInstanceInAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.TerminateInstanceInAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroup(
            Consumer<TerminateInstanceInAutoScalingGroupRequest.Builder> terminateInstanceInAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException,
            AutoScalingException {
        return terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest.builder()
                .applyMutation(terminateInstanceInAutoScalingGroupRequest).build());
    }

    /**
     * <p>
     * <b>We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Updates the configuration for the specified Auto Scaling group.
     * </p>
     * <p>
     * To update an Auto Scaling group, specify the name of the group and the property that you want to change. Any
     * properties that you don't specify are not changed by this update request. The new settings take effect on any
     * scaling activities after this call returns.
     * </p>
     * <p>
     * If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get
     * the updated configuration. Existing instances continue to run with the configuration that they were originally
     * launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or
     * template, existing instances may be replaced to match the new purchasing options that you specified in the
     * policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot
     * capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances.
     * When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that
     * updating your group does not compromise the performance or availability of your application.
     * </p>
     * <p>
     * Note the following about changing <code>DesiredCapacity</code>, <code>MaxSize</code>, or <code>MinSize</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MinSize</code> is larger than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MinSize</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MaxSize</code> is smaller than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MaxSize</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To see which properties have been set, call the <a>DescribeAutoScalingGroups</a> API. To view the scaling
     * policies for an Auto Scaling group, call the <a>DescribePolicies</a> API. If the group has scaling policies, you
     * can update them by calling the <a>PutScalingPolicy</a> API.
     * </p>
     *
     * @param updateAutoScalingGroupRequest
     * @return Result of the UpdateAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.UpdateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAutoScalingGroupResponse updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, ServiceLinkedRoleFailureException,
            AwsServiceException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Updates the configuration for the specified Auto Scaling group.
     * </p>
     * <p>
     * To update an Auto Scaling group, specify the name of the group and the property that you want to change. Any
     * properties that you don't specify are not changed by this update request. The new settings take effect on any
     * scaling activities after this call returns.
     * </p>
     * <p>
     * If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get
     * the updated configuration. Existing instances continue to run with the configuration that they were originally
     * launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or
     * template, existing instances may be replaced to match the new purchasing options that you specified in the
     * policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot
     * capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances.
     * When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that
     * updating your group does not compromise the performance or availability of your application.
     * </p>
     * <p>
     * Note the following about changing <code>DesiredCapacity</code>, <code>MaxSize</code>, or <code>MinSize</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MinSize</code> is larger than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MinSize</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MaxSize</code> is smaller than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MaxSize</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To see which properties have been set, call the <a>DescribeAutoScalingGroups</a> API. To view the scaling
     * policies for an Auto Scaling group, call the <a>DescribePolicies</a> API. If the group has scaling policies, you
     * can update them by calling the <a>PutScalingPolicy</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAutoScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param updateAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling
     *         group, instance, or load balancer).
     * @throws ServiceLinkedRoleFailureException
     *         The service-linked role is not yet ready for use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingClient.UpdateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAutoScalingGroupResponse updateAutoScalingGroup(
            Consumer<UpdateAutoScalingGroupRequest.Builder> updateAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, ServiceLinkedRoleFailureException,
            AwsServiceException, SdkClientException, AutoScalingException {
        return updateAutoScalingGroup(UpdateAutoScalingGroupRequest.builder().applyMutation(updateAutoScalingGroupRequest)
                .build());
    }

    /**
     * Create an instance of {@link AutoScalingWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link AutoScalingWaiter}
     */
    default AutoScalingWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AutoScalingClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AutoScalingClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AutoScalingClient}.
     */
    static AutoScalingClientBuilder builder() {
        return new DefaultAutoScalingClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default AutoScalingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
