/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchConfigurationRequest extends AutoScalingRequest implements
        ToCopyableBuilder<CreateLaunchConfigurationRequest.Builder, CreateLaunchConfigurationRequest> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(CreateLaunchConfigurationRequest::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(CreateLaunchConfigurationRequest::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(CreateLaunchConfigurationRequest::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(CreateLaunchConfigurationRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLASSIC_LINK_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClassicLinkVPCId").getter(getter(CreateLaunchConfigurationRequest::classicLinkVPCId))
            .setter(setter(Builder::classicLinkVPCId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCId").build()).build();

    private static final SdkField<List<String>> CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClassicLinkVPCSecurityGroups")
            .getter(getter(CreateLaunchConfigurationRequest::classicLinkVPCSecurityGroups))
            .setter(setter(Builder::classicLinkVPCSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCSecurityGroups")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserData").getter(getter(CreateLaunchConfigurationRequest::userData)).setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateLaunchConfigurationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CreateLaunchConfigurationRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KernelId").getter(getter(CreateLaunchConfigurationRequest::kernelId)).setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId").getter(getter(CreateLaunchConfigurationRequest::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(CreateLaunchConfigurationRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceMonitoring> INSTANCE_MONITORING_FIELD = SdkField
            .<InstanceMonitoring> builder(MarshallingType.SDK_POJO).memberName("InstanceMonitoring")
            .getter(getter(CreateLaunchConfigurationRequest::instanceMonitoring)).setter(setter(Builder::instanceMonitoring))
            .constructor(InstanceMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMonitoring").build())
            .build();

    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpotPrice").getter(getter(CreateLaunchConfigurationRequest::spotPrice))
            .setter(setter(Builder::spotPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").build()).build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamInstanceProfile").getter(getter(CreateLaunchConfigurationRequest::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build())
            .build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized").getter(getter(CreateLaunchConfigurationRequest::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress")
            .getter(getter(CreateLaunchConfigurationRequest::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build())
            .build();

    private static final SdkField<String> PLACEMENT_TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementTenancy").getter(getter(CreateLaunchConfigurationRequest::placementTenancy))
            .setter(setter(Builder::placementTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementTenancy").build()).build();

    private static final SdkField<InstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptions> builder(MarshallingType.SDK_POJO).memberName("MetadataOptions")
            .getter(getter(CreateLaunchConfigurationRequest::metadataOptions)).setter(setter(Builder::metadataOptions))
            .constructor(InstanceMetadataOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_CONFIGURATION_NAME_FIELD, IMAGE_ID_FIELD, KEY_NAME_FIELD, SECURITY_GROUPS_FIELD, CLASSIC_LINK_VPC_ID_FIELD,
            CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD, USER_DATA_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD,
            RAMDISK_ID_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, INSTANCE_MONITORING_FIELD, SPOT_PRICE_FIELD,
            IAM_INSTANCE_PROFILE_FIELD, EBS_OPTIMIZED_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, PLACEMENT_TENANCY_FIELD,
            METADATA_OPTIONS_FIELD));

    private final String launchConfigurationName;

    private final String imageId;

    private final String keyName;

    private final List<String> securityGroups;

    private final String classicLinkVPCId;

    private final List<String> classicLinkVPCSecurityGroups;

    private final String userData;

    private final String instanceId;

    private final String instanceType;

    private final String kernelId;

    private final String ramdiskId;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final InstanceMonitoring instanceMonitoring;

    private final String spotPrice;

    private final String iamInstanceProfile;

    private final Boolean ebsOptimized;

    private final Boolean associatePublicIpAddress;

    private final String placementTenancy;

    private final InstanceMetadataOptions metadataOptions;

    private CreateLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.launchConfigurationName = builder.launchConfigurationName;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
        this.metadataOptions = builder.metadataOptions;
    }

    /**
     * <p>
     * The name of the launch configuration. This name must be unique per Region per account.
     * </p>
     * 
     * @return The name of the launch configuration. This name must be unique per Region per account.
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Find a Linux AMI</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * If you specify <code>InstanceId</code>, an <code>ImageId</code> is not required.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Find a Linux AMI</a> in
     *         the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     *         <p>
     *         If you specify <code>InstanceId</code>, an <code>ImageId</code> is not required.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the key pair. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs and Amazon EC2
     * instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The name of the key pair. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs and
     *         Amazon EC2 instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html">Control
     * traffic to your Amazon Web Services resources using security groups</a> in the <i>Amazon Virtual Private Cloud
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html">Control traffic to your
     *         Amazon Web Services resources using security groups</a> in the <i>Amazon Virtual Private Cloud User
     *         Guide</i>.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Available for backward compatibility.
     * </p>
     * 
     * @return Available for backward compatibility.
     */
    public final String classicLinkVPCId() {
        return classicLinkVPCId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClassicLinkVPCSecurityGroups property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClassicLinkVPCSecurityGroups() {
        return classicLinkVPCSecurityGroups != null && !(classicLinkVPCSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Available for backward compatibility.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClassicLinkVPCSecurityGroups} method.
     * </p>
     * 
     * @return Available for backward compatibility.
     */
    public final List<String> classicLinkVPCSecurityGroups() {
        return classicLinkVPCSecurityGroups;
    }

    /**
     * <p>
     * The user data to make available to the launched EC2 instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user
     * data</a> (Linux) and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and
     * user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can
     * load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
     * </p>
     * 
     * @return The user data to make available to the launched EC2 instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata
     *         and user data</a> (Linux) and <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance
     *         metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed
     *         for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User
     *         data is limited to 16 KB.
     */
    public final String userData() {
        return userData;
    }

    /**
     * <p>
     * The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes
     * from the instance, except for the block device mapping.
     * </p>
     * <p>
     * To create a launch configuration with a block device mapping or override any other instance attributes, specify
     * them as part of the same request.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html">Create a launch
     * configuration</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of the instance to use to create the launch configuration. The new launch configuration derives
     *         attributes from the instance, except for the block device mapping.</p>
     *         <p>
     *         To create a launch configuration with a block device mapping or override any other instance attributes,
     *         specify them as part of the same request.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html">Create a launch
     *         configuration</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Specifies the instance type of the EC2 instance. For information about available instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
     * instance types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * If you specify <code>InstanceId</code>, an <code>InstanceType</code> is not required.
     * </p>
     * 
     * @return Specifies the instance type of the EC2 instance. For information about available instance types, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">
     *         Available instance types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     *         <p>
     *         If you specify <code>InstanceId</code>, an <code>InstanceType</code> is not required.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel associated with the AMI.
     * </p>
     * <note>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * </note>
     * 
     * @return The ID of the kernel associated with the AMI.</p> <note>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided
     *         kernels</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     *         </p>
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The ID of the RAM disk to select.
     * </p>
     * <note>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * </note>
     * 
     * @return The ID of the RAM disk to select.</p> <note>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided
     *         kernels</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     *         </p>
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping entries that define the block devices to attach to the instances at launch. By default,
     * the block devices specified in the block device mapping for the AMI are used. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block device
     * mappings</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return The block device mapping entries that define the block devices to attach to the instances at launch. By
     *         default, the block devices specified in the block device mapping for the AMI are used. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
     *         device mappings</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
     * <code>false</code>) monitoring.
     * </p>
     * <p>
     * The default value is <code>true</code> (enabled).
     * </p>
     * <important>
     * <p>
     * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged
     * a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
     * monitoring for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * </important>
     * 
     * @return Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
     *         <code>false</code>) monitoring.</p>
     *         <p>
     *         The default value is <code>true</code> (enabled).
     *         </p>
     *         <important>
     *         <p>
     *         When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is
     *         charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
     *         monitoring for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     */
    public final InstanceMonitoring instanceMonitoring() {
        return instanceMonitoring;
    }

    /**
     * <p>
     * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
     * launched when the price you specify exceeds the current Spot price. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html">Request Spot
     * Instances for fault-tolerant and flexible applications</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Valid Range: Minimum value of 0.001
     * </p>
     * <note>
     * <p>
     * When you change your maximum price by creating a new launch configuration, running instances will continue to run
     * as long as the maximum price for those running instances is higher than the current Spot price.
     * </p>
     * </note>
     * 
     * @return The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances
     *         are launched when the price you specify exceeds the current Spot price. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html">Request
     *         Spot Instances for fault-tolerant and flexible applications</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.</p>
     *         <p>
     *         Valid Range: Minimum value of 0.001
     *         </p>
     *         <note>
     *         <p>
     *         When you change your maximum price by creating a new launch configuration, running instances will
     *         continue to run as long as the maximum price for those running instances is higher than the current Spot
     *         price.
     *         </p>
     */
    public final String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
     * The instance profile contains the IAM role. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run
     * on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
     *         instance. The instance profile contains the IAM role. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications
     *         that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
     * <code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration
     * stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional
     * fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon
     * EBS-optimized instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
     *         <code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized
     *         configuration stack to provide optimal I/O performance. This optimization is not available with all
     *         instance types. Additional fees are incurred when you enable EBS optimization for an instance type that
     *         is not EBS-optimized by default. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS-optimized
     *         instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Specifies whether to assign a public IPv4 address to the group's instances. If the instance is launched into a
     * default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public
     * IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a
     * public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet.
     * </p>
     * <p>
     * If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IPv4 address.
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Provide
     * network connectivity for your Auto Scaling instances using Amazon VPC</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * <p>
     * If you specify this property, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you
     * create your group.
     * </p>
     * 
     * @return Specifies whether to assign a public IPv4 address to the group's instances. If the instance is launched
     *         into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to
     *         assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the
     *         default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4
     *         address on the subnet.</p>
     *         <p>
     *         If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IPv4
     *         address. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Provide network connectivity
     *         for your Auto Scaling instances using Amazon VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         If you specify this property, you must specify at least one subnet for <code>VPCZoneIdentifier</code>
     *         when you create your group.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
     * <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC. To
     * launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to
     * <code>default</code>), you must set the value of this property to <code>dedicated</code>.
     * </p>
     * <p>
     * If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for
     * <code>VPCZoneIdentifier</code> when you create your group.
     * </p>
     * <p>
     * Valid values: <code>default</code> | <code>dedicated</code>
     * </p>
     * 
     * @return The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
     *         <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a
     *         VPC. To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy
     *         attribute set to <code>default</code>), you must set the value of this property to <code>dedicated</code>
     *         .</p>
     *         <p>
     *         If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for
     *         <code>VPCZoneIdentifier</code> when you create your group.
     *         </p>
     *         <p>
     *         Valid values: <code>default</code> | <code>dedicated</code>
     */
    public final String placementTenancy() {
        return placementTenancy;
    }

    /**
     * <p>
     * The metadata options for the instances. For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds"
     * >Configure the instance metadata options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The metadata options for the instances. For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds"
     *         >Configure the instance metadata options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final InstanceMetadataOptions metadataOptions() {
        return metadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(classicLinkVPCId());
        hashCode = 31 * hashCode + Objects.hashCode(hasClassicLinkVPCSecurityGroups() ? classicLinkVPCSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(placementTenancy());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationRequest)) {
            return false;
        }
        CreateLaunchConfigurationRequest other = (CreateLaunchConfigurationRequest) obj;
        return Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(keyName(), other.keyName())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(classicLinkVPCId(), other.classicLinkVPCId())
                && hasClassicLinkVPCSecurityGroups() == other.hasClassicLinkVPCSecurityGroups()
                && Objects.equals(classicLinkVPCSecurityGroups(), other.classicLinkVPCSecurityGroups())
                && Objects.equals(userData(), other.userData()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(ramdiskId(), other.ramdiskId()) && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(instanceMonitoring(), other.instanceMonitoring())
                && Objects.equals(spotPrice(), other.spotPrice())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(placementTenancy(), other.placementTenancy())
                && Objects.equals(metadataOptions(), other.metadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLaunchConfigurationRequest").add("LaunchConfigurationName", launchConfigurationName())
                .add("ImageId", imageId()).add("KeyName", keyName())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("ClassicLinkVPCId", classicLinkVPCId())
                .add("ClassicLinkVPCSecurityGroups", hasClassicLinkVPCSecurityGroups() ? classicLinkVPCSecurityGroups() : null)
                .add("UserData", userData()).add("InstanceId", instanceId()).add("InstanceType", instanceType())
                .add("KernelId", kernelId()).add("RamdiskId", ramdiskId())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("InstanceMonitoring", instanceMonitoring()).add("SpotPrice", spotPrice())
                .add("IamInstanceProfile", iamInstanceProfile()).add("EbsOptimized", ebsOptimized())
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).add("PlacementTenancy", placementTenancy())
                .add("MetadataOptions", metadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "ClassicLinkVPCId":
            return Optional.ofNullable(clazz.cast(classicLinkVPCId()));
        case "ClassicLinkVPCSecurityGroups":
            return Optional.ofNullable(clazz.cast(classicLinkVPCSecurityGroups()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "InstanceMonitoring":
            return Optional.ofNullable(clazz.cast(instanceMonitoring()));
        case "SpotPrice":
            return Optional.ofNullable(clazz.cast(spotPrice()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "PlacementTenancy":
            return Optional.ofNullable(clazz.cast(placementTenancy()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchConfigurationRequest, T> g) {
        return obj -> g.apply((CreateLaunchConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLaunchConfigurationRequest> {
        /**
         * <p>
         * The name of the launch configuration. This name must be unique per Region per account.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration. This name must be unique per Region per account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Find a Linux AMI</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * <p>
         * If you specify <code>InstanceId</code>, an <code>ImageId</code> is not required.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information,
         *        see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Find a Linux
         *        AMI</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
         *        <p>
         *        If you specify <code>InstanceId</code>, an <code>ImageId</code> is not required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the key pair. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs and Amazon
         * EC2 instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs and
         *        Amazon EC2 instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For more
         * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html">Control
         * traffic to your Amazon Web Services resources using security groups</a> in the <i>Amazon Virtual Private
         * Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html">Control traffic to
         *        your Amazon Web Services resources using security groups</a> in the <i>Amazon Virtual Private Cloud
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For more
         * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html">Control
         * traffic to your Amazon Web Services resources using security groups</a> in the <i>Amazon Virtual Private
         * Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html">Control traffic to
         *        your Amazon Web Services resources using security groups</a> in the <i>Amazon Virtual Private Cloud
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * Available for backward compatibility.
         * </p>
         * 
         * @param classicLinkVPCId
         *        Available for backward compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCId(String classicLinkVPCId);

        /**
         * <p>
         * Available for backward compatibility.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        Available for backward compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups);

        /**
         * <p>
         * Available for backward compatibility.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        Available for backward compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The user data to make available to the launched EC2 instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and
         * user data</a> (Linux) and <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata
         * and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and
         * you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to
         * 16 KB.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the launched EC2 instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        metadata and user data</a> (Linux) and <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance
         *        metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is
         *        performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded
         *        text. User data is limited to 16 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The ID of the instance to use to create the launch configuration. The new launch configuration derives
         * attributes from the instance, except for the block device mapping.
         * </p>
         * <p>
         * To create a launch configuration with a block device mapping or override any other instance attributes,
         * specify them as part of the same request.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html">Create a launch
         * configuration</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to use to create the launch configuration. The new launch configuration derives
         *        attributes from the instance, except for the block device mapping.</p>
         *        <p>
         *        To create a launch configuration with a block device mapping or override any other instance
         *        attributes, specify them as part of the same request.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html">Create a launch
         *        configuration</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Specifies the instance type of the EC2 instance. For information about available instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         * >Available instance types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * <p>
         * If you specify <code>InstanceId</code>, an <code>InstanceType</code> is not required.
         * </p>
         * 
         * @param instanceType
         *        Specifies the instance type of the EC2 instance. For information about available instance types, see
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         *        >Available instance types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
         *        <p>
         *        If you specify <code>InstanceId</code>, an <code>InstanceType</code> is not required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel associated with the AMI.
         * </p>
         * <note>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a>
         * in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * </note>
         * 
         * @param kernelId
         *        The ID of the kernel associated with the AMI.</p> <note>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided
         *        kernels</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The ID of the RAM disk to select.
         * </p>
         * <note>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a>
         * in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * </note>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk to select.</p> <note>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided
         *        kernels</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The block device mapping entries that define the block devices to attach to the instances at launch. By
         * default, the block devices specified in the block device mapping for the AMI are used. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         * device mappings</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries that define the block devices to attach to the instances at launch.
         *        By default, the block devices specified in the block device mapping for the AMI are used. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        device mappings</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries that define the block devices to attach to the instances at launch. By
         * default, the block devices specified in the block device mapping for the AMI are used. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         * device mappings</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries that define the block devices to attach to the instances at launch.
         *        By default, the block devices specified in the block device mapping for the AMI are used. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        device mappings</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries that define the block devices to attach to the instances at launch. By
         * default, the block devices specified in the block device mapping for the AMI are used. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         * device mappings</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         * <code>false</code>) monitoring.
         * </p>
         * <p>
         * The default value is <code>true</code> (enabled).
         * </p>
         * <important>
         * <p>
         * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is
         * charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
         * monitoring for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * </important>
         * 
         * @param instanceMonitoring
         *        Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         *        <code>false</code>) monitoring.</p>
         *        <p>
         *        The default value is <code>true</code> (enabled).
         *        </p>
         *        <important>
         *        <p>
         *        When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
         *        is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html"
         *        >Configure monitoring for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitoring(InstanceMonitoring instanceMonitoring);

        /**
         * <p>
         * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         * <code>false</code>) monitoring.
         * </p>
         * <p>
         * The default value is <code>true</code> (enabled).
         * </p>
         * <important>
         * <p>
         * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is
         * charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
         * monitoring for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * </important> This is a convenience method that creates an instance of the {@link InstanceMonitoring.Builder}
         * avoiding the need to create one manually via {@link InstanceMonitoring#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMonitoring.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceMonitoring(InstanceMonitoring)}.
         * 
         * @param instanceMonitoring
         *        a consumer that will call methods on {@link InstanceMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMonitoring(InstanceMonitoring)
         */
        default Builder instanceMonitoring(Consumer<InstanceMonitoring.Builder> instanceMonitoring) {
            return instanceMonitoring(InstanceMonitoring.builder().applyMutation(instanceMonitoring).build());
        }

        /**
         * <p>
         * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
         * launched when the price you specify exceeds the current Spot price. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html">Request Spot
         * Instances for fault-tolerant and flexible applications</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Valid Range: Minimum value of 0.001
         * </p>
         * <note>
         * <p>
         * When you change your maximum price by creating a new launch configuration, running instances will continue to
         * run as long as the maximum price for those running instances is higher than the current Spot price.
         * </p>
         * </note>
         * 
         * @param spotPrice
         *        The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot
         *        Instances are launched when the price you specify exceeds the current Spot price. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html"
         *        >Request Spot Instances for fault-tolerant and flexible applications</a> in the <i>Amazon EC2 Auto
         *        Scaling User Guide</i>.</p>
         *        <p>
         *        Valid Range: Minimum value of 0.001
         *        </p>
         *        <note>
         *        <p>
         *        When you change your maximum price by creating a new launch configuration, running instances will
         *        continue to run as long as the maximum price for those running instances is higher than the current
         *        Spot price.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
         * instance. The instance profile contains the IAM role. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that
         * run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for
         *        the instance. The instance profile contains the IAM role. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for
         *        applications that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(String iamInstanceProfile);

        /**
         * <p>
         * Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
         * <code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized
         * configuration stack to provide optimal I/O performance. This optimization is not available with all instance
         * types. Additional fees are incurred when you enable EBS optimization for an instance type that is not
         * EBS-optimized by default. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS-optimized
         * instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param ebsOptimized
         *        Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
         *        <code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized
         *        configuration stack to provide optimal I/O performance. This optimization is not available with all
         *        instance types. Additional fees are incurred when you enable EBS optimization for an instance type
         *        that is not EBS-optimized by default. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS-optimized
         *        instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Specifies whether to assign a public IPv4 address to the group's instances. If the instance is launched into
         * a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a
         * public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not
         * to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet.
         * </p>
         * <p>
         * If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IPv4
         * address. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Provide network connectivity for
         * your Auto Scaling instances using Amazon VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * If you specify this property, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when
         * you create your group.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Specifies whether to assign a public IPv4 address to the group's instances. If the instance is
         *        launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled
         *        the option to assign a public IPv4 address on the subnet. If the instance is launched into a
         *        nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option
         *        to assign a public IPv4 address on the subnet.</p>
         *        <p>
         *        If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public
         *        IPv4 address. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Provide network
         *        connectivity for your Auto Scaling instances using Amazon VPC</a> in the <i>Amazon EC2 Auto Scaling
         *        User Guide</i>.
         *        </p>
         *        <p>
         *        If you specify this property, you must specify at least one subnet for <code>VPCZoneIdentifier</code>
         *        when you create your group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
         * <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.
         * To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute
         * set to <code>default</code>), you must set the value of this property to <code>dedicated</code>.
         * </p>
         * <p>
         * If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for
         * <code>VPCZoneIdentifier</code> when you create your group.
         * </p>
         * <p>
         * Valid values: <code>default</code> | <code>dedicated</code>
         * </p>
         * 
         * @param placementTenancy
         *        The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
         *        <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into
         *        a VPC. To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement
         *        tenancy attribute set to <code>default</code>), you must set the value of this property to
         *        <code>dedicated</code>.</p>
         *        <p>
         *        If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for
         *        <code>VPCZoneIdentifier</code> when you create your group.
         *        </p>
         *        <p>
         *        Valid values: <code>default</code> | <code>dedicated</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTenancy(String placementTenancy);

        /**
         * <p>
         * The metadata options for the instances. For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds"
         * >Configure the instance metadata options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instances. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds"
         *        >Configure the instance metadata options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(InstanceMetadataOptions metadataOptions);

        /**
         * <p>
         * The metadata options for the instances. For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds"
         * >Configure the instance metadata options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMetadataOptions.Builder} avoiding
         * the need to create one manually via {@link InstanceMetadataOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #metadataOptions(InstanceMetadataOptions)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(InstanceMetadataOptions)
         */
        default Builder metadataOptions(Consumer<InstanceMetadataOptions.Builder> metadataOptions) {
            return metadataOptions(InstanceMetadataOptions.builder().applyMutation(metadataOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String launchConfigurationName;

        private String imageId;

        private String keyName;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String classicLinkVPCId;

        private List<String> classicLinkVPCSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String userData;

        private String instanceId;

        private String instanceType;

        private String kernelId;

        private String ramdiskId;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private InstanceMonitoring instanceMonitoring;

        private String spotPrice;

        private String iamInstanceProfile;

        private Boolean ebsOptimized;

        private Boolean associatePublicIpAddress;

        private String placementTenancy;

        private InstanceMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationRequest model) {
            super(model);
            launchConfigurationName(model.launchConfigurationName);
            imageId(model.imageId);
            keyName(model.keyName);
            securityGroups(model.securityGroups);
            classicLinkVPCId(model.classicLinkVPCId);
            classicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            userData(model.userData);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            ramdiskId(model.ramdiskId);
            blockDeviceMappings(model.blockDeviceMappings);
            instanceMonitoring(model.instanceMonitoring);
            spotPrice(model.spotPrice);
            iamInstanceProfile(model.iamInstanceProfile);
            ebsOptimized(model.ebsOptimized);
            associatePublicIpAddress(model.associatePublicIpAddress);
            placementTenancy(model.placementTenancy);
            metadataOptions(model.metadataOptions);
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getClassicLinkVPCId() {
            return classicLinkVPCId;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            if (classicLinkVPCSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return classicLinkVPCSecurityGroups;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups) {
            classicLinkVPCSecurityGroups(Arrays.asList(classicLinkVPCSecurityGroups));
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingsCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceMonitoring.Builder getInstanceMonitoring() {
            return instanceMonitoring != null ? instanceMonitoring.toBuilder() : null;
        }

        public final void setInstanceMonitoring(InstanceMonitoring.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final String getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final String getPlacementTenancy() {
            return placementTenancy;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final InstanceMetadataOptions.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchConfigurationRequest build() {
            return new CreateLaunchConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
