/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastRequest;
import software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastResponse;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.PutWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.PutWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolPublisher;
import software.amazon.awssdk.services.autoscaling.waiters.AutoScalingAsyncWaiter;

/**
 * Service client for accessing Auto Scaling asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon EC2 Auto Scaling</fullname>
 * <p>
 * Amazon EC2 Auto Scaling is designed to automatically launch and terminate EC2 instances based on user-defined scaling
 * policies, scheduled actions, and health checks.
 * </p>
 * <p>
 * For more information, see the <a
 * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html">Amazon EC2 Auto
 * Scaling User Guide</a> and the <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/Welcome.html">Amazon
 * EC2 Auto Scaling API Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AutoScalingAsyncClient extends AwsClient {
    String SERVICE_NAME = "autoscaling";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "autoscaling";

    /**
     * <p>
     * Attaches one or more EC2 instances to the specified Auto Scaling group.
     * </p>
     * <p>
     * When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of
     * instances being attached. If the number of instances being attached plus the desired capacity of the group
     * exceeds the maximum size of the group, the operation fails.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with
     * the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also
     * registered with the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-detach-attach-instances.html">Detach
     * or attach instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param attachInstancesRequest
     * @return A Java Future containing the result of the AttachInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachInstancesResponse> attachInstances(AttachInstancesRequest attachInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more EC2 instances to the specified Auto Scaling group.
     * </p>
     * <p>
     * When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of
     * instances being attached. If the number of instances being attached plus the desired capacity of the group
     * exceeds the maximum size of the group, the operation fails.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with
     * the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also
     * registered with the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-detach-attach-instances.html">Detach
     * or attach instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link AttachInstancesRequest#builder()}
     * </p>
     *
     * @param attachInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachInstancesResponse> attachInstances(
            Consumer<AttachInstancesRequest.Builder> attachInstancesRequest) {
        return attachInstances(AttachInstancesRequest.builder().applyMutation(attachInstancesRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>AttachLoadBalancerTargetGroups</code> API operation and <code>AttachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more target groups to the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation is used with the following load balancer types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer - Operates at the network layer (layer 3).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To describe the target groups for an Auto Scaling group, call the <a>DescribeLoadBalancerTargetGroups</a> API. To
     * detach the target group from the Auto Scaling group, call the <a>DetachLoadBalancerTargetGroups</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing target groups or Classic Load Balancers from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     *
     * @param attachLoadBalancerTargetGroupsRequest
     * @return A Java Future containing the result of the AttachLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachLoadBalancerTargetGroupsResponse> attachLoadBalancerTargetGroups(
            AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>AttachLoadBalancerTargetGroups</code> API operation and <code>AttachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more target groups to the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation is used with the following load balancer types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer - Operates at the network layer (layer 3).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To describe the target groups for an Auto Scaling group, call the <a>DescribeLoadBalancerTargetGroups</a> API. To
     * detach the target group from the Auto Scaling group, call the <a>DetachLoadBalancerTargetGroups</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing target groups or Classic Load Balancers from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link AttachLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param attachLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AttachLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachLoadBalancerTargetGroupsResponse> attachLoadBalancerTargetGroups(
            Consumer<AttachLoadBalancerTargetGroupsRequest.Builder> attachLoadBalancerTargetGroupsRequest) {
        return attachLoadBalancerTargetGroups(AttachLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(attachLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancers</code>. You can use both the original
     * <code>AttachLoadBalancers</code> API operation and <code>AttachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more Classic Load Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling
     * registers the running instances with these Classic Load Balancers.
     * </p>
     * <p>
     * To describe the load balancers for an Auto Scaling group, call the <a>DescribeLoadBalancers</a> API. To detach a
     * load balancer from the Auto Scaling group, call the <a>DetachLoadBalancers</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing Classic Load Balancers or target groups from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     *
     * @param attachLoadBalancersRequest
     * @return A Java Future containing the result of the AttachLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachLoadBalancersResponse> attachLoadBalancers(
            AttachLoadBalancersRequest attachLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>AttachTrafficSources</a>, which can attach multiple traffic sources types.
     * We recommend using <code>AttachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>AttachLoadBalancers</code>. You can use both the original
     * <code>AttachLoadBalancers</code> API operation and <code>AttachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Attaches one or more Classic Load Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling
     * registers the running instances with these Classic Load Balancers.
     * </p>
     * <p>
     * To describe the load balancers for an Auto Scaling group, call the <a>DescribeLoadBalancers</a> API. To detach a
     * load balancer from the Auto Scaling group, call the <a>DetachLoadBalancers</a> API.
     * </p>
     * <p>
     * This operation is additive and does not detach existing Classic Load Balancers or target groups from the Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link AttachLoadBalancersRequest#builder()}
     * </p>
     *
     * @param attachLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachLoadBalancersResponse> attachLoadBalancers(
            Consumer<AttachLoadBalancersRequest.Builder> attachLoadBalancersRequest) {
        return attachLoadBalancers(AttachLoadBalancersRequest.builder().applyMutation(attachLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Attaches one or more traffic sources to the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use any of the following as traffic sources for an Auto Scaling group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Classic Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * VPC Lattice
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is additive and does not detach existing traffic sources from the Auto Scaling group.
     * </p>
     * <p>
     * After the operation completes, use the <a>DescribeTrafficSources</a> API to return details about the state of the
     * attachments between traffic sources and your Auto Scaling group. To detach a traffic source from the Auto Scaling
     * group, call the <a>DetachTrafficSources</a> API.
     * </p>
     *
     * @param attachTrafficSourcesRequest
     * @return A Java Future containing the result of the AttachTrafficSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachTrafficSourcesResponse> attachTrafficSources(
            AttachTrafficSourcesRequest attachTrafficSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more traffic sources to the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use any of the following as traffic sources for an Auto Scaling group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Classic Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Load Balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * VPC Lattice
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is additive and does not detach existing traffic sources from the Auto Scaling group.
     * </p>
     * <p>
     * After the operation completes, use the <a>DescribeTrafficSources</a> API to return details about the state of the
     * attachments between traffic sources and your Auto Scaling group. To detach a traffic source from the Auto Scaling
     * group, call the <a>DetachTrafficSources</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link AttachTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param attachTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachTrafficSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachTrafficSourcesResponse> attachTrafficSources(
            Consumer<AttachTrafficSourcesRequest.Builder> attachTrafficSourcesRequest) {
        return attachTrafficSources(AttachTrafficSourcesRequest.builder().applyMutation(attachTrafficSourcesRequest).build());
    }

    /**
     * <p>
     * Deletes one or more scheduled actions for the specified Auto Scaling group.
     * </p>
     *
     * @param batchDeleteScheduledActionRequest
     * @return A Java Future containing the result of the BatchDeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.BatchDeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchDeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteScheduledActionResponse> batchDeleteScheduledAction(
            BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more scheduled actions for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteScheduledActionRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteScheduledActionRequest#builder()}
     * </p>
     *
     * @param batchDeleteScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchDeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.BatchDeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchDeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteScheduledActionResponse> batchDeleteScheduledAction(
            Consumer<BatchDeleteScheduledActionRequest.Builder> batchDeleteScheduledActionRequest) {
        return batchDeleteScheduledAction(BatchDeleteScheduledActionRequest.builder()
                .applyMutation(batchDeleteScheduledActionRequest).build());
    }

    /**
     * <p>
     * Creates or updates one or more scheduled scaling actions for an Auto Scaling group.
     * </p>
     *
     * @param batchPutScheduledUpdateGroupActionRequest
     * @return A Java Future containing the result of the BatchPutScheduledUpdateGroupAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.BatchPutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutScheduledUpdateGroupActionResponse> batchPutScheduledUpdateGroupAction(
            BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates one or more scheduled scaling actions for an Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutScheduledUpdateGroupActionRequest.Builder}
     * avoiding the need to create one manually via {@link BatchPutScheduledUpdateGroupActionRequest#builder()}
     * </p>
     *
     * @param batchPutScheduledUpdateGroupActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchPutScheduledUpdateGroupAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.BatchPutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutScheduledUpdateGroupActionResponse> batchPutScheduledUpdateGroupAction(
            Consumer<BatchPutScheduledUpdateGroupActionRequest.Builder> batchPutScheduledUpdateGroupActionRequest) {
        return batchPutScheduledUpdateGroupAction(BatchPutScheduledUpdateGroupActionRequest.builder()
                .applyMutation(batchPutScheduledUpdateGroupActionRequest).build());
    }

    /**
     * <p>
     * Cancels an instance refresh or rollback that is in progress. If an instance refresh or rollback is not in
     * progress, an <code>ActiveInstanceRefreshNotFound</code> error occurs.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * When you cancel an instance refresh, this does not roll back any changes that it made. Use the
     * <a>RollbackInstanceRefresh</a> API to roll back instead.
     * </p>
     *
     * @param cancelInstanceRefreshRequest
     * @return A Java Future containing the result of the CancelInstanceRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ActiveInstanceRefreshNotFoundException The request failed because an active instance refresh or
     *         rollback for the specified Auto Scaling group was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CancelInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CancelInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelInstanceRefreshResponse> cancelInstanceRefresh(
            CancelInstanceRefreshRequest cancelInstanceRefreshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an instance refresh or rollback that is in progress. If an instance refresh or rollback is not in
     * progress, an <code>ActiveInstanceRefreshNotFound</code> error occurs.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * When you cancel an instance refresh, this does not roll back any changes that it made. Use the
     * <a>RollbackInstanceRefresh</a> API to roll back instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelInstanceRefreshRequest.Builder} avoiding the
     * need to create one manually via {@link CancelInstanceRefreshRequest#builder()}
     * </p>
     *
     * @param cancelInstanceRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelInstanceRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ActiveInstanceRefreshNotFoundException The request failed because an active instance refresh or
     *         rollback for the specified Auto Scaling group was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CancelInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CancelInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelInstanceRefreshResponse> cancelInstanceRefresh(
            Consumer<CancelInstanceRefreshRequest.Builder> cancelInstanceRefreshRequest) {
        return cancelInstanceRefresh(CancelInstanceRefreshRequest.builder().applyMutation(cancelInstanceRefreshRequest).build());
    }

    /**
     * <p>
     * Completes the lifecycle action for the specified token or instance with the specified result.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.</b>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/completing-lifecycle-hooks.html">Complete a lifecycle
     * action</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param completeLifecycleActionRequest
     * @return A Java Future containing the result of the CompleteLifecycleAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CompleteLifecycleAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteLifecycleActionResponse> completeLifecycleAction(
            CompleteLifecycleActionRequest completeLifecycleActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Completes the lifecycle action for the specified token or instance with the specified result.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.</b>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/completing-lifecycle-hooks.html">Complete a lifecycle
     * action</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteLifecycleActionRequest.Builder} avoiding
     * the need to create one manually via {@link CompleteLifecycleActionRequest#builder()}
     * </p>
     *
     * @param completeLifecycleActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CompleteLifecycleAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CompleteLifecycleAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteLifecycleActionResponse> completeLifecycleAction(
            Consumer<CompleteLifecycleActionRequest.Builder> completeLifecycleActionRequest) {
        return completeLifecycleAction(CompleteLifecycleActionRequest.builder().applyMutation(completeLifecycleActionRequest)
                .build());
    }

    /**
     * <p>
     * <b>We strongly recommend using a launch template when calling this operation to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Creates an Auto Scaling group with the specified name and attributes.
     * </p>
     * <p>
     * If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you're new to Amazon EC2 Auto Scaling, see the introductory tutorials in <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/get-started-with-ec2-auto-scaling.html">Get started
     * with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Every Auto Scaling group has three size properties (<code>DesiredCapacity</code>, <code>MaxSize</code>, and
     * <code>MinSize</code>). Usually, you set these sizes based on a specific number of instances. However, if you
     * configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with
     * the same units that you use for weighting instances.
     * </p>
     *
     * @param createAutoScalingGroupRequest
     * @return A Java Future containing the result of the CreateAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutoScalingGroupResponse> createAutoScalingGroup(
            CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>We strongly recommend using a launch template when calling this operation to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Creates an Auto Scaling group with the specified name and attributes.
     * </p>
     * <p>
     * If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you're new to Amazon EC2 Auto Scaling, see the introductory tutorials in <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/get-started-with-ec2-auto-scaling.html">Get started
     * with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Every Auto Scaling group has three size properties (<code>DesiredCapacity</code>, <code>MaxSize</code>, and
     * <code>MinSize</code>). Usually, you set these sizes based on a specific number of instances. However, if you
     * configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with
     * the same units that you use for weighting instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutoScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param createAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAutoScalingGroupResponse> createAutoScalingGroup(
            Consumer<CreateAutoScalingGroupRequest.Builder> createAutoScalingGroupRequest) {
        return createAutoScalingGroup(CreateAutoScalingGroupRequest.builder().applyMutation(createAutoScalingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a launch configuration.
     * </p>
     * <p>
     * If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html">Launch configurations</a>
     * in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a launch
     * template or a launch configuration. We strongly recommend that you do not use launch configurations. They do not
     * provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For information about using launch
     * templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch
     * templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * </note>
     *
     * @param createLaunchConfigurationRequest
     * @return A Java Future containing the result of the CreateLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLaunchConfigurationResponse> createLaunchConfiguration(
            CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a launch configuration.
     * </p>
     * <p>
     * If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the
     * <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html">Launch configurations</a>
     * in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a launch
     * template or a launch configuration. We strongly recommend that you do not use launch configurations. They do not
     * provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For information about using launch
     * templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch
     * templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param createLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLaunchConfigurationResponse> createLaunchConfiguration(
            Consumer<CreateLaunchConfigurationRequest.Builder> createLaunchConfigurationRequest) {
        return createLaunchConfiguration(CreateLaunchConfigurationRequest.builder()
                .applyMutation(createLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates tags for the specified Auto Scaling group.
     * </p>
     * <p>
     * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and
     * you do not get an error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param createOrUpdateTagsRequest
     * @return A Java Future containing the result of the CreateOrUpdateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateOrUpdateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOrUpdateTagsResponse> createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates tags for the specified Auto Scaling group.
     * </p>
     * <p>
     * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and
     * you do not get an error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrUpdateTagsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOrUpdateTagsRequest#builder()}
     * </p>
     *
     * @param createOrUpdateTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateOrUpdateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateOrUpdateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOrUpdateTagsResponse> createOrUpdateTags(
            Consumer<CreateOrUpdateTagsRequest.Builder> createOrUpdateTagsRequest) {
        return createOrUpdateTags(CreateOrUpdateTagsRequest.builder().applyMutation(createOrUpdateTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling group.
     * </p>
     * <p>
     * If the group has instances or scaling activities in progress, you must specify the option to force the deletion
     * in order for it to succeed. The force delete operation will also terminate the EC2 instances. If the group has a
     * warm pool, the force delete option also deletes the warm pool.
     * </p>
     * <p>
     * To remove instances from the Auto Scaling group before deleting it, call the <a>DetachInstances</a> API with the
     * list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling
     * does not launch replacement instances.
     * </p>
     * <p>
     * To terminate all instances before deleting the Auto Scaling group, call the <a>UpdateAutoScalingGroup</a> API and
     * set the minimum size and desired capacity of the Auto Scaling group to zero.
     * </p>
     * <p>
     * If the group has scaling policies, deleting the group deletes the policies, the underlying alarm actions, and any
     * alarm that no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html">Delete your Auto Scaling
     * infrastructure</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param deleteAutoScalingGroupRequest
     * @return A Java Future containing the result of the DeleteAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutoScalingGroupResponse> deleteAutoScalingGroup(
            DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling group.
     * </p>
     * <p>
     * If the group has instances or scaling activities in progress, you must specify the option to force the deletion
     * in order for it to succeed. The force delete operation will also terminate the EC2 instances. If the group has a
     * warm pool, the force delete option also deletes the warm pool.
     * </p>
     * <p>
     * To remove instances from the Auto Scaling group before deleting it, call the <a>DetachInstances</a> API with the
     * list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling
     * does not launch replacement instances.
     * </p>
     * <p>
     * To terminate all instances before deleting the Auto Scaling group, call the <a>UpdateAutoScalingGroup</a> API and
     * set the minimum size and desired capacity of the Auto Scaling group to zero.
     * </p>
     * <p>
     * If the group has scaling policies, deleting the group deletes the policies, the underlying alarm actions, and any
     * alarm that no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html">Delete your Auto Scaling
     * infrastructure</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAutoScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param deleteAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAutoScalingGroupResponse> deleteAutoScalingGroup(
            Consumer<DeleteAutoScalingGroupRequest.Builder> deleteAutoScalingGroupRequest) {
        return deleteAutoScalingGroup(DeleteAutoScalingGroupRequest.builder().applyMutation(deleteAutoScalingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified launch configuration.
     * </p>
     * <p>
     * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch
     * configuration is no longer available for use.
     * </p>
     *
     * @param deleteLaunchConfigurationRequest
     * @return A Java Future containing the result of the DeleteLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchConfigurationResponse> deleteLaunchConfiguration(
            DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified launch configuration.
     * </p>
     * <p>
     * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch
     * configuration is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchConfigurationResponse> deleteLaunchConfiguration(
            Consumer<DeleteLaunchConfigurationRequest.Builder> deleteLaunchConfigurationRequest) {
        return deleteLaunchConfiguration(DeleteLaunchConfigurationRequest.builder()
                .applyMutation(deleteLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified lifecycle hook.
     * </p>
     * <p>
     * If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching
     * instances, <code>CONTINUE</code> for terminating instances).
     * </p>
     *
     * @param deleteLifecycleHookRequest
     * @return A Java Future containing the result of the DeleteLifecycleHook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLifecycleHookResponse> deleteLifecycleHook(
            DeleteLifecycleHookRequest deleteLifecycleHookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified lifecycle hook.
     * </p>
     * <p>
     * If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching
     * instances, <code>CONTINUE</code> for terminating instances).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLifecycleHookRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLifecycleHookRequest#builder()}
     * </p>
     *
     * @param deleteLifecycleHookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLifecycleHook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLifecycleHookResponse> deleteLifecycleHook(
            Consumer<DeleteLifecycleHookRequest.Builder> deleteLifecycleHookRequest) {
        return deleteLifecycleHook(DeleteLifecycleHookRequest.builder().applyMutation(deleteLifecycleHookRequest).build());
    }

    /**
     * <p>
     * Deletes the specified notification.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return A Java Future containing the result of the DeleteNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(
            Consumer<DeleteNotificationConfigurationRequest.Builder> deleteNotificationConfigurationRequest) {
        return deleteNotificationConfiguration(DeleteNotificationConfigurationRequest.builder()
                .applyMutation(deleteNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scaling policy.
     * </p>
     * <p>
     * Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does
     * not delete the alarm, even if it no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html">Delete a scaling
     * policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param deletePolicyRequest
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scaling policy.
     * </p>
     * <p>
     * Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does
     * not delete the alarm, even if it no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html">Delete a scaling
     * policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest) {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scheduled action.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            DeleteScheduledActionRequest deleteScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scheduled action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduledActionRequest#builder()}
     * </p>
     *
     * @param deleteScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            Consumer<DeleteScheduledActionRequest.Builder> deleteScheduledActionRequest) {
        return deleteScheduledAction(DeleteScheduledActionRequest.builder().applyMutation(deleteScheduledActionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the warm pool for the specified Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param deleteWarmPoolRequest
     * @return A Java Future containing the result of the DeleteWarmPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWarmPoolResponse> deleteWarmPool(DeleteWarmPoolRequest deleteWarmPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the warm pool for the specified Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWarmPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWarmPoolRequest#builder()}
     * </p>
     *
     * @param deleteWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWarmPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWarmPoolResponse> deleteWarmPool(Consumer<DeleteWarmPoolRequest.Builder> deleteWarmPoolRequest) {
        return deleteWarmPool(DeleteWarmPoolRequest.builder().applyMutation(deleteWarmPoolRequest).build());
    }

    /**
     * <p>
     * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto
     * Scaling groups and launch configurations that you can create in a given Region. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto
     * Scaling groups and launch configurations that you can create in a given Region. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto
     * Scaling groups and launch configurations that you can create in a given Region. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html">Quotas for Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits() {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available adjustment types for step scaling and simple scaling policies.
     * </p>
     * <p>
     * The following adjustment types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChangeInCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExactCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PercentChangeInCapacity</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAdjustmentTypesRequest
     * @return A Java Future containing the result of the DescribeAdjustmentTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAdjustmentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAdjustmentTypesResponse> describeAdjustmentTypes(
            DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available adjustment types for step scaling and simple scaling policies.
     * </p>
     * <p>
     * The following adjustment types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChangeInCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExactCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PercentChangeInCapacity</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAdjustmentTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAdjustmentTypesRequest#builder()}
     * </p>
     *
     * @param describeAdjustmentTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeAdjustmentTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAdjustmentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAdjustmentTypesResponse> describeAdjustmentTypes(
            Consumer<DescribeAdjustmentTypesRequest.Builder> describeAdjustmentTypesRequest) {
        return describeAdjustmentTypes(DescribeAdjustmentTypesRequest.builder().applyMutation(describeAdjustmentTypesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the available adjustment types for step scaling and simple scaling policies.
     * </p>
     * <p>
     * The following adjustment types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChangeInCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExactCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PercentChangeInCapacity</code>
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeAdjustmentTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAdjustmentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAdjustmentTypesResponse> describeAdjustmentTypes() {
        return describeAdjustmentTypes(DescribeAdjustmentTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling groups in the account and Region.
     * </p>
     * <p>
     * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling
     * groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the
     * filter criteria. If you do not specify group names or filters, the output includes information for all Auto
     * Scaling groups.
     * </p>
     * <p>
     * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the
     * instances in a warm pool, you must call the <a>DescribeWarmPool</a> API.
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     * @return A Java Future containing the result of the DescribeAutoScalingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingGroupsResponse> describeAutoScalingGroups(
            DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Auto Scaling groups in the account and Region.
     * </p>
     * <p>
     * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling
     * groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the
     * filter criteria. If you do not specify group names or filters, the output includes information for all Auto
     * Scaling groups.
     * </p>
     * <p>
     * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the
     * instances in a warm pool, you must call the <a>DescribeWarmPool</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAutoScalingGroupsRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAutoScalingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingGroupsResponse> describeAutoScalingGroups(
            Consumer<DescribeAutoScalingGroupsRequest.Builder> describeAutoScalingGroupsRequest) {
        return describeAutoScalingGroups(DescribeAutoScalingGroupsRequest.builder()
                .applyMutation(describeAutoScalingGroupsRequest).build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling groups in the account and Region.
     * </p>
     * <p>
     * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling
     * groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the
     * filter criteria. If you do not specify group names or filters, the output includes information for all Auto
     * Scaling groups.
     * </p>
     * <p>
     * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the
     * instances in a warm pool, you must call the <a>DescribeWarmPool</a> API.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAutoScalingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingGroupsResponse> describeAutoScalingGroups() {
        return describeAutoScalingGroups(DescribeAutoScalingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsPublisher describeAutoScalingGroupsPaginator() {
        return describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsPublisher describeAutoScalingGroupsPaginator(
            DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return new DescribeAutoScalingGroupsPublisher(this, describeAutoScalingGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAutoScalingGroupsRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsPublisher describeAutoScalingGroupsPaginator(
            Consumer<DescribeAutoScalingGroupsRequest.Builder> describeAutoScalingGroupsRequest) {
        return describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest.builder()
                .applyMutation(describeAutoScalingGroupsRequest).build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling instances in the account and Region.
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     * @return A Java Future containing the result of the DescribeAutoScalingInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingInstancesResponse> describeAutoScalingInstances(
            DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Auto Scaling instances in the account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutoScalingInstancesRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAutoScalingInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingInstancesResponse> describeAutoScalingInstances(
            Consumer<DescribeAutoScalingInstancesRequest.Builder> describeAutoScalingInstancesRequest) {
        return describeAutoScalingInstances(DescribeAutoScalingInstancesRequest.builder()
                .applyMutation(describeAutoScalingInstancesRequest).build());
    }

    /**
     * <p>
     * Gets information about the Auto Scaling instances in the account and Region.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAutoScalingInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingInstancesResponse> describeAutoScalingInstances() {
        return describeAutoScalingInstances(DescribeAutoScalingInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesPublisher describeAutoScalingInstancesPaginator() {
        return describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesPublisher describeAutoScalingInstancesPaginator(
            DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        return new DescribeAutoScalingInstancesPublisher(this, describeAutoScalingInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoScalingInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutoScalingInstancesRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesPublisher describeAutoScalingInstancesPaginator(
            Consumer<DescribeAutoScalingInstancesRequest.Builder> describeAutoScalingInstancesRequest) {
        return describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest.builder()
                .applyMutation(describeAutoScalingInstancesRequest).build());
    }

    /**
     * <p>
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     * </p>
     *
     * @param describeAutoScalingNotificationTypesRequest
     * @return A Java Future containing the result of the DescribeAutoScalingNotificationTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingNotificationTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingNotificationTypesResponse> describeAutoScalingNotificationTypes(
            DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAutoScalingNotificationTypesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAutoScalingNotificationTypesRequest#builder()}
     * </p>
     *
     * @param describeAutoScalingNotificationTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAutoScalingNotificationTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingNotificationTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingNotificationTypesResponse> describeAutoScalingNotificationTypes(
            Consumer<DescribeAutoScalingNotificationTypesRequest.Builder> describeAutoScalingNotificationTypesRequest) {
        return describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest.builder()
                .applyMutation(describeAutoScalingNotificationTypesRequest).build());
    }

    /**
     * <p>
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAutoScalingNotificationTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingNotificationTypes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutoScalingNotificationTypesResponse> describeAutoScalingNotificationTypes() {
        return describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the instance refreshes for the specified Auto Scaling group from the previous six weeks.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * To help you determine the status of an instance refresh, Amazon EC2 Auto Scaling returns information about the
     * instance refreshes you previously initiated, including their status, start time, end time, the percentage of the
     * instance refresh that is complete, and the number of instances remaining to update before the instance refresh is
     * complete. If a rollback is initiated while an instance refresh is in progress, Amazon EC2 Auto Scaling also
     * returns information about the rollback of the instance refresh.
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     * @return A Java Future containing the result of the DescribeInstanceRefreshes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceRefreshesResponse> describeInstanceRefreshes(
            DescribeInstanceRefreshesRequest describeInstanceRefreshesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the instance refreshes for the specified Auto Scaling group from the previous six weeks.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * To help you determine the status of an instance refresh, Amazon EC2 Auto Scaling returns information about the
     * instance refreshes you previously initiated, including their status, start time, end time, the percentage of the
     * instance refresh that is complete, and the number of instances remaining to update before the instance refresh is
     * complete. If a rollback is initiated while an instance refresh is in progress, Amazon EC2 Auto Scaling also
     * returns information about the rollback of the instance refresh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRefreshesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceRefreshesRequest#builder()}
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeInstanceRefreshes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceRefreshesResponse> describeInstanceRefreshes(
            Consumer<DescribeInstanceRefreshesRequest.Builder> describeInstanceRefreshesRequest) {
        return describeInstanceRefreshes(DescribeInstanceRefreshesRequest.builder()
                .applyMutation(describeInstanceRefreshesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesPublisher publisher = client.describeInstanceRefreshesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesPublisher publisher = client.describeInstanceRefreshesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceRefreshesPublisher describeInstanceRefreshesPaginator(
            DescribeInstanceRefreshesRequest describeInstanceRefreshesRequest) {
        return new DescribeInstanceRefreshesPublisher(this, describeInstanceRefreshesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesPublisher publisher = client.describeInstanceRefreshesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeInstanceRefreshesPublisher publisher = client.describeInstanceRefreshesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceRefreshes(software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRefreshesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceRefreshesRequest#builder()}
     * </p>
     *
     * @param describeInstanceRefreshesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeInstanceRefreshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceRefreshesPublisher describeInstanceRefreshesPaginator(
            Consumer<DescribeInstanceRefreshesRequest.Builder> describeInstanceRefreshesRequest) {
        return describeInstanceRefreshesPaginator(DescribeInstanceRefreshesRequest.builder()
                .applyMutation(describeInstanceRefreshesRequest).build());
    }

    /**
     * <p>
     * Gets information about the launch configurations in the account and Region.
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     * @return A Java Future containing the result of the DescribeLaunchConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLaunchConfigurationsResponse> describeLaunchConfigurations(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the launch configurations in the account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLaunchConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLaunchConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeLaunchConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLaunchConfigurationsResponse> describeLaunchConfigurations(
            Consumer<DescribeLaunchConfigurationsRequest.Builder> describeLaunchConfigurationsRequest) {
        return describeLaunchConfigurations(DescribeLaunchConfigurationsRequest.builder()
                .applyMutation(describeLaunchConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the launch configurations in the account and Region.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeLaunchConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLaunchConfigurationsResponse> describeLaunchConfigurations() {
        return describeLaunchConfigurations(DescribeLaunchConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsPublisher describeLaunchConfigurationsPaginator() {
        return describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsPublisher describeLaunchConfigurationsPaginator(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        return new DescribeLaunchConfigurationsPublisher(this, describeLaunchConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLaunchConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLaunchConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsPublisher describeLaunchConfigurationsPaginator(
            Consumer<DescribeLaunchConfigurationsRequest.Builder> describeLaunchConfigurationsRequest) {
        return describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest.builder()
                .applyMutation(describeLaunchConfigurationsRequest).build());
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * <p>
     * The following hook types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATING</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeLifecycleHookTypesRequest
     * @return A Java Future containing the result of the DescribeLifecycleHookTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLifecycleHookTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLifecycleHookTypesResponse> describeLifecycleHookTypes(
            DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * <p>
     * The following hook types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATING</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLifecycleHookTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLifecycleHookTypesRequest#builder()}
     * </p>
     *
     * @param describeLifecycleHookTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeLifecycleHookTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLifecycleHookTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLifecycleHookTypesResponse> describeLifecycleHookTypes(
            Consumer<DescribeLifecycleHookTypesRequest.Builder> describeLifecycleHookTypesRequest) {
        return describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest.builder()
                .applyMutation(describeLifecycleHookTypesRequest).build());
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * <p>
     * The following hook types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATING</code>
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeLifecycleHookTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLifecycleHookTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLifecycleHookTypesResponse> describeLifecycleHookTypes() {
        return describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the lifecycle hooks for the specified Auto Scaling group.
     * </p>
     *
     * @param describeLifecycleHooksRequest
     * @return A Java Future containing the result of the DescribeLifecycleHooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLifecycleHooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLifecycleHooksResponse> describeLifecycleHooks(
            DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the lifecycle hooks for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLifecycleHooksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLifecycleHooksRequest#builder()}
     * </p>
     *
     * @param describeLifecycleHooksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLifecycleHooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLifecycleHooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLifecycleHooksResponse> describeLifecycleHooks(
            Consumer<DescribeLifecycleHooksRequest.Builder> describeLifecycleHooksRequest) {
        return describeLifecycleHooks(DescribeLifecycleHooksRequest.builder().applyMutation(describeLifecycleHooksRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However,
     * we continue to support <code>DescribeLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DescribeLoadBalancerTargetGroups</code> API operation and <code>DescribeTrafficSources</code> on the same
     * Auto Scaling group.
     * </p>
     * </note>
     * <p>
     * Gets information about the Elastic Load Balancing target groups for the specified Auto Scaling group.
     * </p>
     * <p>
     * To determine the attachment status of the target group, use the <code>State</code> element in the response. When
     * you attach a target group to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the target
     * group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to
     * <code>InService</code> after at least one Auto Scaling instance passes the health check. When the target group is
     * in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances that are
     * reported as unhealthy. If no registered instances pass the health checks, the target group doesn't enter the
     * <code>InService</code> state.
     * </p>
     * <p>
     * Target groups also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your target group state is <code>InService</code>, but it is not working properly, check the scaling
     * activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can use this operation to describe target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     * @return A Java Future containing the result of the DescribeLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancerTargetGroupsResponse> describeLoadBalancerTargetGroups(
            DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However,
     * we continue to support <code>DescribeLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DescribeLoadBalancerTargetGroups</code> API operation and <code>DescribeTrafficSources</code> on the same
     * Auto Scaling group.
     * </p>
     * </note>
     * <p>
     * Gets information about the Elastic Load Balancing target groups for the specified Auto Scaling group.
     * </p>
     * <p>
     * To determine the attachment status of the target group, use the <code>State</code> element in the response. When
     * you attach a target group to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the target
     * group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to
     * <code>InService</code> after at least one Auto Scaling instance passes the health check. When the target group is
     * in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances that are
     * reported as unhealthy. If no registered instances pass the health checks, the target group doesn't enter the
     * <code>InService</code> state.
     * </p>
     * <p>
     * Target groups also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your target group state is <code>InService</code>, but it is not working properly, check the scaling
     * activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can use this operation to describe target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancerTargetGroupsResponse> describeLoadBalancerTargetGroups(
            Consumer<DescribeLoadBalancerTargetGroupsRequest.Builder> describeLoadBalancerTargetGroupsRequest) {
        return describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(describeLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsPublisher publisher = client.describeLoadBalancerTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsPublisher publisher = client.describeLoadBalancerTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerTargetGroupsPublisher describeLoadBalancerTargetGroupsPaginator(
            DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) {
        return new DescribeLoadBalancerTargetGroupsPublisher(this, describeLoadBalancerTargetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsPublisher publisher = client.describeLoadBalancerTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancerTargetGroupsPublisher publisher = client.describeLoadBalancerTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancerTargetGroups(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerTargetGroupsPublisher describeLoadBalancerTargetGroupsPaginator(
            Consumer<DescribeLoadBalancerTargetGroupsRequest.Builder> describeLoadBalancerTargetGroupsRequest) {
        return describeLoadBalancerTargetGroupsPaginator(DescribeLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(describeLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DescribeTrafficSources</code> to simplify how you manage traffic sources.
     * However, we continue to support <code>DescribeLoadBalancers</code>. You can use both the original
     * <code>DescribeLoadBalancers</code> API operation and <code>DescribeTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Gets information about the load balancers for the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation describes only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DescribeLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * To determine the attachment status of the load balancer, use the <code>State</code> element in the response. When
     * you attach a load balancer to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the load
     * balancer. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions
     * to <code>InService</code> after at least one Auto Scaling instance passes the health check. When the load
     * balancer is in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances
     * that are reported as unhealthy. If no registered instances pass the health checks, the load balancer doesn't
     * enter the <code>InService</code> state.
     * </p>
     * <p>
     * Load balancers also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your load balancer state is <code>InService</code>, but it is not working properly, check the
     * scaling activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(
            DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DescribeTrafficSources</a>, which can describe multiple traffic sources
     * types. We recommend using <code>DescribeTrafficSources</code> to simplify how you manage traffic sources.
     * However, we continue to support <code>DescribeLoadBalancers</code>. You can use both the original
     * <code>DescribeLoadBalancers</code> API operation and <code>DescribeTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Gets information about the load balancers for the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation describes only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DescribeLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * To determine the attachment status of the load balancer, use the <code>State</code> element in the response. When
     * you attach a load balancer to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>.
     * The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the load
     * balancer. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions
     * to <code>InService</code> after at least one Auto Scaling instance passes the health check. When the load
     * balancer is in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances
     * that are reported as unhealthy. If no registered instances pass the health checks, the load balancer doesn't
     * enter the <code>InService</code> state.
     * </p>
     * <p>
     * Load balancers also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a>
     * API call. If your load balancer state is <code>InService</code>, but it is not working properly, check the
     * scaling activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.
     * </p>
     * <p>
     * For help with failed health checks, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2
     * Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) {
        return describeLoadBalancers(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersPublisher describeLoadBalancersPaginator(
            DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return new DescribeLoadBalancersPublisher(this, describeLoadBalancersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersPublisher describeLoadBalancersPaginator(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) {
        return describeLoadBalancersPaginator(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)
                .build());
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     * </p>
     *
     * @param describeMetricCollectionTypesRequest
     * @return A Java Future containing the result of the DescribeMetricCollectionTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeMetricCollectionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetricCollectionTypesResponse> describeMetricCollectionTypes(
            DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetricCollectionTypesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetricCollectionTypesRequest#builder()}
     * </p>
     *
     * @param describeMetricCollectionTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMetricCollectionTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeMetricCollectionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetricCollectionTypesResponse> describeMetricCollectionTypes(
            Consumer<DescribeMetricCollectionTypesRequest.Builder> describeMetricCollectionTypesRequest) {
        return describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest.builder()
                .applyMutation(describeMetricCollectionTypesRequest).build());
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeMetricCollectionTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeMetricCollectionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetricCollectionTypesResponse> describeMetricCollectionTypes() {
        return describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     * @return A Java Future containing the result of the DescribeNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotificationConfigurationsResponse> describeNotificationConfigurations(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotificationConfigurationsResponse> describeNotificationConfigurations(
            Consumer<DescribeNotificationConfigurationsRequest.Builder> describeNotificationConfigurationsRequest) {
        return describeNotificationConfigurations(DescribeNotificationConfigurationsRequest.builder()
                .applyMutation(describeNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotificationConfigurationsResponse> describeNotificationConfigurations() {
        return describeNotificationConfigurations(DescribeNotificationConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsPublisher describeNotificationConfigurationsPaginator() {
        return describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsPublisher describeNotificationConfigurationsPaginator(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        return new DescribeNotificationConfigurationsPublisher(this, describeNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsPublisher describeNotificationConfigurationsPaginator(
            Consumer<DescribeNotificationConfigurationsRequest.Builder> describeNotificationConfigurationsRequest) {
        return describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest.builder()
                .applyMutation(describeNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling policies in the account and Region.
     * </p>
     *
     * @param describePoliciesRequest
     * @return A Java Future containing the result of the DescribePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePoliciesResponse> describePolicies(DescribePoliciesRequest describePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scaling policies in the account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePoliciesRequest#builder()}
     * </p>
     *
     * @param describePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePoliciesResponse> describePolicies(
            Consumer<DescribePoliciesRequest.Builder> describePoliciesRequest) {
        return describePolicies(DescribePoliciesRequest.builder().applyMutation(describePoliciesRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling policies in the account and Region.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePoliciesResponse> describePolicies() {
        return describePolicies(DescribePoliciesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesPublisher describePoliciesPaginator() {
        return describePoliciesPaginator(DescribePoliciesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesPublisher describePoliciesPaginator(DescribePoliciesRequest describePoliciesRequest) {
        return new DescribePoliciesPublisher(this, describePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePoliciesRequest#builder()}
     * </p>
     *
     * @param describePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesPublisher describePoliciesPaginator(Consumer<DescribePoliciesRequest.Builder> describePoliciesRequest) {
        return describePoliciesPaginator(DescribePoliciesRequest.builder().applyMutation(describePoliciesRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling activities in the account and Region.
     * </p>
     * <p>
     * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html">Verify a scaling
     * activity for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the scaling event succeeds, the value of the <code>StatusCode</code> element in the response is
     * <code>Successful</code>. If an attempt to launch instances failed, the <code>StatusCode</code> value is
     * <code>Failed</code> or <code>Cancelled</code> and the <code>StatusMessage</code> element in the response
     * indicates the cause of the failure. For help interpreting the <code>StatusMessage</code>, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html">Troubleshooting Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return A Java Future containing the result of the DescribeScalingActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scaling activities in the account and Region.
     * </p>
     * <p>
     * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html">Verify a scaling
     * activity for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the scaling event succeeds, the value of the <code>StatusCode</code> element in the response is
     * <code>Successful</code>. If an attempt to launch instances failed, the <code>StatusCode</code> value is
     * <code>Failed</code> or <code>Cancelled</code> and the <code>StatusMessage</code> element in the response
     * indicates the cause of the failure. For help interpreting the <code>StatusMessage</code>, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html">Troubleshooting Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingActivitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingActivitiesRequest#builder()}
     * </p>
     *
     * @param describeScalingActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeScalingActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities(
            Consumer<DescribeScalingActivitiesRequest.Builder> describeScalingActivitiesRequest) {
        return describeScalingActivities(DescribeScalingActivitiesRequest.builder()
                .applyMutation(describeScalingActivitiesRequest).build());
    }

    /**
     * <p>
     * Gets information about the scaling activities in the account and Region.
     * </p>
     * <p>
     * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html">Verify a scaling
     * activity for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the scaling event succeeds, the value of the <code>StatusCode</code> element in the response is
     * <code>Successful</code>. If an attempt to launch instances failed, the <code>StatusCode</code> value is
     * <code>Failed</code> or <code>Cancelled</code> and the <code>StatusMessage</code> element in the response
     * indicates the cause of the failure. For help interpreting the <code>StatusMessage</code>, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html">Troubleshooting Amazon EC2
     * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeScalingActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities() {
        return describeScalingActivities(DescribeScalingActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesPublisher describeScalingActivitiesPaginator() {
        return describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesPublisher describeScalingActivitiesPaginator(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        return new DescribeScalingActivitiesPublisher(this, describeScalingActivitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingActivitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingActivitiesRequest#builder()}
     * </p>
     *
     * @param describeScalingActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesPublisher describeScalingActivitiesPaginator(
            Consumer<DescribeScalingActivitiesRequest.Builder> describeScalingActivitiesRequest) {
        return describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest.builder()
                .applyMutation(describeScalingActivitiesRequest).build());
    }

    /**
     * <p>
     * Describes the scaling process types for use with the <a>ResumeProcesses</a> and <a>SuspendProcesses</a> APIs.
     * </p>
     *
     * @param describeScalingProcessTypesRequest
     * @return A Java Future containing the result of the DescribeScalingProcessTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingProcessTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingProcessTypesResponse> describeScalingProcessTypes(
            DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the scaling process types for use with the <a>ResumeProcesses</a> and <a>SuspendProcesses</a> APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingProcessTypesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeScalingProcessTypesRequest#builder()}
     * </p>
     *
     * @param describeScalingProcessTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeScalingProcessTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingProcessTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingProcessTypesResponse> describeScalingProcessTypes(
            Consumer<DescribeScalingProcessTypesRequest.Builder> describeScalingProcessTypesRequest) {
        return describeScalingProcessTypes(DescribeScalingProcessTypesRequest.builder()
                .applyMutation(describeScalingProcessTypesRequest).build());
    }

    /**
     * <p>
     * Describes the scaling process types for use with the <a>ResumeProcesses</a> and <a>SuspendProcesses</a> APIs.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeScalingProcessTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingProcessTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingProcessTypesResponse> describeScalingProcessTypes() {
        return describeScalingProcessTypes(DescribeScalingProcessTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the scheduled actions that haven't run or that have not reached their end time.
     * </p>
     * <p>
     * To describe the scaling activities for scheduled actions that have already run, call the
     * <a>DescribeScalingActivities</a> API.
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scheduled actions that haven't run or that have not reached their end time.
     * </p>
     * <p>
     * To describe the scaling activities for scheduled actions that have already run, call the
     * <a>DescribeScalingActivities</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) {
        return describeScheduledActions(DescribeScheduledActionsRequest.builder().applyMutation(describeScheduledActionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the scheduled actions that haven't run or that have not reached their end time.
     * </p>
     * <p>
     * To describe the scaling activities for scheduled actions that have already run, call the
     * <a>DescribeScalingActivities</a> API.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions() {
        return describeScheduledActions(DescribeScheduledActionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsPublisher describeScheduledActionsPaginator() {
        return describeScheduledActionsPaginator(DescribeScheduledActionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsPublisher describeScheduledActionsPaginator(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        return new DescribeScheduledActionsPublisher(this, describeScheduledActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsPublisher describeScheduledActionsPaginator(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) {
        return describeScheduledActionsPaginator(DescribeScheduledActionsRequest.builder()
                .applyMutation(describeScheduledActionsRequest).build());
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags() {
        return describeTags(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsPublisher describeTagsPaginator() {
        return describeTagsPaginator(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @param describeTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsPublisher describeTagsPaginator(DescribeTagsRequest describeTagsRequest) {
        return new DescribeTagsPublisher(this, describeTagsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsPublisher describeTagsPaginator(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTagsPaginator(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Configure
     * termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeTerminationPolicyTypesRequest
     * @return A Java Future containing the result of the DescribeTerminationPolicyTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTerminationPolicyTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTerminationPolicyTypesResponse> describeTerminationPolicyTypes(
            DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Configure
     * termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTerminationPolicyTypesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTerminationPolicyTypesRequest#builder()}
     * </p>
     *
     * @param describeTerminationPolicyTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTerminationPolicyTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTerminationPolicyTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTerminationPolicyTypesResponse> describeTerminationPolicyTypes(
            Consumer<DescribeTerminationPolicyTypesRequest.Builder> describeTerminationPolicyTypesRequest) {
        return describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest.builder()
                .applyMutation(describeTerminationPolicyTypesRequest).build());
    }

    /**
     * <p>
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Configure
     * termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTerminationPolicyTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTerminationPolicyTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTerminationPolicyTypesResponse> describeTerminationPolicyTypes() {
        return describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the traffic sources for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can optionally provide a traffic source type. If you provide a traffic source type, then the results only
     * include that traffic source type.
     * </p>
     * <p>
     * If you do not provide a traffic source type, then the results include all the traffic sources for the specified
     * Auto Scaling group.
     * </p>
     *
     * @param describeTrafficSourcesRequest
     * @return A Java Future containing the result of the DescribeTrafficSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrafficSourcesResponse> describeTrafficSources(
            DescribeTrafficSourcesRequest describeTrafficSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the traffic sources for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can optionally provide a traffic source type. If you provide a traffic source type, then the results only
     * include that traffic source type.
     * </p>
     * <p>
     * If you do not provide a traffic source type, then the results include all the traffic sources for the specified
     * Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param describeTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeTrafficSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrafficSourcesResponse> describeTrafficSources(
            Consumer<DescribeTrafficSourcesRequest.Builder> describeTrafficSourcesRequest) {
        return describeTrafficSources(DescribeTrafficSourcesRequest.builder().applyMutation(describeTrafficSourcesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesPublisher publisher = client.describeTrafficSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesPublisher publisher = client.describeTrafficSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTrafficSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficSourcesPublisher describeTrafficSourcesPaginator(
            DescribeTrafficSourcesRequest describeTrafficSourcesRequest) {
        return new DescribeTrafficSourcesPublisher(this, describeTrafficSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesPublisher publisher = client.describeTrafficSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTrafficSourcesPublisher publisher = client.describeTrafficSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrafficSources(software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param describeTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficSourcesPublisher describeTrafficSourcesPaginator(
            Consumer<DescribeTrafficSourcesRequest.Builder> describeTrafficSourcesRequest) {
        return describeTrafficSourcesPaginator(DescribeTrafficSourcesRequest.builder()
                .applyMutation(describeTrafficSourcesRequest).build());
    }

    /**
     * <p>
     * Gets information about a warm pool and its instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeWarmPoolRequest
     * @return A Java Future containing the result of the DescribeWarmPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWarmPoolResponse> describeWarmPool(DescribeWarmPoolRequest describeWarmPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a warm pool and its instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWarmPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWarmPoolRequest#builder()}
     * </p>
     *
     * @param describeWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWarmPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWarmPoolResponse> describeWarmPool(
            Consumer<DescribeWarmPoolRequest.Builder> describeWarmPoolRequest) {
        return describeWarmPool(DescribeWarmPoolRequest.builder().applyMutation(describeWarmPoolRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolPublisher publisher = client.describeWarmPoolPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolPublisher publisher = client.describeWarmPoolPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWarmPoolRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWarmPoolPublisher describeWarmPoolPaginator(DescribeWarmPoolRequest describeWarmPoolRequest) {
        return new DescribeWarmPoolPublisher(this, describeWarmPoolRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolPublisher publisher = client.describeWarmPoolPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeWarmPoolPublisher publisher = client.describeWarmPoolPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWarmPool(software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWarmPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWarmPoolRequest#builder()}
     * </p>
     *
     * @param describeWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWarmPoolPublisher describeWarmPoolPaginator(Consumer<DescribeWarmPoolRequest.Builder> describeWarmPoolRequest) {
        return describeWarmPoolPaginator(DescribeWarmPoolRequest.builder().applyMutation(describeWarmPoolRequest).build());
    }

    /**
     * <p>
     * Removes one or more instances from the specified Auto Scaling group.
     * </p>
     * <p>
     * After the instances are detached, you can manage them independent of the Auto Scaling group.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are detached.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the
     * load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from
     * the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-detach-attach-instances.html">Detach
     * or attach instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param detachInstancesRequest
     * @return A Java Future containing the result of the DetachInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachInstancesResponse> detachInstances(DetachInstancesRequest detachInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more instances from the specified Auto Scaling group.
     * </p>
     * <p>
     * After the instances are detached, you can manage them independent of the Auto Scaling group.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are detached.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the
     * load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from
     * the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-detach-attach-instances.html">Detach
     * or attach instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link DetachInstancesRequest#builder()}
     * </p>
     *
     * @param detachInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetachInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachInstancesResponse> detachInstances(
            Consumer<DetachInstancesRequest.Builder> detachInstancesRequest) {
        return detachInstances(DetachInstancesRequest.builder().applyMutation(detachInstancesRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DetachLoadBalancerTargetGroups</code> API operation and <code>DetachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more target groups from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a target group, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the target group using the
     * <a>DescribeLoadBalancerTargetGroups</a> API call. The instances remain running.
     * </p>
     * <note>
     * <p>
     * You can use this operation to detach target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note>
     *
     * @param detachLoadBalancerTargetGroupsRequest
     * @return A Java Future containing the result of the DetachLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachLoadBalancerTargetGroupsResponse> detachLoadBalancerTargetGroups(
            DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancerTargetGroups</code>. You can use both the original
     * <code>DetachLoadBalancerTargetGroups</code> API operation and <code>DetachTrafficSources</code> on the same Auto
     * Scaling group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more target groups from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a target group, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the target group using the
     * <a>DescribeLoadBalancerTargetGroups</a> API call. The instances remain running.
     * </p>
     * <note>
     * <p>
     * You can use this operation to detach target groups that were attached by using
     * <a>AttachLoadBalancerTargetGroups</a>, but not for target groups that were attached by using
     * <a>AttachTrafficSources</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachLoadBalancerTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DetachLoadBalancerTargetGroupsRequest#builder()}
     * </p>
     *
     * @param detachLoadBalancerTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DetachLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachLoadBalancerTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachLoadBalancerTargetGroupsResponse> detachLoadBalancerTargetGroups(
            Consumer<DetachLoadBalancerTargetGroupsRequest.Builder> detachLoadBalancerTargetGroupsRequest) {
        return detachLoadBalancerTargetGroups(DetachLoadBalancerTargetGroupsRequest.builder()
                .applyMutation(detachLoadBalancerTargetGroupsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancers</code>. You can use both the original
     * <code>DetachLoadBalancers</code> API operation and <code>DetachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation detaches only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DetachLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the load balancer using the
     * <a>DescribeLoadBalancers</a> API call. The instances remain running.
     * </p>
     *
     * @param detachLoadBalancersRequest
     * @return A Java Future containing the result of the DetachLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachLoadBalancersResponse> detachLoadBalancers(
            DetachLoadBalancersRequest detachLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API operation is superseded by <a>DetachTrafficSources</a>, which can detach multiple traffic sources types.
     * We recommend using <code>DetachTrafficSources</code> to simplify how you manage traffic sources. However, we
     * continue to support <code>DetachLoadBalancers</code>. You can use both the original
     * <code>DetachLoadBalancers</code> API operation and <code>DetachTrafficSources</code> on the same Auto Scaling
     * group.
     * </p>
     * </note>
     * <p>
     * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation detaches only Classic Load Balancers. If you have Application Load Balancers, Network Load
     * Balancers, or Gateway Load Balancers, use the <a>DetachLoadBalancerTargetGroups</a> API instead.
     * </p>
     * <p>
     * When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the load balancer using the
     * <a>DescribeLoadBalancers</a> API call. The instances remain running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DetachLoadBalancersRequest#builder()}
     * </p>
     *
     * @param detachLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetachLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachLoadBalancersResponse> detachLoadBalancers(
            Consumer<DetachLoadBalancersRequest.Builder> detachLoadBalancersRequest) {
        return detachLoadBalancers(DetachLoadBalancersRequest.builder().applyMutation(detachLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Detaches one or more traffic sources from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a traffic source, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the traffic source using the
     * <a>DescribeTrafficSources</a> API call. The instances continue to run.
     * </p>
     *
     * @param detachTrafficSourcesRequest
     * @return A Java Future containing the result of the DetachTrafficSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachTrafficSourcesResponse> detachTrafficSources(
            DetachTrafficSourcesRequest detachTrafficSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches one or more traffic sources from the specified Auto Scaling group.
     * </p>
     * <p>
     * When you detach a traffic source, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the traffic source using the
     * <a>DescribeTrafficSources</a> API call. The instances continue to run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachTrafficSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DetachTrafficSourcesRequest#builder()}
     * </p>
     *
     * @param detachTrafficSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetachTrafficSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachTrafficSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachTrafficSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachTrafficSourcesResponse> detachTrafficSources(
            Consumer<DetachTrafficSourcesRequest.Builder> detachTrafficSourcesRequest) {
        return detachTrafficSources(DetachTrafficSourcesRequest.builder().applyMutation(detachTrafficSourcesRequest).build());
    }

    /**
     * <p>
     * Disables group metrics collection for the specified Auto Scaling group.
     * </p>
     *
     * @param disableMetricsCollectionRequest
     * @return A Java Future containing the result of the DisableMetricsCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DisableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableMetricsCollectionResponse> disableMetricsCollection(
            DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables group metrics collection for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableMetricsCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link DisableMetricsCollectionRequest#builder()}
     * </p>
     *
     * @param disableMetricsCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableMetricsCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DisableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableMetricsCollectionResponse> disableMetricsCollection(
            Consumer<DisableMetricsCollectionRequest.Builder> disableMetricsCollectionRequest) {
        return disableMetricsCollection(DisableMetricsCollectionRequest.builder().applyMutation(disableMetricsCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Enables group metrics collection for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use these metrics to track changes in an Auto Scaling group and to set alarms on threshold values. You
     * can view group metrics using the Amazon EC2 Auto Scaling console or the CloudWatch console. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html">
     * Monitor CloudWatch metrics for your Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     *
     * @param enableMetricsCollectionRequest
     * @return A Java Future containing the result of the EnableMetricsCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.EnableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableMetricsCollectionResponse> enableMetricsCollection(
            EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables group metrics collection for the specified Auto Scaling group.
     * </p>
     * <p>
     * You can use these metrics to track changes in an Auto Scaling group and to set alarms on threshold values. You
     * can view group metrics using the Amazon EC2 Auto Scaling console or the CloudWatch console. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html">
     * Monitor CloudWatch metrics for your Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableMetricsCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link EnableMetricsCollectionRequest#builder()}
     * </p>
     *
     * @param enableMetricsCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the EnableMetricsCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.EnableMetricsCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableMetricsCollectionResponse> enableMetricsCollection(
            Consumer<EnableMetricsCollectionRequest.Builder> enableMetricsCollectionRequest) {
        return enableMetricsCollection(EnableMetricsCollectionRequest.builder().applyMutation(enableMetricsCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Moves the specified instances into the standby state.
     * </p>
     * <p>
     * If you choose to decrement the desired capacity of the Auto Scaling group, the instances can enter standby as
     * long as the desired capacity of the Auto Scaling group after the instances are placed into standby is equal to or
     * greater than the minimum capacity of the group.
     * </p>
     * <p>
     * If you choose not to decrement the desired capacity of the Auto Scaling group, the Auto Scaling group launches
     * new instances to replace the instances on standby.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param enterStandbyRequest
     * @return A Java Future containing the result of the EnterStandby operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.EnterStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnterStandbyResponse> enterStandby(EnterStandbyRequest enterStandbyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified instances into the standby state.
     * </p>
     * <p>
     * If you choose to decrement the desired capacity of the Auto Scaling group, the instances can enter standby as
     * long as the desired capacity of the Auto Scaling group after the instances are placed into standby is equal to or
     * greater than the minimum capacity of the group.
     * </p>
     * <p>
     * If you choose not to decrement the desired capacity of the Auto Scaling group, the Auto Scaling group launches
     * new instances to replace the instances on standby.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnterStandbyRequest.Builder} avoiding the need to
     * create one manually via {@link EnterStandbyRequest#builder()}
     * </p>
     *
     * @param enterStandbyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnterStandby operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.EnterStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnterStandbyResponse> enterStandby(Consumer<EnterStandbyRequest.Builder> enterStandbyRequest) {
        return enterStandby(EnterStandbyRequest.builder().applyMutation(enterStandbyRequest).build());
    }

    /**
     * <p>
     * Executes the specified policy. This can be useful for testing the design of your scaling policy.
     * </p>
     *
     * @param executePolicyRequest
     * @return A Java Future containing the result of the ExecutePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ExecutePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecutePolicyResponse> executePolicy(ExecutePolicyRequest executePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes the specified policy. This can be useful for testing the design of your scaling policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecutePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link ExecutePolicyRequest#builder()}
     * </p>
     *
     * @param executePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecutePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ExecutePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecutePolicyResponse> executePolicy(Consumer<ExecutePolicyRequest.Builder> executePolicyRequest) {
        return executePolicy(ExecutePolicyRequest.builder().applyMutation(executePolicyRequest).build());
    }

    /**
     * <p>
     * Moves the specified instances out of the standby state.
     * </p>
     * <p>
     * After you put the instances back in service, the desired capacity is incremented.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param exitStandbyRequest
     * @return A Java Future containing the result of the ExitStandby operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ExitStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExitStandbyResponse> exitStandby(ExitStandbyRequest exitStandbyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified instances out of the standby state.
     * </p>
     * <p>
     * After you put the instances back in service, the desired capacity is incremented.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing
     * instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExitStandbyRequest.Builder} avoiding the need to
     * create one manually via {@link ExitStandbyRequest#builder()}
     * </p>
     *
     * @param exitStandbyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExitStandby operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ExitStandby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExitStandbyResponse> exitStandby(Consumer<ExitStandbyRequest.Builder> exitStandbyRequest) {
        return exitStandby(ExitStandbyRequest.builder().applyMutation(exitStandbyRequest).build());
    }

    /**
     * <p>
     * Retrieves the forecast data for a predictive scaling policy.
     * </p>
     * <p>
     * Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an
     * analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity
     * that is needed on an hourly basis, based on the hourly load forecast.
     * </p>
     * <p>
     * A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of
     * historical data results in more accurate forecasts.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param getPredictiveScalingForecastRequest
     * @return A Java Future containing the result of the GetPredictiveScalingForecast operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.GetPredictiveScalingForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/GetPredictiveScalingForecast"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPredictiveScalingForecastResponse> getPredictiveScalingForecast(
            GetPredictiveScalingForecastRequest getPredictiveScalingForecastRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the forecast data for a predictive scaling policy.
     * </p>
     * <p>
     * Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an
     * analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity
     * that is needed on an hourly basis, based on the hourly load forecast.
     * </p>
     * <p>
     * A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of
     * historical data results in more accurate forecasts.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPredictiveScalingForecastRequest.Builder}
     * avoiding the need to create one manually via {@link GetPredictiveScalingForecastRequest#builder()}
     * </p>
     *
     * @param getPredictiveScalingForecastRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPredictiveScalingForecast operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.GetPredictiveScalingForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/GetPredictiveScalingForecast"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPredictiveScalingForecastResponse> getPredictiveScalingForecast(
            Consumer<GetPredictiveScalingForecastRequest.Builder> getPredictiveScalingForecastRequest) {
        return getPredictiveScalingForecast(GetPredictiveScalingForecastRequest.builder()
                .applyMutation(getPredictiveScalingForecastRequest).build());
    }

    /**
     * <p>
     * Creates or updates a lifecycle hook for the specified Auto Scaling group.
     * </p>
     * <p>
     * Lifecycle hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and
     * then perform a custom action on instances when the corresponding lifecycle event occurs.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state using the
     * <a>RecordLifecycleActionHeartbeat</a> API call.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call
     * fails.
     * </p>
     * <p>
     * You can view the lifecycle hooks for an Auto Scaling group using the <a>DescribeLifecycleHooks</a> API call. If
     * you are no longer using a lifecycle hook, you can delete it by calling the <a>DeleteLifecycleHook</a> API.
     * </p>
     *
     * @param putLifecycleHookRequest
     * @return A Java Future containing the result of the PutLifecycleHook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLifecycleHookResponse> putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a lifecycle hook for the specified Auto Scaling group.
     * </p>
     * <p>
     * Lifecycle hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and
     * then perform a custom action on instances when the corresponding lifecycle event occurs.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state using the
     * <a>RecordLifecycleActionHeartbeat</a> API call.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call
     * fails.
     * </p>
     * <p>
     * You can view the lifecycle hooks for an Auto Scaling group using the <a>DescribeLifecycleHooks</a> API call. If
     * you are no longer using a lifecycle hook, you can delete it by calling the <a>DeleteLifecycleHook</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLifecycleHookRequest.Builder} avoiding the need
     * to create one manually via {@link PutLifecycleHookRequest#builder()}
     * </p>
     *
     * @param putLifecycleHookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLifecycleHook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutLifecycleHook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLifecycleHookResponse> putLifecycleHook(
            Consumer<PutLifecycleHookRequest.Builder> putLifecycleHookRequest) {
        return putLifecycleHook(PutLifecycleHookRequest.builder().applyMutation(putLifecycleHookRequest).build());
    }

    /**
     * <p>
     * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the
     * specified topic can have messages delivered to an endpoint such as a web server or an email address.
     * </p>
     * <p>
     * This configuration overwrites any existing configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-sns-notifications.html">Amazon SNS
     * notification options for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.
     * </p>
     *
     * @param putNotificationConfigurationRequest
     * @return A Java Future containing the result of the PutNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutNotificationConfigurationResponse> putNotificationConfiguration(
            PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the
     * specified topic can have messages delivered to an endpoint such as a web server or an email address.
     * </p>
     * <p>
     * This configuration overwrites any existing configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-sns-notifications.html">Amazon SNS
     * notification options for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param putNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutNotificationConfigurationResponse> putNotificationConfiguration(
            Consumer<PutNotificationConfigurationRequest.Builder> putNotificationConfigurationRequest) {
        return putNotificationConfiguration(PutNotificationConfigurationRequest.builder()
                .applyMutation(putNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling
     * group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling
     * features are not used.
     * </p>
     * <p>
     * For more information about using dynamic scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
     * scaling policies</a> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
     * policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information about using predictive scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scaling policies for an Auto Scaling group using the <a>DescribePolicies</a> API call. If you
     * are no longer using a scaling policy, you can delete it by calling the <a>DeletePolicy</a> API.
     * </p>
     *
     * @param putScalingPolicyRequest
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling
     * group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling
     * features are not used.
     * </p>
     * <p>
     * For more information about using dynamic scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
     * scaling policies</a> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
     * policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information about using predictive scaling, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive
     * scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scaling policies for an Auto Scaling group using the <a>DescribePolicies</a> API call. If you
     * are no longer using a scaling policy, you can delete it by calling the <a>DeletePolicy</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScalingPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putScalingPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(
            Consumer<PutScalingPolicyRequest.Builder> putScalingPolicyRequest) {
        return putScalingPolicy(PutScalingPolicyRequest.builder().applyMutation(putScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a scheduled scaling action for an Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scheduled-scaling.html">Scheduled
     * scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scheduled actions for an Auto Scaling group using the <a>DescribeScheduledActions</a> API call.
     * If you are no longer using a scheduled action, you can delete it by calling the <a>DeleteScheduledAction</a> API.
     * </p>
     * <p>
     * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
     * </p>
     *
     * @param putScheduledUpdateGroupActionRequest
     * @return A Java Future containing the result of the PutScheduledUpdateGroupAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutScheduledUpdateGroupActionResponse> putScheduledUpdateGroupAction(
            PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scheduled scaling action for an Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scheduled-scaling.html">Scheduled
     * scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * You can view the scheduled actions for an Auto Scaling group using the <a>DescribeScheduledActions</a> API call.
     * If you are no longer using a scheduled action, you can delete it by calling the <a>DeleteScheduledAction</a> API.
     * </p>
     * <p>
     * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScheduledUpdateGroupActionRequest.Builder}
     * avoiding the need to create one manually via {@link PutScheduledUpdateGroupActionRequest#builder()}
     * </p>
     *
     * @param putScheduledUpdateGroupActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutScheduledUpdateGroupAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutScheduledUpdateGroupAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutScheduledUpdateGroupActionResponse> putScheduledUpdateGroupAction(
            Consumer<PutScheduledUpdateGroupActionRequest.Builder> putScheduledUpdateGroupActionRequest) {
        return putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest.builder()
                .applyMutation(putScheduledUpdateGroupActionRequest).build());
    }

    /**
     * <p>
     * Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2
     * instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto
     * Scaling group can draw on the warm pool to meet its new desired capacity.
     * </p>
     * <p>
     * This operation must be called from the Region in which the Auto Scaling group was created.
     * </p>
     * <p>
     * You can view the instances in the warm pool using the <a>DescribeWarmPool</a> API call. If you are no longer
     * using a warm pool, you can delete it by calling the <a>DeleteWarmPool</a> API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param putWarmPoolRequest
     * @return A Java Future containing the result of the PutWarmPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutWarmPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutWarmPoolResponse> putWarmPool(PutWarmPoolRequest putWarmPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2
     * instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto
     * Scaling group can draw on the warm pool to meet its new desired capacity.
     * </p>
     * <p>
     * This operation must be called from the Region in which the Auto Scaling group was created.
     * </p>
     * <p>
     * You can view the instances in the warm pool using the <a>DescribeWarmPool</a> API call. If you are no longer
     * using a warm pool, you can delete it by calling the <a>DeleteWarmPool</a> API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for
     * Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutWarmPoolRequest.Builder} avoiding the need to
     * create one manually via {@link PutWarmPoolRequest#builder()}
     * </p>
     *
     * @param putWarmPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.PutWarmPoolRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutWarmPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutWarmPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutWarmPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutWarmPoolResponse> putWarmPool(Consumer<PutWarmPoolRequest.Builder> putWarmPoolRequest) {
        return putWarmPool(PutWarmPoolRequest.builder().applyMutation(putWarmPoolRequest).build());
    }

    /**
     * <p>
     * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the
     * timeout by the length of time defined using the <a>PutLifecycleHook</a> API call.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param recordLifecycleActionHeartbeatRequest
     * @return A Java Future containing the result of the RecordLifecycleActionHeartbeat operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.RecordLifecycleActionHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecordLifecycleActionHeartbeatResponse> recordLifecycleActionHeartbeat(
            RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the
     * timeout by the length of time defined using the <a>PutLifecycleHook</a> API call.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a launch template or launch configuration with a user data script that runs while an instance
     * is in a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when
     * an instance is put into a wait state due to a lifecycle hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API
     * call.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling
     * lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecordLifecycleActionHeartbeatRequest.Builder}
     * avoiding the need to create one manually via {@link RecordLifecycleActionHeartbeatRequest#builder()}
     * </p>
     *
     * @param recordLifecycleActionHeartbeatRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RecordLifecycleActionHeartbeat operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.RecordLifecycleActionHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecordLifecycleActionHeartbeatResponse> recordLifecycleActionHeartbeat(
            Consumer<RecordLifecycleActionHeartbeatRequest.Builder> recordLifecycleActionHeartbeatRequest) {
        return recordLifecycleActionHeartbeat(RecordLifecycleActionHeartbeatRequest.builder()
                .applyMutation(recordLifecycleActionHeartbeatRequest).build());
    }

    /**
     * <p>
     * Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling
     * group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspend and resume
     * Amazon EC2 Auto Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param resumeProcessesRequest
     * @return A Java Future containing the result of the ResumeProcesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ResumeProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResumeProcessesResponse> resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling
     * group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspend and resume
     * Amazon EC2 Auto Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeProcessesRequest.Builder} avoiding the need
     * to create one manually via {@link ResumeProcessesRequest#builder()}
     * </p>
     *
     * @param resumeProcessesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResumeProcesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ResumeProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResumeProcessesResponse> resumeProcesses(
            Consumer<ResumeProcessesRequest.Builder> resumeProcessesRequest) {
        return resumeProcesses(ResumeProcessesRequest.builder().applyMutation(resumeProcessesRequest).build());
    }

    /**
     * <p>
     * Cancels an instance refresh that is in progress and rolls back any changes that it made. Amazon EC2 Auto Scaling
     * replaces any instances that were replaced during the instance refresh. This restores your Auto Scaling group to
     * the configuration that it was using before the start of the instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * A rollback is not supported in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * There is no desired configuration specified for the instance refresh.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead
     * of an AMI ID for the <code>ImageId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group uses the launch template's <code>&#36Latest</code> or <code>&#36Default</code> version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you receive a successful response from this operation, Amazon EC2 Auto Scaling immediately begins replacing
     * instances. You can check the status of this operation through the <a>DescribeInstanceRefreshes</a> API operation.
     * </p>
     *
     * @param rollbackInstanceRefreshRequest
     * @return A Java Future containing the result of the RollbackInstanceRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ActiveInstanceRefreshNotFoundException The request failed because an active instance refresh or
     *         rollback for the specified Auto Scaling group was not found.</li>
     *         <li>IrreversibleInstanceRefreshException The request failed because a desired configuration was not found
     *         or an incompatible launch template (uses a Systems Manager parameter instead of an AMI ID) or launch
     *         template version (<code>&#36Latest</code> or <code>&#36Default</code>) is present on the Auto Scaling
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.RollbackInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RollbackInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RollbackInstanceRefreshResponse> rollbackInstanceRefresh(
            RollbackInstanceRefreshRequest rollbackInstanceRefreshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an instance refresh that is in progress and rolls back any changes that it made. Amazon EC2 Auto Scaling
     * replaces any instances that were replaced during the instance refresh. This restores your Auto Scaling group to
     * the configuration that it was using before the start of the instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you
     * make configuration changes.
     * </p>
     * <p>
     * A rollback is not supported in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * There is no desired configuration specified for the instance refresh.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead
     * of an AMI ID for the <code>ImageId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Auto Scaling group uses the launch template's <code>&#36Latest</code> or <code>&#36Default</code> version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you receive a successful response from this operation, Amazon EC2 Auto Scaling immediately begins replacing
     * instances. You can check the status of this operation through the <a>DescribeInstanceRefreshes</a> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackInstanceRefreshRequest.Builder} avoiding
     * the need to create one manually via {@link RollbackInstanceRefreshRequest#builder()}
     * </p>
     *
     * @param rollbackInstanceRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RollbackInstanceRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ActiveInstanceRefreshNotFoundException The request failed because an active instance refresh or
     *         rollback for the specified Auto Scaling group was not found.</li>
     *         <li>IrreversibleInstanceRefreshException The request failed because a desired configuration was not found
     *         or an incompatible launch template (uses a Systems Manager parameter instead of an AMI ID) or launch
     *         template version (<code>&#36Latest</code> or <code>&#36Default</code>) is present on the Auto Scaling
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.RollbackInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RollbackInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RollbackInstanceRefreshResponse> rollbackInstanceRefresh(
            Consumer<RollbackInstanceRefreshRequest.Builder> rollbackInstanceRefreshRequest) {
        return rollbackInstanceRefresh(RollbackInstanceRefreshRequest.builder().applyMutation(rollbackInstanceRefreshRequest)
                .build());
    }

    /**
     * <p>
     * Sets the size of the specified Auto Scaling group.
     * </p>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-manually.html">Manual
     * scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param setDesiredCapacityRequest
     * @return A Java Future containing the result of the SetDesiredCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetDesiredCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetDesiredCapacityResponse> setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the size of the specified Auto Scaling group.
     * </p>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-manually.html">Manual
     * scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDesiredCapacityRequest.Builder} avoiding the
     * need to create one manually via {@link SetDesiredCapacityRequest#builder()}
     * </p>
     *
     * @param setDesiredCapacityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetDesiredCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetDesiredCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetDesiredCapacityResponse> setDesiredCapacity(
            Consumer<SetDesiredCapacityRequest.Builder> setDesiredCapacityRequest) {
        return setDesiredCapacity(SetDesiredCapacityRequest.builder().applyMutation(setDesiredCapacityRequest).build());
    }

    /**
     * <p>
     * Sets the health status of the specified instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html">Health checks
     * for instances in an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param setInstanceHealthRequest
     * @return A Java Future containing the result of the SetInstanceHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetInstanceHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetInstanceHealthResponse> setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the health status of the specified instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html">Health checks
     * for instances in an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetInstanceHealthRequest.Builder} avoiding the need
     * to create one manually via {@link SetInstanceHealthRequest#builder()}
     * </p>
     *
     * @param setInstanceHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetInstanceHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetInstanceHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetInstanceHealthResponse> setInstanceHealth(
            Consumer<SetInstanceHealthRequest.Builder> setInstanceHealthRequest) {
        return setInstanceHealth(SetInstanceHealthRequest.builder().applyMutation(setInstanceHealthRequest).build());
    }

    /**
     * <p>
     * Updates the instance protection settings of the specified instances. This operation cannot be called on instances
     * in a warm pool.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Use
     * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.
     * </p>
     *
     * @param setInstanceProtectionRequest
     * @return A Java Future containing the result of the SetInstanceProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetInstanceProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetInstanceProtectionResponse> setInstanceProtection(
            SetInstanceProtectionRequest setInstanceProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the instance protection settings of the specified instances. This operation cannot be called on instances
     * in a warm pool.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Use
     * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetInstanceProtectionRequest.Builder} avoiding the
     * need to create one manually via {@link SetInstanceProtectionRequest#builder()}
     * </p>
     *
     * @param setInstanceProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetInstanceProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetInstanceProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetInstanceProtectionResponse> setInstanceProtection(
            Consumer<SetInstanceProtectionRequest.Builder> setInstanceProtectionRequest) {
        return setInstanceProtection(SetInstanceProtectionRequest.builder().applyMutation(setInstanceProtectionRequest).build());
    }

    /**
     * <p>
     * Starts an instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group. This feature
     * is helpful, for example, when you have a new AMI or a new user data script. You just need to create a new launch
     * template that specifies the new AMI or user data script. Then start an instance refresh to immediately begin the
     * process of updating instances in the group.
     * </p>
     * <p>
     * If successful, the request's response contains a unique ID that you can use to track the progress of the instance
     * refresh. To query its status, call the <a>DescribeInstanceRefreshes</a> API. To describe the instance refreshes
     * that have already run, call the <a>DescribeInstanceRefreshes</a> API. To cancel an instance refresh that is in
     * progress, use the <a>CancelInstanceRefresh</a> API.
     * </p>
     * <p>
     * An instance refresh might fail for several reasons, such as EC2 launch failures, misconfigured health checks, or
     * not ignoring or allowing the termination of instances that are in <code>Standby</code> state or protected from
     * scale in. You can monitor for failed EC2 launches using the scaling activities. To find the scaling activities,
     * call the <a>DescribeScalingActivities</a> API.
     * </p>
     * <p>
     * If you enable auto rollback, your Auto Scaling group will be rolled back automatically when the instance refresh
     * fails. You can enable this feature before starting an instance refresh by specifying the
     * <code>AutoRollback</code> property in the instance refresh preferences. Otherwise, to roll back an instance
     * refresh before it finishes, use the <a>RollbackInstanceRefresh</a> API.
     * </p>
     *
     * @param startInstanceRefreshRequest
     * @return A Java Future containing the result of the StartInstanceRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InstanceRefreshInProgressException The request failed because an active instance refresh already
     *         exists for the specified Auto Scaling group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.StartInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/StartInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInstanceRefreshResponse> startInstanceRefresh(
            StartInstanceRefreshRequest startInstanceRefreshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an instance refresh.
     * </p>
     * <p>
     * This operation is part of the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh
     * feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group. This feature
     * is helpful, for example, when you have a new AMI or a new user data script. You just need to create a new launch
     * template that specifies the new AMI or user data script. Then start an instance refresh to immediately begin the
     * process of updating instances in the group.
     * </p>
     * <p>
     * If successful, the request's response contains a unique ID that you can use to track the progress of the instance
     * refresh. To query its status, call the <a>DescribeInstanceRefreshes</a> API. To describe the instance refreshes
     * that have already run, call the <a>DescribeInstanceRefreshes</a> API. To cancel an instance refresh that is in
     * progress, use the <a>CancelInstanceRefresh</a> API.
     * </p>
     * <p>
     * An instance refresh might fail for several reasons, such as EC2 launch failures, misconfigured health checks, or
     * not ignoring or allowing the termination of instances that are in <code>Standby</code> state or protected from
     * scale in. You can monitor for failed EC2 launches using the scaling activities. To find the scaling activities,
     * call the <a>DescribeScalingActivities</a> API.
     * </p>
     * <p>
     * If you enable auto rollback, your Auto Scaling group will be rolled back automatically when the instance refresh
     * fails. You can enable this feature before starting an instance refresh by specifying the
     * <code>AutoRollback</code> property in the instance refresh preferences. Otherwise, to roll back an instance
     * refresh before it finishes, use the <a>RollbackInstanceRefresh</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInstanceRefreshRequest.Builder} avoiding the
     * need to create one manually via {@link StartInstanceRefreshRequest#builder()}
     * </p>
     *
     * @param startInstanceRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartInstanceRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Amazon EC2 Auto Scaling resources
     *         (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">
     *         DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>InstanceRefreshInProgressException The request failed because an active instance refresh already
     *         exists for the specified Auto Scaling group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.StartInstanceRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/StartInstanceRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInstanceRefreshResponse> startInstanceRefresh(
            Consumer<StartInstanceRefreshRequest.Builder> startInstanceRefreshRequest) {
        return startInstanceRefresh(StartInstanceRefreshRequest.builder().applyMutation(startInstanceRefreshRequest).build());
    }

    /**
     * <p>
     * Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.
     * </p>
     * <p>
     * If you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent other
     * process types from functioning properly. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspend and resume
     * Amazon EC2 Auto Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * To resume processes that have been suspended, call the <a>ResumeProcesses</a> API.
     * </p>
     *
     * @param suspendProcessesRequest
     * @return A Java Future containing the result of the SuspendProcesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SuspendProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SuspendProcessesResponse> suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.
     * </p>
     * <p>
     * If you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent other
     * process types from functioning properly. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspend and resume
     * Amazon EC2 Auto Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * To resume processes that have been suspended, call the <a>ResumeProcesses</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SuspendProcessesRequest.Builder} avoiding the need
     * to create one manually via {@link SuspendProcessesRequest#builder()}
     * </p>
     *
     * @param suspendProcessesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SuspendProcesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SuspendProcesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SuspendProcessesResponse> suspendProcesses(
            Consumer<SuspendProcessesRequest.Builder> suspendProcessesRequest) {
        return suspendProcesses(SuspendProcessesRequest.builder().applyMutation(suspendProcessesRequest).build());
    }

    /**
     * <p>
     * Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called
     * on instances in a warm pool.
     * </p>
     * <p>
     * This call simply makes a termination request. The instance is not terminated immediately. When an instance is
     * terminated, the instance status changes to <code>terminated</code>. You can't connect to or start an instance
     * after you've terminated it.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are terminated.
     * </p>
     * <p>
     * By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the
     * desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto
     * Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-manually.html">Manual
     * scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param terminateInstanceInAutoScalingGroupRequest
     * @return A Java Future containing the result of the TerminateInstanceInAutoScalingGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.TerminateInstanceInAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateInstanceInAutoScalingGroupResponse> terminateInstanceInAutoScalingGroup(
            TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called
     * on instances in a warm pool.
     * </p>
     * <p>
     * This call simply makes a termination request. The instance is not terminated immediately. When an instance is
     * terminated, the instance status changes to <code>terminated</code>. You can't connect to or start an instance
     * after you've terminated it.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are terminated.
     * </p>
     * <p>
     * By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the
     * desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto
     * Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-manually.html">Manual
     * scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateInstanceInAutoScalingGroupRequest.Builder}
     * avoiding the need to create one manually via {@link TerminateInstanceInAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param terminateInstanceInAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the TerminateInstanceInAutoScalingGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.TerminateInstanceInAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateInstanceInAutoScalingGroupResponse> terminateInstanceInAutoScalingGroup(
            Consumer<TerminateInstanceInAutoScalingGroupRequest.Builder> terminateInstanceInAutoScalingGroupRequest) {
        return terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest.builder()
                .applyMutation(terminateInstanceInAutoScalingGroupRequest).build());
    }

    /**
     * <p>
     * <b>We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Updates the configuration for the specified Auto Scaling group.
     * </p>
     * <p>
     * To update an Auto Scaling group, specify the name of the group and the property that you want to change. Any
     * properties that you don't specify are not changed by this update request. The new settings take effect on any
     * scaling activities after this call returns.
     * </p>
     * <p>
     * If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get
     * the updated configuration. Existing instances continue to run with the configuration that they were originally
     * launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or
     * template, existing instances may be replaced to match the new purchasing options that you specified in the
     * policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot
     * capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances.
     * When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that
     * updating your group does not compromise the performance or availability of your application.
     * </p>
     * <p>
     * Note the following about changing <code>DesiredCapacity</code>, <code>MaxSize</code>, or <code>MinSize</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MinSize</code> is larger than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MinSize</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MaxSize</code> is smaller than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MaxSize</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To see which properties have been set, call the <a>DescribeAutoScalingGroups</a> API. To view the scaling
     * policies for an Auto Scaling group, call the <a>DescribePolicies</a> API. If the group has scaling policies, you
     * can update them by calling the <a>PutScalingPolicy</a> API.
     * </p>
     *
     * @param updateAutoScalingGroupRequest
     * @return A Java Future containing the result of the UpdateAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.UpdateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutoScalingGroupResponse> updateAutoScalingGroup(
            UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for
     * Amazon EC2 Auto Scaling and Amazon EC2.</b>
     * </p>
     * <p>
     * Updates the configuration for the specified Auto Scaling group.
     * </p>
     * <p>
     * To update an Auto Scaling group, specify the name of the group and the property that you want to change. Any
     * properties that you don't specify are not changed by this update request. The new settings take effect on any
     * scaling activities after this call returns.
     * </p>
     * <p>
     * If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get
     * the updated configuration. Existing instances continue to run with the configuration that they were originally
     * launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or
     * template, existing instances may be replaced to match the new purchasing options that you specified in the
     * policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot
     * capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances.
     * When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that
     * updating your group does not compromise the performance or availability of your application.
     * </p>
     * <p>
     * Note the following about changing <code>DesiredCapacity</code>, <code>MaxSize</code>, or <code>MinSize</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the
     * current size of the group, the Auto Scaling group uses its termination policy to determine which instances to
     * terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MinSize</code> is larger than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MinSize</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MaxSize</code> is smaller than the current size of the group, this sets the group's
     * <code>DesiredCapacity</code> to the new <code>MaxSize</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To see which properties have been set, call the <a>DescribeAutoScalingGroups</a> API. To view the scaling
     * policies for an Auto Scaling group, call the <a>DescribePolicies</a> API. If the group has scaling policies, you
     * can update them by calling the <a>PutScalingPolicy</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAutoScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAutoScalingGroupRequest#builder()}
     * </p>
     *
     * @param updateAutoScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Amazon EC2 Auto Scaling resource
     *         (for example, an Auto Scaling group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.UpdateAutoScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAutoScalingGroupResponse> updateAutoScalingGroup(
            Consumer<UpdateAutoScalingGroupRequest.Builder> updateAutoScalingGroupRequest) {
        return updateAutoScalingGroup(UpdateAutoScalingGroupRequest.builder().applyMutation(updateAutoScalingGroupRequest)
                .build());
    }

    /**
     * Create an instance of {@link AutoScalingAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link AutoScalingAsyncWaiter}
     */
    default AutoScalingAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default AutoScalingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AutoScalingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AutoScalingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AutoScalingAsyncClient}.
     */
    static AutoScalingAsyncClientBuilder builder() {
        return new DefaultAutoScalingAsyncClientBuilder();
    }
}
