/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Availability Zone distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZoneDistribution implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZoneDistribution.Builder, AvailabilityZoneDistribution> {
    private static final SdkField<String> CAPACITY_DISTRIBUTION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityDistributionStrategy")
            .getter(getter(AvailabilityZoneDistribution::capacityDistributionStrategyAsString))
            .setter(setter(Builder::capacityDistributionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityDistributionStrategy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CAPACITY_DISTRIBUTION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CapacityDistributionStrategy", CAPACITY_DISTRIBUTION_STRATEGY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String capacityDistributionStrategy;

    private AvailabilityZoneDistribution(BuilderImpl builder) {
        this.capacityDistributionStrategy = builder.capacityDistributionStrategy;
    }

    /**
     * <p>
     * If launches fail in an Availability Zone, the following strategies are available. The default is
     * <code>balanced-best-effort</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to attempt to
     * launch in the unhealthy zone to preserve a balanced distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will attempt to launch
     * in another healthy Availability Zone instead.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityDistributionStrategy} will return {@link CapacityDistributionStrategy#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityDistributionStrategyAsString}.
     * </p>
     * 
     * @return If launches fail in an Availability Zone, the following strategies are available. The default is
     *         <code>balanced-best-effort</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to
     *         attempt to launch in the unhealthy zone to preserve a balanced distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will attempt
     *         to launch in another healthy Availability Zone instead.
     *         </p>
     *         </li>
     * @see CapacityDistributionStrategy
     */
    public final CapacityDistributionStrategy capacityDistributionStrategy() {
        return CapacityDistributionStrategy.fromValue(capacityDistributionStrategy);
    }

    /**
     * <p>
     * If launches fail in an Availability Zone, the following strategies are available. The default is
     * <code>balanced-best-effort</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to attempt to
     * launch in the unhealthy zone to preserve a balanced distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will attempt to launch
     * in another healthy Availability Zone instead.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityDistributionStrategy} will return {@link CapacityDistributionStrategy#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityDistributionStrategyAsString}.
     * </p>
     * 
     * @return If launches fail in an Availability Zone, the following strategies are available. The default is
     *         <code>balanced-best-effort</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to
     *         attempt to launch in the unhealthy zone to preserve a balanced distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will attempt
     *         to launch in another healthy Availability Zone instead.
     *         </p>
     *         </li>
     * @see CapacityDistributionStrategy
     */
    public final String capacityDistributionStrategyAsString() {
        return capacityDistributionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityDistributionStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZoneDistribution)) {
            return false;
        }
        AvailabilityZoneDistribution other = (AvailabilityZoneDistribution) obj;
        return Objects.equals(capacityDistributionStrategyAsString(), other.capacityDistributionStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailabilityZoneDistribution")
                .add("CapacityDistributionStrategy", capacityDistributionStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityDistributionStrategy":
            return Optional.ofNullable(clazz.cast(capacityDistributionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZoneDistribution, T> g) {
        return obj -> g.apply((AvailabilityZoneDistribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZoneDistribution> {
        /**
         * <p>
         * If launches fail in an Availability Zone, the following strategies are available. The default is
         * <code>balanced-best-effort</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to attempt
         * to launch in the unhealthy zone to preserve a balanced distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will attempt to
         * launch in another healthy Availability Zone instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityDistributionStrategy
         *        If launches fail in an Availability Zone, the following strategies are available. The default is
         *        <code>balanced-best-effort</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to
         *        attempt to launch in the unhealthy zone to preserve a balanced distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will
         *        attempt to launch in another healthy Availability Zone instead.
         *        </p>
         *        </li>
         * @see CapacityDistributionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityDistributionStrategy
         */
        Builder capacityDistributionStrategy(String capacityDistributionStrategy);

        /**
         * <p>
         * If launches fail in an Availability Zone, the following strategies are available. The default is
         * <code>balanced-best-effort</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to attempt
         * to launch in the unhealthy zone to preserve a balanced distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will attempt to
         * launch in another healthy Availability Zone instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityDistributionStrategy
         *        If launches fail in an Availability Zone, the following strategies are available. The default is
         *        <code>balanced-best-effort</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>balanced-only</code> - If launches fail in an Availability Zone, Auto Scaling will continue to
         *        attempt to launch in the unhealthy zone to preserve a balanced distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>balanced-best-effort</code> - If launches fail in an Availability Zone, Auto Scaling will
         *        attempt to launch in another healthy Availability Zone instead.
         *        </p>
         *        </li>
         * @see CapacityDistributionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityDistributionStrategy
         */
        Builder capacityDistributionStrategy(CapacityDistributionStrategy capacityDistributionStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String capacityDistributionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZoneDistribution model) {
            capacityDistributionStrategy(model.capacityDistributionStrategy);
        }

        public final String getCapacityDistributionStrategy() {
            return capacityDistributionStrategy;
        }

        public final void setCapacityDistributionStrategy(String capacityDistributionStrategy) {
            this.capacityDistributionStrategy = capacityDistributionStrategy;
        }

        @Override
        public final Builder capacityDistributionStrategy(String capacityDistributionStrategy) {
            this.capacityDistributionStrategy = capacityDistributionStrategy;
            return this;
        }

        @Override
        public final Builder capacityDistributionStrategy(CapacityDistributionStrategy capacityDistributionStrategy) {
            this.capacityDistributionStrategy(capacityDistributionStrategy == null ? null : capacityDistributionStrategy
                    .toString());
            return this;
        }

        @Override
        public AvailabilityZoneDistribution build() {
            return new AvailabilityZoneDistribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
