/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reports progress on replacing instances in an Auto Scaling group that has a warm pool. This includes separate details
 * for instances in the warm pool and instances in the Auto Scaling group (the live pool).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceRefreshProgressDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceRefreshProgressDetails.Builder, InstanceRefreshProgressDetails> {
    private static final SdkField<InstanceRefreshLivePoolProgress> LIVE_POOL_PROGRESS_FIELD = SdkField
            .<InstanceRefreshLivePoolProgress> builder(MarshallingType.SDK_POJO).memberName("LivePoolProgress")
            .getter(getter(InstanceRefreshProgressDetails::livePoolProgress)).setter(setter(Builder::livePoolProgress))
            .constructor(InstanceRefreshLivePoolProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LivePoolProgress").build()).build();

    private static final SdkField<InstanceRefreshWarmPoolProgress> WARM_POOL_PROGRESS_FIELD = SdkField
            .<InstanceRefreshWarmPoolProgress> builder(MarshallingType.SDK_POJO).memberName("WarmPoolProgress")
            .getter(getter(InstanceRefreshProgressDetails::warmPoolProgress)).setter(setter(Builder::warmPoolProgress))
            .constructor(InstanceRefreshWarmPoolProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolProgress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIVE_POOL_PROGRESS_FIELD,
            WARM_POOL_PROGRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LivePoolProgress", LIVE_POOL_PROGRESS_FIELD);
                    put("WarmPoolProgress", WARM_POOL_PROGRESS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final InstanceRefreshLivePoolProgress livePoolProgress;

    private final InstanceRefreshWarmPoolProgress warmPoolProgress;

    private InstanceRefreshProgressDetails(BuilderImpl builder) {
        this.livePoolProgress = builder.livePoolProgress;
        this.warmPoolProgress = builder.warmPoolProgress;
    }

    /**
     * <p>
     * Reports progress on replacing instances that are in the Auto Scaling group.
     * </p>
     * 
     * @return Reports progress on replacing instances that are in the Auto Scaling group.
     */
    public final InstanceRefreshLivePoolProgress livePoolProgress() {
        return livePoolProgress;
    }

    /**
     * <p>
     * Reports progress on replacing instances that are in the warm pool.
     * </p>
     * 
     * @return Reports progress on replacing instances that are in the warm pool.
     */
    public final InstanceRefreshWarmPoolProgress warmPoolProgress() {
        return warmPoolProgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(livePoolProgress());
        hashCode = 31 * hashCode + Objects.hashCode(warmPoolProgress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRefreshProgressDetails)) {
            return false;
        }
        InstanceRefreshProgressDetails other = (InstanceRefreshProgressDetails) obj;
        return Objects.equals(livePoolProgress(), other.livePoolProgress())
                && Objects.equals(warmPoolProgress(), other.warmPoolProgress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceRefreshProgressDetails").add("LivePoolProgress", livePoolProgress())
                .add("WarmPoolProgress", warmPoolProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LivePoolProgress":
            return Optional.ofNullable(clazz.cast(livePoolProgress()));
        case "WarmPoolProgress":
            return Optional.ofNullable(clazz.cast(warmPoolProgress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRefreshProgressDetails, T> g) {
        return obj -> g.apply((InstanceRefreshProgressDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceRefreshProgressDetails> {
        /**
         * <p>
         * Reports progress on replacing instances that are in the Auto Scaling group.
         * </p>
         * 
         * @param livePoolProgress
         *        Reports progress on replacing instances that are in the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder livePoolProgress(InstanceRefreshLivePoolProgress livePoolProgress);

        /**
         * <p>
         * Reports progress on replacing instances that are in the Auto Scaling group.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRefreshLivePoolProgress.Builder}
         * avoiding the need to create one manually via {@link InstanceRefreshLivePoolProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRefreshLivePoolProgress.Builder#build()} is called
         * immediately and its result is passed to {@link #livePoolProgress(InstanceRefreshLivePoolProgress)}.
         * 
         * @param livePoolProgress
         *        a consumer that will call methods on {@link InstanceRefreshLivePoolProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #livePoolProgress(InstanceRefreshLivePoolProgress)
         */
        default Builder livePoolProgress(Consumer<InstanceRefreshLivePoolProgress.Builder> livePoolProgress) {
            return livePoolProgress(InstanceRefreshLivePoolProgress.builder().applyMutation(livePoolProgress).build());
        }

        /**
         * <p>
         * Reports progress on replacing instances that are in the warm pool.
         * </p>
         * 
         * @param warmPoolProgress
         *        Reports progress on replacing instances that are in the warm pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmPoolProgress(InstanceRefreshWarmPoolProgress warmPoolProgress);

        /**
         * <p>
         * Reports progress on replacing instances that are in the warm pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRefreshWarmPoolProgress.Builder}
         * avoiding the need to create one manually via {@link InstanceRefreshWarmPoolProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRefreshWarmPoolProgress.Builder#build()} is called
         * immediately and its result is passed to {@link #warmPoolProgress(InstanceRefreshWarmPoolProgress)}.
         * 
         * @param warmPoolProgress
         *        a consumer that will call methods on {@link InstanceRefreshWarmPoolProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmPoolProgress(InstanceRefreshWarmPoolProgress)
         */
        default Builder warmPoolProgress(Consumer<InstanceRefreshWarmPoolProgress.Builder> warmPoolProgress) {
            return warmPoolProgress(InstanceRefreshWarmPoolProgress.builder().applyMutation(warmPoolProgress).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceRefreshLivePoolProgress livePoolProgress;

        private InstanceRefreshWarmPoolProgress warmPoolProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRefreshProgressDetails model) {
            livePoolProgress(model.livePoolProgress);
            warmPoolProgress(model.warmPoolProgress);
        }

        public final InstanceRefreshLivePoolProgress.Builder getLivePoolProgress() {
            return livePoolProgress != null ? livePoolProgress.toBuilder() : null;
        }

        public final void setLivePoolProgress(InstanceRefreshLivePoolProgress.BuilderImpl livePoolProgress) {
            this.livePoolProgress = livePoolProgress != null ? livePoolProgress.build() : null;
        }

        @Override
        public final Builder livePoolProgress(InstanceRefreshLivePoolProgress livePoolProgress) {
            this.livePoolProgress = livePoolProgress;
            return this;
        }

        public final InstanceRefreshWarmPoolProgress.Builder getWarmPoolProgress() {
            return warmPoolProgress != null ? warmPoolProgress.toBuilder() : null;
        }

        public final void setWarmPoolProgress(InstanceRefreshWarmPoolProgress.BuilderImpl warmPoolProgress) {
            this.warmPoolProgress = warmPoolProgress != null ? warmPoolProgress.build() : null;
        }

        @Override
        public final Builder warmPoolProgress(InstanceRefreshWarmPoolProgress warmPoolProgress) {
            this.warmPoolProgress = warmPoolProgress;
            return this;
        }

        @Override
        public InstanceRefreshProgressDetails build() {
            return new InstanceRefreshProgressDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
