/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingGroup.Builder, AutoScalingGroup> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(AutoScalingGroup::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupARN").getter(getter(AutoScalingGroup::autoScalingGroupARN))
            .setter(setter(Builder::autoScalingGroupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupARN").build())
            .build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(AutoScalingGroup::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(AutoScalingGroup::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField
            .<MixedInstancesPolicy> builder(MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy")
            .getter(getter(AutoScalingGroup::mixedInstancesPolicy)).setter(setter(Builder::mixedInstancesPolicy))
            .constructor(MixedInstancesPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build())
            .build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(AutoScalingGroup::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(AutoScalingGroup::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredCapacity").getter(getter(AutoScalingGroup::desiredCapacity))
            .setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final SdkField<Integer> PREDICTED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PredictedCapacity").getter(getter(AutoScalingGroup::predictedCapacity))
            .setter(setter(Builder::predictedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictedCapacity").build()).build();

    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultCooldown").getter(getter(AutoScalingGroup::defaultCooldown))
            .setter(setter(Builder::defaultCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(AutoScalingGroup::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerNames")
            .getter(getter(AutoScalingGroup::loadBalancerNames))
            .setter(setter(Builder::loadBalancerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_GROUP_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetGroupARNs")
            .getter(getter(AutoScalingGroup::targetGroupARNs))
            .setter(setter(Builder::targetGroupARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckType").getter(getter(AutoScalingGroup::healthCheckType))
            .setter(setter(Builder::healthCheckType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckGracePeriod").getter(getter(AutoScalingGroup::healthCheckGracePeriod))
            .setter(setter(Builder::healthCheckGracePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build())
            .build();

    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField
            .<List<Instance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(AutoScalingGroup::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instance> builder(MarshallingType.SDK_POJO)
                                            .constructor(Instance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(AutoScalingGroup::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<List<SuspendedProcess>> SUSPENDED_PROCESSES_FIELD = SdkField
            .<List<SuspendedProcess>> builder(MarshallingType.LIST)
            .memberName("SuspendedProcesses")
            .getter(getter(AutoScalingGroup::suspendedProcesses))
            .setter(setter(Builder::suspendedProcesses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedProcesses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuspendedProcess> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuspendedProcess::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementGroup").getter(getter(AutoScalingGroup::placementGroup))
            .setter(setter(Builder::placementGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()).build();

    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCZoneIdentifier").getter(getter(AutoScalingGroup::vpcZoneIdentifier))
            .setter(setter(Builder::vpcZoneIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()).build();

    private static final SdkField<List<EnabledMetric>> ENABLED_METRICS_FIELD = SdkField
            .<List<EnabledMetric>> builder(MarshallingType.LIST)
            .memberName("EnabledMetrics")
            .getter(getter(AutoScalingGroup::enabledMetrics))
            .setter(setter(Builder::enabledMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnabledMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnabledMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AutoScalingGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<TagDescription>> TAGS_FIELD = SdkField
            .<List<TagDescription>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(AutoScalingGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TerminationPolicies")
            .getter(getter(AutoScalingGroup::terminationPolicies))
            .setter(setter(Builder::terminationPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NewInstancesProtectedFromScaleIn")
            .getter(getter(AutoScalingGroup::newInstancesProtectedFromScaleIn))
            .setter(setter(Builder::newInstancesProtectedFromScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn")
                    .build()).build();

    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceLinkedRoleARN").getter(getter(AutoScalingGroup::serviceLinkedRoleARN))
            .setter(setter(Builder::serviceLinkedRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build())
            .build();

    private static final SdkField<Integer> MAX_INSTANCE_LIFETIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInstanceLifetime").getter(getter(AutoScalingGroup::maxInstanceLifetime))
            .setter(setter(Builder::maxInstanceLifetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceLifetime").build())
            .build();

    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CapacityRebalance").getter(getter(AutoScalingGroup::capacityRebalance))
            .setter(setter(Builder::capacityRebalance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()).build();

    private static final SdkField<WarmPoolConfiguration> WARM_POOL_CONFIGURATION_FIELD = SdkField
            .<WarmPoolConfiguration> builder(MarshallingType.SDK_POJO).memberName("WarmPoolConfiguration")
            .getter(getter(AutoScalingGroup::warmPoolConfiguration)).setter(setter(Builder::warmPoolConfiguration))
            .constructor(WarmPoolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolConfiguration").build())
            .build();

    private static final SdkField<Integer> WARM_POOL_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WarmPoolSize").getter(getter(AutoScalingGroup::warmPoolSize)).setter(setter(Builder::warmPoolSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolSize").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Context")
            .getter(getter(AutoScalingGroup::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()).build();

    private static final SdkField<String> DESIRED_CAPACITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredCapacityType").getter(getter(AutoScalingGroup::desiredCapacityType))
            .setter(setter(Builder::desiredCapacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacityType").build())
            .build();

    private static final SdkField<Integer> DEFAULT_INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultInstanceWarmup").getter(getter(AutoScalingGroup::defaultInstanceWarmup))
            .setter(setter(Builder::defaultInstanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceWarmup").build())
            .build();

    private static final SdkField<List<TrafficSourceIdentifier>> TRAFFIC_SOURCES_FIELD = SdkField
            .<List<TrafficSourceIdentifier>> builder(MarshallingType.LIST)
            .memberName("TrafficSources")
            .getter(getter(AutoScalingGroup::trafficSources))
            .setter(setter(Builder::trafficSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrafficSourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficSourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceMaintenancePolicy> INSTANCE_MAINTENANCE_POLICY_FIELD = SdkField
            .<InstanceMaintenancePolicy> builder(MarshallingType.SDK_POJO).memberName("InstanceMaintenancePolicy")
            .getter(getter(AutoScalingGroup::instanceMaintenancePolicy)).setter(setter(Builder::instanceMaintenancePolicy))
            .constructor(InstanceMaintenancePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMaintenancePolicy").build())
            .build();

    private static final SdkField<AvailabilityZoneDistribution> AVAILABILITY_ZONE_DISTRIBUTION_FIELD = SdkField
            .<AvailabilityZoneDistribution> builder(MarshallingType.SDK_POJO)
            .memberName("AvailabilityZoneDistribution")
            .getter(getter(AutoScalingGroup::availabilityZoneDistribution))
            .setter(setter(Builder::availabilityZoneDistribution))
            .constructor(AvailabilityZoneDistribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneDistribution")
                    .build()).build();

    private static final SdkField<AvailabilityZoneImpairmentPolicy> AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD = SdkField
            .<AvailabilityZoneImpairmentPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("AvailabilityZoneImpairmentPolicy")
            .getter(getter(AutoScalingGroup::availabilityZoneImpairmentPolicy))
            .setter(setter(Builder::availabilityZoneImpairmentPolicy))
            .constructor(AvailabilityZoneImpairmentPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneImpairmentPolicy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            AUTO_SCALING_GROUP_ARN_FIELD, LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIXED_INSTANCES_POLICY_FIELD,
            MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD, PREDICTED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD,
            AVAILABILITY_ZONES_FIELD, LOAD_BALANCER_NAMES_FIELD, TARGET_GROUP_AR_NS_FIELD, HEALTH_CHECK_TYPE_FIELD,
            HEALTH_CHECK_GRACE_PERIOD_FIELD, INSTANCES_FIELD, CREATED_TIME_FIELD, SUSPENDED_PROCESSES_FIELD,
            PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, ENABLED_METRICS_FIELD, STATUS_FIELD, TAGS_FIELD,
            TERMINATION_POLICIES_FIELD, NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD,
            MAX_INSTANCE_LIFETIME_FIELD, CAPACITY_REBALANCE_FIELD, WARM_POOL_CONFIGURATION_FIELD, WARM_POOL_SIZE_FIELD,
            CONTEXT_FIELD, DESIRED_CAPACITY_TYPE_FIELD, DEFAULT_INSTANCE_WARMUP_FIELD, TRAFFIC_SOURCES_FIELD,
            INSTANCE_MAINTENANCE_POLICY_FIELD, AVAILABILITY_ZONE_DISTRIBUTION_FIELD, AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
                    put("AutoScalingGroupARN", AUTO_SCALING_GROUP_ARN_FIELD);
                    put("LaunchConfigurationName", LAUNCH_CONFIGURATION_NAME_FIELD);
                    put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
                    put("MixedInstancesPolicy", MIXED_INSTANCES_POLICY_FIELD);
                    put("MinSize", MIN_SIZE_FIELD);
                    put("MaxSize", MAX_SIZE_FIELD);
                    put("DesiredCapacity", DESIRED_CAPACITY_FIELD);
                    put("PredictedCapacity", PREDICTED_CAPACITY_FIELD);
                    put("DefaultCooldown", DEFAULT_COOLDOWN_FIELD);
                    put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
                    put("LoadBalancerNames", LOAD_BALANCER_NAMES_FIELD);
                    put("TargetGroupARNs", TARGET_GROUP_AR_NS_FIELD);
                    put("HealthCheckType", HEALTH_CHECK_TYPE_FIELD);
                    put("HealthCheckGracePeriod", HEALTH_CHECK_GRACE_PERIOD_FIELD);
                    put("Instances", INSTANCES_FIELD);
                    put("CreatedTime", CREATED_TIME_FIELD);
                    put("SuspendedProcesses", SUSPENDED_PROCESSES_FIELD);
                    put("PlacementGroup", PLACEMENT_GROUP_FIELD);
                    put("VPCZoneIdentifier", VPC_ZONE_IDENTIFIER_FIELD);
                    put("EnabledMetrics", ENABLED_METRICS_FIELD);
                    put("Status", STATUS_FIELD);
                    put("Tags", TAGS_FIELD);
                    put("TerminationPolicies", TERMINATION_POLICIES_FIELD);
                    put("NewInstancesProtectedFromScaleIn", NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD);
                    put("ServiceLinkedRoleARN", SERVICE_LINKED_ROLE_ARN_FIELD);
                    put("MaxInstanceLifetime", MAX_INSTANCE_LIFETIME_FIELD);
                    put("CapacityRebalance", CAPACITY_REBALANCE_FIELD);
                    put("WarmPoolConfiguration", WARM_POOL_CONFIGURATION_FIELD);
                    put("WarmPoolSize", WARM_POOL_SIZE_FIELD);
                    put("Context", CONTEXT_FIELD);
                    put("DesiredCapacityType", DESIRED_CAPACITY_TYPE_FIELD);
                    put("DefaultInstanceWarmup", DEFAULT_INSTANCE_WARMUP_FIELD);
                    put("TrafficSources", TRAFFIC_SOURCES_FIELD);
                    put("InstanceMaintenancePolicy", INSTANCE_MAINTENANCE_POLICY_FIELD);
                    put("AvailabilityZoneDistribution", AVAILABILITY_ZONE_DISTRIBUTION_FIELD);
                    put("AvailabilityZoneImpairmentPolicy", AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String autoScalingGroupName;

    private final String autoScalingGroupARN;

    private final String launchConfigurationName;

    private final LaunchTemplateSpecification launchTemplate;

    private final MixedInstancesPolicy mixedInstancesPolicy;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final Integer predictedCapacity;

    private final Integer defaultCooldown;

    private final List<String> availabilityZones;

    private final List<String> loadBalancerNames;

    private final List<String> targetGroupARNs;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final List<Instance> instances;

    private final Instant createdTime;

    private final List<SuspendedProcess> suspendedProcesses;

    private final String placementGroup;

    private final String vpcZoneIdentifier;

    private final List<EnabledMetric> enabledMetrics;

    private final String status;

    private final List<TagDescription> tags;

    private final List<String> terminationPolicies;

    private final Boolean newInstancesProtectedFromScaleIn;

    private final String serviceLinkedRoleARN;

    private final Integer maxInstanceLifetime;

    private final Boolean capacityRebalance;

    private final WarmPoolConfiguration warmPoolConfiguration;

    private final Integer warmPoolSize;

    private final String context;

    private final String desiredCapacityType;

    private final Integer defaultInstanceWarmup;

    private final List<TrafficSourceIdentifier> trafficSources;

    private final InstanceMaintenancePolicy instanceMaintenancePolicy;

    private final AvailabilityZoneDistribution availabilityZoneDistribution;

    private final AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy;

    private AutoScalingGroup(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.autoScalingGroupARN = builder.autoScalingGroupARN;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.predictedCapacity = builder.predictedCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.instances = builder.instances;
        this.createdTime = builder.createdTime;
        this.suspendedProcesses = builder.suspendedProcesses;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.enabledMetrics = builder.enabledMetrics;
        this.status = builder.status;
        this.tags = builder.tags;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
        this.maxInstanceLifetime = builder.maxInstanceLifetime;
        this.capacityRebalance = builder.capacityRebalance;
        this.warmPoolConfiguration = builder.warmPoolConfiguration;
        this.warmPoolSize = builder.warmPoolSize;
        this.context = builder.context;
        this.desiredCapacityType = builder.desiredCapacityType;
        this.defaultInstanceWarmup = builder.defaultInstanceWarmup;
        this.trafficSources = builder.trafficSources;
        this.instanceMaintenancePolicy = builder.instanceMaintenancePolicy;
        this.availabilityZoneDistribution = builder.availabilityZoneDistribution;
        this.availabilityZoneImpairmentPolicy = builder.availabilityZoneImpairmentPolicy;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Auto Scaling group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public final String autoScalingGroupARN() {
        return autoScalingGroupARN;
    }

    /**
     * <p>
     * The name of the associated launch configuration.
     * </p>
     * 
     * @return The name of the associated launch configuration.
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The launch template for the group.
     * </p>
     * 
     * @return The launch template for the group.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The mixed instances policy for the group.
     * </p>
     * 
     * @return The mixed instances policy for the group.
     */
    public final MixedInstancesPolicy mixedInstancesPolicy() {
        return mixedInstancesPolicy;
    }

    /**
     * <p>
     * The minimum size of the group.
     * </p>
     * 
     * @return The minimum size of the group.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the group.
     * </p>
     * 
     * @return The maximum size of the group.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The desired size of the group.
     * </p>
     * 
     * @return The desired size of the group.
     */
    public final Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * The predicted capacity of the group when it has a predictive scaling policy.
     * </p>
     * 
     * @return The predicted capacity of the group when it has a predictive scaling policy.
     */
    public final Integer predictedCapacity() {
        return predictedCapacity;
    }

    /**
     * <p>
     * The duration of the default cooldown period, in seconds.
     * </p>
     * 
     * @return The duration of the default cooldown period, in seconds.
     */
    public final Integer defaultCooldown() {
        return defaultCooldown;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Availability Zones for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return One or more Availability Zones for the group.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancerNames() {
        return loadBalancerNames != null && !(loadBalancerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more load balancers associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerNames} method.
     * </p>
     * 
     * @return One or more load balancers associated with the group.
     */
    public final List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetGroupARNs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetGroupARNs() {
        return targetGroupARNs != null && !(targetGroupARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the target groups for your load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetGroupARNs} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the target groups for your load balancer.
     */
    public final List<String> targetGroupARNs() {
        return targetGroupARNs;
    }

    /**
     * <p>
     * A comma-separated value string of one or more health check types.
     * </p>
     * 
     * @return A comma-separated value string of one or more health check types.
     */
    public final String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The duration of the health check grace period, in seconds.
     * </p>
     * 
     * @return The duration of the health check grace period, in seconds.
     */
    public final Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 instances associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return The EC2 instances associated with the group.
     */
    public final List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * The date and time the group was created.
     * </p>
     * 
     * @return The date and time the group was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuspendedProcesses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuspendedProcesses() {
        return suspendedProcesses != null && !(suspendedProcesses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The suspended processes associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuspendedProcesses} method.
     * </p>
     * 
     * @return The suspended processes associated with the group.
     */
    public final List<SuspendedProcess> suspendedProcesses() {
        return suspendedProcesses;
    }

    /**
     * <p>
     * The name of the placement group into which to launch your instances, if any.
     * </p>
     * 
     * @return The name of the placement group into which to launch your instances, if any.
     */
    public final String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * One or more subnet IDs, if applicable, separated by commas.
     * </p>
     * 
     * @return One or more subnet IDs, if applicable, separated by commas.
     */
    public final String vpcZoneIdentifier() {
        return vpcZoneIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledMetrics() {
        return enabledMetrics != null && !(enabledMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics enabled for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledMetrics} method.
     * </p>
     * 
     * @return The metrics enabled for the group.
     */
    public final List<EnabledMetric> enabledMetrics() {
        return enabledMetrics;
    }

    /**
     * <p>
     * The current state of the group when the <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeleteAutoScalingGroup.html"
     * >DeleteAutoScalingGroup</a> operation is in progress.
     * </p>
     * 
     * @return The current state of the group when the <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeleteAutoScalingGroup.html"
     *         >DeleteAutoScalingGroup</a> operation is in progress.
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the group.
     */
    public final List<TagDescription> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerminationPolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerminationPolicies() {
        return terminationPolicies != null && !(terminationPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The termination policies for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerminationPolicies} method.
     * </p>
     * 
     * @return The termination policies for the group.
     */
    public final List<String> terminationPolicies() {
        return terminationPolicies;
    }

    /**
     * <p>
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling
     * in.
     * </p>
     * 
     * @return Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
     *         scaling in.
     */
    public final Boolean newInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon
     * Web Services on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other
     *         Amazon Web Services on your behalf.
     */
    public final String serviceLinkedRoleARN() {
        return serviceLinkedRoleARN;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that an instance can be in service.
     * </p>
     * <p>
     * Valid Range: Minimum value of 0.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that an instance can be in service.</p>
     *         <p>
     *         Valid Range: Minimum value of 0.
     */
    public final Integer maxInstanceLifetime() {
        return maxInstanceLifetime;
    }

    /**
     * <p>
     * Indicates whether Capacity Rebalancing is enabled.
     * </p>
     * 
     * @return Indicates whether Capacity Rebalancing is enabled.
     */
    public final Boolean capacityRebalance() {
        return capacityRebalance;
    }

    /**
     * <p>
     * The warm pool for the group.
     * </p>
     * 
     * @return The warm pool for the group.
     */
    public final WarmPoolConfiguration warmPoolConfiguration() {
        return warmPoolConfiguration;
    }

    /**
     * <p>
     * The current size of the warm pool.
     * </p>
     * 
     * @return The current size of the warm pool.
     */
    public final Integer warmPoolSize() {
        return warmPoolSize;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
     * <code>DesiredCapacityType</code> for attribute-based instance type selection only.
     * </p>
     * 
     * @return The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
     *         <code>DesiredCapacityType</code> for attribute-based instance type selection only.
     */
    public final String desiredCapacityType() {
        return desiredCapacityType;
    }

    /**
     * <p>
     * The duration of the default instance warmup, in seconds.
     * </p>
     * 
     * @return The duration of the default instance warmup, in seconds.
     */
    public final Integer defaultInstanceWarmup() {
        return defaultInstanceWarmup;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrafficSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrafficSources() {
        return trafficSources != null && !(trafficSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The traffic sources associated with this Auto Scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrafficSources} method.
     * </p>
     * 
     * @return The traffic sources associated with this Auto Scaling group.
     */
    public final List<TrafficSourceIdentifier> trafficSources() {
        return trafficSources;
    }

    /**
     * <p>
     * An instance maintenance policy.
     * </p>
     * 
     * @return An instance maintenance policy.
     */
    public final InstanceMaintenancePolicy instanceMaintenancePolicy() {
        return instanceMaintenancePolicy;
    }

    /**
     * <p>
     * The instance capacity distribution across Availability Zones.
     * </p>
     * 
     * @return The instance capacity distribution across Availability Zones.
     */
    public final AvailabilityZoneDistribution availabilityZoneDistribution() {
        return availabilityZoneDistribution;
    }

    /**
     * <p>
     * The Availability Zone impairment policy.
     * </p>
     * 
     * @return The Availability Zone impairment policy.
     */
    public final AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy() {
        return availabilityZoneImpairmentPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(predictedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerNames() ? loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroupARNs() ? targetGroupARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuspendedProcesses() ? suspendedProcesses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledMetrics() ? enabledMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminationPolicies() ? terminationPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceLinkedRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(maxInstanceLifetime());
        hashCode = 31 * hashCode + Objects.hashCode(capacityRebalance());
        hashCode = 31 * hashCode + Objects.hashCode(warmPoolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(warmPoolSize());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacityType());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrafficSources() ? trafficSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceMaintenancePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneImpairmentPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(autoScalingGroupARN(), other.autoScalingGroupARN())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(mixedInstancesPolicy(), other.mixedInstancesPolicy())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(maxSize(), other.maxSize())
                && Objects.equals(desiredCapacity(), other.desiredCapacity())
                && Objects.equals(predictedCapacity(), other.predictedCapacity())
                && Objects.equals(defaultCooldown(), other.defaultCooldown())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasLoadBalancerNames() == other.hasLoadBalancerNames()
                && Objects.equals(loadBalancerNames(), other.loadBalancerNames())
                && hasTargetGroupARNs() == other.hasTargetGroupARNs()
                && Objects.equals(targetGroupARNs(), other.targetGroupARNs())
                && Objects.equals(healthCheckType(), other.healthCheckType())
                && Objects.equals(healthCheckGracePeriod(), other.healthCheckGracePeriod())
                && hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && Objects.equals(createdTime(), other.createdTime()) && hasSuspendedProcesses() == other.hasSuspendedProcesses()
                && Objects.equals(suspendedProcesses(), other.suspendedProcesses())
                && Objects.equals(placementGroup(), other.placementGroup())
                && Objects.equals(vpcZoneIdentifier(), other.vpcZoneIdentifier())
                && hasEnabledMetrics() == other.hasEnabledMetrics() && Objects.equals(enabledMetrics(), other.enabledMetrics())
                && Objects.equals(status(), other.status()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTerminationPolicies() == other.hasTerminationPolicies()
                && Objects.equals(terminationPolicies(), other.terminationPolicies())
                && Objects.equals(newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn())
                && Objects.equals(serviceLinkedRoleARN(), other.serviceLinkedRoleARN())
                && Objects.equals(maxInstanceLifetime(), other.maxInstanceLifetime())
                && Objects.equals(capacityRebalance(), other.capacityRebalance())
                && Objects.equals(warmPoolConfiguration(), other.warmPoolConfiguration())
                && Objects.equals(warmPoolSize(), other.warmPoolSize()) && Objects.equals(context(), other.context())
                && Objects.equals(desiredCapacityType(), other.desiredCapacityType())
                && Objects.equals(defaultInstanceWarmup(), other.defaultInstanceWarmup())
                && hasTrafficSources() == other.hasTrafficSources() && Objects.equals(trafficSources(), other.trafficSources())
                && Objects.equals(instanceMaintenancePolicy(), other.instanceMaintenancePolicy())
                && Objects.equals(availabilityZoneDistribution(), other.availabilityZoneDistribution())
                && Objects.equals(availabilityZoneImpairmentPolicy(), other.availabilityZoneImpairmentPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingGroup").add("AutoScalingGroupName", autoScalingGroupName())
                .add("AutoScalingGroupARN", autoScalingGroupARN()).add("LaunchConfigurationName", launchConfigurationName())
                .add("LaunchTemplate", launchTemplate()).add("MixedInstancesPolicy", mixedInstancesPolicy())
                .add("MinSize", minSize()).add("MaxSize", maxSize()).add("DesiredCapacity", desiredCapacity())
                .add("PredictedCapacity", predictedCapacity()).add("DefaultCooldown", defaultCooldown())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("LoadBalancerNames", hasLoadBalancerNames() ? loadBalancerNames() : null)
                .add("TargetGroupARNs", hasTargetGroupARNs() ? targetGroupARNs() : null)
                .add("HealthCheckType", healthCheckType()).add("HealthCheckGracePeriod", healthCheckGracePeriod())
                .add("Instances", hasInstances() ? instances() : null).add("CreatedTime", createdTime())
                .add("SuspendedProcesses", hasSuspendedProcesses() ? suspendedProcesses() : null)
                .add("PlacementGroup", placementGroup()).add("VPCZoneIdentifier", vpcZoneIdentifier())
                .add("EnabledMetrics", hasEnabledMetrics() ? enabledMetrics() : null).add("Status", status())
                .add("Tags", hasTags() ? tags() : null)
                .add("TerminationPolicies", hasTerminationPolicies() ? terminationPolicies() : null)
                .add("NewInstancesProtectedFromScaleIn", newInstancesProtectedFromScaleIn())
                .add("ServiceLinkedRoleARN", serviceLinkedRoleARN()).add("MaxInstanceLifetime", maxInstanceLifetime())
                .add("CapacityRebalance", capacityRebalance()).add("WarmPoolConfiguration", warmPoolConfiguration())
                .add("WarmPoolSize", warmPoolSize()).add("Context", context()).add("DesiredCapacityType", desiredCapacityType())
                .add("DefaultInstanceWarmup", defaultInstanceWarmup())
                .add("TrafficSources", hasTrafficSources() ? trafficSources() : null)
                .add("InstanceMaintenancePolicy", instanceMaintenancePolicy())
                .add("AvailabilityZoneDistribution", availabilityZoneDistribution())
                .add("AvailabilityZoneImpairmentPolicy", availabilityZoneImpairmentPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "AutoScalingGroupARN":
            return Optional.ofNullable(clazz.cast(autoScalingGroupARN()));
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "MixedInstancesPolicy":
            return Optional.ofNullable(clazz.cast(mixedInstancesPolicy()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "PredictedCapacity":
            return Optional.ofNullable(clazz.cast(predictedCapacity()));
        case "DefaultCooldown":
            return Optional.ofNullable(clazz.cast(defaultCooldown()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "LoadBalancerNames":
            return Optional.ofNullable(clazz.cast(loadBalancerNames()));
        case "TargetGroupARNs":
            return Optional.ofNullable(clazz.cast(targetGroupARNs()));
        case "HealthCheckType":
            return Optional.ofNullable(clazz.cast(healthCheckType()));
        case "HealthCheckGracePeriod":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriod()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "SuspendedProcesses":
            return Optional.ofNullable(clazz.cast(suspendedProcesses()));
        case "PlacementGroup":
            return Optional.ofNullable(clazz.cast(placementGroup()));
        case "VPCZoneIdentifier":
            return Optional.ofNullable(clazz.cast(vpcZoneIdentifier()));
        case "EnabledMetrics":
            return Optional.ofNullable(clazz.cast(enabledMetrics()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TerminationPolicies":
            return Optional.ofNullable(clazz.cast(terminationPolicies()));
        case "NewInstancesProtectedFromScaleIn":
            return Optional.ofNullable(clazz.cast(newInstancesProtectedFromScaleIn()));
        case "ServiceLinkedRoleARN":
            return Optional.ofNullable(clazz.cast(serviceLinkedRoleARN()));
        case "MaxInstanceLifetime":
            return Optional.ofNullable(clazz.cast(maxInstanceLifetime()));
        case "CapacityRebalance":
            return Optional.ofNullable(clazz.cast(capacityRebalance()));
        case "WarmPoolConfiguration":
            return Optional.ofNullable(clazz.cast(warmPoolConfiguration()));
        case "WarmPoolSize":
            return Optional.ofNullable(clazz.cast(warmPoolSize()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "DesiredCapacityType":
            return Optional.ofNullable(clazz.cast(desiredCapacityType()));
        case "DefaultInstanceWarmup":
            return Optional.ofNullable(clazz.cast(defaultInstanceWarmup()));
        case "TrafficSources":
            return Optional.ofNullable(clazz.cast(trafficSources()));
        case "InstanceMaintenancePolicy":
            return Optional.ofNullable(clazz.cast(instanceMaintenancePolicy()));
        case "AvailabilityZoneDistribution":
            return Optional.ofNullable(clazz.cast(availabilityZoneDistribution()));
        case "AvailabilityZoneImpairmentPolicy":
            return Optional.ofNullable(clazz.cast(availabilityZoneImpairmentPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroup, T> g) {
        return obj -> g.apply((AutoScalingGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingGroup> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupARN
         *        The Amazon Resource Name (ARN) of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupARN(String autoScalingGroupARN);

        /**
         * <p>
         * The name of the associated launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the associated launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The launch template for the group.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The launch template for the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The mixed instances policy for the group.
         * </p>
         * 
         * @param mixedInstancesPolicy
         *        The mixed instances policy for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy);

        /**
         * <p>
         * The mixed instances policy for the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link MixedInstancesPolicy.Builder} avoiding
         * the need to create one manually via {@link MixedInstancesPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MixedInstancesPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #mixedInstancesPolicy(MixedInstancesPolicy)}.
         * 
         * @param mixedInstancesPolicy
         *        a consumer that will call methods on {@link MixedInstancesPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedInstancesPolicy(MixedInstancesPolicy)
         */
        default Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return mixedInstancesPolicy(MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy).build());
        }

        /**
         * <p>
         * The minimum size of the group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The desired size of the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * The predicted capacity of the group when it has a predictive scaling policy.
         * </p>
         * 
         * @param predictedCapacity
         *        The predicted capacity of the group when it has a predictive scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictedCapacity(Integer predictedCapacity);

        /**
         * <p>
         * The duration of the default cooldown period, in seconds.
         * </p>
         * 
         * @param defaultCooldown
         *        The duration of the default cooldown period, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCooldown(Integer defaultCooldown);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * One or more load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        One or more load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * One or more load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        One or more load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(Collection<String> targetGroupARNs);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(String... targetGroupARNs);

        /**
         * <p>
         * A comma-separated value string of one or more health check types.
         * </p>
         * 
         * @param healthCheckType
         *        A comma-separated value string of one or more health check types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The duration of the health check grace period, in seconds.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The duration of the health check grace period, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * The EC2 instances associated with the group.
         * </p>
         * 
         * @param instances
         *        The EC2 instances associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * The EC2 instances associated with the group.
         * </p>
         * 
         * @param instances
         *        The EC2 instances associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The EC2 instances associated with the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.Instance.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.autoscaling.model.Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.Instance.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(List<Instance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(java.util.Collection<Instance>)
         */
        Builder instances(Consumer<Instance.Builder>... instances);

        /**
         * <p>
         * The date and time the group was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The suspended processes associated with the group.
         * </p>
         * 
         * @param suspendedProcesses
         *        The suspended processes associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suspendedProcesses(Collection<SuspendedProcess> suspendedProcesses);

        /**
         * <p>
         * The suspended processes associated with the group.
         * </p>
         * 
         * @param suspendedProcesses
         *        The suspended processes associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suspendedProcesses(SuspendedProcess... suspendedProcesses);

        /**
         * <p>
         * The suspended processes associated with the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.SuspendedProcess.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.autoscaling.model.SuspendedProcess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.SuspendedProcess.Builder#build()} is called
         * immediately and its result is passed to {@link #suspendedProcesses(List<SuspendedProcess>)}.
         * 
         * @param suspendedProcesses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.SuspendedProcess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suspendedProcesses(java.util.Collection<SuspendedProcess>)
         */
        Builder suspendedProcesses(Consumer<SuspendedProcess.Builder>... suspendedProcesses);

        /**
         * <p>
         * The name of the placement group into which to launch your instances, if any.
         * </p>
         * 
         * @param placementGroup
         *        The name of the placement group into which to launch your instances, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * One or more subnet IDs, if applicable, separated by commas.
         * </p>
         * 
         * @param vpcZoneIdentifier
         *        One or more subnet IDs, if applicable, separated by commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcZoneIdentifier(String vpcZoneIdentifier);

        /**
         * <p>
         * The metrics enabled for the group.
         * </p>
         * 
         * @param enabledMetrics
         *        The metrics enabled for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMetrics(Collection<EnabledMetric> enabledMetrics);

        /**
         * <p>
         * The metrics enabled for the group.
         * </p>
         * 
         * @param enabledMetrics
         *        The metrics enabled for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMetrics(EnabledMetric... enabledMetrics);

        /**
         * <p>
         * The metrics enabled for the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.EnabledMetric.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.autoscaling.model.EnabledMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.EnabledMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #enabledMetrics(List<EnabledMetric>)}.
         * 
         * @param enabledMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.EnabledMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enabledMetrics(java.util.Collection<EnabledMetric>)
         */
        Builder enabledMetrics(Consumer<EnabledMetric.Builder>... enabledMetrics);

        /**
         * <p>
         * The current state of the group when the <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeleteAutoScalingGroup.html"
         * >DeleteAutoScalingGroup</a> operation is in progress.
         * </p>
         * 
         * @param status
         *        The current state of the group when the <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeleteAutoScalingGroup.html"
         *        >DeleteAutoScalingGroup</a> operation is in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The tags for the group.
         * </p>
         * 
         * @param tags
         *        The tags for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagDescription> tags);

        /**
         * <p>
         * The tags for the group.
         * </p>
         * 
         * @param tags
         *        The tags for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagDescription... tags);

        /**
         * <p>
         * The tags for the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.TagDescription.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.autoscaling.model.TagDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.TagDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #tags(List<TagDescription>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.TagDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagDescription>)
         */
        Builder tags(Consumer<TagDescription.Builder>... tags);

        /**
         * <p>
         * The termination policies for the group.
         * </p>
         * 
         * @param terminationPolicies
         *        The termination policies for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(Collection<String> terminationPolicies);

        /**
         * <p>
         * The termination policies for the group.
         * </p>
         * 
         * @param terminationPolicies
         *        The termination policies for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(String... terminationPolicies);

        /**
         * <p>
         * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
         * scaling in.
         * </p>
         * 
         * @param newInstancesProtectedFromScaleIn
         *        Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
         *        when scaling in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other
         * Amazon Web Services on your behalf.
         * </p>
         * 
         * @param serviceLinkedRoleARN
         *        The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call
         *        other Amazon Web Services on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkedRoleARN(String serviceLinkedRoleARN);

        /**
         * <p>
         * The maximum amount of time, in seconds, that an instance can be in service.
         * </p>
         * <p>
         * Valid Range: Minimum value of 0.
         * </p>
         * 
         * @param maxInstanceLifetime
         *        The maximum amount of time, in seconds, that an instance can be in service.</p>
         *        <p>
         *        Valid Range: Minimum value of 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceLifetime(Integer maxInstanceLifetime);

        /**
         * <p>
         * Indicates whether Capacity Rebalancing is enabled.
         * </p>
         * 
         * @param capacityRebalance
         *        Indicates whether Capacity Rebalancing is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRebalance(Boolean capacityRebalance);

        /**
         * <p>
         * The warm pool for the group.
         * </p>
         * 
         * @param warmPoolConfiguration
         *        The warm pool for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration);

        /**
         * <p>
         * The warm pool for the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link WarmPoolConfiguration.Builder} avoiding
         * the need to create one manually via {@link WarmPoolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WarmPoolConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #warmPoolConfiguration(WarmPoolConfiguration)}.
         * 
         * @param warmPoolConfiguration
         *        a consumer that will call methods on {@link WarmPoolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmPoolConfiguration(WarmPoolConfiguration)
         */
        default Builder warmPoolConfiguration(Consumer<WarmPoolConfiguration.Builder> warmPoolConfiguration) {
            return warmPoolConfiguration(WarmPoolConfiguration.builder().applyMutation(warmPoolConfiguration).build());
        }

        /**
         * <p>
         * The current size of the warm pool.
         * </p>
         * 
         * @param warmPoolSize
         *        The current size of the warm pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmPoolSize(Integer warmPoolSize);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param context
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
         * <code>DesiredCapacityType</code> for attribute-based instance type selection only.
         * </p>
         * 
         * @param desiredCapacityType
         *        The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
         *        <code>DesiredCapacityType</code> for attribute-based instance type selection only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacityType(String desiredCapacityType);

        /**
         * <p>
         * The duration of the default instance warmup, in seconds.
         * </p>
         * 
         * @param defaultInstanceWarmup
         *        The duration of the default instance warmup, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceWarmup(Integer defaultInstanceWarmup);

        /**
         * <p>
         * The traffic sources associated with this Auto Scaling group.
         * </p>
         * 
         * @param trafficSources
         *        The traffic sources associated with this Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources);

        /**
         * <p>
         * The traffic sources associated with this Auto Scaling group.
         * </p>
         * 
         * @param trafficSources
         *        The traffic sources associated with this Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(TrafficSourceIdentifier... trafficSources);

        /**
         * <p>
         * The traffic sources associated with this Auto Scaling group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #trafficSources(List<TrafficSourceIdentifier>)}.
         * 
         * @param trafficSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficSources(java.util.Collection<TrafficSourceIdentifier>)
         */
        Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder>... trafficSources);

        /**
         * <p>
         * An instance maintenance policy.
         * </p>
         * 
         * @param instanceMaintenancePolicy
         *        An instance maintenance policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMaintenancePolicy(InstanceMaintenancePolicy instanceMaintenancePolicy);

        /**
         * <p>
         * An instance maintenance policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMaintenancePolicy.Builder}
         * avoiding the need to create one manually via {@link InstanceMaintenancePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMaintenancePolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceMaintenancePolicy(InstanceMaintenancePolicy)}.
         * 
         * @param instanceMaintenancePolicy
         *        a consumer that will call methods on {@link InstanceMaintenancePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMaintenancePolicy(InstanceMaintenancePolicy)
         */
        default Builder instanceMaintenancePolicy(Consumer<InstanceMaintenancePolicy.Builder> instanceMaintenancePolicy) {
            return instanceMaintenancePolicy(InstanceMaintenancePolicy.builder().applyMutation(instanceMaintenancePolicy).build());
        }

        /**
         * <p>
         * The instance capacity distribution across Availability Zones.
         * </p>
         * 
         * @param availabilityZoneDistribution
         *        The instance capacity distribution across Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneDistribution(AvailabilityZoneDistribution availabilityZoneDistribution);

        /**
         * <p>
         * The instance capacity distribution across Availability Zones.
         * </p>
         * This is a convenience method that creates an instance of the {@link AvailabilityZoneDistribution.Builder}
         * avoiding the need to create one manually via {@link AvailabilityZoneDistribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailabilityZoneDistribution.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityZoneDistribution(AvailabilityZoneDistribution)}.
         * 
         * @param availabilityZoneDistribution
         *        a consumer that will call methods on {@link AvailabilityZoneDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZoneDistribution(AvailabilityZoneDistribution)
         */
        default Builder availabilityZoneDistribution(Consumer<AvailabilityZoneDistribution.Builder> availabilityZoneDistribution) {
            return availabilityZoneDistribution(AvailabilityZoneDistribution.builder()
                    .applyMutation(availabilityZoneDistribution).build());
        }

        /**
         * <p>
         * The Availability Zone impairment policy.
         * </p>
         * 
         * @param availabilityZoneImpairmentPolicy
         *        The Availability Zone impairment policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy);

        /**
         * <p>
         * The Availability Zone impairment policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AvailabilityZoneImpairmentPolicy.Builder}
         * avoiding the need to create one manually via {@link AvailabilityZoneImpairmentPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailabilityZoneImpairmentPolicy.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy)}.
         * 
         * @param availabilityZoneImpairmentPolicy
         *        a consumer that will call methods on {@link AvailabilityZoneImpairmentPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy)
         */
        default Builder availabilityZoneImpairmentPolicy(
                Consumer<AvailabilityZoneImpairmentPolicy.Builder> availabilityZoneImpairmentPolicy) {
            return availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy.builder()
                    .applyMutation(availabilityZoneImpairmentPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String autoScalingGroupARN;

        private String launchConfigurationName;

        private LaunchTemplateSpecification launchTemplate;

        private MixedInstancesPolicy mixedInstancesPolicy;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private Integer predictedCapacity;

        private Integer defaultCooldown;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private List<SuspendedProcess> suspendedProcesses = DefaultSdkAutoConstructList.getInstance();

        private String placementGroup;

        private String vpcZoneIdentifier;

        private List<EnabledMetric> enabledMetrics = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private List<TagDescription> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();

        private Boolean newInstancesProtectedFromScaleIn;

        private String serviceLinkedRoleARN;

        private Integer maxInstanceLifetime;

        private Boolean capacityRebalance;

        private WarmPoolConfiguration warmPoolConfiguration;

        private Integer warmPoolSize;

        private String context;

        private String desiredCapacityType;

        private Integer defaultInstanceWarmup;

        private List<TrafficSourceIdentifier> trafficSources = DefaultSdkAutoConstructList.getInstance();

        private InstanceMaintenancePolicy instanceMaintenancePolicy;

        private AvailabilityZoneDistribution availabilityZoneDistribution;

        private AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            autoScalingGroupName(model.autoScalingGroupName);
            autoScalingGroupARN(model.autoScalingGroupARN);
            launchConfigurationName(model.launchConfigurationName);
            launchTemplate(model.launchTemplate);
            mixedInstancesPolicy(model.mixedInstancesPolicy);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
            predictedCapacity(model.predictedCapacity);
            defaultCooldown(model.defaultCooldown);
            availabilityZones(model.availabilityZones);
            loadBalancerNames(model.loadBalancerNames);
            targetGroupARNs(model.targetGroupARNs);
            healthCheckType(model.healthCheckType);
            healthCheckGracePeriod(model.healthCheckGracePeriod);
            instances(model.instances);
            createdTime(model.createdTime);
            suspendedProcesses(model.suspendedProcesses);
            placementGroup(model.placementGroup);
            vpcZoneIdentifier(model.vpcZoneIdentifier);
            enabledMetrics(model.enabledMetrics);
            status(model.status);
            tags(model.tags);
            terminationPolicies(model.terminationPolicies);
            newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            serviceLinkedRoleARN(model.serviceLinkedRoleARN);
            maxInstanceLifetime(model.maxInstanceLifetime);
            capacityRebalance(model.capacityRebalance);
            warmPoolConfiguration(model.warmPoolConfiguration);
            warmPoolSize(model.warmPoolSize);
            context(model.context);
            desiredCapacityType(model.desiredCapacityType);
            defaultInstanceWarmup(model.defaultInstanceWarmup);
            trafficSources(model.trafficSources);
            instanceMaintenancePolicy(model.instanceMaintenancePolicy);
            availabilityZoneDistribution(model.availabilityZoneDistribution);
            availabilityZoneImpairmentPolicy(model.availabilityZoneImpairmentPolicy);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getAutoScalingGroupARN() {
            return autoScalingGroupARN;
        }

        public final void setAutoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
        }

        @Override
        public final Builder autoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
            return this;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return mixedInstancesPolicy != null ? mixedInstancesPolicy.toBuilder() : null;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final Integer getPredictedCapacity() {
            return predictedCapacity;
        }

        public final void setPredictedCapacity(Integer predictedCapacity) {
            this.predictedCapacity = predictedCapacity;
        }

        @Override
        public final Builder predictedCapacity(Integer predictedCapacity) {
            this.predictedCapacity = predictedCapacity;
            return this;
        }

        public final Integer getDefaultCooldown() {
            return defaultCooldown;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getLoadBalancerNames() {
            if (loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancerNames;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final Collection<String> getTargetGroupARNs() {
            if (targetGroupARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return targetGroupARNs;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String... targetGroupARNs) {
            targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final List<Instance.Builder> getInstances() {
            List<Instance.Builder> result = InstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> Instance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final List<SuspendedProcess.Builder> getSuspendedProcesses() {
            List<SuspendedProcess.Builder> result = SuspendedProcessesCopier.copyToBuilder(this.suspendedProcesses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuspendedProcesses(Collection<SuspendedProcess.BuilderImpl> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copyFromBuilder(suspendedProcesses);
        }

        @Override
        public final Builder suspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copy(suspendedProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedProcesses(SuspendedProcess... suspendedProcesses) {
            suspendedProcesses(Arrays.asList(suspendedProcesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedProcesses(Consumer<SuspendedProcess.Builder>... suspendedProcesses) {
            suspendedProcesses(Stream.of(suspendedProcesses).map(c -> SuspendedProcess.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final String getVpcZoneIdentifier() {
            return vpcZoneIdentifier;
        }

        public final void setVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final List<EnabledMetric.Builder> getEnabledMetrics() {
            List<EnabledMetric.Builder> result = EnabledMetricsCopier.copyToBuilder(this.enabledMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnabledMetrics(Collection<EnabledMetric.BuilderImpl> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copyFromBuilder(enabledMetrics);
        }

        @Override
        public final Builder enabledMetrics(Collection<EnabledMetric> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copy(enabledMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMetrics(EnabledMetric... enabledMetrics) {
            enabledMetrics(Arrays.asList(enabledMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMetrics(Consumer<EnabledMetric.Builder>... enabledMetrics) {
            enabledMetrics(Stream.of(enabledMetrics).map(c -> EnabledMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final List<TagDescription.Builder> getTags() {
            List<TagDescription.Builder> result = TagDescriptionListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagDescription.BuilderImpl> tags) {
            this.tags = TagDescriptionListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagDescription... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagDescription.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTerminationPolicies() {
            if (terminationPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return terminationPolicies;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return newInstancesProtectedFromScaleIn;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final String getServiceLinkedRoleARN() {
            return serviceLinkedRoleARN;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final Integer getMaxInstanceLifetime() {
            return maxInstanceLifetime;
        }

        public final void setMaxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
        }

        @Override
        public final Builder maxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public final Boolean getCapacityRebalance() {
            return capacityRebalance;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public final WarmPoolConfiguration.Builder getWarmPoolConfiguration() {
            return warmPoolConfiguration != null ? warmPoolConfiguration.toBuilder() : null;
        }

        public final void setWarmPoolConfiguration(WarmPoolConfiguration.BuilderImpl warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration != null ? warmPoolConfiguration.build() : null;
        }

        @Override
        public final Builder warmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration;
            return this;
        }

        public final Integer getWarmPoolSize() {
            return warmPoolSize;
        }

        public final void setWarmPoolSize(Integer warmPoolSize) {
            this.warmPoolSize = warmPoolSize;
        }

        @Override
        public final Builder warmPoolSize(Integer warmPoolSize) {
            this.warmPoolSize = warmPoolSize;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getDesiredCapacityType() {
            return desiredCapacityType;
        }

        public final void setDesiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
        }

        @Override
        public final Builder desiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
            return this;
        }

        public final Integer getDefaultInstanceWarmup() {
            return defaultInstanceWarmup;
        }

        public final void setDefaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
        }

        @Override
        public final Builder defaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
            return this;
        }

        public final List<TrafficSourceIdentifier.Builder> getTrafficSources() {
            List<TrafficSourceIdentifier.Builder> result = TrafficSourcesCopier.copyToBuilder(this.trafficSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficSources(Collection<TrafficSourceIdentifier.BuilderImpl> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copyFromBuilder(trafficSources);
        }

        @Override
        public final Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copy(trafficSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(TrafficSourceIdentifier... trafficSources) {
            trafficSources(Arrays.asList(trafficSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder>... trafficSources) {
            trafficSources(Stream.of(trafficSources).map(c -> TrafficSourceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceMaintenancePolicy.Builder getInstanceMaintenancePolicy() {
            return instanceMaintenancePolicy != null ? instanceMaintenancePolicy.toBuilder() : null;
        }

        public final void setInstanceMaintenancePolicy(InstanceMaintenancePolicy.BuilderImpl instanceMaintenancePolicy) {
            this.instanceMaintenancePolicy = instanceMaintenancePolicy != null ? instanceMaintenancePolicy.build() : null;
        }

        @Override
        public final Builder instanceMaintenancePolicy(InstanceMaintenancePolicy instanceMaintenancePolicy) {
            this.instanceMaintenancePolicy = instanceMaintenancePolicy;
            return this;
        }

        public final AvailabilityZoneDistribution.Builder getAvailabilityZoneDistribution() {
            return availabilityZoneDistribution != null ? availabilityZoneDistribution.toBuilder() : null;
        }

        public final void setAvailabilityZoneDistribution(AvailabilityZoneDistribution.BuilderImpl availabilityZoneDistribution) {
            this.availabilityZoneDistribution = availabilityZoneDistribution != null ? availabilityZoneDistribution.build()
                    : null;
        }

        @Override
        public final Builder availabilityZoneDistribution(AvailabilityZoneDistribution availabilityZoneDistribution) {
            this.availabilityZoneDistribution = availabilityZoneDistribution;
            return this;
        }

        public final AvailabilityZoneImpairmentPolicy.Builder getAvailabilityZoneImpairmentPolicy() {
            return availabilityZoneImpairmentPolicy != null ? availabilityZoneImpairmentPolicy.toBuilder() : null;
        }

        public final void setAvailabilityZoneImpairmentPolicy(
                AvailabilityZoneImpairmentPolicy.BuilderImpl availabilityZoneImpairmentPolicy) {
            this.availabilityZoneImpairmentPolicy = availabilityZoneImpairmentPolicy != null ? availabilityZoneImpairmentPolicy
                    .build() : null;
        }

        @Override
        public final Builder availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy) {
            this.availabilityZoneImpairmentPolicy = availabilityZoneImpairmentPolicy;
            return this;
        }

        @Override
        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
