/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutScalingPolicyRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutScalingPolicyRequest.Builder, PutScalingPolicyRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(PutScalingPolicyRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(PutScalingPolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(PutScalingPolicyRequest::policyType)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> ADJUSTMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdjustmentType").getter(getter(PutScalingPolicyRequest::adjustmentType))
            .setter(setter(Builder::adjustmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentType").build()).build();

    private static final SdkField<Integer> MIN_ADJUSTMENT_STEP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinAdjustmentStep").getter(getter(PutScalingPolicyRequest::minAdjustmentStep))
            .setter(setter(Builder::minAdjustmentStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentStep").build()).build();

    private static final SdkField<Integer> MIN_ADJUSTMENT_MAGNITUDE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinAdjustmentMagnitude").getter(getter(PutScalingPolicyRequest::minAdjustmentMagnitude))
            .setter(setter(Builder::minAdjustmentMagnitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentMagnitude").build())
            .build();

    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScalingAdjustment").getter(getter(PutScalingPolicyRequest::scalingAdjustment))
            .setter(setter(Builder::scalingAdjustment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()).build();

    private static final SdkField<Integer> COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Cooldown").getter(getter(PutScalingPolicyRequest::cooldown)).setter(setter(Builder::cooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cooldown").build()).build();

    private static final SdkField<String> METRIC_AGGREGATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricAggregationType").getter(getter(PutScalingPolicyRequest::metricAggregationType))
            .setter(setter(Builder::metricAggregationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAggregationType").build())
            .build();

    private static final SdkField<List<StepAdjustment>> STEP_ADJUSTMENTS_FIELD = SdkField
            .<List<StepAdjustment>> builder(MarshallingType.LIST)
            .memberName("StepAdjustments")
            .getter(getter(PutScalingPolicyRequest::stepAdjustments))
            .setter(setter(Builder::stepAdjustments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepAdjustments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepAdjustment> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepAdjustment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EstimatedInstanceWarmup").getter(getter(PutScalingPolicyRequest::estimatedInstanceWarmup))
            .setter(setter(Builder::estimatedInstanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build())
            .build();

    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField
            .<TargetTrackingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TargetTrackingConfiguration")
            .getter(getter(PutScalingPolicyRequest::targetTrackingConfiguration))
            .setter(setter(Builder::targetTrackingConfiguration))
            .constructor(TargetTrackingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration")
                    .build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(PutScalingPolicyRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<PredictiveScalingConfiguration> PREDICTIVE_SCALING_CONFIGURATION_FIELD = SdkField
            .<PredictiveScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PredictiveScalingConfiguration")
            .getter(getter(PutScalingPolicyRequest::predictiveScalingConfiguration))
            .setter(setter(Builder::predictiveScalingConfiguration))
            .constructor(PredictiveScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictiveScalingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            POLICY_NAME_FIELD, POLICY_TYPE_FIELD, ADJUSTMENT_TYPE_FIELD, MIN_ADJUSTMENT_STEP_FIELD,
            MIN_ADJUSTMENT_MAGNITUDE_FIELD, SCALING_ADJUSTMENT_FIELD, COOLDOWN_FIELD, METRIC_AGGREGATION_TYPE_FIELD,
            STEP_ADJUSTMENTS_FIELD, ESTIMATED_INSTANCE_WARMUP_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD, ENABLED_FIELD,
            PREDICTIVE_SCALING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
                    put("PolicyName", POLICY_NAME_FIELD);
                    put("PolicyType", POLICY_TYPE_FIELD);
                    put("AdjustmentType", ADJUSTMENT_TYPE_FIELD);
                    put("MinAdjustmentStep", MIN_ADJUSTMENT_STEP_FIELD);
                    put("MinAdjustmentMagnitude", MIN_ADJUSTMENT_MAGNITUDE_FIELD);
                    put("ScalingAdjustment", SCALING_ADJUSTMENT_FIELD);
                    put("Cooldown", COOLDOWN_FIELD);
                    put("MetricAggregationType", METRIC_AGGREGATION_TYPE_FIELD);
                    put("StepAdjustments", STEP_ADJUSTMENTS_FIELD);
                    put("EstimatedInstanceWarmup", ESTIMATED_INSTANCE_WARMUP_FIELD);
                    put("TargetTrackingConfiguration", TARGET_TRACKING_CONFIGURATION_FIELD);
                    put("Enabled", ENABLED_FIELD);
                    put("PredictiveScalingConfiguration", PREDICTIVE_SCALING_CONFIGURATION_FIELD);
                }
            });

    private final String autoScalingGroupName;

    private final String policyName;

    private final String policyType;

    private final String adjustmentType;

    private final Integer minAdjustmentStep;

    private final Integer minAdjustmentMagnitude;

    private final Integer scalingAdjustment;

    private final Integer cooldown;

    private final String metricAggregationType;

    private final List<StepAdjustment> stepAdjustments;

    private final Integer estimatedInstanceWarmup;

    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private final Boolean enabled;

    private final PredictiveScalingConfiguration predictiveScalingConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
        this.stepAdjustments = builder.stepAdjustments;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
        this.enabled = builder.enabled;
        this.predictiveScalingConfiguration = builder.predictiveScalingConfiguration;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * One of the following policy types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TargetTrackingScaling</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StepScaling</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SimpleScaling</code> (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PredictiveScaling</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following policy types: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TargetTrackingScaling</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StepScaling</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SimpleScaling</code> (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PredictiveScaling</code>
     *         </p>
     *         </li>
     */
    public final String policyType() {
        return policyType;
    }

    /**
     * <p>
     * Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid
     * values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
     * </p>
     * <p>
     * Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">
     * Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage).
     *         The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     *         <code>PercentChangeInCapacity</code>.</p>
     *         <p>
     *         Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
     *         >Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String adjustmentType() {
        return adjustmentType;
    }

    /**
     * <p>
     * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     * </p>
     * 
     * @return Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     */
    public final Integer minAdjustmentStep() {
        return minAdjustmentStep;
    }

    /**
     * <p>
     * The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example,
     * suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a
     * <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25
     * percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto
     * Scaling scales out the group by 2 instances.
     * </p>
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
     * >Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a
     * value that is at least as large as your largest instance weight.
     * </p>
     * </note>
     * 
     * @return The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For
     *         example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent
     *         and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling
     *         policy is performed, 25 percent of 4 is 1. However, because you specified a
     *         <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2
     *         instances.</p>
     *         <p>
     *         Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
     *         >Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code>
     *         to a value that is at least as large as your largest instance weight.
     *         </p>
     */
    public final Integer minAdjustmentMagnitude() {
        return minAdjustmentMagnitude;
    }

    /**
     * <p>
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
     * capacity while a negative number removes from the current capacity. For exact capacity, you must specify a
     * non-negative value.
     * </p>
     * <p>
     * Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.)
     * </p>
     * 
     * @return The amount by which to scale, based on the specified adjustment type. A positive value adds to the
     *         current capacity while a negative number removes from the current capacity. For exact capacity, you must
     *         specify a non-negative value.</p>
     *         <p>
     *         Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.)
     */
    public final Integer scalingAdjustment() {
        return scalingAdjustment;
    }

    /**
     * <p>
     * A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is
     * specified here, it overrides the default cooldown.
     * </p>
     * <p>
     * Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html">Scaling
     * cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Default: None
     * </p>
     * 
     * @return A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period
     *         is specified here, it overrides the default cooldown.</p>
     *         <p>
     *         Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html"
     *         >Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         Default: None
     */
    public final Integer cooldown() {
        return cooldown;
    }

    /**
     * <p>
     * The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>,
     * and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.
     * </p>
     * <p>
     * Valid only if the policy type is <code>StepScaling</code>.
     * </p>
     * 
     * @return The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as
     *         <code>Average</code>.</p>
     *         <p>
     *         Valid only if the policy type is <code>StepScaling</code>.
     */
    public final String metricAggregationType() {
        return metricAggregationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepAdjustments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStepAdjustments() {
        return stepAdjustments != null && !(stepAdjustments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * </p>
     * <p>
     * Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepAdjustments} method.
     * </p>
     * 
     * @return A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
     *         <p>
     *         Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.)
     */
    public final List<StepAdjustment> stepAdjustments() {
        return stepAdjustments;
    }

    /**
     * <p>
     * <i>Not needed if the default instance warmup is defined for the group.</i>
     * </p>
     * <p>
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This
     * warm-up period applies to instances launched due to a specific target tracking or step scaling policy. When a
     * warm-up period is specified here, it overrides the default instance warmup.
     * </p>
     * <p>
     * Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.
     * </p>
     * <note>
     * <p>
     * The default is to use the value for the default instance warmup defined for the group. If default instance warmup
     * is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default cooldown.
     * </p>
     * </note>
     * 
     * @return <i>Not needed if the default instance warmup is defined for the group.</i> </p>
     *         <p>
     *         The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     *         This warm-up period applies to instances launched due to a specific target tracking or step scaling
     *         policy. When a warm-up period is specified here, it overrides the default instance warmup.
     *         </p>
     *         <p>
     *         Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.
     *         </p>
     *         <note>
     *         <p>
     *         The default is to use the value for the default instance warmup defined for the group. If default
     *         instance warmup is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default
     *         cooldown.
     *         </p>
     */
    public final Integer estimatedInstanceWarmup() {
        return estimatedInstanceWarmup;
    }

    /**
     * <p>
     * A target tracking scaling policy. Provides support for predefined or custom metrics.
     * </p>
     * <p>
     * The following predefined metrics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASGAverageCPUUtilization</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASGAverageNetworkIn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASGAverageNetworkOut</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALBRequestCountPerTarget</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the
     * <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
     * >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * </p>
     * <p>
     * Required if the policy type is <code>TargetTrackingScaling</code>.
     * </p>
     * 
     * @return A target tracking scaling policy. Provides support for predefined or custom metrics.</p>
     *         <p>
     *         The following predefined metrics are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASGAverageCPUUtilization</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASGAverageNetworkIn</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASGAverageNetworkOut</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALBRequestCountPerTarget</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the
     *         <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
     *         >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     *         </p>
     *         <p>
     *         Required if the policy type is <code>TargetTrackingScaling</code>.
     */
    public final TargetTrackingConfiguration targetTrackingConfiguration() {
        return targetTrackingConfiguration;
    }

    /**
     * <p>
     * Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html">Disable a
     * scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html"
     *         >Disable a scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A predictive scaling policy. Provides support for predefined and custom metrics.
     * </p>
     * <p>
     * Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html"
     * >PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * </p>
     * <p>
     * Required if the policy type is <code>PredictiveScaling</code>.
     * </p>
     * 
     * @return A predictive scaling policy. Provides support for predefined and custom metrics.</p>
     *         <p>
     *         Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request
     *         count.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html"
     *         >PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     *         </p>
     *         <p>
     *         Required if the policy type is <code>PredictiveScaling</code>.
     */
    public final PredictiveScalingConfiguration predictiveScalingConfiguration() {
        return predictiveScalingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyType());
        hashCode = 31 * hashCode + Objects.hashCode(adjustmentType());
        hashCode = 31 * hashCode + Objects.hashCode(minAdjustmentStep());
        hashCode = 31 * hashCode + Objects.hashCode(minAdjustmentMagnitude());
        hashCode = 31 * hashCode + Objects.hashCode(scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(cooldown());
        hashCode = 31 * hashCode + Objects.hashCode(metricAggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(hasStepAdjustments() ? stepAdjustments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(predictiveScalingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(policyType(), other.policyType())
                && Objects.equals(adjustmentType(), other.adjustmentType())
                && Objects.equals(minAdjustmentStep(), other.minAdjustmentStep())
                && Objects.equals(minAdjustmentMagnitude(), other.minAdjustmentMagnitude())
                && Objects.equals(scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(cooldown(), other.cooldown())
                && Objects.equals(metricAggregationType(), other.metricAggregationType())
                && hasStepAdjustments() == other.hasStepAdjustments()
                && Objects.equals(stepAdjustments(), other.stepAdjustments())
                && Objects.equals(estimatedInstanceWarmup(), other.estimatedInstanceWarmup())
                && Objects.equals(targetTrackingConfiguration(), other.targetTrackingConfiguration())
                && Objects.equals(enabled(), other.enabled())
                && Objects.equals(predictiveScalingConfiguration(), other.predictiveScalingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutScalingPolicyRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("PolicyName", policyName()).add("PolicyType", policyType()).add("AdjustmentType", adjustmentType())
                .add("MinAdjustmentStep", minAdjustmentStep()).add("MinAdjustmentMagnitude", minAdjustmentMagnitude())
                .add("ScalingAdjustment", scalingAdjustment()).add("Cooldown", cooldown())
                .add("MetricAggregationType", metricAggregationType())
                .add("StepAdjustments", hasStepAdjustments() ? stepAdjustments() : null)
                .add("EstimatedInstanceWarmup", estimatedInstanceWarmup())
                .add("TargetTrackingConfiguration", targetTrackingConfiguration()).add("Enabled", enabled())
                .add("PredictiveScalingConfiguration", predictiveScalingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyType()));
        case "AdjustmentType":
            return Optional.ofNullable(clazz.cast(adjustmentType()));
        case "MinAdjustmentStep":
            return Optional.ofNullable(clazz.cast(minAdjustmentStep()));
        case "MinAdjustmentMagnitude":
            return Optional.ofNullable(clazz.cast(minAdjustmentMagnitude()));
        case "ScalingAdjustment":
            return Optional.ofNullable(clazz.cast(scalingAdjustment()));
        case "Cooldown":
            return Optional.ofNullable(clazz.cast(cooldown()));
        case "MetricAggregationType":
            return Optional.ofNullable(clazz.cast(metricAggregationType()));
        case "StepAdjustments":
            return Optional.ofNullable(clazz.cast(stepAdjustments()));
        case "EstimatedInstanceWarmup":
            return Optional.ofNullable(clazz.cast(estimatedInstanceWarmup()));
        case "TargetTrackingConfiguration":
            return Optional.ofNullable(clazz.cast(targetTrackingConfiguration()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "PredictiveScalingConfiguration":
            return Optional.ofNullable(clazz.cast(predictiveScalingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutScalingPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutScalingPolicyRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * One of the following policy types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TargetTrackingScaling</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StepScaling</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SimpleScaling</code> (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PredictiveScaling</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyType
         *        One of the following policy types: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TargetTrackingScaling</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StepScaling</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SimpleScaling</code> (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PredictiveScaling</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The
         * valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
         * <code>PercentChangeInCapacity</code>.
         * </p>
         * <p>
         * Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
         * >Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param adjustmentType
         *        Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage).
         *        The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
         *        <code>PercentChangeInCapacity</code>.</p>
         *        <p>
         *        Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
         *        >Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentType(String adjustmentType);

        /**
         * <p>
         * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * </p>
         * 
         * @param minAdjustmentStep
         *        Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentStep(Integer minAdjustmentStep);

        /**
         * <p>
         * The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example,
         * suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you
         * specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is
         * performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2,
         * Amazon EC2 Auto Scaling scales out the group by 2 instances.
         * </p>
         * <p>
         * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
         * >Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <note>
         * <p>
         * Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a
         * value that is at least as large as your largest instance weight.
         * </p>
         * </note>
         * 
         * @param minAdjustmentMagnitude
         *        The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For
         *        example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25
         *        percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and
         *        the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a
         *        <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2
         *        instances.</p>
         *        <p>
         *        Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
         *        >Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Some Auto Scaling groups use instance weights. In this case, set the
         *        <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance
         *        weight.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude);

        /**
         * <p>
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
         * capacity while a negative number removes from the current capacity. For exact capacity, you must specify a
         * non-negative value.
         * </p>
         * <p>
         * Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.)
         * </p>
         * 
         * @param scalingAdjustment
         *        The amount by which to scale, based on the specified adjustment type. A positive value adds to the
         *        current capacity while a negative number removes from the current capacity. For exact capacity, you
         *        must specify a non-negative value.</p>
         *        <p>
         *        Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingAdjustment(Integer scalingAdjustment);

        /**
         * <p>
         * A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is
         * specified here, it overrides the default cooldown.
         * </p>
         * <p>
         * Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html">Scaling
         * cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Default: None
         * </p>
         * 
         * @param cooldown
         *        A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown
         *        period is specified here, it overrides the default cooldown.</p>
         *        <p>
         *        Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html"
         *        >Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         *        </p>
         *        <p>
         *        Default: None
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cooldown(Integer cooldown);

        /**
         * <p>
         * The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as
         * <code>Average</code>.
         * </p>
         * <p>
         * Valid only if the policy type is <code>StepScaling</code>.
         * </p>
         * 
         * @param metricAggregationType
         *        The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
         *        <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated
         *        as <code>Average</code>.</p>
         *        <p>
         *        Valid only if the policy type is <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAggregationType(String metricAggregationType);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.)
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.)
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(StepAdjustment... stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.)
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.StepAdjustment.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.autoscaling.model.StepAdjustment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.StepAdjustment.Builder#build()} is called
         * immediately and its result is passed to {@link #stepAdjustments(List<StepAdjustment>)}.
         * 
         * @param stepAdjustments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.StepAdjustment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepAdjustments(java.util.Collection<StepAdjustment>)
         */
        Builder stepAdjustments(Consumer<StepAdjustment.Builder>... stepAdjustments);

        /**
         * <p>
         * <i>Not needed if the default instance warmup is defined for the group.</i>
         * </p>
         * <p>
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
         * This warm-up period applies to instances launched due to a specific target tracking or step scaling policy.
         * When a warm-up period is specified here, it overrides the default instance warmup.
         * </p>
         * <p>
         * Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.
         * </p>
         * <note>
         * <p>
         * The default is to use the value for the default instance warmup defined for the group. If default instance
         * warmup is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default cooldown.
         * </p>
         * </note>
         * 
         * @param estimatedInstanceWarmup
         *        <i>Not needed if the default instance warmup is defined for the group.</i> </p>
         *        <p>
         *        The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch
         *        metrics. This warm-up period applies to instances launched due to a specific target tracking or step
         *        scaling policy. When a warm-up period is specified here, it overrides the default instance warmup.
         *        </p>
         *        <p>
         *        Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.
         *        </p>
         *        <note>
         *        <p>
         *        The default is to use the value for the default instance warmup defined for the group. If default
         *        instance warmup is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default
         *        cooldown.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup);

        /**
         * <p>
         * A target tracking scaling policy. Provides support for predefined or custom metrics.
         * </p>
         * <p>
         * The following predefined metrics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASGAverageCPUUtilization</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASGAverageNetworkIn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASGAverageNetworkOut</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALBRequestCountPerTarget</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the
         * <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
         * >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         * </p>
         * <p>
         * Required if the policy type is <code>TargetTrackingScaling</code>.
         * </p>
         * 
         * @param targetTrackingConfiguration
         *        A target tracking scaling policy. Provides support for predefined or custom metrics.</p>
         *        <p>
         *        The following predefined metrics are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASGAverageCPUUtilization</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASGAverageNetworkIn</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASGAverageNetworkOut</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALBRequestCountPerTarget</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the
         *        <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
         *        >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         *        </p>
         *        <p>
         *        Required if the policy type is <code>TargetTrackingScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration);

        /**
         * <p>
         * A target tracking scaling policy. Provides support for predefined or custom metrics.
         * </p>
         * <p>
         * The following predefined metrics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASGAverageCPUUtilization</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASGAverageNetworkIn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASGAverageNetworkOut</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALBRequestCountPerTarget</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the
         * <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
         * >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         * </p>
         * <p>
         * Required if the policy type is <code>TargetTrackingScaling</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetTrackingConfiguration.Builder}
         * avoiding the need to create one manually via {@link TargetTrackingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetTrackingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetTrackingConfiguration(TargetTrackingConfiguration)}.
         * 
         * @param targetTrackingConfiguration
         *        a consumer that will call methods on {@link TargetTrackingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingConfiguration(TargetTrackingConfiguration)
         */
        default Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return targetTrackingConfiguration(TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)
                    .build());
        }

        /**
         * <p>
         * Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html">Disable a
         * scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html"
         *        >Disable a scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A predictive scaling policy. Provides support for predefined and custom metrics.
         * </p>
         * <p>
         * Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html"
         * >PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         * </p>
         * <p>
         * Required if the policy type is <code>PredictiveScaling</code>.
         * </p>
         * 
         * @param predictiveScalingConfiguration
         *        A predictive scaling policy. Provides support for predefined and custom metrics.</p>
         *        <p>
         *        Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request
         *        count.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html"
         *        >PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         *        </p>
         *        <p>
         *        Required if the policy type is <code>PredictiveScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictiveScalingConfiguration(PredictiveScalingConfiguration predictiveScalingConfiguration);

        /**
         * <p>
         * A predictive scaling policy. Provides support for predefined and custom metrics.
         * </p>
         * <p>
         * Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html"
         * >PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         * </p>
         * <p>
         * Required if the policy type is <code>PredictiveScaling</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictiveScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link PredictiveScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #predictiveScalingConfiguration(PredictiveScalingConfiguration)}.
         * 
         * @param predictiveScalingConfiguration
         *        a consumer that will call methods on {@link PredictiveScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictiveScalingConfiguration(PredictiveScalingConfiguration)
         */
        default Builder predictiveScalingConfiguration(
                Consumer<PredictiveScalingConfiguration.Builder> predictiveScalingConfiguration) {
            return predictiveScalingConfiguration(PredictiveScalingConfiguration.builder()
                    .applyMutation(predictiveScalingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private String policyType;

        private String adjustmentType;

        private Integer minAdjustmentStep;

        private Integer minAdjustmentMagnitude;

        private Integer scalingAdjustment;

        private Integer cooldown;

        private String metricAggregationType;

        private List<StepAdjustment> stepAdjustments = DefaultSdkAutoConstructList.getInstance();

        private Integer estimatedInstanceWarmup;

        private TargetTrackingConfiguration targetTrackingConfiguration;

        private Boolean enabled;

        private PredictiveScalingConfiguration predictiveScalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
            policyType(model.policyType);
            adjustmentType(model.adjustmentType);
            minAdjustmentStep(model.minAdjustmentStep);
            minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            scalingAdjustment(model.scalingAdjustment);
            cooldown(model.cooldown);
            metricAggregationType(model.metricAggregationType);
            stepAdjustments(model.stepAdjustments);
            estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            targetTrackingConfiguration(model.targetTrackingConfiguration);
            enabled(model.enabled);
            predictiveScalingConfiguration(model.predictiveScalingConfiguration);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final String getAdjustmentType() {
            return adjustmentType;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final Integer getMinAdjustmentStep() {
            return minAdjustmentStep;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return minAdjustmentMagnitude;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final Integer getScalingAdjustment() {
            return scalingAdjustment;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final Integer getCooldown() {
            return cooldown;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final String getMetricAggregationType() {
            return metricAggregationType;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final List<StepAdjustment.Builder> getStepAdjustments() {
            List<StepAdjustment.Builder> result = StepAdjustmentsCopier.copyToBuilder(this.stepAdjustments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment... stepAdjustments) {
            stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(Consumer<StepAdjustment.Builder>... stepAdjustments) {
            stepAdjustments(Stream.of(stepAdjustments).map(c -> StepAdjustment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getEstimatedInstanceWarmup() {
            return estimatedInstanceWarmup;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return targetTrackingConfiguration != null ? targetTrackingConfiguration.toBuilder() : null;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final PredictiveScalingConfiguration.Builder getPredictiveScalingConfiguration() {
            return predictiveScalingConfiguration != null ? predictiveScalingConfiguration.toBuilder() : null;
        }

        public final void setPredictiveScalingConfiguration(
                PredictiveScalingConfiguration.BuilderImpl predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration != null ? predictiveScalingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder predictiveScalingConfiguration(PredictiveScalingConfiguration predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
