/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingActivitiesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DescribeScalingActivitiesRequest.Builder, DescribeScalingActivitiesRequest> {
    private static final SdkField<List<String>> ACTIVITY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ActivityIds")
            .getter(getter(DescribeScalingActivitiesRequest::activityIds))
            .setter(setter(Builder::activityIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(DescribeScalingActivitiesRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_DELETED_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeDeletedGroups").getter(getter(DescribeScalingActivitiesRequest::includeDeletedGroups))
            .setter(setter(Builder::includeDeletedGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDeletedGroups").build())
            .build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeScalingActivitiesRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScalingActivitiesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_IDS_FIELD,
            AUTO_SCALING_GROUP_NAME_FIELD, INCLUDE_DELETED_GROUPS_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ActivityIds", ACTIVITY_IDS_FIELD);
                    put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
                    put("IncludeDeletedGroups", INCLUDE_DELETED_GROUPS_FIELD);
                    put("MaxRecords", MAX_RECORDS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<String> activityIds;

    private final String autoScalingGroupName;

    private final Boolean includeDeletedGroups;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeScalingActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.activityIds = builder.activityIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.includeDeletedGroups = builder.includeDeletedGroups;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActivityIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActivityIds() {
        return activityIds != null && !(activityIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The activity IDs of the desired scaling activities. If you omit this property, all activities for the past six
     * weeks are described. If unknown activities are requested, they are ignored with no error. If you specify an Auto
     * Scaling group, the results are limited to that group.
     * </p>
     * <p>
     * Array Members: Maximum number of 50 IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActivityIds} method.
     * </p>
     * 
     * @return The activity IDs of the desired scaling activities. If you omit this property, all activities for the
     *         past six weeks are described. If unknown activities are requested, they are ignored with no error. If you
     *         specify an Auto Scaling group, the results are limited to that group.</p>
     *         <p>
     *         Array Members: Maximum number of 50 IDs.
     */
    public final List<String> activityIds() {
        return activityIds;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * Indicates whether to include scaling activity from deleted Auto Scaling groups.
     * </p>
     * 
     * @return Indicates whether to include scaling activity from deleted Auto Scaling groups.
     */
    public final Boolean includeDeletedGroups() {
        return includeDeletedGroups;
    }

    /**
     * <p>
     * The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value
     * is <code>100</code>.
     * </p>
     * 
     * @return The maximum number of items to return with this call. The default value is <code>100</code> and the
     *         maximum value is <code>100</code>.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActivityIds() ? activityIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(includeDeletedGroups());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesRequest)) {
            return false;
        }
        DescribeScalingActivitiesRequest other = (DescribeScalingActivitiesRequest) obj;
        return hasActivityIds() == other.hasActivityIds() && Objects.equals(activityIds(), other.activityIds())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(includeDeletedGroups(), other.includeDeletedGroups())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScalingActivitiesRequest").add("ActivityIds", hasActivityIds() ? activityIds() : null)
                .add("AutoScalingGroupName", autoScalingGroupName()).add("IncludeDeletedGroups", includeDeletedGroups())
                .add("MaxRecords", maxRecords()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityIds":
            return Optional.ofNullable(clazz.cast(activityIds()));
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "IncludeDeletedGroups":
            return Optional.ofNullable(clazz.cast(includeDeletedGroups()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingActivitiesRequest, T> g) {
        return obj -> g.apply((DescribeScalingActivitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
        /**
         * <p>
         * The activity IDs of the desired scaling activities. If you omit this property, all activities for the past
         * six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify
         * an Auto Scaling group, the results are limited to that group.
         * </p>
         * <p>
         * Array Members: Maximum number of 50 IDs.
         * </p>
         * 
         * @param activityIds
         *        The activity IDs of the desired scaling activities. If you omit this property, all activities for the
         *        past six weeks are described. If unknown activities are requested, they are ignored with no error. If
         *        you specify an Auto Scaling group, the results are limited to that group.</p>
         *        <p>
         *        Array Members: Maximum number of 50 IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityIds(Collection<String> activityIds);

        /**
         * <p>
         * The activity IDs of the desired scaling activities. If you omit this property, all activities for the past
         * six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify
         * an Auto Scaling group, the results are limited to that group.
         * </p>
         * <p>
         * Array Members: Maximum number of 50 IDs.
         * </p>
         * 
         * @param activityIds
         *        The activity IDs of the desired scaling activities. If you omit this property, all activities for the
         *        past six weeks are described. If unknown activities are requested, they are ignored with no error. If
         *        you specify an Auto Scaling group, the results are limited to that group.</p>
         *        <p>
         *        Array Members: Maximum number of 50 IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityIds(String... activityIds);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Indicates whether to include scaling activity from deleted Auto Scaling groups.
         * </p>
         * 
         * @param includeDeletedGroups
         *        Indicates whether to include scaling activity from deleted Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDeletedGroups(Boolean includeDeletedGroups);

        /**
         * <p>
         * The maximum number of items to return with this call. The default value is <code>100</code> and the maximum
         * value is <code>100</code>.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to return with this call. The default value is <code>100</code> and the
         *        maximum value is <code>100</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private List<String> activityIds = DefaultSdkAutoConstructList.getInstance();

        private String autoScalingGroupName;

        private Boolean includeDeletedGroups;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesRequest model) {
            super(model);
            activityIds(model.activityIds);
            autoScalingGroupName(model.autoScalingGroupName);
            includeDeletedGroups(model.includeDeletedGroups);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final Collection<String> getActivityIds() {
            if (activityIds instanceof SdkAutoConstructList) {
                return null;
            }
            return activityIds;
        }

        public final void setActivityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
        }

        @Override
        public final Builder activityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activityIds(String... activityIds) {
            activityIds(Arrays.asList(activityIds));
            return this;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Boolean getIncludeDeletedGroups() {
            return includeDeletedGroups;
        }

        public final void setIncludeDeletedGroups(Boolean includeDeletedGroups) {
            this.includeDeletedGroups = includeDeletedGroups;
        }

        @Override
        public final Builder includeDeletedGroups(Boolean includeDeletedGroups) {
            this.includeDeletedGroups = includeDeletedGroups;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingActivitiesRequest build() {
            return new DescribeScalingActivitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
