/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachTrafficSourcesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DetachTrafficSourcesRequest.Builder, DetachTrafficSourcesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(DetachTrafficSourcesRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<List<TrafficSourceIdentifier>> TRAFFIC_SOURCES_FIELD = SdkField
            .<List<TrafficSourceIdentifier>> builder(MarshallingType.LIST)
            .memberName("TrafficSources")
            .getter(getter(DetachTrafficSourcesRequest::trafficSources))
            .setter(setter(Builder::trafficSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrafficSourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficSourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            TRAFFIC_SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
                    put("TrafficSources", TRAFFIC_SOURCES_FIELD);
                }
            });

    private final String autoScalingGroupName;

    private final List<TrafficSourceIdentifier> trafficSources;

    private DetachTrafficSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.trafficSources = builder.trafficSources;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrafficSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrafficSources() {
        return trafficSources != null && !(trafficSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of one or more traffic sources. You can specify up to 10 traffic sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrafficSources} method.
     * </p>
     * 
     * @return The unique identifiers of one or more traffic sources. You can specify up to 10 traffic sources.
     */
    public final List<TrafficSourceIdentifier> trafficSources() {
        return trafficSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrafficSources() ? trafficSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachTrafficSourcesRequest)) {
            return false;
        }
        DetachTrafficSourcesRequest other = (DetachTrafficSourcesRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && hasTrafficSources() == other.hasTrafficSources() && Objects.equals(trafficSources(), other.trafficSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachTrafficSourcesRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("TrafficSources", hasTrafficSources() ? trafficSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "TrafficSources":
            return Optional.ofNullable(clazz.cast(trafficSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetachTrafficSourcesRequest, T> g) {
        return obj -> g.apply((DetachTrafficSourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetachTrafficSourcesRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The unique identifiers of one or more traffic sources. You can specify up to 10 traffic sources.
         * </p>
         * 
         * @param trafficSources
         *        The unique identifiers of one or more traffic sources. You can specify up to 10 traffic sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources);

        /**
         * <p>
         * The unique identifiers of one or more traffic sources. You can specify up to 10 traffic sources.
         * </p>
         * 
         * @param trafficSources
         *        The unique identifiers of one or more traffic sources. You can specify up to 10 traffic sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(TrafficSourceIdentifier... trafficSources);

        /**
         * <p>
         * The unique identifiers of one or more traffic sources. You can specify up to 10 traffic sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #trafficSources(List<TrafficSourceIdentifier>)}.
         * 
         * @param trafficSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficSources(java.util.Collection<TrafficSourceIdentifier>)
         */
        Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder>... trafficSources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<TrafficSourceIdentifier> trafficSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetachTrafficSourcesRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            trafficSources(model.trafficSources);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final List<TrafficSourceIdentifier.Builder> getTrafficSources() {
            List<TrafficSourceIdentifier.Builder> result = TrafficSourcesCopier.copyToBuilder(this.trafficSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficSources(Collection<TrafficSourceIdentifier.BuilderImpl> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copyFromBuilder(trafficSources);
        }

        @Override
        public final Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copy(trafficSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(TrafficSourceIdentifier... trafficSources) {
            trafficSources(Arrays.asList(trafficSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder>... trafficSources) {
            trafficSources(Stream.of(trafficSources).map(c -> TrafficSourceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachTrafficSourcesRequest build() {
            return new DetachTrafficSourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
