/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.InstancesDistribution;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MixedInstancesPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MixedInstancesPolicy> {
    private static final SdkField<LaunchTemplate> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(MixedInstancesPolicy.getter(MixedInstancesPolicy::launchTemplate)).setter(MixedInstancesPolicy.setter(Builder::launchTemplate)).constructor(LaunchTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()}).build();
    private static final SdkField<InstancesDistribution> INSTANCES_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstancesDistribution").getter(MixedInstancesPolicy.getter(MixedInstancesPolicy::instancesDistribution)).setter(MixedInstancesPolicy.setter(Builder::instancesDistribution)).constructor(InstancesDistribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesDistribution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_FIELD, INSTANCES_DISTRIBUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
            this.put("InstancesDistribution", INSTANCES_DISTRIBUTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final LaunchTemplate launchTemplate;
    private final InstancesDistribution instancesDistribution;

    private MixedInstancesPolicy(BuilderImpl builder) {
        this.launchTemplate = builder.launchTemplate;
        this.instancesDistribution = builder.instancesDistribution;
    }

    public final LaunchTemplate launchTemplate() {
        return this.launchTemplate;
    }

    public final InstancesDistribution instancesDistribution() {
        return this.instancesDistribution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesDistribution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MixedInstancesPolicy)) {
            return false;
        }
        MixedInstancesPolicy other = (MixedInstancesPolicy)obj;
        return Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.instancesDistribution(), other.instancesDistribution());
    }

    public final String toString() {
        return ToString.builder((String)"MixedInstancesPolicy").add("LaunchTemplate", (Object)this.launchTemplate()).add("InstancesDistribution", (Object)this.instancesDistribution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "InstancesDistribution": {
                return Optional.ofNullable(clazz.cast(this.instancesDistribution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MixedInstancesPolicy, T> g) {
        return obj -> g.apply((MixedInstancesPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LaunchTemplate launchTemplate;
        private InstancesDistribution instancesDistribution;

        private BuilderImpl() {
        }

        private BuilderImpl(MixedInstancesPolicy model) {
            this.launchTemplate(model.launchTemplate);
            this.instancesDistribution(model.instancesDistribution);
        }

        public final LaunchTemplate.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplate.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplate launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final InstancesDistribution.Builder getInstancesDistribution() {
            return this.instancesDistribution != null ? this.instancesDistribution.toBuilder() : null;
        }

        public final void setInstancesDistribution(InstancesDistribution.BuilderImpl instancesDistribution) {
            this.instancesDistribution = instancesDistribution != null ? instancesDistribution.build() : null;
        }

        @Override
        public final Builder instancesDistribution(InstancesDistribution instancesDistribution) {
            this.instancesDistribution = instancesDistribution;
            return this;
        }

        public MixedInstancesPolicy build() {
            return new MixedInstancesPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MixedInstancesPolicy> {
        public Builder launchTemplate(LaunchTemplate var1);

        default public Builder launchTemplate(Consumer<LaunchTemplate.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplate)((LaunchTemplate.Builder)LaunchTemplate.builder().applyMutation(launchTemplate)).build());
        }

        public Builder instancesDistribution(InstancesDistribution var1);

        default public Builder instancesDistribution(Consumer<InstancesDistribution.Builder> instancesDistribution) {
            return this.instancesDistribution((InstancesDistribution)((InstancesDistribution.Builder)InstancesDistribution.builder().applyMutation(instancesDistribution)).build());
        }
    }
}

