/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateInstanceInAutoScalingGroupRequest extends AutoScalingRequest implements
        ToCopyableBuilder<TerminateInstanceInAutoScalingGroupRequest.Builder, TerminateInstanceInAutoScalingGroupRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(TerminateInstanceInAutoScalingGroupRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Boolean> SHOULD_DECREMENT_DESIRED_CAPACITY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShouldDecrementDesiredCapacity")
            .getter(getter(TerminateInstanceInAutoScalingGroupRequest::shouldDecrementDesiredCapacity))
            .setter(setter(Builder::shouldDecrementDesiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShouldDecrementDesiredCapacity")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            SHOULD_DECREMENT_DESIRED_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("ShouldDecrementDesiredCapacity", SHOULD_DECREMENT_DESIRED_CAPACITY_FIELD);
                }
            });

    private final String instanceId;

    private final Boolean shouldDecrementDesiredCapacity;

    private TerminateInstanceInAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Indicates whether terminating the instance also decrements the size of the Auto Scaling group.
     * </p>
     * 
     * @return Indicates whether terminating the instance also decrements the size of the Auto Scaling group.
     */
    public final Boolean shouldDecrementDesiredCapacity() {
        return shouldDecrementDesiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(shouldDecrementDesiredCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstanceInAutoScalingGroupRequest)) {
            return false;
        }
        TerminateInstanceInAutoScalingGroupRequest other = (TerminateInstanceInAutoScalingGroupRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(shouldDecrementDesiredCapacity(), other.shouldDecrementDesiredCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateInstanceInAutoScalingGroupRequest").add("InstanceId", instanceId())
                .add("ShouldDecrementDesiredCapacity", shouldDecrementDesiredCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ShouldDecrementDesiredCapacity":
            return Optional.ofNullable(clazz.cast(shouldDecrementDesiredCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TerminateInstanceInAutoScalingGroupRequest, T> g) {
        return obj -> g.apply((TerminateInstanceInAutoScalingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Indicates whether terminating the instance also decrements the size of the Auto Scaling group.
         * </p>
         * 
         * @param shouldDecrementDesiredCapacity
         *        Indicates whether terminating the instance also decrements the size of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstanceInAutoScalingGroupRequest model) {
            super(model);
            instanceId(model.instanceId);
            shouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return shouldDecrementDesiredCapacity;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateInstanceInAutoScalingGroupRequest build() {
            return new TerminateInstanceInAutoScalingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
