/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Availability Zone impairment policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZoneImpairmentPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZoneImpairmentPolicy.Builder, AvailabilityZoneImpairmentPolicy> {
    private static final SdkField<Boolean> ZONAL_SHIFT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ZonalShiftEnabled").getter(getter(AvailabilityZoneImpairmentPolicy::zonalShiftEnabled))
            .setter(setter(Builder::zonalShiftEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZonalShiftEnabled").build()).build();

    private static final SdkField<String> IMPAIRED_ZONE_HEALTH_CHECK_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImpairedZoneHealthCheckBehavior")
            .getter(getter(AvailabilityZoneImpairmentPolicy::impairedZoneHealthCheckBehaviorAsString))
            .setter(setter(Builder::impairedZoneHealthCheckBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpairedZoneHealthCheckBehavior")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONAL_SHIFT_ENABLED_FIELD,
            IMPAIRED_ZONE_HEALTH_CHECK_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean zonalShiftEnabled;

    private final String impairedZoneHealthCheckBehavior;

    private AvailabilityZoneImpairmentPolicy(BuilderImpl builder) {
        this.zonalShiftEnabled = builder.zonalShiftEnabled;
        this.impairedZoneHealthCheckBehavior = builder.impairedZoneHealthCheckBehavior;
    }

    /**
     * <p>
     * If <code>true</code>, enable zonal shift for your Auto Scaling group.
     * </p>
     * 
     * @return If <code>true</code>, enable zonal shift for your Auto Scaling group.
     */
    public final Boolean zonalShiftEnabled() {
        return zonalShiftEnabled;
    }

    /**
     * <p>
     * Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you select
     * <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all Availability Zones. If
     * you select <code>Ignore unhealthy</code>, instances will not be replaced in the Availability Zone with the active
     * zonal shift. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto Scaling group
     * zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #impairedZoneHealthCheckBehavior} will return
     * {@link ImpairedZoneHealthCheckBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #impairedZoneHealthCheckBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you
     *         select <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all
     *         Availability Zones. If you select <code>Ignore unhealthy</code>, instances will not be replaced in the
     *         Availability Zone with the active zonal shift. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto
     *         Scaling group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * @see ImpairedZoneHealthCheckBehavior
     */
    public final ImpairedZoneHealthCheckBehavior impairedZoneHealthCheckBehavior() {
        return ImpairedZoneHealthCheckBehavior.fromValue(impairedZoneHealthCheckBehavior);
    }

    /**
     * <p>
     * Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you select
     * <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all Availability Zones. If
     * you select <code>Ignore unhealthy</code>, instances will not be replaced in the Availability Zone with the active
     * zonal shift. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto Scaling group
     * zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #impairedZoneHealthCheckBehavior} will return
     * {@link ImpairedZoneHealthCheckBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #impairedZoneHealthCheckBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you
     *         select <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all
     *         Availability Zones. If you select <code>Ignore unhealthy</code>, instances will not be replaced in the
     *         Availability Zone with the active zonal shift. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto
     *         Scaling group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * @see ImpairedZoneHealthCheckBehavior
     */
    public final String impairedZoneHealthCheckBehaviorAsString() {
        return impairedZoneHealthCheckBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zonalShiftEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(impairedZoneHealthCheckBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZoneImpairmentPolicy)) {
            return false;
        }
        AvailabilityZoneImpairmentPolicy other = (AvailabilityZoneImpairmentPolicy) obj;
        return Objects.equals(zonalShiftEnabled(), other.zonalShiftEnabled())
                && Objects.equals(impairedZoneHealthCheckBehaviorAsString(), other.impairedZoneHealthCheckBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailabilityZoneImpairmentPolicy").add("ZonalShiftEnabled", zonalShiftEnabled())
                .add("ImpairedZoneHealthCheckBehavior", impairedZoneHealthCheckBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ZonalShiftEnabled":
            return Optional.ofNullable(clazz.cast(zonalShiftEnabled()));
        case "ImpairedZoneHealthCheckBehavior":
            return Optional.ofNullable(clazz.cast(impairedZoneHealthCheckBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ZonalShiftEnabled", ZONAL_SHIFT_ENABLED_FIELD);
        map.put("ImpairedZoneHealthCheckBehavior", IMPAIRED_ZONE_HEALTH_CHECK_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZoneImpairmentPolicy, T> g) {
        return obj -> g.apply((AvailabilityZoneImpairmentPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZoneImpairmentPolicy> {
        /**
         * <p>
         * If <code>true</code>, enable zonal shift for your Auto Scaling group.
         * </p>
         * 
         * @param zonalShiftEnabled
         *        If <code>true</code>, enable zonal shift for your Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShiftEnabled(Boolean zonalShiftEnabled);

        /**
         * <p>
         * Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you
         * select <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all Availability
         * Zones. If you select <code>Ignore unhealthy</code>, instances will not be replaced in the Availability Zone
         * with the active zonal shift. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto Scaling
         * group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param impairedZoneHealthCheckBehavior
         *        Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If
         *        you select <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all
         *        Availability Zones. If you select <code>Ignore unhealthy</code>, instances will not be replaced in the
         *        Availability Zone with the active zonal shift. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto
         *        Scaling group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @see ImpairedZoneHealthCheckBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpairedZoneHealthCheckBehavior
         */
        Builder impairedZoneHealthCheckBehavior(String impairedZoneHealthCheckBehavior);

        /**
         * <p>
         * Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you
         * select <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all Availability
         * Zones. If you select <code>Ignore unhealthy</code>, instances will not be replaced in the Availability Zone
         * with the active zonal shift. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto Scaling
         * group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param impairedZoneHealthCheckBehavior
         *        Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If
         *        you select <code>Replace unhealthy</code>, instances that appear unhealthy will be replaced in all
         *        Availability Zones. If you select <code>Ignore unhealthy</code>, instances will not be replaced in the
         *        Availability Zone with the active zonal shift. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto
         *        Scaling group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @see ImpairedZoneHealthCheckBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpairedZoneHealthCheckBehavior
         */
        Builder impairedZoneHealthCheckBehavior(ImpairedZoneHealthCheckBehavior impairedZoneHealthCheckBehavior);
    }

    static final class BuilderImpl implements Builder {
        private Boolean zonalShiftEnabled;

        private String impairedZoneHealthCheckBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZoneImpairmentPolicy model) {
            zonalShiftEnabled(model.zonalShiftEnabled);
            impairedZoneHealthCheckBehavior(model.impairedZoneHealthCheckBehavior);
        }

        public final Boolean getZonalShiftEnabled() {
            return zonalShiftEnabled;
        }

        public final void setZonalShiftEnabled(Boolean zonalShiftEnabled) {
            this.zonalShiftEnabled = zonalShiftEnabled;
        }

        @Override
        public final Builder zonalShiftEnabled(Boolean zonalShiftEnabled) {
            this.zonalShiftEnabled = zonalShiftEnabled;
            return this;
        }

        public final String getImpairedZoneHealthCheckBehavior() {
            return impairedZoneHealthCheckBehavior;
        }

        public final void setImpairedZoneHealthCheckBehavior(String impairedZoneHealthCheckBehavior) {
            this.impairedZoneHealthCheckBehavior = impairedZoneHealthCheckBehavior;
        }

        @Override
        public final Builder impairedZoneHealthCheckBehavior(String impairedZoneHealthCheckBehavior) {
            this.impairedZoneHealthCheckBehavior = impairedZoneHealthCheckBehavior;
            return this;
        }

        @Override
        public final Builder impairedZoneHealthCheckBehavior(ImpairedZoneHealthCheckBehavior impairedZoneHealthCheckBehavior) {
            this.impairedZoneHealthCheckBehavior(impairedZoneHealthCheckBehavior == null ? null : impairedZoneHealthCheckBehavior
                    .toString());
            return this;
        }

        @Override
        public AvailabilityZoneImpairmentPolicy build() {
            return new AvailabilityZoneImpairmentPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
