/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPredictiveScalingForecastResponse extends AutoScalingResponse implements
        ToCopyableBuilder<GetPredictiveScalingForecastResponse.Builder, GetPredictiveScalingForecastResponse> {
    private static final SdkField<List<LoadForecast>> LOAD_FORECAST_FIELD = SdkField
            .<List<LoadForecast>> builder(MarshallingType.LIST)
            .memberName("LoadForecast")
            .getter(getter(GetPredictiveScalingForecastResponse::loadForecast))
            .setter(setter(Builder::loadForecast))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadForecast").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadForecast> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadForecast::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CapacityForecast> CAPACITY_FORECAST_FIELD = SdkField
            .<CapacityForecast> builder(MarshallingType.SDK_POJO).memberName("CapacityForecast")
            .getter(getter(GetPredictiveScalingForecastResponse::capacityForecast)).setter(setter(Builder::capacityForecast))
            .constructor(CapacityForecast::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityForecast").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime").getter(getter(GetPredictiveScalingForecastResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_FORECAST_FIELD,
            CAPACITY_FORECAST_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LoadForecast> loadForecast;

    private final CapacityForecast capacityForecast;

    private final Instant updateTime;

    private GetPredictiveScalingForecastResponse(BuilderImpl builder) {
        super(builder);
        this.loadForecast = builder.loadForecast;
        this.capacityForecast = builder.capacityForecast;
        this.updateTime = builder.updateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadForecast property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadForecast() {
        return loadForecast != null && !(loadForecast instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The load forecast.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadForecast} method.
     * </p>
     * 
     * @return The load forecast.
     */
    public final List<LoadForecast> loadForecast() {
        return loadForecast;
    }

    /**
     * <p>
     * The capacity forecast.
     * </p>
     * 
     * @return The capacity forecast.
     */
    public final CapacityForecast capacityForecast() {
        return capacityForecast;
    }

    /**
     * <p>
     * The time the forecast was made.
     * </p>
     * 
     * @return The time the forecast was made.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadForecast() ? loadForecast() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capacityForecast());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPredictiveScalingForecastResponse)) {
            return false;
        }
        GetPredictiveScalingForecastResponse other = (GetPredictiveScalingForecastResponse) obj;
        return hasLoadForecast() == other.hasLoadForecast() && Objects.equals(loadForecast(), other.loadForecast())
                && Objects.equals(capacityForecast(), other.capacityForecast())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPredictiveScalingForecastResponse")
                .add("LoadForecast", hasLoadForecast() ? loadForecast() : null).add("CapacityForecast", capacityForecast())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadForecast":
            return Optional.ofNullable(clazz.cast(loadForecast()));
        case "CapacityForecast":
            return Optional.ofNullable(clazz.cast(capacityForecast()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LoadForecast", LOAD_FORECAST_FIELD);
        map.put("CapacityForecast", CAPACITY_FORECAST_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPredictiveScalingForecastResponse, T> g) {
        return obj -> g.apply((GetPredictiveScalingForecastResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPredictiveScalingForecastResponse> {
        /**
         * <p>
         * The load forecast.
         * </p>
         * 
         * @param loadForecast
         *        The load forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadForecast(Collection<LoadForecast> loadForecast);

        /**
         * <p>
         * The load forecast.
         * </p>
         * 
         * @param loadForecast
         *        The load forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadForecast(LoadForecast... loadForecast);

        /**
         * <p>
         * The load forecast.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.LoadForecast.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.autoscaling.model.LoadForecast#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.LoadForecast.Builder#build()} is called immediately
         * and its result is passed to {@link #loadForecast(List<LoadForecast>)}.
         * 
         * @param loadForecast
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.LoadForecast.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadForecast(java.util.Collection<LoadForecast>)
         */
        Builder loadForecast(Consumer<LoadForecast.Builder>... loadForecast);

        /**
         * <p>
         * The capacity forecast.
         * </p>
         * 
         * @param capacityForecast
         *        The capacity forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityForecast(CapacityForecast capacityForecast);

        /**
         * <p>
         * The capacity forecast.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityForecast.Builder} avoiding the
         * need to create one manually via {@link CapacityForecast#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityForecast.Builder#build()} is called immediately and its
         * result is passed to {@link #capacityForecast(CapacityForecast)}.
         * 
         * @param capacityForecast
         *        a consumer that will call methods on {@link CapacityForecast.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityForecast(CapacityForecast)
         */
        default Builder capacityForecast(Consumer<CapacityForecast.Builder> capacityForecast) {
            return capacityForecast(CapacityForecast.builder().applyMutation(capacityForecast).build());
        }

        /**
         * <p>
         * The time the forecast was made.
         * </p>
         * 
         * @param updateTime
         *        The time the forecast was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<LoadForecast> loadForecast = DefaultSdkAutoConstructList.getInstance();

        private CapacityForecast capacityForecast;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPredictiveScalingForecastResponse model) {
            super(model);
            loadForecast(model.loadForecast);
            capacityForecast(model.capacityForecast);
            updateTime(model.updateTime);
        }

        public final List<LoadForecast.Builder> getLoadForecast() {
            List<LoadForecast.Builder> result = LoadForecastsCopier.copyToBuilder(this.loadForecast);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadForecast(Collection<LoadForecast.BuilderImpl> loadForecast) {
            this.loadForecast = LoadForecastsCopier.copyFromBuilder(loadForecast);
        }

        @Override
        public final Builder loadForecast(Collection<LoadForecast> loadForecast) {
            this.loadForecast = LoadForecastsCopier.copy(loadForecast);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadForecast(LoadForecast... loadForecast) {
            loadForecast(Arrays.asList(loadForecast));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadForecast(Consumer<LoadForecast.Builder>... loadForecast) {
            loadForecast(Stream.of(loadForecast).map(c -> LoadForecast.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CapacityForecast.Builder getCapacityForecast() {
            return capacityForecast != null ? capacityForecast.toBuilder() : null;
        }

        public final void setCapacityForecast(CapacityForecast.BuilderImpl capacityForecast) {
            this.capacityForecast = capacityForecast != null ? capacityForecast.build() : null;
        }

        @Override
        public final Builder capacityForecast(CapacityForecast capacityForecast) {
            this.capacityForecast = capacityForecast;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetPredictiveScalingForecastResponse build() {
            return new GetPredictiveScalingForecastResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
