/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a traffic source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficSourceState implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficSourceState.Builder, TrafficSourceState> {
    private static final SdkField<String> TRAFFIC_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficSource").getter(getter(TrafficSourceState::trafficSource)).setter(setter(Builder::trafficSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSource").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(TrafficSourceState::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(TrafficSourceState::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TrafficSourceState::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_SOURCE_FIELD,
            STATE_FIELD, IDENTIFIER_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TrafficSource", TRAFFIC_SOURCE_FIELD);
                    put("State", STATE_FIELD);
                    put("Identifier", IDENTIFIER_FIELD);
                    put("Type", TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String trafficSource;

    private final String state;

    private final String identifier;

    private final String type;

    private TrafficSourceState(BuilderImpl builder) {
        this.trafficSource = builder.trafficSource;
        this.state = builder.state;
        this.identifier = builder.identifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * This is replaced by <code>Identifier</code>.
     * </p>
     * 
     * @return This is replaced by <code>Identifier</code>.
     * @deprecated TrafficSource has been replaced by Identifier
     */
    @Deprecated
    public final String trafficSource() {
        return trafficSource;
    }

    /**
     * <p>
     * Describes the current state of a traffic source.
     * </p>
     * <p>
     * The state values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Adding</code> - The Auto Scaling instances are being registered with the load balancer or target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Added</code> - All Auto Scaling instances are registered with the load balancer or target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InService</code> - For an Elastic Load Balancing load balancer or target group, at least one Auto Scaling
     * instance passed an <code>ELB</code> health check. For VPC Lattice, at least one Auto Scaling instance passed an
     * <code>VPC_LATTICE</code> health check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removing</code> - The Auto Scaling instances are being deregistered from the load balancer or target group.
     * If connection draining (deregistration delay) is enabled, Elastic Load Balancing or VPC Lattice waits for
     * in-flight requests to complete before deregistering the instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removed</code> - All Auto Scaling instances are deregistered from the load balancer or target group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes the current state of a traffic source.</p>
     *         <p>
     *         The state values are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Adding</code> - The Auto Scaling instances are being registered with the load balancer or target
     *         group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Added</code> - All Auto Scaling instances are registered with the load balancer or target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InService</code> - For an Elastic Load Balancing load balancer or target group, at least one Auto
     *         Scaling instance passed an <code>ELB</code> health check. For VPC Lattice, at least one Auto Scaling
     *         instance passed an <code>VPC_LATTICE</code> health check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removing</code> - The Auto Scaling instances are being deregistered from the load balancer or
     *         target group. If connection draining (deregistration delay) is enabled, Elastic Load Balancing or VPC
     *         Lattice waits for in-flight requests to complete before deregistering the instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removed</code> - All Auto Scaling instances are deregistered from the load balancer or target
     *         group.
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The unique identifier of the traffic source.
     * </p>
     * 
     * @return The unique identifier of the traffic source.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Provides additional context for the value of <code>Identifier</code>.
     * </p>
     * <p>
     * The following lists the valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load Balancer,
     * or Network Load Balancer target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Required if the identifier is the name of a Classic Load Balancer.
     * </p>
     * 
     * @return Provides additional context for the value of <code>Identifier</code>.</p>
     *         <p>
     *         The following lists the valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load
     *         Balancer, or Network Load Balancer target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Required if the identifier is the name of a Classic Load Balancer.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficSource());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficSourceState)) {
            return false;
        }
        TrafficSourceState other = (TrafficSourceState) obj;
        return Objects.equals(trafficSource(), other.trafficSource()) && Objects.equals(state(), other.state())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficSourceState").add("TrafficSource", trafficSource()).add("State", state())
                .add("Identifier", identifier()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficSource":
            return Optional.ofNullable(clazz.cast(trafficSource()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrafficSourceState, T> g) {
        return obj -> g.apply((TrafficSourceState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficSourceState> {
        /**
         * <p>
         * This is replaced by <code>Identifier</code>.
         * </p>
         * 
         * @param trafficSource
         *        This is replaced by <code>Identifier</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated TrafficSource has been replaced by Identifier
         */
        @Deprecated
        Builder trafficSource(String trafficSource);

        /**
         * <p>
         * Describes the current state of a traffic source.
         * </p>
         * <p>
         * The state values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Adding</code> - The Auto Scaling instances are being registered with the load balancer or target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Added</code> - All Auto Scaling instances are registered with the load balancer or target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InService</code> - For an Elastic Load Balancing load balancer or target group, at least one Auto
         * Scaling instance passed an <code>ELB</code> health check. For VPC Lattice, at least one Auto Scaling instance
         * passed an <code>VPC_LATTICE</code> health check.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removing</code> - The Auto Scaling instances are being deregistered from the load balancer or target
         * group. If connection draining (deregistration delay) is enabled, Elastic Load Balancing or VPC Lattice waits
         * for in-flight requests to complete before deregistering the instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removed</code> - All Auto Scaling instances are deregistered from the load balancer or target group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        Describes the current state of a traffic source.</p>
         *        <p>
         *        The state values are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Adding</code> - The Auto Scaling instances are being registered with the load balancer or target
         *        group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Added</code> - All Auto Scaling instances are registered with the load balancer or target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InService</code> - For an Elastic Load Balancing load balancer or target group, at least one
         *        Auto Scaling instance passed an <code>ELB</code> health check. For VPC Lattice, at least one Auto
         *        Scaling instance passed an <code>VPC_LATTICE</code> health check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removing</code> - The Auto Scaling instances are being deregistered from the load balancer or
         *        target group. If connection draining (deregistration delay) is enabled, Elastic Load Balancing or VPC
         *        Lattice waits for in-flight requests to complete before deregistering the instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removed</code> - All Auto Scaling instances are deregistered from the load balancer or target
         *        group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The unique identifier of the traffic source.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the traffic source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Provides additional context for the value of <code>Identifier</code>.
         * </p>
         * <p>
         * The following lists the valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load
         * Balancer, or Network Load Balancer target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Required if the identifier is the name of a Classic Load Balancer.
         * </p>
         * 
         * @param type
         *        Provides additional context for the value of <code>Identifier</code>.</p>
         *        <p>
         *        The following lists the valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load
         *        Balancer, or Network Load Balancer target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Required if the identifier is the name of a Classic Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String trafficSource;

        private String state;

        private String identifier;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficSourceState model) {
            trafficSource(model.trafficSource);
            state(model.state);
            identifier(model.identifier);
            type(model.type);
        }

        @Deprecated
        public final String getTrafficSource() {
            return trafficSource;
        }

        @Deprecated
        public final void setTrafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
        }

        @Override
        @Deprecated
        public final Builder trafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public TrafficSourceState build() {
            return new TrafficSourceState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
