/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnterStandbyResponse extends AutoScalingResponse implements
        ToCopyableBuilder<EnterStandbyResponse.Builder, EnterStandbyResponse> {
    private static final SdkField<List<Activity>> ACTIVITIES_FIELD = SdkField
            .<List<Activity>> builder(MarshallingType.LIST)
            .getter(getter(EnterStandbyResponse::activities))
            .setter(setter(Builder::activities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Activities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Activity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Activity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITIES_FIELD));

    private final List<Activity> activities;

    private EnterStandbyResponse(BuilderImpl builder) {
        super(builder);
        this.activities = builder.activities;
    }

    /**
     * <p>
     * The activities related to moving instances into <code>Standby</code> mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The activities related to moving instances into <code>Standby</code> mode.
     */
    public List<Activity> activities() {
        return activities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activities());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnterStandbyResponse)) {
            return false;
        }
        EnterStandbyResponse other = (EnterStandbyResponse) obj;
        return Objects.equals(activities(), other.activities());
    }

    @Override
    public String toString() {
        return ToString.builder("EnterStandbyResponse").add("Activities", activities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Activities":
            return Optional.ofNullable(clazz.cast(activities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnterStandbyResponse, T> g) {
        return obj -> g.apply((EnterStandbyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo, CopyableBuilder<Builder, EnterStandbyResponse> {
        /**
         * <p>
         * The activities related to moving instances into <code>Standby</code> mode.
         * </p>
         * 
         * @param activities
         *        The activities related to moving instances into <code>Standby</code> mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<Activity> activities);

        /**
         * <p>
         * The activities related to moving instances into <code>Standby</code> mode.
         * </p>
         * 
         * @param activities
         *        The activities related to moving instances into <code>Standby</code> mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Activity... activities);

        /**
         * <p>
         * The activities related to moving instances into <code>Standby</code> mode.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Activity>.Builder} avoiding the need to
         * create one manually via {@link List<Activity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Activity>.Builder#build()} is called immediately and its
         * result is passed to {@link #activities(List<Activity>)}.
         * 
         * @param activities
         *        a consumer that will call methods on {@link List<Activity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activities(List<Activity>)
         */
        Builder activities(Consumer<Activity.Builder>... activities);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<Activity> activities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnterStandbyResponse model) {
            super(model);
            activities(model.activities);
        }

        public final Collection<Activity.Builder> getActivities() {
            return activities != null ? activities.stream().map(Activity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Consumer<Activity.Builder>... activities) {
            activities(Stream.of(activities).map(c -> Activity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActivities(Collection<Activity.BuilderImpl> activities) {
            this.activities = ActivitiesCopier.copyFromBuilder(activities);
        }

        @Override
        public EnterStandbyResponse build() {
            return new EnterStandbyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
