/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes one or more scheduled scaling action updates for a specified Auto Scaling group. Used in combination with
 * <a>BatchPutScheduledUpdateGroupAction</a>.
 * </p>
 * <p>
 * When updating a scheduled scaling action, all optional parameters are left unchanged if not specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledUpdateGroupActionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledUpdateGroupActionRequest.Builder, ScheduledUpdateGroupActionRequest> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduledUpdateGroupActionRequest::scheduledActionName)).setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ScheduledUpdateGroupActionRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ScheduledUpdateGroupActionRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> RECURRENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduledUpdateGroupActionRequest::recurrence)).setter(setter(Builder::recurrence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScheduledUpdateGroupActionRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScheduledUpdateGroupActionRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScheduledUpdateGroupActionRequest::desiredCapacity)).setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, RECURRENCE_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduledActionName;

    private final Instant startTime;

    private final Instant endTime;

    private final String recurrence;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private ScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        this.scheduledActionName = builder.scheduledActionName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recurrence = builder.recurrence;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
    }

    /**
     * <p>
     * The name of the scaling action.
     * </p>
     * 
     * @return The name of the scaling action.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * The time for the action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
     * <code>2014-06-01T00:00:00Z</code>).
     * </p>
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at
     * this time, and then performs the action based on the specified recurrence.
     * </p>
     * <p>
     * If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
     * </p>
     * 
     * @return The time for the action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
     *         <code>2014-06-01T00:00:00Z</code>).</p>
     *         <p>
     *         If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the
     *         action at this time, and then performs the action based on the specified recurrence.
     *         </p>
     *         <p>
     *         If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the action after this time.
     * </p>
     * 
     * @return The time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the action after
     *         this time.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The recurring schedule for the action, in Unix cron syntax format. For more information about this format, see <a
     * href="http://crontab.org">Crontab</a>.
     * </p>
     * 
     * @return The recurring schedule for the action, in Unix cron syntax format. For more information about this
     *         format, see <a href="http://crontab.org">Crontab</a>.
     */
    public String recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The minimum size of the group.
     * </p>
     * 
     * @return The minimum size of the group.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the group.
     * </p>
     * 
     * @return The maximum size of the group.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The number of EC2 instances that should be running in the group.
     * </p>
     * 
     * @return The number of EC2 instances that should be running in the group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledUpdateGroupActionRequest)) {
            return false;
        }
        ScheduledUpdateGroupActionRequest other = (ScheduledUpdateGroupActionRequest) obj;
        return Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(recurrence(), other.recurrence()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(desiredCapacity(), other.desiredCapacity());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduledUpdateGroupActionRequest").add("ScheduledActionName", scheduledActionName())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Recurrence", recurrence())
                .add("MinSize", minSize()).add("MaxSize", maxSize()).add("DesiredCapacity", desiredCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledUpdateGroupActionRequest, T> g) {
        return obj -> g.apply((ScheduledUpdateGroupActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledUpdateGroupActionRequest> {
        /**
         * <p>
         * The name of the scaling action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scaling action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * The time for the action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
         * <code>2014-06-01T00:00:00Z</code>).
         * </p>
         * <p>
         * If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the
         * action at this time, and then performs the action based on the specified recurrence.
         * </p>
         * <p>
         * If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
         * </p>
         * 
         * @param startTime
         *        The time for the action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
         *        <code>2014-06-01T00:00:00Z</code>).</p>
         *        <p>
         *        If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs
         *        the action at this time, and then performs the action based on the specified recurrence.
         *        </p>
         *        <p>
         *        If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the action after this
         * time.
         * </p>
         * 
         * @param endTime
         *        The time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the action after
         *        this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The recurring schedule for the action, in Unix cron syntax format. For more information about this format,
         * see <a href="http://crontab.org">Crontab</a>.
         * </p>
         * 
         * @param recurrence
         *        The recurring schedule for the action, in Unix cron syntax format. For more information about this
         *        format, see <a href="http://crontab.org">Crontab</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(String recurrence);

        /**
         * <p>
         * The minimum size of the group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The number of EC2 instances that should be running in the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The number of EC2 instances that should be running in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String scheduledActionName;

        private Instant startTime;

        private Instant endTime;

        private String recurrence;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledUpdateGroupActionRequest model) {
            scheduledActionName(model.scheduledActionName);
            startTime(model.startTime);
            endTime(model.endTime);
            recurrence(model.recurrence);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getRecurrence() {
            return recurrence;
        }

        @Override
        public final Builder recurrence(String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public ScheduledUpdateGroupActionRequest build() {
            return new ScheduledUpdateGroupActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
