/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLifecycleHooksResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeLifecycleHooksResponse.Builder, DescribeLifecycleHooksResponse> {
    private static final SdkField<List<LifecycleHook>> LIFECYCLE_HOOKS_FIELD = SdkField
            .<List<LifecycleHook>> builder(MarshallingType.LIST)
            .memberName("LifecycleHooks")
            .getter(getter(DescribeLifecycleHooksResponse::lifecycleHooks))
            .setter(setter(Builder::lifecycleHooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHooks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecycleHook> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecycleHook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LifecycleHook> lifecycleHooks;

    private DescribeLifecycleHooksResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleHooks = builder.lifecycleHooks;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecycleHooks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifecycleHooks() {
        return lifecycleHooks != null && !(lifecycleHooks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The lifecycle hooks for the specified group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecycleHooks} method.
     * </p>
     * 
     * @return The lifecycle hooks for the specified group.
     */
    public final List<LifecycleHook> lifecycleHooks() {
        return lifecycleHooks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecycleHooks() ? lifecycleHooks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksResponse)) {
            return false;
        }
        DescribeLifecycleHooksResponse other = (DescribeLifecycleHooksResponse) obj;
        return hasLifecycleHooks() == other.hasLifecycleHooks() && Objects.equals(lifecycleHooks(), other.lifecycleHooks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLifecycleHooksResponse")
                .add("LifecycleHooks", hasLifecycleHooks() ? lifecycleHooks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHooks":
            return Optional.ofNullable(clazz.cast(lifecycleHooks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LifecycleHooks", LIFECYCLE_HOOKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLifecycleHooksResponse, T> g) {
        return obj -> g.apply((DescribeLifecycleHooksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLifecycleHooksResponse> {
        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks);

        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(LifecycleHook... lifecycleHooks);

        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHook.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHook#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHook.Builder#build()} is called immediately
         * and its result is passed to {@link #lifecycleHooks(List<LifecycleHook>)}.
         * 
         * @param lifecycleHooks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleHooks(java.util.Collection<LifecycleHook>)
         */
        Builder lifecycleHooks(Consumer<LifecycleHook.Builder>... lifecycleHooks);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<LifecycleHook> lifecycleHooks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksResponse model) {
            super(model);
            lifecycleHooks(model.lifecycleHooks);
        }

        public final List<LifecycleHook.Builder> getLifecycleHooks() {
            List<LifecycleHook.Builder> result = LifecycleHooksCopier.copyToBuilder(this.lifecycleHooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecycleHooks(Collection<LifecycleHook.BuilderImpl> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copyFromBuilder(lifecycleHooks);
        }

        @Override
        public final Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copy(lifecycleHooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(LifecycleHook... lifecycleHooks) {
            lifecycleHooks(Arrays.asList(lifecycleHooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(Consumer<LifecycleHook.Builder>... lifecycleHooks) {
            lifecycleHooks(Stream.of(lifecycleHooks).map(c -> LifecycleHook.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeLifecycleHooksResponse build() {
            return new DescribeLifecycleHooksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
