/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the desired configuration for an instance refresh.
 * </p>
 * <p>
 * If you specify a desired configuration, you must specify either a <code>LaunchTemplate</code> or a
 * <code>MixedInstancesPolicy</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DesiredConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DesiredConfiguration.Builder, DesiredConfiguration> {
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(DesiredConfiguration::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField
            .<MixedInstancesPolicy> builder(MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy")
            .getter(getter(DesiredConfiguration::mixedInstancesPolicy)).setter(setter(Builder::mixedInstancesPolicy))
            .constructor(MixedInstancesPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_FIELD,
            MIXED_INSTANCES_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LaunchTemplateSpecification launchTemplate;

    private final MixedInstancesPolicy mixedInstancesPolicy;

    private DesiredConfiguration(BuilderImpl builder) {
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
    }

    /**
     * <p>
     * Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses to launch
     * Amazon EC2 instances. For more information about launch templates, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch templates</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses to
     *         launch Amazon EC2 instances. For more information about launch templates, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch templates</a>
     *         in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single
     * Auto Scaling group.
     * </p>
     * <p>
     * A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help
     * optimize your costs. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto
     * Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * 
     * @return Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a
     *         single Auto Scaling group.</p>
     *         <p>
     *         A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances
     *         and help optimize your costs. For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto
     *         Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling
     *         User Guide</i>.
     */
    public final MixedInstancesPolicy mixedInstancesPolicy() {
        return mixedInstancesPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(mixedInstancesPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredConfiguration)) {
            return false;
        }
        DesiredConfiguration other = (DesiredConfiguration) obj;
        return Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(mixedInstancesPolicy(), other.mixedInstancesPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DesiredConfiguration").add("LaunchTemplate", launchTemplate())
                .add("MixedInstancesPolicy", mixedInstancesPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "MixedInstancesPolicy":
            return Optional.ofNullable(clazz.cast(mixedInstancesPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("MixedInstancesPolicy", MIXED_INSTANCES_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DesiredConfiguration, T> g) {
        return obj -> g.apply((DesiredConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DesiredConfiguration> {
        /**
         * <p>
         * Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses to
         * launch Amazon EC2 instances. For more information about launch templates, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch templates</a> in
         * the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param launchTemplate
         *        Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses
         *        to launch Amazon EC2 instances. For more information about launch templates, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch
         *        templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses to
         * launch Amazon EC2 instances. For more information about launch templates, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html">Launch templates</a> in
         * the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a
         * single Auto Scaling group.
         * </p>
         * <p>
         * A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and
         * help optimize your costs. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         * >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling
         * User Guide</i>.
         * </p>
         * 
         * @param mixedInstancesPolicy
         *        Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within
         *        a single Auto Scaling group.</p>
         *        <p>
         *        A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances
         *        and help optimize your costs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         *        >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto
         *        Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy);

        /**
         * <p>
         * Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a
         * single Auto Scaling group.
         * </p>
         * <p>
         * A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and
         * help optimize your costs. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         * >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling
         * User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MixedInstancesPolicy.Builder} avoiding
         * the need to create one manually via {@link MixedInstancesPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MixedInstancesPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #mixedInstancesPolicy(MixedInstancesPolicy)}.
         * 
         * @param mixedInstancesPolicy
         *        a consumer that will call methods on {@link MixedInstancesPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedInstancesPolicy(MixedInstancesPolicy)
         */
        default Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return mixedInstancesPolicy(MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LaunchTemplateSpecification launchTemplate;

        private MixedInstancesPolicy mixedInstancesPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredConfiguration model) {
            launchTemplate(model.launchTemplate);
            mixedInstancesPolicy(model.mixedInstancesPolicy);
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return mixedInstancesPolicy != null ? mixedInstancesPolicy.toBuilder() : null;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        @Override
        public DesiredConfiguration build() {
            return new DesiredConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
