/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfiguration;

public class DescribeNotificationConfigurationsPublisher
implements SdkPublisher<DescribeNotificationConfigurationsResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeNotificationConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNotificationConfigurationsPublisher(AutoScalingAsyncClient client, DescribeNotificationConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNotificationConfigurationsPublisher(AutoScalingAsyncClient client, DescribeNotificationConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNotificationConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNotificationConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotificationConfiguration> notificationConfigurations() {
        Function<DescribeNotificationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationConfigurations() != null) {
                return response.notificationConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNotificationConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNotificationConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeNotificationConfigurationsResponse> {
        private DescribeNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNotificationConfigurationsResponse> nextPage(DescribeNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationConfigurationsPublisher.this.client.describeNotificationConfigurations(DescribeNotificationConfigurationsPublisher.this.firstRequest);
            }
            return DescribeNotificationConfigurationsPublisher.this.client.describeNotificationConfigurations((DescribeNotificationConfigurationsRequest)((Object)DescribeNotificationConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

