/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutLifecycleHookRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutLifecycleHookRequest.Builder, PutLifecycleHookRequest> {
    private static final SdkField<String> LIFECYCLE_HOOK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleHookName").getter(getter(PutLifecycleHookRequest::lifecycleHookName))
            .setter(setter(Builder::lifecycleHookName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookName").build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(PutLifecycleHookRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> LIFECYCLE_TRANSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleTransition").getter(getter(PutLifecycleHookRequest::lifecycleTransition))
            .setter(setter(Builder::lifecycleTransition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransition").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(PutLifecycleHookRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> NOTIFICATION_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTargetARN").getter(getter(PutLifecycleHookRequest::notificationTargetARN))
            .setter(setter(Builder::notificationTargetARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTargetARN").build())
            .build();

    private static final SdkField<String> NOTIFICATION_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationMetadata").getter(getter(PutLifecycleHookRequest::notificationMetadata))
            .setter(setter(Builder::notificationMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationMetadata").build())
            .build();

    private static final SdkField<Integer> HEARTBEAT_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HeartbeatTimeout").getter(getter(PutLifecycleHookRequest::heartbeatTimeout))
            .setter(setter(Builder::heartbeatTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatTimeout").build()).build();

    private static final SdkField<String> DEFAULT_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultResult").getter(getter(PutLifecycleHookRequest::defaultResult))
            .setter(setter(Builder::defaultResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_NAME_FIELD,
            AUTO_SCALING_GROUP_NAME_FIELD, LIFECYCLE_TRANSITION_FIELD, ROLE_ARN_FIELD, NOTIFICATION_TARGET_ARN_FIELD,
            NOTIFICATION_METADATA_FIELD, HEARTBEAT_TIMEOUT_FIELD, DEFAULT_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lifecycleHookName;

    private final String autoScalingGroupName;

    private final String lifecycleTransition;

    private final String roleARN;

    private final String notificationTargetARN;

    private final String notificationMetadata;

    private final Integer heartbeatTimeout;

    private final String defaultResult;

    private PutLifecycleHookRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleTransition = builder.lifecycleTransition;
        this.roleARN = builder.roleARN;
        this.notificationTargetARN = builder.notificationTargetARN;
        this.notificationMetadata = builder.notificationMetadata;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.defaultResult = builder.defaultResult;
    }

    /**
     * <p>
     * The name of the lifecycle hook.
     * </p>
     * 
     * @return The name of the lifecycle hook.
     */
    public final String lifecycleHookName() {
        return lifecycleHookName;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a lifecycle hook for scale-out events, specify <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a lifecycle hook for scale-in events, specify <code>autoscaling:EC2_INSTANCE_TERMINATING</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Required for new lifecycle hooks, but optional when updating existing hooks.
     * </p>
     * 
     * @return The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a lifecycle hook for scale-out events, specify <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a lifecycle hook for scale-in events, specify <code>autoscaling:EC2_INSTANCE_TERMINATING</code>
     *         .
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Required for new lifecycle hooks, but optional when updating existing hooks.
     */
    public final String lifecycleTransition() {
        return lifecycleTransition;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
     * </p>
     * <p>
     * Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle
     * hooks, but optional when updating existing hooks.
     * </p>
     * 
     * @return The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification
     *         target.</p>
     *         <p>
     *         Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new
     *         lifecycle hooks, but optional when updating existing hooks.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling uses to notify you when an
     * instance is in a wait state for the lifecycle hook. You can specify either an Amazon SNS topic or an Amazon SQS
     * queue.
     * </p>
     * <p>
     * If you specify an empty string, this overrides the current ARN.
     * </p>
     * <p>
     * This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value
     * pair format when sending notifications to an Amazon SNS topic.
     * </p>
     * <p>
     * When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain
     * the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling uses to notify you
     *         when an instance is in a wait state for the lifecycle hook. You can specify either an Amazon SNS topic or
     *         an Amazon SQS queue.</p>
     *         <p>
     *         If you specify an empty string, this overrides the current ARN.
     *         </p>
     *         <p>
     *         This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email
     *         key-value pair format when sending notifications to an Amazon SNS topic.
     *         </p>
     *         <p>
     *         When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages
     *         contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
     */
    public final String notificationTargetARN() {
        return notificationTargetARN;
    }

    /**
     * <p>
     * Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the
     * notification target.
     * </p>
     * 
     * @return Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the
     *         notification target.
     */
    public final String notificationMetadata() {
        return notificationMetadata;
    }

    /**
     * <p>
     * The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from
     * <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).
     * </p>
     * 
     * @return The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from
     *         <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).
     */
    public final Integer heartbeatTimeout() {
        return heartbeatTimeout;
    }

    /**
     * <p>
     * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure
     * occurs. The default value is <code>ABANDON</code>.
     * </p>
     * <p>
     * Valid values: <code>CONTINUE</code> | <code>ABANDON</code>
     * </p>
     * 
     * @return The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected
     *         failure occurs. The default value is <code>ABANDON</code>.</p>
     *         <p>
     *         Valid values: <code>CONTINUE</code> | <code>ABANDON</code>
     */
    public final String defaultResult() {
        return defaultResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleTransition());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTargetARN());
        hashCode = 31 * hashCode + Objects.hashCode(notificationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(heartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleHookRequest)) {
            return false;
        }
        PutLifecycleHookRequest other = (PutLifecycleHookRequest) obj;
        return Objects.equals(lifecycleHookName(), other.lifecycleHookName())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(lifecycleTransition(), other.lifecycleTransition())
                && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(notificationTargetARN(), other.notificationTargetARN())
                && Objects.equals(notificationMetadata(), other.notificationMetadata())
                && Objects.equals(heartbeatTimeout(), other.heartbeatTimeout())
                && Objects.equals(defaultResult(), other.defaultResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutLifecycleHookRequest").add("LifecycleHookName", lifecycleHookName())
                .add("AutoScalingGroupName", autoScalingGroupName()).add("LifecycleTransition", lifecycleTransition())
                .add("RoleARN", roleARN()).add("NotificationTargetARN", notificationTargetARN())
                .add("NotificationMetadata", notificationMetadata()).add("HeartbeatTimeout", heartbeatTimeout())
                .add("DefaultResult", defaultResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHookName":
            return Optional.ofNullable(clazz.cast(lifecycleHookName()));
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "LifecycleTransition":
            return Optional.ofNullable(clazz.cast(lifecycleTransition()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "NotificationTargetARN":
            return Optional.ofNullable(clazz.cast(notificationTargetARN()));
        case "NotificationMetadata":
            return Optional.ofNullable(clazz.cast(notificationMetadata()));
        case "HeartbeatTimeout":
            return Optional.ofNullable(clazz.cast(heartbeatTimeout()));
        case "DefaultResult":
            return Optional.ofNullable(clazz.cast(defaultResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LifecycleHookName", LIFECYCLE_HOOK_NAME_FIELD);
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("LifecycleTransition", LIFECYCLE_TRANSITION_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("NotificationTargetARN", NOTIFICATION_TARGET_ARN_FIELD);
        map.put("NotificationMetadata", NOTIFICATION_METADATA_FIELD);
        map.put("HeartbeatTimeout", HEARTBEAT_TIMEOUT_FIELD);
        map.put("DefaultResult", DEFAULT_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutLifecycleHookRequest, T> g) {
        return obj -> g.apply((PutLifecycleHookRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutLifecycleHookRequest> {
        /**
         * <p>
         * The name of the lifecycle hook.
         * </p>
         * 
         * @param lifecycleHookName
         *        The name of the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookName(String lifecycleHookName);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To create a lifecycle hook for scale-out events, specify <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a lifecycle hook for scale-in events, specify <code>autoscaling:EC2_INSTANCE_TERMINATING</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Required for new lifecycle hooks, but optional when updating existing hooks.
         * </p>
         * 
         * @param lifecycleTransition
         *        The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To create a lifecycle hook for scale-out events, specify
         *        <code>autoscaling:EC2_INSTANCE_LAUNCHING</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a lifecycle hook for scale-in events, specify
         *        <code>autoscaling:EC2_INSTANCE_TERMINATING</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Required for new lifecycle hooks, but optional when updating existing hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleTransition(String lifecycleTransition);

        /**
         * <p>
         * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
         * </p>
         * <p>
         * Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new
         * lifecycle hooks, but optional when updating existing hooks.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification
         *        target.</p>
         *        <p>
         *        Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new
         *        lifecycle hooks, but optional when updating existing hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling uses to notify you
         * when an instance is in a wait state for the lifecycle hook. You can specify either an Amazon SNS topic or an
         * Amazon SQS queue.
         * </p>
         * <p>
         * If you specify an empty string, this overrides the current ARN.
         * </p>
         * <p>
         * This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value
         * pair format when sending notifications to an Amazon SNS topic.
         * </p>
         * <p>
         * When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages
         * contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
         * </p>
         * 
         * @param notificationTargetARN
         *        The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling uses to notify
         *        you when an instance is in a wait state for the lifecycle hook. You can specify either an Amazon SNS
         *        topic or an Amazon SQS queue.</p>
         *        <p>
         *        If you specify an empty string, this overrides the current ARN.
         *        </p>
         *        <p>
         *        This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email
         *        key-value pair format when sending notifications to an Amazon SNS topic.
         *        </p>
         *        <p>
         *        When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages
         *        contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTargetARN(String notificationTargetARN);

        /**
         * <p>
         * Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the
         * notification target.
         * </p>
         * 
         * @param notificationMetadata
         *        Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to
         *        the notification target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationMetadata(String notificationMetadata);

        /**
         * <p>
         * The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from
         * <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).
         * </p>
         * 
         * @param heartbeatTimeout
         *        The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from
         *        <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatTimeout(Integer heartbeatTimeout);

        /**
         * <p>
         * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure
         * occurs. The default value is <code>ABANDON</code>.
         * </p>
         * <p>
         * Valid values: <code>CONTINUE</code> | <code>ABANDON</code>
         * </p>
         * 
         * @param defaultResult
         *        The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected
         *        failure occurs. The default value is <code>ABANDON</code>.</p>
         *        <p>
         *        Valid values: <code>CONTINUE</code> | <code>ABANDON</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResult(String defaultResult);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String lifecycleHookName;

        private String autoScalingGroupName;

        private String lifecycleTransition;

        private String roleARN;

        private String notificationTargetARN;

        private String notificationMetadata;

        private Integer heartbeatTimeout;

        private String defaultResult;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleHookRequest model) {
            super(model);
            lifecycleHookName(model.lifecycleHookName);
            autoScalingGroupName(model.autoScalingGroupName);
            lifecycleTransition(model.lifecycleTransition);
            roleARN(model.roleARN);
            notificationTargetARN(model.notificationTargetARN);
            notificationMetadata(model.notificationMetadata);
            heartbeatTimeout(model.heartbeatTimeout);
            defaultResult(model.defaultResult);
        }

        public final String getLifecycleHookName() {
            return lifecycleHookName;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getLifecycleTransition() {
            return lifecycleTransition;
        }

        public final void setLifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
        }

        @Override
        public final Builder lifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getNotificationTargetARN() {
            return notificationTargetARN;
        }

        public final void setNotificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
        }

        @Override
        public final Builder notificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
            return this;
        }

        public final String getNotificationMetadata() {
            return notificationMetadata;
        }

        public final void setNotificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
        }

        @Override
        public final Builder notificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        public final Integer getHeartbeatTimeout() {
            return heartbeatTimeout;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final String getDefaultResult() {
            return defaultResult;
        }

        public final void setDefaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
        }

        @Override
        public final Builder defaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLifecycleHookRequest build() {
            return new PutLifecycleHookRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
