/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 instance associated with an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingInstanceDetails.Builder, AutoScalingInstanceDetails> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AutoScalingInstanceDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(AutoScalingInstanceDetails::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(AutoScalingInstanceDetails::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(AutoScalingInstanceDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleState").getter(getter(AutoScalingInstanceDetails::lifecycleState))
            .setter(setter(Builder::lifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleState").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthStatus").getter(getter(AutoScalingInstanceDetails::healthStatus))
            .setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(AutoScalingInstanceDetails::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(AutoScalingInstanceDetails::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<Boolean> PROTECTED_FROM_SCALE_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ProtectedFromScaleIn").getter(getter(AutoScalingInstanceDetails::protectedFromScaleIn))
            .setter(setter(Builder::protectedFromScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedFromScaleIn").build())
            .build();

    private static final SdkField<String> WEIGHTED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WeightedCapacity").getter(getter(AutoScalingInstanceDetails::weightedCapacity))
            .setter(setter(Builder::weightedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INSTANCE_TYPE_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, AVAILABILITY_ZONE_FIELD, LIFECYCLE_STATE_FIELD,
            HEALTH_STATUS_FIELD, LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, PROTECTED_FROM_SCALE_IN_FIELD,
            WEIGHTED_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String instanceType;

    private final String autoScalingGroupName;

    private final String availabilityZone;

    private final String lifecycleState;

    private final String healthStatus;

    private final String launchConfigurationName;

    private final LaunchTemplateSpecification launchTemplate;

    private final Boolean protectedFromScaleIn;

    private final String weightedCapacity;

    private AutoScalingInstanceDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.availabilityZone = builder.availabilityZone;
        this.lifecycleState = builder.lifecycleState;
        this.healthStatus = builder.healthStatus;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
        this.weightedCapacity = builder.weightedCapacity;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type of the EC2 instance.
     * </p>
     * 
     * @return The instance type of the EC2 instance.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The name of the Auto Scaling group for the instance.
     * </p>
     * 
     * @return The name of the Auto Scaling group for the instance.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Availability Zone for the instance.
     * </p>
     * 
     * @return The Availability Zone for the instance.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The lifecycle state for the instance. The <code>Quarantined</code> state is not used. For more information, see
     * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html">Amazon EC2 Auto
     * Scaling instance lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Valid values: <code>Pending</code> | <code>Pending:Wait</code> | <code>Pending:Proceed</code> |
     * <code>Quarantined</code> | <code>InService</code> | <code>Terminating</code> | <code>Terminating:Wait</code> |
     * <code>Terminating:Proceed</code> | <code>Terminated</code> | <code>Detaching</code> | <code>Detached</code> |
     * <code>EnteringStandby</code> | <code>Standby</code> | <code>Warmed:Pending</code> |
     * <code>Warmed:Pending:Wait</code> | <code>Warmed:Pending:Proceed</code> | <code>Warmed:Terminating</code> |
     * <code>Warmed:Terminating:Wait</code> | <code>Warmed:Terminating:Proceed</code> | <code>Warmed:Terminated</code> |
     * <code>Warmed:Stopped</code> | <code>Warmed:Running</code>
     * </p>
     * 
     * @return The lifecycle state for the instance. The <code>Quarantined</code> state is not used. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html">Amazon EC2
     *         Auto Scaling instance lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
     *         <p>
     *         Valid values: <code>Pending</code> | <code>Pending:Wait</code> | <code>Pending:Proceed</code> |
     *         <code>Quarantined</code> | <code>InService</code> | <code>Terminating</code> |
     *         <code>Terminating:Wait</code> | <code>Terminating:Proceed</code> | <code>Terminated</code> |
     *         <code>Detaching</code> | <code>Detached</code> | <code>EnteringStandby</code> | <code>Standby</code> |
     *         <code>Warmed:Pending</code> | <code>Warmed:Pending:Wait</code> | <code>Warmed:Pending:Proceed</code> |
     *         <code>Warmed:Terminating</code> | <code>Warmed:Terminating:Wait</code> |
     *         <code>Warmed:Terminating:Proceed</code> | <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code> |
     *         <code>Warmed:Running</code>
     */
    public final String lifecycleState() {
        return lifecycleState;
    }

    /**
     * <p>
     * The last reported health status of this instance. <code>Healthy</code> means that the instance is healthy and
     * should remain in service. <code>Unhealthy</code> means that the instance is unhealthy and Amazon EC2 Auto Scaling
     * should terminate and replace it.
     * </p>
     * 
     * @return The last reported health status of this instance. <code>Healthy</code> means that the instance is healthy
     *         and should remain in service. <code>Unhealthy</code> means that the instance is unhealthy and Amazon EC2
     *         Auto Scaling should terminate and replace it.
     */
    public final String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * The launch configuration used to launch the instance. This value is not available if you attached the instance to
     * the Auto Scaling group.
     * </p>
     * 
     * @return The launch configuration used to launch the instance. This value is not available if you attached the
     *         instance to the Auto Scaling group.
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The launch template for the instance.
     * </p>
     * 
     * @return The launch template for the instance.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.
     * </p>
     * 
     * @return Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.
     */
    public final Boolean protectedFromScaleIn() {
        return protectedFromScaleIn;
    }

    /**
     * <p>
     * The number of capacity units contributed by the instance based on its instance type.
     * </p>
     * <p>
     * Valid Range: Minimum value of 1. Maximum value of 999.
     * </p>
     * 
     * @return The number of capacity units contributed by the instance based on its instance type.</p>
     *         <p>
     *         Valid Range: Minimum value of 1. Maximum value of 999.
     */
    public final String weightedCapacity() {
        return weightedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(protectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(weightedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingInstanceDetails)) {
            return false;
        }
        AutoScalingInstanceDetails other = (AutoScalingInstanceDetails) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(lifecycleState(), other.lifecycleState())
                && Objects.equals(healthStatus(), other.healthStatus())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(protectedFromScaleIn(), other.protectedFromScaleIn())
                && Objects.equals(weightedCapacity(), other.weightedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingInstanceDetails").add("InstanceId", instanceId()).add("InstanceType", instanceType())
                .add("AutoScalingGroupName", autoScalingGroupName()).add("AvailabilityZone", availabilityZone())
                .add("LifecycleState", lifecycleState()).add("HealthStatus", healthStatus())
                .add("LaunchConfigurationName", launchConfigurationName()).add("LaunchTemplate", launchTemplate())
                .add("ProtectedFromScaleIn", protectedFromScaleIn()).add("WeightedCapacity", weightedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "LifecycleState":
            return Optional.ofNullable(clazz.cast(lifecycleState()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatus()));
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "ProtectedFromScaleIn":
            return Optional.ofNullable(clazz.cast(protectedFromScaleIn()));
        case "WeightedCapacity":
            return Optional.ofNullable(clazz.cast(weightedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("LifecycleState", LIFECYCLE_STATE_FIELD);
        map.put("HealthStatus", HEALTH_STATUS_FIELD);
        map.put("LaunchConfigurationName", LAUNCH_CONFIGURATION_NAME_FIELD);
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("ProtectedFromScaleIn", PROTECTED_FROM_SCALE_IN_FIELD);
        map.put("WeightedCapacity", WEIGHTED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingInstanceDetails, T> g) {
        return obj -> g.apply((AutoScalingInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingInstanceDetails> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type of the EC2 instance.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The name of the Auto Scaling group for the instance.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Availability Zone for the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The lifecycle state for the instance. The <code>Quarantined</code> state is not used. For more information,
         * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html">Amazon
         * EC2 Auto Scaling instance lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>Pending</code> | <code>Pending:Wait</code> | <code>Pending:Proceed</code> |
         * <code>Quarantined</code> | <code>InService</code> | <code>Terminating</code> | <code>Terminating:Wait</code>
         * | <code>Terminating:Proceed</code> | <code>Terminated</code> | <code>Detaching</code> | <code>Detached</code>
         * | <code>EnteringStandby</code> | <code>Standby</code> | <code>Warmed:Pending</code> |
         * <code>Warmed:Pending:Wait</code> | <code>Warmed:Pending:Proceed</code> | <code>Warmed:Terminating</code> |
         * <code>Warmed:Terminating:Wait</code> | <code>Warmed:Terminating:Proceed</code> |
         * <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code> | <code>Warmed:Running</code>
         * </p>
         * 
         * @param lifecycleState
         *        The lifecycle state for the instance. The <code>Quarantined</code> state is not used. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html">Amazon
         *        EC2 Auto Scaling instance lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
         *        <p>
         *        Valid values: <code>Pending</code> | <code>Pending:Wait</code> | <code>Pending:Proceed</code> |
         *        <code>Quarantined</code> | <code>InService</code> | <code>Terminating</code> |
         *        <code>Terminating:Wait</code> | <code>Terminating:Proceed</code> | <code>Terminated</code> |
         *        <code>Detaching</code> | <code>Detached</code> | <code>EnteringStandby</code> | <code>Standby</code> |
         *        <code>Warmed:Pending</code> | <code>Warmed:Pending:Wait</code> | <code>Warmed:Pending:Proceed</code> |
         *        <code>Warmed:Terminating</code> | <code>Warmed:Terminating:Wait</code> |
         *        <code>Warmed:Terminating:Proceed</code> | <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code>
         *        | <code>Warmed:Running</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * The last reported health status of this instance. <code>Healthy</code> means that the instance is healthy and
         * should remain in service. <code>Unhealthy</code> means that the instance is unhealthy and Amazon EC2 Auto
         * Scaling should terminate and replace it.
         * </p>
         * 
         * @param healthStatus
         *        The last reported health status of this instance. <code>Healthy</code> means that the instance is
         *        healthy and should remain in service. <code>Unhealthy</code> means that the instance is unhealthy and
         *        Amazon EC2 Auto Scaling should terminate and replace it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The launch configuration used to launch the instance. This value is not available if you attached the
         * instance to the Auto Scaling group.
         * </p>
         * 
         * @param launchConfigurationName
         *        The launch configuration used to launch the instance. This value is not available if you attached the
         *        instance to the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The launch template for the instance.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The launch template for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.
         * </p>
         * 
         * @param protectedFromScaleIn
         *        Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedFromScaleIn(Boolean protectedFromScaleIn);

        /**
         * <p>
         * The number of capacity units contributed by the instance based on its instance type.
         * </p>
         * <p>
         * Valid Range: Minimum value of 1. Maximum value of 999.
         * </p>
         * 
         * @param weightedCapacity
         *        The number of capacity units contributed by the instance based on its instance type.</p>
         *        <p>
         *        Valid Range: Minimum value of 1. Maximum value of 999.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(String weightedCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String instanceType;

        private String autoScalingGroupName;

        private String availabilityZone;

        private String lifecycleState;

        private String healthStatus;

        private String launchConfigurationName;

        private LaunchTemplateSpecification launchTemplate;

        private Boolean protectedFromScaleIn;

        private String weightedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingInstanceDetails model) {
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            autoScalingGroupName(model.autoScalingGroupName);
            availabilityZone(model.availabilityZone);
            lifecycleState(model.lifecycleState);
            healthStatus(model.healthStatus);
            launchConfigurationName(model.launchConfigurationName);
            launchTemplate(model.launchTemplate);
            protectedFromScaleIn(model.protectedFromScaleIn);
            weightedCapacity(model.weightedCapacity);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Boolean getProtectedFromScaleIn() {
            return protectedFromScaleIn;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final String getWeightedCapacity() {
            return weightedCapacity;
        }

        public final void setWeightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        @Override
        public AutoScalingInstanceDetails build() {
            return new AutoScalingInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
