/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetricCollectionTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeMetricCollectionTypesResponse.Builder, DescribeMetricCollectionTypesResponse> {
    private static final SdkField<List<MetricCollectionType>> METRICS_FIELD = SdkField
            .<List<MetricCollectionType>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(DescribeMetricCollectionTypesResponse::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricCollectionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricCollectionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricGranularityType>> GRANULARITIES_FIELD = SdkField
            .<List<MetricGranularityType>> builder(MarshallingType.LIST)
            .memberName("Granularities")
            .getter(getter(DescribeMetricCollectionTypesResponse::granularities))
            .setter(setter(Builder::granularities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricGranularityType> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricGranularityType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD,
            GRANULARITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MetricCollectionType> metrics;

    private final List<MetricGranularityType> granularities;

    private DescribeMetricCollectionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.granularities = builder.granularities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics.
     */
    public final List<MetricCollectionType> metrics() {
        return metrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Granularities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGranularities() {
        return granularities != null && !(granularities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The granularities for the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGranularities} method.
     * </p>
     * 
     * @return The granularities for the metrics.
     */
    public final List<MetricGranularityType> granularities() {
        return granularities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGranularities() ? granularities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricCollectionTypesResponse)) {
            return false;
        }
        DescribeMetricCollectionTypesResponse other = (DescribeMetricCollectionTypesResponse) obj;
        return hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && hasGranularities() == other.hasGranularities() && Objects.equals(granularities(), other.granularities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetricCollectionTypesResponse").add("Metrics", hasMetrics() ? metrics() : null)
                .add("Granularities", hasGranularities() ? granularities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "Granularities":
            return Optional.ofNullable(clazz.cast(granularities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metrics", METRICS_FIELD);
        map.put("Granularities", GRANULARITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricCollectionTypesResponse, T> g) {
        return obj -> g.apply((DescribeMetricCollectionTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
        /**
         * <p>
         * The metrics.
         * </p>
         * 
         * @param metrics
         *        The metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<MetricCollectionType> metrics);

        /**
         * <p>
         * The metrics.
         * </p>
         * 
         * @param metrics
         *        The metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(MetricCollectionType... metrics);

        /**
         * <p>
         * The metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.MetricCollectionType.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.MetricCollectionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.MetricCollectionType.Builder#build()} is called
         * immediately and its result is passed to {@link #metrics(List<MetricCollectionType>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.MetricCollectionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<MetricCollectionType>)
         */
        Builder metrics(Consumer<MetricCollectionType.Builder>... metrics);

        /**
         * <p>
         * The granularities for the metrics.
         * </p>
         * 
         * @param granularities
         *        The granularities for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularities(Collection<MetricGranularityType> granularities);

        /**
         * <p>
         * The granularities for the metrics.
         * </p>
         * 
         * @param granularities
         *        The granularities for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularities(MetricGranularityType... granularities);

        /**
         * <p>
         * The granularities for the metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.MetricGranularityType.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.MetricGranularityType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.MetricGranularityType.Builder#build()} is called
         * immediately and its result is passed to {@link #granularities(List<MetricGranularityType>)}.
         * 
         * @param granularities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.MetricGranularityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #granularities(java.util.Collection<MetricGranularityType>)
         */
        Builder granularities(Consumer<MetricGranularityType.Builder>... granularities);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<MetricCollectionType> metrics = DefaultSdkAutoConstructList.getInstance();

        private List<MetricGranularityType> granularities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricCollectionTypesResponse model) {
            super(model);
            metrics(model.metrics);
            granularities(model.granularities);
        }

        public final List<MetricCollectionType.Builder> getMetrics() {
            List<MetricCollectionType.Builder> result = MetricCollectionTypesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricCollectionType.BuilderImpl> metrics) {
            this.metrics = MetricCollectionTypesCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<MetricCollectionType> metrics) {
            this.metrics = MetricCollectionTypesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricCollectionType... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricCollectionType.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> MetricCollectionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MetricGranularityType.Builder> getGranularities() {
            List<MetricGranularityType.Builder> result = MetricGranularityTypesCopier.copyToBuilder(this.granularities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGranularities(Collection<MetricGranularityType.BuilderImpl> granularities) {
            this.granularities = MetricGranularityTypesCopier.copyFromBuilder(granularities);
        }

        @Override
        public final Builder granularities(Collection<MetricGranularityType> granularities) {
            this.granularities = MetricGranularityTypesCopier.copy(granularities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(MetricGranularityType... granularities) {
            granularities(Arrays.asList(granularities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(Consumer<MetricGranularityType.Builder>... granularities) {
            granularities(Stream.of(granularities).map(c -> MetricGranularityType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMetricCollectionTypesResponse build() {
            return new DescribeMetricCollectionTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
