/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficSourceState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficSourceState> {
    private static final SdkField<String> TRAFFIC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficSource").getter(TrafficSourceState.getter(TrafficSourceState::trafficSource)).setter(TrafficSourceState.setter(Builder::trafficSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSource").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TrafficSourceState.getter(TrafficSourceState::state)).setter(TrafficSourceState.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(TrafficSourceState.getter(TrafficSourceState::identifier)).setter(TrafficSourceState.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TrafficSourceState.getter(TrafficSourceState::type)).setter(TrafficSourceState.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_SOURCE_FIELD, STATE_FIELD, IDENTIFIER_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrafficSourceState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trafficSource;
    private final String state;
    private final String identifier;
    private final String type;

    private TrafficSourceState(BuilderImpl builder) {
        this.trafficSource = builder.trafficSource;
        this.state = builder.state;
        this.identifier = builder.identifier;
        this.type = builder.type;
    }

    @Deprecated
    public final String trafficSource() {
        return this.trafficSource;
    }

    public final String state() {
        return this.state;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficSourceState)) {
            return false;
        }
        TrafficSourceState other = (TrafficSourceState)obj;
        return Objects.equals(this.trafficSource(), other.trafficSource()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficSourceState").add("TrafficSource", (Object)this.trafficSource()).add("State", (Object)this.state()).add("Identifier", (Object)this.identifier()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficSource": {
                return Optional.ofNullable(clazz.cast(this.trafficSource()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TrafficSource", TRAFFIC_SOURCE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficSourceState, T> g) {
        return obj -> g.apply((TrafficSourceState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficSource;
        private String state;
        private String identifier;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficSourceState model) {
            this.trafficSource(model.trafficSource);
            this.state(model.state);
            this.identifier(model.identifier);
            this.type(model.type);
        }

        @Deprecated
        public final String getTrafficSource() {
            return this.trafficSource;
        }

        @Deprecated
        public final void setTrafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
        }

        @Override
        @Deprecated
        public final Builder trafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public TrafficSourceState build() {
            return new TrafficSourceState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficSourceState> {
        @Deprecated
        public Builder trafficSource(String var1);

        public Builder state(String var1);

        public Builder identifier(String var1);

        public Builder type(String var1);
    }
}

