/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutoScalingGroupRequest extends AutoScalingRequest implements
        ToCopyableBuilder<CreateAutoScalingGroupRequest.Builder, CreateAutoScalingGroupRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(CreateAutoScalingGroupRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(CreateAutoScalingGroupRequest::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(CreateAutoScalingGroupRequest::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField
            .<MixedInstancesPolicy> builder(MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy")
            .getter(getter(CreateAutoScalingGroupRequest::mixedInstancesPolicy)).setter(setter(Builder::mixedInstancesPolicy))
            .constructor(MixedInstancesPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateAutoScalingGroupRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(CreateAutoScalingGroupRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(CreateAutoScalingGroupRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredCapacity").getter(getter(CreateAutoScalingGroupRequest::desiredCapacity))
            .setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultCooldown").getter(getter(CreateAutoScalingGroupRequest::defaultCooldown))
            .setter(setter(Builder::defaultCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(CreateAutoScalingGroupRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerNames")
            .getter(getter(CreateAutoScalingGroupRequest::loadBalancerNames))
            .setter(setter(Builder::loadBalancerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_GROUP_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetGroupARNs")
            .getter(getter(CreateAutoScalingGroupRequest::targetGroupARNs))
            .setter(setter(Builder::targetGroupARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckType").getter(getter(CreateAutoScalingGroupRequest::healthCheckType))
            .setter(setter(Builder::healthCheckType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckGracePeriod").getter(getter(CreateAutoScalingGroupRequest::healthCheckGracePeriod))
            .setter(setter(Builder::healthCheckGracePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build())
            .build();

    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementGroup").getter(getter(CreateAutoScalingGroupRequest::placementGroup))
            .setter(setter(Builder::placementGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()).build();

    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCZoneIdentifier").getter(getter(CreateAutoScalingGroupRequest::vpcZoneIdentifier))
            .setter(setter(Builder::vpcZoneIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()).build();

    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TerminationPolicies")
            .getter(getter(CreateAutoScalingGroupRequest::terminationPolicies))
            .setter(setter(Builder::terminationPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NewInstancesProtectedFromScaleIn")
            .getter(getter(CreateAutoScalingGroupRequest::newInstancesProtectedFromScaleIn))
            .setter(setter(Builder::newInstancesProtectedFromScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn")
                    .build()).build();

    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CapacityRebalance").getter(getter(CreateAutoScalingGroupRequest::capacityRebalance))
            .setter(setter(Builder::capacityRebalance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()).build();

    private static final SdkField<List<LifecycleHookSpecification>> LIFECYCLE_HOOK_SPECIFICATION_LIST_FIELD = SdkField
            .<List<LifecycleHookSpecification>> builder(MarshallingType.LIST)
            .memberName("LifecycleHookSpecificationList")
            .getter(getter(CreateAutoScalingGroupRequest::lifecycleHookSpecificationList))
            .setter(setter(Builder::lifecycleHookSpecificationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookSpecificationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecycleHookSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecycleHookSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAutoScalingGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceLinkedRoleARN").getter(getter(CreateAutoScalingGroupRequest::serviceLinkedRoleARN))
            .setter(setter(Builder::serviceLinkedRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build())
            .build();

    private static final SdkField<Integer> MAX_INSTANCE_LIFETIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInstanceLifetime").getter(getter(CreateAutoScalingGroupRequest::maxInstanceLifetime))
            .setter(setter(Builder::maxInstanceLifetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceLifetime").build())
            .build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Context")
            .getter(getter(CreateAutoScalingGroupRequest::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()).build();

    private static final SdkField<String> DESIRED_CAPACITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredCapacityType").getter(getter(CreateAutoScalingGroupRequest::desiredCapacityType))
            .setter(setter(Builder::desiredCapacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacityType").build())
            .build();

    private static final SdkField<Integer> DEFAULT_INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultInstanceWarmup").getter(getter(CreateAutoScalingGroupRequest::defaultInstanceWarmup))
            .setter(setter(Builder::defaultInstanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceWarmup").build())
            .build();

    private static final SdkField<List<TrafficSourceIdentifier>> TRAFFIC_SOURCES_FIELD = SdkField
            .<List<TrafficSourceIdentifier>> builder(MarshallingType.LIST)
            .memberName("TrafficSources")
            .getter(getter(CreateAutoScalingGroupRequest::trafficSources))
            .setter(setter(Builder::trafficSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrafficSourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficSourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceMaintenancePolicy> INSTANCE_MAINTENANCE_POLICY_FIELD = SdkField
            .<InstanceMaintenancePolicy> builder(MarshallingType.SDK_POJO).memberName("InstanceMaintenancePolicy")
            .getter(getter(CreateAutoScalingGroupRequest::instanceMaintenancePolicy))
            .setter(setter(Builder::instanceMaintenancePolicy)).constructor(InstanceMaintenancePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMaintenancePolicy").build())
            .build();

    private static final SdkField<AvailabilityZoneDistribution> AVAILABILITY_ZONE_DISTRIBUTION_FIELD = SdkField
            .<AvailabilityZoneDistribution> builder(MarshallingType.SDK_POJO)
            .memberName("AvailabilityZoneDistribution")
            .getter(getter(CreateAutoScalingGroupRequest::availabilityZoneDistribution))
            .setter(setter(Builder::availabilityZoneDistribution))
            .constructor(AvailabilityZoneDistribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneDistribution")
                    .build()).build();

    private static final SdkField<AvailabilityZoneImpairmentPolicy> AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD = SdkField
            .<AvailabilityZoneImpairmentPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("AvailabilityZoneImpairmentPolicy")
            .getter(getter(CreateAutoScalingGroupRequest::availabilityZoneImpairmentPolicy))
            .setter(setter(Builder::availabilityZoneImpairmentPolicy))
            .constructor(AvailabilityZoneImpairmentPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneImpairmentPolicy")
                    .build()).build();

    private static final SdkField<Boolean> SKIP_ZONAL_SHIFT_VALIDATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SkipZonalShiftValidation")
            .getter(getter(CreateAutoScalingGroupRequest::skipZonalShiftValidation))
            .setter(setter(Builder::skipZonalShiftValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipZonalShiftValidation").build())
            .build();

    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<CapacityReservationSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(CreateAutoScalingGroupRequest::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(CapacityReservationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIXED_INSTANCES_POLICY_FIELD, INSTANCE_ID_FIELD,
            MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD, AVAILABILITY_ZONES_FIELD,
            LOAD_BALANCER_NAMES_FIELD, TARGET_GROUP_AR_NS_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD,
            PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, TERMINATION_POLICIES_FIELD,
            NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, CAPACITY_REBALANCE_FIELD, LIFECYCLE_HOOK_SPECIFICATION_LIST_FIELD,
            TAGS_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD, MAX_INSTANCE_LIFETIME_FIELD, CONTEXT_FIELD, DESIRED_CAPACITY_TYPE_FIELD,
            DEFAULT_INSTANCE_WARMUP_FIELD, TRAFFIC_SOURCES_FIELD, INSTANCE_MAINTENANCE_POLICY_FIELD,
            AVAILABILITY_ZONE_DISTRIBUTION_FIELD, AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD, SKIP_ZONAL_SHIFT_VALIDATION_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String autoScalingGroupName;

    private final String launchConfigurationName;

    private final LaunchTemplateSpecification launchTemplate;

    private final MixedInstancesPolicy mixedInstancesPolicy;

    private final String instanceId;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final Integer defaultCooldown;

    private final List<String> availabilityZones;

    private final List<String> loadBalancerNames;

    private final List<String> targetGroupARNs;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final String placementGroup;

    private final String vpcZoneIdentifier;

    private final List<String> terminationPolicies;

    private final Boolean newInstancesProtectedFromScaleIn;

    private final Boolean capacityRebalance;

    private final List<LifecycleHookSpecification> lifecycleHookSpecificationList;

    private final List<Tag> tags;

    private final String serviceLinkedRoleARN;

    private final Integer maxInstanceLifetime;

    private final String context;

    private final String desiredCapacityType;

    private final Integer defaultInstanceWarmup;

    private final List<TrafficSourceIdentifier> trafficSources;

    private final InstanceMaintenancePolicy instanceMaintenancePolicy;

    private final AvailabilityZoneDistribution availabilityZoneDistribution;

    private final AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy;

    private final Boolean skipZonalShiftValidation;

    private final CapacityReservationSpecification capacityReservationSpecification;

    private CreateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.instanceId = builder.instanceId;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.capacityRebalance = builder.capacityRebalance;
        this.lifecycleHookSpecificationList = builder.lifecycleHookSpecificationList;
        this.tags = builder.tags;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
        this.maxInstanceLifetime = builder.maxInstanceLifetime;
        this.context = builder.context;
        this.desiredCapacityType = builder.desiredCapacityType;
        this.defaultInstanceWarmup = builder.defaultInstanceWarmup;
        this.trafficSources = builder.trafficSources;
        this.instanceMaintenancePolicy = builder.instanceMaintenancePolicy;
        this.availabilityZoneDistribution = builder.availabilityZoneDistribution;
        this.availabilityZoneImpairmentPolicy = builder.availabilityZoneImpairmentPolicy;
        this.skipZonalShiftValidation = builder.skipZonalShiftValidation;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
    }

    /**
     * <p>
     * The name of the Auto Scaling group. This name must be unique per Region per account.
     * </p>
     * <p>
     * The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and
     * lowercased letters.
     * </p>
     * <note>
     * <p>
     * You cannot use a colon (:) in the name.
     * </p>
     * </note>
     * 
     * @return The name of the Auto Scaling group. This name must be unique per Region per account.</p>
     *         <p>
     *         The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and
     *         upper and lowercased letters.
     *         </p>
     *         <note>
     *         <p>
     *         You cannot use a colon (:) in the name.
     *         </p>
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the launch configuration to use to launch instances.
     * </p>
     * <p>
     * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     * <code>InstanceId</code>).
     * </p>
     * 
     * @return The name of the launch configuration to use to launch instances. </p>
     *         <p>
     *         Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     *         <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     *         <code>InstanceId</code>).
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * Information used to specify the launch template and version to use to launch instances.
     * </p>
     * <p>
     * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     * <code>InstanceId</code>).
     * </p>
     * <note>
     * <p>
     * The launch template that is specified must be configured for use with an Auto Scaling group. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Create a launch template
     * for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * </note>
     * 
     * @return Information used to specify the launch template and version to use to launch instances. </p>
     *         <p>
     *         Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     *         <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     *         <code>InstanceId</code>).
     *         </p>
     *         <note>
     *         <p>
     *         The launch template that is specified must be configured for use with an Auto Scaling group. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Create a launch
     *         template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The mixed instances policy. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto
     * Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * 
     * @return The mixed instances policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
     *         >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto
     *         Scaling User Guide</i>.
     */
    public final MixedInstancesPolicy mixedInstancesPolicy() {
        return mixedInstancesPolicy;
    }

    /**
     * <p>
     * The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the
     * configuration values from the specified instance to create a new launch configuration. To get the instance ID,
     * use the Amazon EC2 <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a>
     * API operation. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Create an Auto Scaling
     * group using parameters from an existing instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling
     *         uses the configuration values from the specified instance to create a new launch configuration. To get
     *         the instance ID, use the Amazon EC2 <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
     *         >DescribeInstances</a> API operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Create an Auto
     *         Scaling group using parameters from an existing instance</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The minimum size of the group.
     * </p>
     * 
     * @return The minimum size of the group.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the group.
     * </p>
     * <note>
     * <p>
     * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
     * <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go
     * above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each
     * instance contributes to the desired capacity of the group).
     * </p>
     * </note>
     * 
     * @return The maximum size of the group.</p> <note>
     *         <p>
     *         With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
     *         <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will
     *         never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how
     *         many units each instance contributes to the desired capacity of the group).
     *         </p>
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the
     * capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number
     * must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the
     * group. If you do not specify a desired capacity, the default is the minimum size of the group.
     * </p>
     * 
     * @return The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and
     *         the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling.
     *         This number must be greater than or equal to the minimum size of the group and less than or equal to the
     *         maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of
     *         the group.
     */
    public final Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * <i>Only needed if you use simple scaling policies.</i>
     * </p>
     * <p>
     * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple
     * scaling policies. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html">Scaling
     * cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Default: <code>300</code> seconds
     * </p>
     * 
     * @return <i>Only needed if you use simple scaling policies.</i> </p>
     *         <p>
     *         The amount of time, in seconds, between one scaling activity ending and another one starting due to
     *         simple scaling policies. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html"
     *         >Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>300</code> seconds
     */
    public final Integer defaultCooldown() {
        return defaultCooldown;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into
     * the default VPC subnet in each Availability Zone when not using the <code>VPCZoneIdentifier</code> property, or
     * for attaching a network interface when an existing network interface ID is specified in a launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching
     *         into the default VPC subnet in each Availability Zone when not using the <code>VPCZoneIdentifier</code>
     *         property, or for attaching a network interface when an existing network interface ID is specified in a
     *         launch template.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancerNames() {
        return loadBalancerNames != null && !(loadBalancerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network
     * Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerNames} method.
     * </p>
     * 
     * @return A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers,
     *         Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property
     *         instead.
     */
    public final List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetGroupARNs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetGroupARNs() {
        return targetGroupARNs != null && !(targetGroupARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling
     * group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and
     * route requests to one or more registered targets. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
     * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetGroupARNs} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto
     *         Scaling group. Instances are registered as targets with the target groups. The target groups receive
     *         incoming traffic and route requests to one or more registered targets. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic
     *         Load Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon
     *         EC2 Auto Scaling User Guide</i>.
     */
    public final List<String> targetGroupARNs() {
        return targetGroupARNs;
    }

    /**
     * <p>
     * A comma-separated value string of one or more health check types.
     * </p>
     * <p>
     * The valid values are <code>EC2</code>, <code>EBS</code>, <code>ELB</code>, and <code>VPC_LATTICE</code>.
     * <code>EC2</code> is the default health check and cannot be disabled. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html">Health checks
     * for instances in an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Only specify <code>EC2</code> if you must clear a value that was previously set.
     * </p>
     * 
     * @return A comma-separated value string of one or more health check types.</p>
     *         <p>
     *         The valid values are <code>EC2</code>, <code>EBS</code>, <code>ELB</code>, and <code>VPC_LATTICE</code>.
     *         <code>EC2</code> is the default health check and cannot be disabled. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html">Health
     *         checks for instances in an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         Only specify <code>EC2</code> if you must clear a value that was previously set.
     */
    public final String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2
     * instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your
     * instances do not immediately pass their health checks after they enter the <code>InService</code> state. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html">Set the health check
     * grace period for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Default: <code>0</code> seconds
     * </p>
     * 
     * @return The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of
     *         an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is
     *         useful if your instances do not immediately pass their health checks after they enter the
     *         <code>InService</code> state. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html">Set the
     *         health check grace period for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.</p>
     *         <p>
     *         Default: <code>0</code> seconds
     */
    public final Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * The name of the placement group into which to launch your instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <note>
     * <p>
     * A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot
     * specify multiple Availability Zones and a cluster placement group.
     * </p>
     * </note>
     * 
     * @return The name of the placement group into which to launch your instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in
     *         the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
     *         <p>
     *         A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone.
     *         You cannot specify multiple Availability Zones and a cluster placement group.
     *         </p>
     */
    public final String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group
     * can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets
     * that you specify must reside in those Availability Zones.
     * </p>
     * 
     * @return A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto
     *         Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with
     *         <code>AvailabilityZones</code>, the subnets that you specify must reside in those Availability Zones.
     */
    public final String vpcZoneIdentifier() {
        return vpcZoneIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerminationPolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerminationPolicies() {
        return terminationPolicies != null && !(terminationPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A policy or a list of policies that are used to select the instance to terminate. These policies are executed in
     * the order that you list them. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html">Configure
     * termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Valid values: <code>Default</code> | <code>AllocationStrategy</code> | <code>ClosestToNextInstanceHour</code> |
     * <code>NewestInstance</code> | <code>OldestInstance</code> | <code>OldestLaunchConfiguration</code> |
     * <code>OldestLaunchTemplate</code> | <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerminationPolicies} method.
     * </p>
     * 
     * @return A policy or a list of policies that are used to select the instance to terminate. These policies are
     *         executed in the order that you list them. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
     *         >Configure termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.</p>
     *         <p>
     *         Valid values: <code>Default</code> | <code>AllocationStrategy</code> |
     *         <code>ClosestToNextInstanceHour</code> | <code>NewestInstance</code> | <code>OldestInstance</code> |
     *         <code>OldestLaunchConfiguration</code> | <code>OldestLaunchTemplate</code> |
     *         <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
     */
    public final List<String> terminationPolicies() {
        return terminationPolicies;
    }

    /**
     * <p>
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling
     * in. For more information about preventing instances from terminating on scale in, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Use
     * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
     *         scaling in. For more information about preventing instances from terminating on scale in, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html"
     *         >Use instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean newInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    /**
     * <p>
     * Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on
     * Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies
     * that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates
     * an old instance. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Use
     * Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * 
     * @return Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you
     *         turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon
     *         EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance,
     *         it then terminates an old instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html"
     *         >Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the in the <i>Amazon EC2 Auto
     *         Scaling User Guide</i>.
     */
    public final Boolean capacityRebalance() {
        return capacityRebalance;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecycleHookSpecificationList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLifecycleHookSpecificationList() {
        return lifecycleHookSpecificationList != null && !(lifecycleHookSpecificationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecycleHookSpecificationList} method.
     * </p>
     * 
     * @return One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
     */
    public final List<LifecycleHookSpecification> lifecycleHookSpecificationList() {
        return lifecycleHookSpecificationList;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
     * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a
     * launch template but use caution. If the launch template specifies an instance tag with a key that is also
     * specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the
     * value specified by the Auto Scaling group. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
     * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances
     *         it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify
     *         the tags in a launch template but use caution. If the launch template specifies an instance tag with a
     *         key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of
     *         that instance tag with the value specified by the Auto Scaling group. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto
     *         Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon
     * Web Services service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named
     * <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked
     * roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other
     *         Amazon Web Services service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked
     *         role named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html"
     *         >Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String serviceLinkedRoleARN() {
        return serviceLinkedRoleARN;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified,
     * the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see
     * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replace Auto
     * Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
     *         specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replace Auto
     *         Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final Integer maxInstanceLifetime() {
        return maxInstanceLifetime;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
     * <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html"
     * >Create a mixed instances group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto
     * Scaling User Guide</i>.
     * </p>
     * <p>
     * By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.
     * </p>
     * <p>
     * Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
     * </p>
     * 
     * @return The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
     *         <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html"
     *         >Create a mixed instances group using attribute-based instance type selection</a> in the <i>Amazon EC2
     *         Auto Scaling User Guide</i>.</p>
     *         <p>
     *         By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
     *         instances.
     *         </p>
     *         <p>
     *         Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
     */
    public final String desiredCapacityType() {
        return desiredCapacityType;
    }

    /**
     * <p>
     * The amount of time, in seconds, until a new instance is considered to have finished initializing and resource
     * consumption to become stable after it enters the <code>InService</code> state.
     * </p>
     * <p>
     * During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance
     * before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period
     * before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that
     * are used for scaling, resulting in more reliable usage data. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set
     * the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To manage various warm-up settings at the group level, we recommend that you set the default instance warmup,
     * <i>even if it is set to 0 seconds</i>. To remove a value that you previously set, include the property but
     * specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled
     * by specifying a value of <code>0</code> or other nominal value.
     * </p>
     * </important>
     * <p>
     * Default: None
     * </p>
     * 
     * @return The amount of time, in seconds, until a new instance is considered to have finished initializing and
     *         resource consumption to become stable after it enters the <code>InService</code> state. </p>
     *         <p>
     *         During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an
     *         instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the
     *         warm-up period before aggregating the metrics for new instances with existing instances in the Amazon
     *         CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set
     *         the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     *         </p>
     *         <important>
     *         <p>
     *         To manage various warm-up settings at the group level, we recommend that you set the default instance
     *         warmup, <i>even if it is set to 0 seconds</i>. To remove a value that you previously set, include the
     *         property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default
     *         instance warmup enabled by specifying a value of <code>0</code> or other nominal value.
     *         </p>
     *         </important>
     *         <p>
     *         Default: None
     */
    public final Integer defaultInstanceWarmup() {
        return defaultInstanceWarmup;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrafficSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrafficSources() {
        return trafficSources != null && !(trafficSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as traffic
     * sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway Load Balancer,
     * Network Load Balancer, and VPC Lattice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrafficSources} method.
     * </p>
     * 
     * @return The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as
     *         traffic sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway Load
     *         Balancer, Network Load Balancer, and VPC Lattice.
     */
    public final List<TrafficSourceIdentifier> trafficSources() {
        return trafficSources;
    }

    /**
     * <p>
     * An instance maintenance policy. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html"
     * >Set instance maintenance policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return An instance maintenance policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html"
     *         >Set instance maintenance policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final InstanceMaintenancePolicy instanceMaintenancePolicy() {
        return instanceMaintenancePolicy;
    }

    /**
     * <p>
     * The instance capacity distribution across Availability Zones.
     * </p>
     * 
     * @return The instance capacity distribution across Availability Zones.
     */
    public final AvailabilityZoneDistribution availabilityZoneDistribution() {
        return availabilityZoneDistribution;
    }

    /**
     * <p>
     * The policy for Availability Zone impairment.
     * </p>
     * 
     * @return The policy for Availability Zone impairment.
     */
    public final AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy() {
        return availabilityZoneImpairmentPolicy;
    }

    /**
     * <p>
     * If you enable zonal shift with cross-zone disabled load balancers, capacity could become imbalanced across
     * Availability Zones. To skip the validation, specify <code>true</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto Scaling group
     * zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return If you enable zonal shift with cross-zone disabled load balancers, capacity could become imbalanced
     *         across Availability Zones. To skip the validation, specify <code>true</code>. For more information, see
     *         <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto
     *         Scaling group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean skipZonalShiftValidation() {
        return skipZonalShiftValidation;
    }

    /**
     * <p>
     * The capacity reservation specification for the Auto Scaling group.
     * </p>
     * 
     * @return The capacity reservation specification for the Auto Scaling group.
     */
    public final CapacityReservationSpecification capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerNames() ? loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroupARNs() ? targetGroupARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminationPolicies() ? terminationPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(capacityRebalance());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLifecycleHookSpecificationList() ? lifecycleHookSpecificationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceLinkedRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(maxInstanceLifetime());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacityType());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrafficSources() ? trafficSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceMaintenancePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneImpairmentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(skipZonalShiftValidation());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoScalingGroupRequest)) {
            return false;
        }
        CreateAutoScalingGroupRequest other = (CreateAutoScalingGroupRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(mixedInstancesPolicy(), other.mixedInstancesPolicy())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(desiredCapacity(), other.desiredCapacity())
                && Objects.equals(defaultCooldown(), other.defaultCooldown())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasLoadBalancerNames() == other.hasLoadBalancerNames()
                && Objects.equals(loadBalancerNames(), other.loadBalancerNames())
                && hasTargetGroupARNs() == other.hasTargetGroupARNs()
                && Objects.equals(targetGroupARNs(), other.targetGroupARNs())
                && Objects.equals(healthCheckType(), other.healthCheckType())
                && Objects.equals(healthCheckGracePeriod(), other.healthCheckGracePeriod())
                && Objects.equals(placementGroup(), other.placementGroup())
                && Objects.equals(vpcZoneIdentifier(), other.vpcZoneIdentifier())
                && hasTerminationPolicies() == other.hasTerminationPolicies()
                && Objects.equals(terminationPolicies(), other.terminationPolicies())
                && Objects.equals(newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn())
                && Objects.equals(capacityRebalance(), other.capacityRebalance())
                && hasLifecycleHookSpecificationList() == other.hasLifecycleHookSpecificationList()
                && Objects.equals(lifecycleHookSpecificationList(), other.lifecycleHookSpecificationList())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(serviceLinkedRoleARN(), other.serviceLinkedRoleARN())
                && Objects.equals(maxInstanceLifetime(), other.maxInstanceLifetime())
                && Objects.equals(context(), other.context())
                && Objects.equals(desiredCapacityType(), other.desiredCapacityType())
                && Objects.equals(defaultInstanceWarmup(), other.defaultInstanceWarmup())
                && hasTrafficSources() == other.hasTrafficSources() && Objects.equals(trafficSources(), other.trafficSources())
                && Objects.equals(instanceMaintenancePolicy(), other.instanceMaintenancePolicy())
                && Objects.equals(availabilityZoneDistribution(), other.availabilityZoneDistribution())
                && Objects.equals(availabilityZoneImpairmentPolicy(), other.availabilityZoneImpairmentPolicy())
                && Objects.equals(skipZonalShiftValidation(), other.skipZonalShiftValidation())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateAutoScalingGroupRequest")
                .add("AutoScalingGroupName", autoScalingGroupName())
                .add("LaunchConfigurationName", launchConfigurationName())
                .add("LaunchTemplate", launchTemplate())
                .add("MixedInstancesPolicy", mixedInstancesPolicy())
                .add("InstanceId", instanceId())
                .add("MinSize", minSize())
                .add("MaxSize", maxSize())
                .add("DesiredCapacity", desiredCapacity())
                .add("DefaultCooldown", defaultCooldown())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("LoadBalancerNames", hasLoadBalancerNames() ? loadBalancerNames() : null)
                .add("TargetGroupARNs", hasTargetGroupARNs() ? targetGroupARNs() : null)
                .add("HealthCheckType", healthCheckType())
                .add("HealthCheckGracePeriod", healthCheckGracePeriod())
                .add("PlacementGroup", placementGroup())
                .add("VPCZoneIdentifier", vpcZoneIdentifier())
                .add("TerminationPolicies", hasTerminationPolicies() ? terminationPolicies() : null)
                .add("NewInstancesProtectedFromScaleIn", newInstancesProtectedFromScaleIn())
                .add("CapacityRebalance", capacityRebalance())
                .add("LifecycleHookSpecificationList",
                        hasLifecycleHookSpecificationList() ? lifecycleHookSpecificationList() : null)
                .add("Tags", hasTags() ? tags() : null).add("ServiceLinkedRoleARN", serviceLinkedRoleARN())
                .add("MaxInstanceLifetime", maxInstanceLifetime()).add("Context", context())
                .add("DesiredCapacityType", desiredCapacityType()).add("DefaultInstanceWarmup", defaultInstanceWarmup())
                .add("TrafficSources", hasTrafficSources() ? trafficSources() : null)
                .add("InstanceMaintenancePolicy", instanceMaintenancePolicy())
                .add("AvailabilityZoneDistribution", availabilityZoneDistribution())
                .add("AvailabilityZoneImpairmentPolicy", availabilityZoneImpairmentPolicy())
                .add("SkipZonalShiftValidation", skipZonalShiftValidation())
                .add("CapacityReservationSpecification", capacityReservationSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "MixedInstancesPolicy":
            return Optional.ofNullable(clazz.cast(mixedInstancesPolicy()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "DefaultCooldown":
            return Optional.ofNullable(clazz.cast(defaultCooldown()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "LoadBalancerNames":
            return Optional.ofNullable(clazz.cast(loadBalancerNames()));
        case "TargetGroupARNs":
            return Optional.ofNullable(clazz.cast(targetGroupARNs()));
        case "HealthCheckType":
            return Optional.ofNullable(clazz.cast(healthCheckType()));
        case "HealthCheckGracePeriod":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriod()));
        case "PlacementGroup":
            return Optional.ofNullable(clazz.cast(placementGroup()));
        case "VPCZoneIdentifier":
            return Optional.ofNullable(clazz.cast(vpcZoneIdentifier()));
        case "TerminationPolicies":
            return Optional.ofNullable(clazz.cast(terminationPolicies()));
        case "NewInstancesProtectedFromScaleIn":
            return Optional.ofNullable(clazz.cast(newInstancesProtectedFromScaleIn()));
        case "CapacityRebalance":
            return Optional.ofNullable(clazz.cast(capacityRebalance()));
        case "LifecycleHookSpecificationList":
            return Optional.ofNullable(clazz.cast(lifecycleHookSpecificationList()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ServiceLinkedRoleARN":
            return Optional.ofNullable(clazz.cast(serviceLinkedRoleARN()));
        case "MaxInstanceLifetime":
            return Optional.ofNullable(clazz.cast(maxInstanceLifetime()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "DesiredCapacityType":
            return Optional.ofNullable(clazz.cast(desiredCapacityType()));
        case "DefaultInstanceWarmup":
            return Optional.ofNullable(clazz.cast(defaultInstanceWarmup()));
        case "TrafficSources":
            return Optional.ofNullable(clazz.cast(trafficSources()));
        case "InstanceMaintenancePolicy":
            return Optional.ofNullable(clazz.cast(instanceMaintenancePolicy()));
        case "AvailabilityZoneDistribution":
            return Optional.ofNullable(clazz.cast(availabilityZoneDistribution()));
        case "AvailabilityZoneImpairmentPolicy":
            return Optional.ofNullable(clazz.cast(availabilityZoneImpairmentPolicy()));
        case "SkipZonalShiftValidation":
            return Optional.ofNullable(clazz.cast(skipZonalShiftValidation()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("LaunchConfigurationName", LAUNCH_CONFIGURATION_NAME_FIELD);
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("MixedInstancesPolicy", MIXED_INSTANCES_POLICY_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("MinSize", MIN_SIZE_FIELD);
        map.put("MaxSize", MAX_SIZE_FIELD);
        map.put("DesiredCapacity", DESIRED_CAPACITY_FIELD);
        map.put("DefaultCooldown", DEFAULT_COOLDOWN_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("LoadBalancerNames", LOAD_BALANCER_NAMES_FIELD);
        map.put("TargetGroupARNs", TARGET_GROUP_AR_NS_FIELD);
        map.put("HealthCheckType", HEALTH_CHECK_TYPE_FIELD);
        map.put("HealthCheckGracePeriod", HEALTH_CHECK_GRACE_PERIOD_FIELD);
        map.put("PlacementGroup", PLACEMENT_GROUP_FIELD);
        map.put("VPCZoneIdentifier", VPC_ZONE_IDENTIFIER_FIELD);
        map.put("TerminationPolicies", TERMINATION_POLICIES_FIELD);
        map.put("NewInstancesProtectedFromScaleIn", NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD);
        map.put("CapacityRebalance", CAPACITY_REBALANCE_FIELD);
        map.put("LifecycleHookSpecificationList", LIFECYCLE_HOOK_SPECIFICATION_LIST_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ServiceLinkedRoleARN", SERVICE_LINKED_ROLE_ARN_FIELD);
        map.put("MaxInstanceLifetime", MAX_INSTANCE_LIFETIME_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("DesiredCapacityType", DESIRED_CAPACITY_TYPE_FIELD);
        map.put("DefaultInstanceWarmup", DEFAULT_INSTANCE_WARMUP_FIELD);
        map.put("TrafficSources", TRAFFIC_SOURCES_FIELD);
        map.put("InstanceMaintenancePolicy", INSTANCE_MAINTENANCE_POLICY_FIELD);
        map.put("AvailabilityZoneDistribution", AVAILABILITY_ZONE_DISTRIBUTION_FIELD);
        map.put("AvailabilityZoneImpairmentPolicy", AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD);
        map.put("SkipZonalShiftValidation", SKIP_ZONAL_SHIFT_VALIDATION_FIELD);
        map.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoScalingGroupRequest, T> g) {
        return obj -> g.apply((CreateAutoScalingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group. This name must be unique per Region per account.
         * </p>
         * <p>
         * The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper
         * and lowercased letters.
         * </p>
         * <note>
         * <p>
         * You cannot use a colon (:) in the name.
         * </p>
         * </note>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group. This name must be unique per Region per account.</p>
         *        <p>
         *        The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and
         *        upper and lowercased letters.
         *        </p>
         *        <note>
         *        <p>
         *        You cannot use a colon (:) in the name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the launch configuration to use to launch instances.
         * </p>
         * <p>
         * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         * <code>InstanceId</code>).
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration to use to launch instances. </p>
         *        <p>
         *        Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         *        <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         *        <code>InstanceId</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * Information used to specify the launch template and version to use to launch instances.
         * </p>
         * <p>
         * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         * <code>InstanceId</code>).
         * </p>
         * <note>
         * <p>
         * The launch template that is specified must be configured for use with an Auto Scaling group. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Create a launch
         * template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * </note>
         * 
         * @param launchTemplate
         *        Information used to specify the launch template and version to use to launch instances. </p>
         *        <p>
         *        Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         *        <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         *        <code>InstanceId</code>).
         *        </p>
         *        <note>
         *        <p>
         *        The launch template that is specified must be configured for use with an Auto Scaling group. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Create a
         *        launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * Information used to specify the launch template and version to use to launch instances.
         * </p>
         * <p>
         * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         * <code>InstanceId</code>).
         * </p>
         * <note>
         * <p>
         * The launch template that is specified must be configured for use with an Auto Scaling group. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Create a launch
         * template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link LaunchTemplateSpecification.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The mixed instances policy. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         * >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling
         * User Guide</i>.
         * </p>
         * 
         * @param mixedInstancesPolicy
         *        The mixed instances policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         *        >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto
         *        Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy);

        /**
         * <p>
         * The mixed instances policy. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html"
         * >Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling
         * User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MixedInstancesPolicy.Builder} avoiding
         * the need to create one manually via {@link MixedInstancesPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MixedInstancesPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #mixedInstancesPolicy(MixedInstancesPolicy)}.
         * 
         * @param mixedInstancesPolicy
         *        a consumer that will call methods on {@link MixedInstancesPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedInstancesPolicy(MixedInstancesPolicy)
         */
        default Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return mixedInstancesPolicy(MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy).build());
        }

        /**
         * <p>
         * The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses
         * the configuration values from the specified instance to create a new launch configuration. To get the
         * instance ID, use the Amazon EC2 <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
         * >DescribeInstances</a> API operation. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Create an Auto
         * Scaling group using parameters from an existing instance</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling
         *        uses the configuration values from the specified instance to create a new launch configuration. To get
         *        the instance ID, use the Amazon EC2 <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
         *        >DescribeInstances</a> API operation. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Create an
         *        Auto Scaling group using parameters from an existing instance</a> in the <i>Amazon EC2 Auto Scaling
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The minimum size of the group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the group.
         * </p>
         * <note>
         * <p>
         * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
         * <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go
         * above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each
         * instance contributes to the desired capacity of the group).
         * </p>
         * </note>
         * 
         * @param maxSize
         *        The maximum size of the group.</p> <note>
         *        <p>
         *        With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go
         *        above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling
         *        will never go above <code>MaxSize</code> by more than your largest instance weight (weights that
         *        define how many units each instance contributes to the desired capacity of the group).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the
         * capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This
         * number must be greater than or equal to the minimum size of the group and less than or equal to the maximum
         * size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and
         *        the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling.
         *        This number must be greater than or equal to the minimum size of the group and less than or equal to
         *        the maximum size of the group. If you do not specify a desired capacity, the default is the minimum
         *        size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * <i>Only needed if you use simple scaling policies.</i>
         * </p>
         * <p>
         * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple
         * scaling policies. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html">Scaling
         * cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Default: <code>300</code> seconds
         * </p>
         * 
         * @param defaultCooldown
         *        <i>Only needed if you use simple scaling policies.</i> </p>
         *        <p>
         *        The amount of time, in seconds, between one scaling activity ending and another one starting due to
         *        simple scaling policies. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html"
         *        >Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>300</code> seconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCooldown(Integer defaultCooldown);

        /**
         * <p>
         * A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching
         * into the default VPC subnet in each Availability Zone when not using the <code>VPCZoneIdentifier</code>
         * property, or for attaching a network interface when an existing network interface ID is specified in a launch
         * template.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for
         *        launching into the default VPC subnet in each Availability Zone when not using the
         *        <code>VPCZoneIdentifier</code> property, or for attaching a network interface when an existing network
         *        interface ID is specified in a launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching
         * into the default VPC subnet in each Availability Zone when not using the <code>VPCZoneIdentifier</code>
         * property, or for attaching a network interface when an existing network interface ID is specified in a launch
         * template.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for
         *        launching into the default VPC subnet in each Availability Zone when not using the
         *        <code>VPCZoneIdentifier</code> property, or for attaching a network interface when an existing network
         *        interface ID is specified in a launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers,
         * Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property
         * instead.
         * </p>
         * 
         * @param loadBalancerNames
         *        A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load
         *        Balancers, Network Load Balancers, and Gateway Load Balancers, specify the
         *        <code>TargetGroupARNs</code> property instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers,
         * Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property
         * instead.
         * </p>
         * 
         * @param loadBalancerNames
         *        A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load
         *        Balancers, Network Load Balancers, and Gateway Load Balancers, specify the
         *        <code>TargetGroupARNs</code> property instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto
         * Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming
         * traffic and route requests to one or more registered targets. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
         * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
         * Scaling User Guide</i>.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto
         *        Scaling group. Instances are registered as targets with the target groups. The target groups receive
         *        incoming traffic and route requests to one or more registered targets. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use
         *        Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group</a> in
         *        the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(Collection<String> targetGroupARNs);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto
         * Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming
         * traffic and route requests to one or more registered targets. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use Elastic Load
         * Balancing to distribute traffic across the instances in your Auto Scaling group</a> in the <i>Amazon EC2 Auto
         * Scaling User Guide</i>.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto
         *        Scaling group. Instances are registered as targets with the target groups. The target groups receive
         *        incoming traffic and route requests to one or more registered targets. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Use
         *        Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group</a> in
         *        the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(String... targetGroupARNs);

        /**
         * <p>
         * A comma-separated value string of one or more health check types.
         * </p>
         * <p>
         * The valid values are <code>EC2</code>, <code>EBS</code>, <code>ELB</code>, and <code>VPC_LATTICE</code>.
         * <code>EC2</code> is the default health check and cannot be disabled. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html">Health
         * checks for instances in an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Only specify <code>EC2</code> if you must clear a value that was previously set.
         * </p>
         * 
         * @param healthCheckType
         *        A comma-separated value string of one or more health check types.</p>
         *        <p>
         *        The valid values are <code>EC2</code>, <code>EBS</code>, <code>ELB</code>, and
         *        <code>VPC_LATTICE</code>. <code>EC2</code> is the default health check and cannot be disabled. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html"
         *        >Health checks for instances in an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        Only specify <code>EC2</code> if you must clear a value that was previously set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an
         * EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful
         * if your instances do not immediately pass their health checks after they enter the <code>InService</code>
         * state. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html">Set the health
         * check grace period for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Default: <code>0</code> seconds
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status
         *        of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.
         *        This is useful if your instances do not immediately pass their health checks after they enter the
         *        <code>InService</code> state. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html">Set the
         *        health check grace period for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.</p>
         *        <p>
         *        Default: <code>0</code> seconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * The name of the placement group into which to launch your instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * <note>
         * <p>
         * A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You
         * cannot specify multiple Availability Zones and a cluster placement group.
         * </p>
         * </note>
         * 
         * @param placementGroup
         *        The name of the placement group into which to launch your instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a>
         *        in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
         *        <p>
         *        A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone.
         *        You cannot specify multiple Availability Zones and a cluster placement group.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling
         * group can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the
         * subnets that you specify must reside in those Availability Zones.
         * </p>
         * 
         * @param vpcZoneIdentifier
         *        A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto
         *        Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with
         *        <code>AvailabilityZones</code>, the subnets that you specify must reside in those Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcZoneIdentifier(String vpcZoneIdentifier);

        /**
         * <p>
         * A policy or a list of policies that are used to select the instance to terminate. These policies are executed
         * in the order that you list them. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
         * >Configure termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>Default</code> | <code>AllocationStrategy</code> | <code>ClosestToNextInstanceHour</code>
         * | <code>NewestInstance</code> | <code>OldestInstance</code> | <code>OldestLaunchConfiguration</code> |
         * <code>OldestLaunchTemplate</code> |
         * <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * </p>
         * 
         * @param terminationPolicies
         *        A policy or a list of policies that are used to select the instance to terminate. These policies are
         *        executed in the order that you list them. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
         *        >Configure termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.</p>
         *        <p>
         *        Valid values: <code>Default</code> | <code>AllocationStrategy</code> |
         *        <code>ClosestToNextInstanceHour</code> | <code>NewestInstance</code> | <code>OldestInstance</code> |
         *        <code>OldestLaunchConfiguration</code> | <code>OldestLaunchTemplate</code> |
         *        <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(Collection<String> terminationPolicies);

        /**
         * <p>
         * A policy or a list of policies that are used to select the instance to terminate. These policies are executed
         * in the order that you list them. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
         * >Configure termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>Default</code> | <code>AllocationStrategy</code> | <code>ClosestToNextInstanceHour</code>
         * | <code>NewestInstance</code> | <code>OldestInstance</code> | <code>OldestLaunchConfiguration</code> |
         * <code>OldestLaunchTemplate</code> |
         * <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * </p>
         * 
         * @param terminationPolicies
         *        A policy or a list of policies that are used to select the instance to terminate. These policies are
         *        executed in the order that you list them. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html"
         *        >Configure termination policies for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.</p>
         *        <p>
         *        Valid values: <code>Default</code> | <code>AllocationStrategy</code> |
         *        <code>ClosestToNextInstanceHour</code> | <code>NewestInstance</code> | <code>OldestInstance</code> |
         *        <code>OldestLaunchConfiguration</code> | <code>OldestLaunchTemplate</code> |
         *        <code>arn:aws:lambda:region:account-id:function:my-function:my-alias</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(String... terminationPolicies);

        /**
         * <p>
         * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
         * scaling in. For more information about preventing instances from terminating on scale in, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Use
         * instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param newInstancesProtectedFromScaleIn
         *        Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
         *        when scaling in. For more information about preventing instances from terminating on scale in, see <a
         *        href
         *        ="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Use
         *        instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn);

        /**
         * <p>
         * Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn
         * on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2
         * notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then
         * terminates an old instance. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Use
         * Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the in the <i>Amazon EC2 Auto Scaling
         * User Guide</i>.
         * </p>
         * 
         * @param capacityRebalance
         *        Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When
         *        you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever
         *        Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new
         *        instance, it then terminates an old instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Use
         *        Capacity Rebalancing to handle Amazon EC2 Spot Interruptions</a> in the in the <i>Amazon EC2 Auto
         *        Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRebalance(Boolean capacityRebalance);

        /**
         * <p>
         * One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
         * </p>
         * 
         * @param lifecycleHookSpecificationList
         *        One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
         * </p>
         * 
         * @param lifecycleHookSpecificationList
         *        One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookSpecificationList(LifecycleHookSpecification... lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #lifecycleHookSpecificationList(List<LifecycleHookSpecification>)}.
         * 
         * @param lifecycleHookSpecificationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleHookSpecificationList(java.util.Collection<LifecycleHookSpecification>)
         */
        Builder lifecycleHookSpecificationList(Consumer<LifecycleHookSpecification.Builder>... lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
         * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
         * in a launch template but use caution. If the launch template specifies an instance tag with a key that is
         * also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag
         * with the value specified by the Auto Scaling group. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
         * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param tags
         *        One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2
         *        instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS
         *        volumes, specify the tags in a launch template but use caution. If the launch template specifies an
         *        instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling
         *        overrides the value of that instance tag with the value specified by the Auto Scaling group. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto
         *        Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
         * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
         * in a launch template but use caution. If the launch template specifies an instance tag with a key that is
         * also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag
         * with the value specified by the Auto Scaling group. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
         * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param tags
         *        One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2
         *        instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS
         *        volumes, specify the tags in a launch template but use caution. If the launch template specifies an
         *        instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling
         *        overrides the value of that instance tag with the value specified by the Auto Scaling group. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto
         *        Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
         * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
         * in a launch template but use caution. If the launch template specifies an instance tag with a key that is
         * also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag
         * with the value specified by the Auto Scaling group. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html">Tag Auto Scaling
         * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.autoscaling.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other
         * Amazon Web Services service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role
         * named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service
         * -linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param serviceLinkedRoleARN
         *        The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call
         *        other Amazon Web Services service on your behalf. By default, Amazon EC2 Auto Scaling uses a
         *        service-linked role named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not
         *        exist. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html"
         *        >Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkedRoleARN(String serviceLinkedRoleARN);

        /**
         * <p>
         * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
         * specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replace Auto
         * Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param maxInstanceLifetime
         *        The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
         *        specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replace
         *        Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceLifetime(Integer maxInstanceLifetime);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param context
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
         * <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html"
         * >Create a mixed instances group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto
         * Scaling User Guide</i>.
         * </p>
         * <p>
         * By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.
         * </p>
         * <p>
         * Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
         * </p>
         * 
         * @param desiredCapacityType
         *        The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports
         *        <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html"
         *        >Create a mixed instances group using attribute-based instance type selection</a> in the <i>Amazon EC2
         *        Auto Scaling User Guide</i>.</p>
         *        <p>
         *        By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
         *        instances.
         *        </p>
         *        <p>
         *        Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacityType(String desiredCapacityType);

        /**
         * <p>
         * The amount of time, in seconds, until a new instance is considered to have finished initializing and resource
         * consumption to become stable after it enters the <code>InService</code> state.
         * </p>
         * <p>
         * During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an
         * instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the
         * warm-up period before aggregating the metrics for new instances with existing instances in the Amazon
         * CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html"
         * >Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * <important>
         * <p>
         * To manage various warm-up settings at the group level, we recommend that you set the default instance warmup,
         * <i>even if it is set to 0 seconds</i>. To remove a value that you previously set, include the property but
         * specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup
         * enabled by specifying a value of <code>0</code> or other nominal value.
         * </p>
         * </important>
         * <p>
         * Default: None
         * </p>
         * 
         * @param defaultInstanceWarmup
         *        The amount of time, in seconds, until a new instance is considered to have finished initializing and
         *        resource consumption to become stable after it enters the <code>InService</code> state. </p>
         *        <p>
         *        During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an
         *        instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the
         *        warm-up period before aggregating the metrics for new instances with existing instances in the Amazon
         *        CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html"
         *        >Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         *        </p>
         *        <important>
         *        <p>
         *        To manage various warm-up settings at the group level, we recommend that you set the default instance
         *        warmup, <i>even if it is set to 0 seconds</i>. To remove a value that you previously set, include the
         *        property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default
         *        instance warmup enabled by specifying a value of <code>0</code> or other nominal value.
         *        </p>
         *        </important>
         *        <p>
         *        Default: None
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceWarmup(Integer defaultInstanceWarmup);

        /**
         * <p>
         * The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as traffic
         * sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway Load Balancer,
         * Network Load Balancer, and VPC Lattice.
         * </p>
         * 
         * @param trafficSources
         *        The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as
         *        traffic sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway
         *        Load Balancer, Network Load Balancer, and VPC Lattice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources);

        /**
         * <p>
         * The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as traffic
         * sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway Load Balancer,
         * Network Load Balancer, and VPC Lattice.
         * </p>
         * 
         * @param trafficSources
         *        The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as
         *        traffic sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway
         *        Load Balancer, Network Load Balancer, and VPC Lattice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(TrafficSourceIdentifier... trafficSources);

        /**
         * <p>
         * The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as traffic
         * sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway Load Balancer,
         * Network Load Balancer, and VPC Lattice.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #trafficSources(List<TrafficSourceIdentifier>)}.
         * 
         * @param trafficSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficSources(java.util.Collection<TrafficSourceIdentifier>)
         */
        Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder>... trafficSources);

        /**
         * <p>
         * An instance maintenance policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html">Set
         * instance maintenance policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param instanceMaintenancePolicy
         *        An instance maintenance policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html"
         *        >Set instance maintenance policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMaintenancePolicy(InstanceMaintenancePolicy instanceMaintenancePolicy);

        /**
         * <p>
         * An instance maintenance policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html">Set
         * instance maintenance policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMaintenancePolicy.Builder}
         * avoiding the need to create one manually via {@link InstanceMaintenancePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMaintenancePolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceMaintenancePolicy(InstanceMaintenancePolicy)}.
         * 
         * @param instanceMaintenancePolicy
         *        a consumer that will call methods on {@link InstanceMaintenancePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMaintenancePolicy(InstanceMaintenancePolicy)
         */
        default Builder instanceMaintenancePolicy(Consumer<InstanceMaintenancePolicy.Builder> instanceMaintenancePolicy) {
            return instanceMaintenancePolicy(InstanceMaintenancePolicy.builder().applyMutation(instanceMaintenancePolicy).build());
        }

        /**
         * <p>
         * The instance capacity distribution across Availability Zones.
         * </p>
         * 
         * @param availabilityZoneDistribution
         *        The instance capacity distribution across Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneDistribution(AvailabilityZoneDistribution availabilityZoneDistribution);

        /**
         * <p>
         * The instance capacity distribution across Availability Zones.
         * </p>
         * This is a convenience method that creates an instance of the {@link AvailabilityZoneDistribution.Builder}
         * avoiding the need to create one manually via {@link AvailabilityZoneDistribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailabilityZoneDistribution.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityZoneDistribution(AvailabilityZoneDistribution)}.
         * 
         * @param availabilityZoneDistribution
         *        a consumer that will call methods on {@link AvailabilityZoneDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZoneDistribution(AvailabilityZoneDistribution)
         */
        default Builder availabilityZoneDistribution(Consumer<AvailabilityZoneDistribution.Builder> availabilityZoneDistribution) {
            return availabilityZoneDistribution(AvailabilityZoneDistribution.builder()
                    .applyMutation(availabilityZoneDistribution).build());
        }

        /**
         * <p>
         * The policy for Availability Zone impairment.
         * </p>
         * 
         * @param availabilityZoneImpairmentPolicy
         *        The policy for Availability Zone impairment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy);

        /**
         * <p>
         * The policy for Availability Zone impairment.
         * </p>
         * This is a convenience method that creates an instance of the {@link AvailabilityZoneImpairmentPolicy.Builder}
         * avoiding the need to create one manually via {@link AvailabilityZoneImpairmentPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailabilityZoneImpairmentPolicy.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy)}.
         * 
         * @param availabilityZoneImpairmentPolicy
         *        a consumer that will call methods on {@link AvailabilityZoneImpairmentPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy)
         */
        default Builder availabilityZoneImpairmentPolicy(
                Consumer<AvailabilityZoneImpairmentPolicy.Builder> availabilityZoneImpairmentPolicy) {
            return availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy.builder()
                    .applyMutation(availabilityZoneImpairmentPolicy).build());
        }

        /**
         * <p>
         * If you enable zonal shift with cross-zone disabled load balancers, capacity could become imbalanced across
         * Availability Zones. To skip the validation, specify <code>true</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto Scaling
         * group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param skipZonalShiftValidation
         *        If you enable zonal shift with cross-zone disabled load balancers, capacity could become imbalanced
         *        across Availability Zones. To skip the validation, specify <code>true</code>. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html">Auto
         *        Scaling group zonal shift</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipZonalShiftValidation(Boolean skipZonalShiftValidation);

        /**
         * <p>
         * The capacity reservation specification for the Auto Scaling group.
         * </p>
         * 
         * @param capacityReservationSpecification
         *        The capacity reservation specification for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification);

        /**
         * <p>
         * The capacity reservation specification for the Auto Scaling group.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservationSpecification.Builder}
         * avoiding the need to create one manually via {@link CapacityReservationSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #capacityReservationSpecification(CapacityReservationSpecification)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on {@link CapacityReservationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(CapacityReservationSpecification)
         */
        default Builder capacityReservationSpecification(
                Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(CapacityReservationSpecification.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String launchConfigurationName;

        private LaunchTemplateSpecification launchTemplate;

        private MixedInstancesPolicy mixedInstancesPolicy;

        private String instanceId;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private Integer defaultCooldown;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private String placementGroup;

        private String vpcZoneIdentifier;

        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();

        private Boolean newInstancesProtectedFromScaleIn;

        private Boolean capacityRebalance;

        private List<LifecycleHookSpecification> lifecycleHookSpecificationList = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String serviceLinkedRoleARN;

        private Integer maxInstanceLifetime;

        private String context;

        private String desiredCapacityType;

        private Integer defaultInstanceWarmup;

        private List<TrafficSourceIdentifier> trafficSources = DefaultSdkAutoConstructList.getInstance();

        private InstanceMaintenancePolicy instanceMaintenancePolicy;

        private AvailabilityZoneDistribution availabilityZoneDistribution;

        private AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy;

        private Boolean skipZonalShiftValidation;

        private CapacityReservationSpecification capacityReservationSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoScalingGroupRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            launchConfigurationName(model.launchConfigurationName);
            launchTemplate(model.launchTemplate);
            mixedInstancesPolicy(model.mixedInstancesPolicy);
            instanceId(model.instanceId);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
            defaultCooldown(model.defaultCooldown);
            availabilityZones(model.availabilityZones);
            loadBalancerNames(model.loadBalancerNames);
            targetGroupARNs(model.targetGroupARNs);
            healthCheckType(model.healthCheckType);
            healthCheckGracePeriod(model.healthCheckGracePeriod);
            placementGroup(model.placementGroup);
            vpcZoneIdentifier(model.vpcZoneIdentifier);
            terminationPolicies(model.terminationPolicies);
            newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            capacityRebalance(model.capacityRebalance);
            lifecycleHookSpecificationList(model.lifecycleHookSpecificationList);
            tags(model.tags);
            serviceLinkedRoleARN(model.serviceLinkedRoleARN);
            maxInstanceLifetime(model.maxInstanceLifetime);
            context(model.context);
            desiredCapacityType(model.desiredCapacityType);
            defaultInstanceWarmup(model.defaultInstanceWarmup);
            trafficSources(model.trafficSources);
            instanceMaintenancePolicy(model.instanceMaintenancePolicy);
            availabilityZoneDistribution(model.availabilityZoneDistribution);
            availabilityZoneImpairmentPolicy(model.availabilityZoneImpairmentPolicy);
            skipZonalShiftValidation(model.skipZonalShiftValidation);
            capacityReservationSpecification(model.capacityReservationSpecification);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return mixedInstancesPolicy != null ? mixedInstancesPolicy.toBuilder() : null;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final Integer getDefaultCooldown() {
            return defaultCooldown;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getLoadBalancerNames() {
            if (loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancerNames;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final Collection<String> getTargetGroupARNs() {
            if (targetGroupARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return targetGroupARNs;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String... targetGroupARNs) {
            targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final String getVpcZoneIdentifier() {
            return vpcZoneIdentifier;
        }

        public final void setVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final Collection<String> getTerminationPolicies() {
            if (terminationPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return terminationPolicies;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return newInstancesProtectedFromScaleIn;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final Boolean getCapacityRebalance() {
            return capacityRebalance;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public final List<LifecycleHookSpecification.Builder> getLifecycleHookSpecificationList() {
            List<LifecycleHookSpecification.Builder> result = LifecycleHookSpecificationsCopier
                    .copyToBuilder(this.lifecycleHookSpecificationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecycleHookSpecificationList(
                Collection<LifecycleHookSpecification.BuilderImpl> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier
                    .copyFromBuilder(lifecycleHookSpecificationList);
        }

        @Override
        public final Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier.copy(lifecycleHookSpecificationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(LifecycleHookSpecification... lifecycleHookSpecificationList) {
            lifecycleHookSpecificationList(Arrays.asList(lifecycleHookSpecificationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(
                Consumer<LifecycleHookSpecification.Builder>... lifecycleHookSpecificationList) {
            lifecycleHookSpecificationList(Stream.of(lifecycleHookSpecificationList)
                    .map(c -> LifecycleHookSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceLinkedRoleARN() {
            return serviceLinkedRoleARN;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final Integer getMaxInstanceLifetime() {
            return maxInstanceLifetime;
        }

        public final void setMaxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
        }

        @Override
        public final Builder maxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getDesiredCapacityType() {
            return desiredCapacityType;
        }

        public final void setDesiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
        }

        @Override
        public final Builder desiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
            return this;
        }

        public final Integer getDefaultInstanceWarmup() {
            return defaultInstanceWarmup;
        }

        public final void setDefaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
        }

        @Override
        public final Builder defaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
            return this;
        }

        public final List<TrafficSourceIdentifier.Builder> getTrafficSources() {
            List<TrafficSourceIdentifier.Builder> result = TrafficSourcesCopier.copyToBuilder(this.trafficSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficSources(Collection<TrafficSourceIdentifier.BuilderImpl> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copyFromBuilder(trafficSources);
        }

        @Override
        public final Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copy(trafficSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(TrafficSourceIdentifier... trafficSources) {
            trafficSources(Arrays.asList(trafficSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder>... trafficSources) {
            trafficSources(Stream.of(trafficSources).map(c -> TrafficSourceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceMaintenancePolicy.Builder getInstanceMaintenancePolicy() {
            return instanceMaintenancePolicy != null ? instanceMaintenancePolicy.toBuilder() : null;
        }

        public final void setInstanceMaintenancePolicy(InstanceMaintenancePolicy.BuilderImpl instanceMaintenancePolicy) {
            this.instanceMaintenancePolicy = instanceMaintenancePolicy != null ? instanceMaintenancePolicy.build() : null;
        }

        @Override
        public final Builder instanceMaintenancePolicy(InstanceMaintenancePolicy instanceMaintenancePolicy) {
            this.instanceMaintenancePolicy = instanceMaintenancePolicy;
            return this;
        }

        public final AvailabilityZoneDistribution.Builder getAvailabilityZoneDistribution() {
            return availabilityZoneDistribution != null ? availabilityZoneDistribution.toBuilder() : null;
        }

        public final void setAvailabilityZoneDistribution(AvailabilityZoneDistribution.BuilderImpl availabilityZoneDistribution) {
            this.availabilityZoneDistribution = availabilityZoneDistribution != null ? availabilityZoneDistribution.build()
                    : null;
        }

        @Override
        public final Builder availabilityZoneDistribution(AvailabilityZoneDistribution availabilityZoneDistribution) {
            this.availabilityZoneDistribution = availabilityZoneDistribution;
            return this;
        }

        public final AvailabilityZoneImpairmentPolicy.Builder getAvailabilityZoneImpairmentPolicy() {
            return availabilityZoneImpairmentPolicy != null ? availabilityZoneImpairmentPolicy.toBuilder() : null;
        }

        public final void setAvailabilityZoneImpairmentPolicy(
                AvailabilityZoneImpairmentPolicy.BuilderImpl availabilityZoneImpairmentPolicy) {
            this.availabilityZoneImpairmentPolicy = availabilityZoneImpairmentPolicy != null ? availabilityZoneImpairmentPolicy
                    .build() : null;
        }

        @Override
        public final Builder availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy) {
            this.availabilityZoneImpairmentPolicy = availabilityZoneImpairmentPolicy;
            return this;
        }

        public final Boolean getSkipZonalShiftValidation() {
            return skipZonalShiftValidation;
        }

        public final void setSkipZonalShiftValidation(Boolean skipZonalShiftValidation) {
            this.skipZonalShiftValidation = skipZonalShiftValidation;
        }

        @Override
        public final Builder skipZonalShiftValidation(Boolean skipZonalShiftValidation) {
            this.skipZonalShiftValidation = skipZonalShiftValidation;
            return this;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(
                CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoScalingGroupRequest build() {
            return new CreateAutoScalingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
