/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrafficSourcesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeTrafficSourcesResponse.Builder, DescribeTrafficSourcesResponse> {
    private static final SdkField<List<TrafficSourceState>> TRAFFIC_SOURCES_FIELD = SdkField
            .<List<TrafficSourceState>> builder(MarshallingType.LIST)
            .memberName("TrafficSources")
            .getter(getter(DescribeTrafficSourcesResponse::trafficSources))
            .setter(setter(Builder::trafficSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrafficSourceState> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficSourceState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeTrafficSourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_SOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TrafficSourceState> trafficSources;

    private final String nextToken;

    private DescribeTrafficSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.trafficSources = builder.trafficSources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrafficSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrafficSources() {
        return trafficSources != null && !(trafficSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the traffic sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrafficSources} method.
     * </p>
     * 
     * @return Information about the traffic sources.
     */
    public final List<TrafficSourceState> trafficSources() {
        return trafficSources;
    }

    /**
     * <p>
     * This string indicates that the response contains more items than can be returned in a single response. To receive
     * additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items.
     * This value is null when there are no more items to return.
     * </p>
     * 
     * @return This string indicates that the response contains more items than can be returned in a single response. To
     *         receive additional items, specify this string for the <code>NextToken</code> value when requesting the
     *         next set of items. This value is null when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrafficSources() ? trafficSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficSourcesResponse)) {
            return false;
        }
        DescribeTrafficSourcesResponse other = (DescribeTrafficSourcesResponse) obj;
        return hasTrafficSources() == other.hasTrafficSources() && Objects.equals(trafficSources(), other.trafficSources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrafficSourcesResponse")
                .add("TrafficSources", hasTrafficSources() ? trafficSources() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficSources":
            return Optional.ofNullable(clazz.cast(trafficSources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficSources", TRAFFIC_SOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficSourcesResponse, T> g) {
        return obj -> g.apply((DescribeTrafficSourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrafficSourcesResponse> {
        /**
         * <p>
         * Information about the traffic sources.
         * </p>
         * 
         * @param trafficSources
         *        Information about the traffic sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(Collection<TrafficSourceState> trafficSources);

        /**
         * <p>
         * Information about the traffic sources.
         * </p>
         * 
         * @param trafficSources
         *        Information about the traffic sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficSources(TrafficSourceState... trafficSources);

        /**
         * <p>
         * Information about the traffic sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceState.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceState.Builder#build()} is called
         * immediately and its result is passed to {@link #trafficSources(List<TrafficSourceState>)}.
         * 
         * @param trafficSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.TrafficSourceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficSources(java.util.Collection<TrafficSourceState>)
         */
        Builder trafficSources(Consumer<TrafficSourceState.Builder>... trafficSources);

        /**
         * <p>
         * This string indicates that the response contains more items than can be returned in a single response. To
         * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next
         * set of items. This value is null when there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        This string indicates that the response contains more items than can be returned in a single response.
         *        To receive additional items, specify this string for the <code>NextToken</code> value when requesting
         *        the next set of items. This value is null when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<TrafficSourceState> trafficSources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficSourcesResponse model) {
            super(model);
            trafficSources(model.trafficSources);
            nextToken(model.nextToken);
        }

        public final List<TrafficSourceState.Builder> getTrafficSources() {
            List<TrafficSourceState.Builder> result = TrafficSourceStatesCopier.copyToBuilder(this.trafficSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficSources(Collection<TrafficSourceState.BuilderImpl> trafficSources) {
            this.trafficSources = TrafficSourceStatesCopier.copyFromBuilder(trafficSources);
        }

        @Override
        public final Builder trafficSources(Collection<TrafficSourceState> trafficSources) {
            this.trafficSources = TrafficSourceStatesCopier.copy(trafficSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(TrafficSourceState... trafficSources) {
            trafficSources(Arrays.asList(trafficSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(Consumer<TrafficSourceState.Builder>... trafficSources) {
            trafficSources(Stream.of(trafficSources).map(c -> TrafficSourceState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTrafficSourcesResponse build() {
            return new DescribeTrafficSourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
