/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.AutoScalingServiceClientConfiguration;
import software.amazon.awssdk.services.autoscaling.internal.AutoScalingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.autoscaling.model.ActiveInstanceRefreshNotFoundException;
import software.amazon.awssdk.services.autoscaling.model.AlreadyExistsException;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachTrafficSourcesResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastRequest;
import software.amazon.awssdk.services.autoscaling.model.GetPredictiveScalingForecastResponse;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshInProgressException;
import software.amazon.awssdk.services.autoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscaling.model.IrreversibleInstanceRefreshException;
import software.amazon.awssdk.services.autoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.PutWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.PutWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResourceContentionException;
import software.amazon.awssdk.services.autoscaling.model.ResourceInUseException;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.RollbackInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityInProgressException;
import software.amazon.awssdk.services.autoscaling.model.ServiceLinkedRoleFailureException;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.transform.AttachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachTrafficSourcesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchDeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchPutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CancelInstanceRefreshRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CompleteLifecycleActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateOrUpdateTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteWarmPoolRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAdjustmentTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingNotificationTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeInstanceRefreshesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLaunchConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHookTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHooksRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeMetricCollectionTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeNotificationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribePoliciesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingActivitiesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingProcessTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTerminationPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTrafficSourcesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeWarmPoolRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachTrafficSourcesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DisableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnterStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExecutePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExitStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.GetPredictiveScalingForecastRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutWarmPoolRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.RecordLifecycleActionHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ResumeProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.RollbackInstanceRefreshRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetDesiredCapacityRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceProtectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.StartInstanceRefreshRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SuspendProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.UpdateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.waiters.AutoScalingWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAutoScalingClient
implements AutoScalingClient {
    private static final Logger log = Logger.loggerFor(DefaultAutoScalingClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.QUERY).build();
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAutoScalingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Auto_Scaling#2.31.78").build();
        this.protocolFactory = this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachInstancesResponse attachInstances(AttachInstancesRequest attachInstancesRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, attachInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachInstances");
            AttachInstancesResponse attachInstancesResponse = (AttachInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachInstancesRequestMarshaller(this.protocolFactory)));
            return attachInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$attachInstances$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroups(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachLoadBalancerTargetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, attachLoadBalancerTargetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancerTargetGroups");
            AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroupsResponse = (AttachLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerTargetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachLoadBalancerTargetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
            return attachLoadBalancerTargetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$attachLoadBalancerTargetGroups$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachLoadBalancersResponse attachLoadBalancers(AttachLoadBalancersRequest attachLoadBalancersRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachLoadBalancersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, attachLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancers");
            AttachLoadBalancersResponse attachLoadBalancersResponse = (AttachLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachLoadBalancersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachLoadBalancersRequestMarshaller(this.protocolFactory)));
            return attachLoadBalancersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$attachLoadBalancers$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachTrafficSourcesResponse attachTrafficSources(AttachTrafficSourcesRequest attachTrafficSourcesRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachTrafficSourcesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachTrafficSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, attachTrafficSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachTrafficSources");
            AttachTrafficSourcesResponse attachTrafficSourcesResponse = (AttachTrafficSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachTrafficSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachTrafficSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachTrafficSourcesRequestMarshaller(this.protocolFactory)));
            return attachTrafficSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$attachTrafficSources$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteScheduledActionResponse batchDeleteScheduledAction(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchDeleteScheduledActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, batchDeleteScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteScheduledAction");
            BatchDeleteScheduledActionResponse batchDeleteScheduledActionResponse = (BatchDeleteScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteScheduledActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteScheduledActionRequestMarshaller(this.protocolFactory)));
            return batchDeleteScheduledActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$batchDeleteScheduledAction$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutScheduledUpdateGroupActionResponse batchPutScheduledUpdateGroupAction(BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchPutScheduledUpdateGroupActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchPutScheduledUpdateGroupActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, batchPutScheduledUpdateGroupActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutScheduledUpdateGroupAction");
            BatchPutScheduledUpdateGroupActionResponse batchPutScheduledUpdateGroupActionResponse = (BatchPutScheduledUpdateGroupActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutScheduledUpdateGroupAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchPutScheduledUpdateGroupActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)));
            return batchPutScheduledUpdateGroupActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$batchPutScheduledUpdateGroupAction$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelInstanceRefreshResponse cancelInstanceRefresh(CancelInstanceRefreshRequest cancelInstanceRefreshRequest) throws LimitExceededException, ResourceContentionException, ActiveInstanceRefreshNotFoundException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CancelInstanceRefreshResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelInstanceRefreshRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, cancelInstanceRefreshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelInstanceRefresh");
            CancelInstanceRefreshResponse cancelInstanceRefreshResponse = (CancelInstanceRefreshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelInstanceRefresh").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelInstanceRefreshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelInstanceRefreshRequestMarshaller(this.protocolFactory)));
            return cancelInstanceRefreshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$cancelInstanceRefresh$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteLifecycleActionResponse completeLifecycleAction(CompleteLifecycleActionRequest completeLifecycleActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CompleteLifecycleActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)completeLifecycleActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, completeLifecycleActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompleteLifecycleAction");
            CompleteLifecycleActionResponse completeLifecycleActionResponse = (CompleteLifecycleActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteLifecycleAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)completeLifecycleActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CompleteLifecycleActionRequestMarshaller(this.protocolFactory)));
            return completeLifecycleActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$completeLifecycleAction$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAutoScalingGroupResponse createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAutoScalingGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, createAutoScalingGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAutoScalingGroup");
            CreateAutoScalingGroupResponse createAutoScalingGroupResponse = (CreateAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAutoScalingGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAutoScalingGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return createAutoScalingGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$createAutoScalingGroup$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLaunchConfigurationResponse createLaunchConfiguration(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLaunchConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, createLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLaunchConfiguration");
            CreateLaunchConfigurationResponse createLaunchConfigurationResponse = (CreateLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLaunchConfigurationRequestMarshaller(this.protocolFactory)));
            return createLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$createLaunchConfiguration$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOrUpdateTagsResponse createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) throws LimitExceededException, AlreadyExistsException, ResourceContentionException, ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateOrUpdateTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createOrUpdateTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, createOrUpdateTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOrUpdateTags");
            CreateOrUpdateTagsResponse createOrUpdateTagsResponse = (CreateOrUpdateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrUpdateTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createOrUpdateTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateOrUpdateTagsRequestMarshaller(this.protocolFactory)));
            return createOrUpdateTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$createOrUpdateTags$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAutoScalingGroupResponse deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAutoScalingGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deleteAutoScalingGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAutoScalingGroup");
            DeleteAutoScalingGroupResponse deleteAutoScalingGroupResponse = (DeleteAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoScalingGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAutoScalingGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return deleteAutoScalingGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deleteAutoScalingGroup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLaunchConfigurationResponse deleteLaunchConfiguration(DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLaunchConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deleteLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLaunchConfiguration");
            DeleteLaunchConfigurationResponse deleteLaunchConfigurationResponse = (DeleteLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLaunchConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deleteLaunchConfiguration$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLifecycleHookResponse deleteLifecycleHook(DeleteLifecycleHookRequest deleteLifecycleHookRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLifecycleHookResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLifecycleHookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deleteLifecycleHookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLifecycleHook");
            DeleteLifecycleHookResponse deleteLifecycleHookResponse = (DeleteLifecycleHookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLifecycleHook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLifecycleHookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLifecycleHookRequestMarshaller(this.protocolFactory)));
            return deleteLifecycleHookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deleteLifecycleHook$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNotificationConfigurationResponse deleteNotificationConfiguration(DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteNotificationConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNotificationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deleteNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNotificationConfiguration");
            DeleteNotificationConfigurationResponse deleteNotificationConfigurationResponse = (DeleteNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotificationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteNotificationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNotificationConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteNotificationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deleteNotificationConfiguration$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deletePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicy");
            DeletePolicyResponse deletePolicyResponse = (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller(this.protocolFactory)));
            return deletePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deletePolicy$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScheduledActionResponse deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteScheduledActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deleteScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledAction");
            DeleteScheduledActionResponse deleteScheduledActionResponse = (DeleteScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteScheduledActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller(this.protocolFactory)));
            return deleteScheduledActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deleteScheduledAction$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceContentionException, ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deleteTags$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWarmPoolResponse deleteWarmPool(DeleteWarmPoolRequest deleteWarmPoolRequest) throws LimitExceededException, ResourceContentionException, ScalingActivityInProgressException, ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteWarmPoolResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWarmPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, deleteWarmPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWarmPool");
            DeleteWarmPoolResponse deleteWarmPoolResponse = (DeleteWarmPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWarmPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWarmPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWarmPoolRequestMarshaller(this.protocolFactory)));
            return deleteWarmPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$deleteWarmPool$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountLimits");
            DescribeAccountLimitsResponse describeAccountLimitsResponse = (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAccountLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
            return describeAccountLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeAccountLimits$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAdjustmentTypesResponse describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAdjustmentTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAdjustmentTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeAdjustmentTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAdjustmentTypes");
            DescribeAdjustmentTypesResponse describeAdjustmentTypesResponse = (DescribeAdjustmentTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAdjustmentTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAdjustmentTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAdjustmentTypesRequestMarshaller(this.protocolFactory)));
            return describeAdjustmentTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeAdjustmentTypes$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingGroupsResponse describeAutoScalingGroups(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAutoScalingGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeAutoScalingGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoScalingGroups");
            DescribeAutoScalingGroupsResponse describeAutoScalingGroupsResponse = (DescribeAutoScalingGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAutoScalingGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoScalingGroupsRequestMarshaller(this.protocolFactory)));
            return describeAutoScalingGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeAutoScalingGroups$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingInstancesResponse describeAutoScalingInstances(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAutoScalingInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeAutoScalingInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoScalingInstances");
            DescribeAutoScalingInstancesResponse describeAutoScalingInstancesResponse = (DescribeAutoScalingInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAutoScalingInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoScalingInstancesRequestMarshaller(this.protocolFactory)));
            return describeAutoScalingInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeAutoScalingInstances$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingNotificationTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAutoScalingNotificationTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeAutoScalingNotificationTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoScalingNotificationTypes");
            DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypesResponse = (DescribeAutoScalingNotificationTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingNotificationTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAutoScalingNotificationTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoScalingNotificationTypesRequestMarshaller(this.protocolFactory)));
            return describeAutoScalingNotificationTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeAutoScalingNotificationTypes$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceRefreshesResponse describeInstanceRefreshes(DescribeInstanceRefreshesRequest describeInstanceRefreshesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstanceRefreshesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInstanceRefreshesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeInstanceRefreshesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInstanceRefreshes");
            DescribeInstanceRefreshesResponse describeInstanceRefreshesResponse = (DescribeInstanceRefreshesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceRefreshes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInstanceRefreshesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInstanceRefreshesRequestMarshaller(this.protocolFactory)));
            return describeInstanceRefreshesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeInstanceRefreshes$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLaunchConfigurationsResponse describeLaunchConfigurations(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLaunchConfigurationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLaunchConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeLaunchConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLaunchConfigurations");
            DescribeLaunchConfigurationsResponse describeLaunchConfigurationsResponse = (DescribeLaunchConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLaunchConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLaunchConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLaunchConfigurationsRequestMarshaller(this.protocolFactory)));
            return describeLaunchConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeLaunchConfigurations$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLifecycleHookTypesResponse describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHookTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLifecycleHookTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeLifecycleHookTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLifecycleHookTypes");
            DescribeLifecycleHookTypesResponse describeLifecycleHookTypesResponse = (DescribeLifecycleHookTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHookTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLifecycleHookTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLifecycleHookTypesRequestMarshaller(this.protocolFactory)));
            return describeLifecycleHookTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeLifecycleHookTypes$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLifecycleHooksResponse describeLifecycleHooks(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHooksResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLifecycleHooksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeLifecycleHooksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLifecycleHooks");
            DescribeLifecycleHooksResponse describeLifecycleHooksResponse = (DescribeLifecycleHooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHooks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLifecycleHooksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLifecycleHooksRequestMarshaller(this.protocolFactory)));
            return describeLifecycleHooksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeLifecycleHooks$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoadBalancerTargetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeLoadBalancerTargetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerTargetGroups");
            DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroupsResponse = (DescribeLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerTargetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLoadBalancerTargetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancerTargetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeLoadBalancerTargetGroups$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoadBalancersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancers");
            DescribeLoadBalancersResponse describeLoadBalancersResponse = (DescribeLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLoadBalancersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeLoadBalancers$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetricCollectionTypesResponse describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeMetricCollectionTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMetricCollectionTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeMetricCollectionTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetricCollectionTypes");
            DescribeMetricCollectionTypesResponse describeMetricCollectionTypesResponse = (DescribeMetricCollectionTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricCollectionTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMetricCollectionTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetricCollectionTypesRequestMarshaller(this.protocolFactory)));
            return describeMetricCollectionTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeMetricCollectionTypes$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNotificationConfigurationsResponse describeNotificationConfigurations(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeNotificationConfigurationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNotificationConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeNotificationConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNotificationConfigurations");
            DescribeNotificationConfigurationsResponse describeNotificationConfigurationsResponse = (DescribeNotificationConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNotificationConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeNotificationConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNotificationConfigurationsRequestMarshaller(this.protocolFactory)));
            return describeNotificationConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeNotificationConfigurations$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePoliciesResponse describePolicies(DescribePoliciesRequest describePoliciesRequest) throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePolicies");
            DescribePoliciesResponse describePoliciesResponse = (DescribePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePoliciesRequestMarshaller(this.protocolFactory)));
            return describePoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describePolicies$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingActivitiesResponse describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingActivitiesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScalingActivitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeScalingActivitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingActivities");
            DescribeScalingActivitiesResponse describeScalingActivitiesResponse = (DescribeScalingActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingActivities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeScalingActivitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingActivitiesRequestMarshaller(this.protocolFactory)));
            return describeScalingActivitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeScalingActivities$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingProcessTypesResponse describeScalingProcessTypes(DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingProcessTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScalingProcessTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeScalingProcessTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingProcessTypes");
            DescribeScalingProcessTypesResponse describeScalingProcessTypesResponse = (DescribeScalingProcessTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingProcessTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeScalingProcessTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingProcessTypesRequestMarshaller(this.protocolFactory)));
            return describeScalingProcessTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeScalingProcessTypes$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScheduledActionsResponse describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScheduledActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScheduledActionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeScheduledActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledActions");
            DescribeScheduledActionsResponse describeScheduledActionsResponse = (DescribeScheduledActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeScheduledActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller(this.protocolFactory)));
            return describeScheduledActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeScheduledActions$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeTags$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTerminationPolicyTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTerminationPolicyTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeTerminationPolicyTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTerminationPolicyTypes");
            DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypesResponse = (DescribeTerminationPolicyTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTerminationPolicyTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTerminationPolicyTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTerminationPolicyTypesRequestMarshaller(this.protocolFactory)));
            return describeTerminationPolicyTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeTerminationPolicyTypes$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrafficSourcesResponse describeTrafficSources(DescribeTrafficSourcesRequest describeTrafficSourcesRequest) throws ResourceContentionException, InvalidNextTokenException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTrafficSourcesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrafficSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeTrafficSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrafficSources");
            DescribeTrafficSourcesResponse describeTrafficSourcesResponse = (DescribeTrafficSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrafficSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrafficSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrafficSourcesRequestMarshaller(this.protocolFactory)));
            return describeTrafficSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeTrafficSources$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWarmPoolResponse describeWarmPool(DescribeWarmPoolRequest describeWarmPoolRequest) throws InvalidNextTokenException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeWarmPoolResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeWarmPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, describeWarmPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWarmPool");
            DescribeWarmPoolResponse describeWarmPoolResponse = (DescribeWarmPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWarmPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeWarmPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWarmPoolRequestMarshaller(this.protocolFactory)));
            return describeWarmPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$describeWarmPool$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachInstancesResponse detachInstances(DetachInstancesRequest detachInstancesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, detachInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachInstances");
            DetachInstancesResponse detachInstancesResponse = (DetachInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachInstancesRequestMarshaller(this.protocolFactory)));
            return detachInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$detachInstances$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroups(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachLoadBalancerTargetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, detachLoadBalancerTargetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachLoadBalancerTargetGroups");
            DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroupsResponse = (DetachLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerTargetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachLoadBalancerTargetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
            return detachLoadBalancerTargetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$detachLoadBalancerTargetGroups$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachLoadBalancersResponse detachLoadBalancers(DetachLoadBalancersRequest detachLoadBalancersRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachLoadBalancersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, detachLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachLoadBalancers");
            DetachLoadBalancersResponse detachLoadBalancersResponse = (DetachLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachLoadBalancersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachLoadBalancersRequestMarshaller(this.protocolFactory)));
            return detachLoadBalancersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$detachLoadBalancers$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachTrafficSourcesResponse detachTrafficSources(DetachTrafficSourcesRequest detachTrafficSourcesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachTrafficSourcesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachTrafficSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, detachTrafficSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachTrafficSources");
            DetachTrafficSourcesResponse detachTrafficSourcesResponse = (DetachTrafficSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachTrafficSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachTrafficSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachTrafficSourcesRequestMarshaller(this.protocolFactory)));
            return detachTrafficSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$detachTrafficSources$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableMetricsCollectionResponse disableMetricsCollection(DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableMetricsCollectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableMetricsCollectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, disableMetricsCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableMetricsCollection");
            DisableMetricsCollectionResponse disableMetricsCollectionResponse = (DisableMetricsCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableMetricsCollection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableMetricsCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableMetricsCollectionRequestMarshaller(this.protocolFactory)));
            return disableMetricsCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$disableMetricsCollection$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableMetricsCollectionResponse enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableMetricsCollectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableMetricsCollectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, enableMetricsCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableMetricsCollection");
            EnableMetricsCollectionResponse enableMetricsCollectionResponse = (EnableMetricsCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableMetricsCollection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableMetricsCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableMetricsCollectionRequestMarshaller(this.protocolFactory)));
            return enableMetricsCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$enableMetricsCollection$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnterStandbyResponse enterStandby(EnterStandbyRequest enterStandbyRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnterStandbyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enterStandbyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, enterStandbyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnterStandby");
            EnterStandbyResponse enterStandbyResponse = (EnterStandbyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnterStandby").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enterStandbyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnterStandbyRequestMarshaller(this.protocolFactory)));
            return enterStandbyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$enterStandby$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutePolicyResponse executePolicy(ExecutePolicyRequest executePolicyRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExecutePolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, executePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecutePolicy");
            ExecutePolicyResponse executePolicyResponse = (ExecutePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecutePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)executePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecutePolicyRequestMarshaller(this.protocolFactory)));
            return executePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$executePolicy$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExitStandbyResponse exitStandby(ExitStandbyRequest exitStandbyRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExitStandbyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exitStandbyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, exitStandbyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExitStandby");
            ExitStandbyResponse exitStandbyResponse = (ExitStandbyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExitStandby").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)exitStandbyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExitStandbyRequestMarshaller(this.protocolFactory)));
            return exitStandbyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$exitStandby$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPredictiveScalingForecastResponse getPredictiveScalingForecast(GetPredictiveScalingForecastRequest getPredictiveScalingForecastRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetPredictiveScalingForecastResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPredictiveScalingForecastRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, getPredictiveScalingForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPredictiveScalingForecast");
            GetPredictiveScalingForecastResponse getPredictiveScalingForecastResponse = (GetPredictiveScalingForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPredictiveScalingForecast").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPredictiveScalingForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPredictiveScalingForecastRequestMarshaller(this.protocolFactory)));
            return getPredictiveScalingForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$getPredictiveScalingForecast$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLifecycleHookResponse putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest) throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutLifecycleHookResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLifecycleHookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, putLifecycleHookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLifecycleHook");
            PutLifecycleHookResponse putLifecycleHookResponse = (PutLifecycleHookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLifecycleHook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putLifecycleHookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutLifecycleHookRequestMarshaller(this.protocolFactory)));
            return putLifecycleHookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$putLifecycleHook$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutNotificationConfigurationResponse putNotificationConfiguration(PutNotificationConfigurationRequest putNotificationConfigurationRequest) throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutNotificationConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putNotificationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, putNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutNotificationConfiguration");
            PutNotificationConfigurationResponse putNotificationConfigurationResponse = (PutNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutNotificationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putNotificationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutNotificationConfigurationRequestMarshaller(this.protocolFactory)));
            return putNotificationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$putNotificationConfiguration$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScalingPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putScalingPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, putScalingPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutScalingPolicy");
            PutScalingPolicyResponse putScalingPolicyResponse = (PutScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScalingPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putScalingPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller(this.protocolFactory)));
            return putScalingPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$putScalingPolicy$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScheduledUpdateGroupActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putScheduledUpdateGroupActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, putScheduledUpdateGroupActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutScheduledUpdateGroupAction");
            PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupActionResponse = (PutScheduledUpdateGroupActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScheduledUpdateGroupAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putScheduledUpdateGroupActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)));
            return putScheduledUpdateGroupActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$putScheduledUpdateGroupAction$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutWarmPoolResponse putWarmPool(PutWarmPoolRequest putWarmPoolRequest) throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutWarmPoolResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putWarmPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, putWarmPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutWarmPool");
            PutWarmPoolResponse putWarmPoolResponse = (PutWarmPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWarmPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putWarmPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutWarmPoolRequestMarshaller(this.protocolFactory)));
            return putWarmPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$putWarmPool$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeat(RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RecordLifecycleActionHeartbeatResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)recordLifecycleActionHeartbeatRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, recordLifecycleActionHeartbeatRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RecordLifecycleActionHeartbeat");
            RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeatResponse = (RecordLifecycleActionHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecordLifecycleActionHeartbeat").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)recordLifecycleActionHeartbeatRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RecordLifecycleActionHeartbeatRequestMarshaller(this.protocolFactory)));
            return recordLifecycleActionHeartbeatResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$recordLifecycleActionHeartbeat$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeProcessesResponse resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResumeProcessesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resumeProcessesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, resumeProcessesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeProcesses");
            ResumeProcessesResponse resumeProcessesResponse = (ResumeProcessesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeProcesses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resumeProcessesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResumeProcessesRequestMarshaller(this.protocolFactory)));
            return resumeProcessesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$resumeProcesses$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollbackInstanceRefreshResponse rollbackInstanceRefresh(RollbackInstanceRefreshRequest rollbackInstanceRefreshRequest) throws LimitExceededException, ResourceContentionException, ActiveInstanceRefreshNotFoundException, IrreversibleInstanceRefreshException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RollbackInstanceRefreshResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rollbackInstanceRefreshRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, rollbackInstanceRefreshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RollbackInstanceRefresh");
            RollbackInstanceRefreshResponse rollbackInstanceRefreshResponse = (RollbackInstanceRefreshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RollbackInstanceRefresh").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rollbackInstanceRefreshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RollbackInstanceRefreshRequestMarshaller(this.protocolFactory)));
            return rollbackInstanceRefreshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$rollbackInstanceRefresh$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetDesiredCapacityResponse setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetDesiredCapacityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setDesiredCapacityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, setDesiredCapacityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetDesiredCapacity");
            SetDesiredCapacityResponse setDesiredCapacityResponse = (SetDesiredCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetDesiredCapacity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setDesiredCapacityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetDesiredCapacityRequestMarshaller(this.protocolFactory)));
            return setDesiredCapacityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$setDesiredCapacity$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetInstanceHealthResponse setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setInstanceHealthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, setInstanceHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetInstanceHealth");
            SetInstanceHealthResponse setInstanceHealthResponse = (SetInstanceHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceHealth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setInstanceHealthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetInstanceHealthRequestMarshaller(this.protocolFactory)));
            return setInstanceHealthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$setInstanceHealth$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetInstanceProtectionResponse setInstanceProtection(SetInstanceProtectionRequest setInstanceProtectionRequest) throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceProtectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setInstanceProtectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, setInstanceProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetInstanceProtection");
            SetInstanceProtectionResponse setInstanceProtectionResponse = (SetInstanceProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceProtection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setInstanceProtectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetInstanceProtectionRequestMarshaller(this.protocolFactory)));
            return setInstanceProtectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$setInstanceProtection$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartInstanceRefreshResponse startInstanceRefresh(StartInstanceRefreshRequest startInstanceRefreshRequest) throws LimitExceededException, ResourceContentionException, InstanceRefreshInProgressException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartInstanceRefreshResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startInstanceRefreshRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, startInstanceRefreshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInstanceRefresh");
            StartInstanceRefreshResponse startInstanceRefreshResponse = (StartInstanceRefreshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInstanceRefresh").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startInstanceRefreshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartInstanceRefreshRequestMarshaller(this.protocolFactory)));
            return startInstanceRefreshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$startInstanceRefresh$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuspendProcessesResponse suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SuspendProcessesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)suspendProcessesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, suspendProcessesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SuspendProcesses");
            SuspendProcessesResponse suspendProcessesResponse = (SuspendProcessesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SuspendProcesses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)suspendProcessesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SuspendProcessesRequestMarshaller(this.protocolFactory)));
            return suspendProcessesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$suspendProcesses$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TerminateInstanceInAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)terminateInstanceInAutoScalingGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, terminateInstanceInAutoScalingGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateInstanceInAutoScalingGroup");
            TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroupResponse = (TerminateInstanceInAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateInstanceInAutoScalingGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)terminateInstanceInAutoScalingGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateInstanceInAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return terminateInstanceInAutoScalingGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$terminateInstanceInAutoScalingGroup$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAutoScalingGroupResponse updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAutoScalingGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(clientConfiguration, updateAutoScalingGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAutoScalingGroup");
            UpdateAutoScalingGroupResponse updateAutoScalingGroupResponse = (UpdateAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAutoScalingGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAutoScalingGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return updateAutoScalingGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingClient.lambda$updateAutoScalingGroup$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public AutoScalingWaiter waiter() {
        return AutoScalingWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "autoscaling";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        AutoScalingServiceClientConfigurationBuilder serviceConfigBuilder = new AutoScalingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InstanceRefreshInProgress").exceptionBuilderSupplier(InstanceRefreshInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScalingActivityInProgress").exceptionBuilderSupplier(ScalingActivityInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextToken").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExists").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActiveInstanceRefreshNotFound").exceptionBuilderSupplier(ActiveInstanceRefreshNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceContention").exceptionBuilderSupplier(ResourceContentionException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleFailure").exceptionBuilderSupplier(ServiceLinkedRoleFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IrreversibleInstanceRefresh").exceptionBuilderSupplier(IrreversibleInstanceRefreshException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AutoScalingException::builder).build();
    }

    @Override
    public final AutoScalingServiceClientConfiguration serviceClientConfiguration() {
        return new AutoScalingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateAutoScalingGroup$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateInstanceInAutoScalingGroup$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$suspendProcesses$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInstanceRefresh$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setInstanceProtection$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setInstanceHealth$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setDesiredCapacity$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rollbackInstanceRefresh$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resumeProcesses$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$recordLifecycleActionHeartbeat$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putWarmPool$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putScheduledUpdateGroupAction$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putScalingPolicy$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putNotificationConfiguration$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLifecycleHook$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPredictiveScalingForecast$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exitStandby$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executePolicy$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enterStandby$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableMetricsCollection$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableMetricsCollection$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachTrafficSources$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachLoadBalancers$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachLoadBalancerTargetGroups$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachInstances$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWarmPool$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrafficSources$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTerminationPolicyTypes$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScheduledActions$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalingProcessTypes$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalingActivities$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePolicies$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNotificationConfigurations$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMetricCollectionTypes$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancers$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancerTargetGroups$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLifecycleHooks$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLifecycleHookTypes$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLaunchConfigurations$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInstanceRefreshes$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAutoScalingNotificationTypes$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAutoScalingInstances$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAutoScalingGroups$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAdjustmentTypes$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountLimits$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWarmPool$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScheduledAction$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicy$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNotificationConfiguration$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLifecycleHook$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLaunchConfiguration$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAutoScalingGroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOrUpdateTags$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLaunchConfiguration$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAutoScalingGroup$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$completeLifecycleAction$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelInstanceRefresh$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchPutScheduledUpdateGroupAction$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteScheduledAction$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachTrafficSources$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachLoadBalancers$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachLoadBalancerTargetGroups$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachInstances$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

