/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PredefinedLoadMetricType {
    ASG_TOTAL_CPU_UTILIZATION("ASGTotalCPUUtilization"),
    ASG_TOTAL_NETWORK_IN("ASGTotalNetworkIn"),
    ASG_TOTAL_NETWORK_OUT("ASGTotalNetworkOut"),
    ALB_TARGET_GROUP_REQUEST_COUNT("ALBTargetGroupRequestCount"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PredefinedLoadMetricType> VALUE_MAP;
    private final String value;

    private PredefinedLoadMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PredefinedLoadMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PredefinedLoadMetricType> knownValues() {
        EnumSet<PredefinedLoadMetricType> knownValues = EnumSet.allOf(PredefinedLoadMetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PredefinedLoadMetricType.class, PredefinedLoadMetricType::toString);
    }
}

