/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Capacity Reservation preference and targeting options. If you specify <code>open</code> or
 * <code>none</code> for <code>CapacityReservationPreference</code>, do not specify a
 * <code>CapacityReservationTarget</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationSpecification.Builder, CapacityReservationSpecification> {
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationPreference")
            .getter(getter(CapacityReservationSpecification::capacityReservationPreferenceAsString))
            .setter(setter(Builder::capacityReservationPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference")
                    .build()).build();

    private static final SdkField<CapacityReservationTarget> CAPACITY_RESERVATION_TARGET_FIELD = SdkField
            .<CapacityReservationTarget> builder(MarshallingType.SDK_POJO).memberName("CapacityReservationTarget")
            .getter(getter(CapacityReservationSpecification::capacityReservationTarget))
            .setter(setter(Builder::capacityReservationTarget)).constructor(CapacityReservationTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationTarget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_PREFERENCE_FIELD, CAPACITY_RESERVATION_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationPreference;

    private final CapacityReservationTarget capacityReservationTarget;

    private CapacityReservationSpecification(BuilderImpl builder) {
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.capacityReservationTarget = builder.capacityReservationTarget;
    }

    /**
     * <p>
     * The capacity reservation preference. The following options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity Reservation or
     * Capacity Reservation resource group. If capacity isn't available, instances will fail to launch.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity Reservation
     * or Capacity Reservation resource group first. If capacity isn't available, instances will run in On-Demand
     * capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will run in
     * On-Demand capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template or an open
     * Capacity Reservation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return The capacity reservation preference. The following options are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity
     *         Reservation or Capacity Reservation resource group. If capacity isn't available, instances will fail to
     *         launch.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity
     *         Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will run
     *         in On-Demand capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will
     *         run in On-Demand capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template or
     *         an open Capacity Reservation.
     *         </p>
     *         </li>
     * @see CapacityReservationPreference
     */
    public final CapacityReservationPreference capacityReservationPreference() {
        return CapacityReservationPreference.fromValue(capacityReservationPreference);
    }

    /**
     * <p>
     * The capacity reservation preference. The following options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity Reservation or
     * Capacity Reservation resource group. If capacity isn't available, instances will fail to launch.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity Reservation
     * or Capacity Reservation resource group first. If capacity isn't available, instances will run in On-Demand
     * capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will run in
     * On-Demand capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template or an open
     * Capacity Reservation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return The capacity reservation preference. The following options are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity
     *         Reservation or Capacity Reservation resource group. If capacity isn't available, instances will fail to
     *         launch.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity
     *         Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will run
     *         in On-Demand capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will
     *         run in On-Demand capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template or
     *         an open Capacity Reservation.
     *         </p>
     *         </li>
     * @see CapacityReservationPreference
     */
    public final String capacityReservationPreferenceAsString() {
        return capacityReservationPreference;
    }

    /**
     * <p>
     * Describes a target Capacity Reservation or Capacity Reservation resource group.
     * </p>
     * 
     * @return Describes a target Capacity Reservation or Capacity Reservation resource group.
     */
    public final CapacityReservationTarget capacityReservationTarget() {
        return capacityReservationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationSpecification)) {
            return false;
        }
        CapacityReservationSpecification other = (CapacityReservationSpecification) obj;
        return Objects.equals(capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString())
                && Objects.equals(capacityReservationTarget(), other.capacityReservationTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservationSpecification")
                .add("CapacityReservationPreference", capacityReservationPreferenceAsString())
                .add("CapacityReservationTarget", capacityReservationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationPreference":
            return Optional.ofNullable(clazz.cast(capacityReservationPreferenceAsString()));
        case "CapacityReservationTarget":
            return Optional.ofNullable(clazz.cast(capacityReservationTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationPreference", CAPACITY_RESERVATION_PREFERENCE_FIELD);
        map.put("CapacityReservationTarget", CAPACITY_RESERVATION_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationSpecification, T> g) {
        return obj -> g.apply((CapacityReservationSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationSpecification> {
        /**
         * <p>
         * The capacity reservation preference. The following options are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity Reservation
         * or Capacity Reservation resource group. If capacity isn't available, instances will fail to launch.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity
         * Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will run in
         * On-Demand capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will run in
         * On-Demand capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template or an
         * open Capacity Reservation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        The capacity reservation preference. The following options are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity
         *        Reservation or Capacity Reservation resource group. If capacity isn't available, instances will fail
         *        to launch.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity
         *        Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will
         *        run in On-Demand capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will
         *        run in On-Demand capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template
         *        or an open Capacity Reservation.
         *        </p>
         *        </li>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(String capacityReservationPreference);

        /**
         * <p>
         * The capacity reservation preference. The following options are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity Reservation
         * or Capacity Reservation resource group. If capacity isn't available, instances will fail to launch.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity
         * Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will run in
         * On-Demand capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will run in
         * On-Demand capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template or an
         * open Capacity Reservation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        The capacity reservation preference. The following options are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>capacity-reservations-only</code> - Auto Scaling will only launch instances into a Capacity
         *        Reservation or Capacity Reservation resource group. If capacity isn't available, instances will fail
         *        to launch.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservations-first</code> - Auto Scaling will try to launch instances into a Capacity
         *        Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will
         *        run in On-Demand capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - Auto Scaling will not launch instances into a Capacity Reservation. Instances will
         *        run in On-Demand capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default</code> - Auto Scaling uses the Capacity Reservation preference from your launch template
         *        or an open Capacity Reservation.
         *        </p>
         *        </li>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference);

        /**
         * <p>
         * Describes a target Capacity Reservation or Capacity Reservation resource group.
         * </p>
         * 
         * @param capacityReservationTarget
         *        Describes a target Capacity Reservation or Capacity Reservation resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationTarget(CapacityReservationTarget capacityReservationTarget);

        /**
         * <p>
         * Describes a target Capacity Reservation or Capacity Reservation resource group.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservationTarget.Builder}
         * avoiding the need to create one manually via {@link CapacityReservationTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityReservationTarget(CapacityReservationTarget)}.
         * 
         * @param capacityReservationTarget
         *        a consumer that will call methods on {@link CapacityReservationTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationTarget(CapacityReservationTarget)
         */
        default Builder capacityReservationTarget(Consumer<CapacityReservationTarget.Builder> capacityReservationTarget) {
            return capacityReservationTarget(CapacityReservationTarget.builder().applyMutation(capacityReservationTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationPreference;

        private CapacityReservationTarget capacityReservationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationSpecification model) {
            capacityReservationPreference(model.capacityReservationPreference);
            capacityReservationTarget(model.capacityReservationTarget);
        }

        public final String getCapacityReservationPreference() {
            return capacityReservationPreference;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference
                    .toString());
            return this;
        }

        public final CapacityReservationTarget.Builder getCapacityReservationTarget() {
            return capacityReservationTarget != null ? capacityReservationTarget.toBuilder() : null;
        }

        public final void setCapacityReservationTarget(CapacityReservationTarget.BuilderImpl capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget != null ? capacityReservationTarget.build() : null;
        }

        @Override
        public final Builder capacityReservationTarget(CapacityReservationTarget capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget;
            return this;
        }

        @Override
        public CapacityReservationSpecification build() {
            return new CapacityReservationSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
