/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifying information for a traffic source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficSourceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficSourceIdentifier.Builder, TrafficSourceIdentifier> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(TrafficSourceIdentifier::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TrafficSourceIdentifier::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String type;

    private TrafficSourceIdentifier(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * Identifies the traffic source.
     * </p>
     * <p>
     * For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the
     * Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will
     * be the name of the Classic Load Balancer in this account and Region.
     * </p>
     * <p>
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application Load Balancer ARN:
     * <code>arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Classic Load Balancer name: <code>my-classic-load-balancer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * VPC Lattice ARN: <code>arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load
     * Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     * >DescribeTargetGroups</a> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     * >DescribeLoadBalancers</a> API operations.
     * </p>
     * <p>
     * To get the ARN of a target group for VPC Lattice, use the VPC Lattice <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html">GetTargetGroup</a> API
     * operation.
     * </p>
     * 
     * @return Identifies the traffic source.</p>
     *         <p>
     *         For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this
     *         will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load
     *         Balancers, this will be the name of the Classic Load Balancer in this account and Region.
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Application Load Balancer ARN:
     *         <code>arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Classic Load Balancer name: <code>my-classic-load-balancer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VPC Lattice ARN: <code>arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load
     *         Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     *         >DescribeTargetGroups</a> and <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     *         >DescribeLoadBalancers</a> API operations.
     *         </p>
     *         <p>
     *         To get the ARN of a target group for VPC Lattice, use the VPC Lattice <a
     *         href="https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html"
     *         >GetTargetGroup</a> API operation.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Provides additional context for the value of <code>Identifier</code>.
     * </p>
     * <p>
     * The following lists the valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load Balancer,
     * or Network Load Balancer target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Required if the identifier is the name of a Classic Load Balancer.
     * </p>
     * 
     * @return Provides additional context for the value of <code>Identifier</code>.</p>
     *         <p>
     *         The following lists the valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load
     *         Balancer, or Network Load Balancer target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Required if the identifier is the name of a Classic Load Balancer.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficSourceIdentifier)) {
            return false;
        }
        TrafficSourceIdentifier other = (TrafficSourceIdentifier) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficSourceIdentifier").add("Identifier", identifier()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficSourceIdentifier, T> g) {
        return obj -> g.apply((TrafficSourceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficSourceIdentifier> {
        /**
         * <p>
         * Identifies the traffic source.
         * </p>
         * <p>
         * For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be
         * the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers,
         * this will be the name of the Classic Load Balancer in this account and Region.
         * </p>
         * <p>
         * For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Application Load Balancer ARN:
         * <code>arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Classic Load Balancer name: <code>my-classic-load-balancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * VPC Lattice ARN: <code>arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load
         * Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         * >DescribeTargetGroups</a> and <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         * >DescribeLoadBalancers</a> API operations.
         * </p>
         * <p>
         * To get the ARN of a target group for VPC Lattice, use the VPC Lattice <a
         * href="https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html">GetTargetGroup</a>
         * API operation.
         * </p>
         * 
         * @param identifier
         *        Identifies the traffic source.</p>
         *        <p>
         *        For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this
         *        will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load
         *        Balancers, this will be the name of the Classic Load Balancer in this account and Region.
         *        </p>
         *        <p>
         *        For example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Application Load Balancer ARN:
         *        <code>arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Classic Load Balancer name: <code>my-classic-load-balancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VPC Lattice ARN:
         *        <code>arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network
         *        Load Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         *        >DescribeTargetGroups</a> and <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         *        >DescribeLoadBalancers</a> API operations.
         *        </p>
         *        <p>
         *        To get the ARN of a target group for VPC Lattice, use the VPC Lattice <a
         *        href="https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html"
         *        >GetTargetGroup</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Provides additional context for the value of <code>Identifier</code>.
         * </p>
         * <p>
         * The following lists the valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load
         * Balancer, or Network Load Balancer target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Required if the identifier is the name of a Classic Load Balancer.
         * </p>
         * 
         * @param type
         *        Provides additional context for the value of <code>Identifier</code>.</p>
         *        <p>
         *        The following lists the valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>elb</code> if <code>Identifier</code> is the name of a Classic Load Balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elbv2</code> if <code>Identifier</code> is the ARN of an Application Load Balancer, Gateway Load
         *        Balancer, or Network Load Balancer target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-lattice</code> if <code>Identifier</code> is the ARN of a VPC Lattice target group.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Required if the identifier is the name of a Classic Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficSourceIdentifier model) {
            identifier(model.identifier);
            type(model.type);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public TrafficSourceIdentifier build() {
            return new TrafficSourceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
