/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ebs implements SdkPojo, Serializable, ToCopyableBuilder<Ebs.Builder, Ebs> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ebs::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Ebs::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ebs::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Ebs::deleteOnTermination)).setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Ebs::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Ebs::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD, DELETE_ON_TERMINATION_FIELD, IOPS_FIELD, ENCRYPTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final Integer volumeSize;

    private final String volumeType;

    private final Boolean deleteOnTermination;

    private final Integer iops;

    private final Boolean encrypted;

    private Ebs(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.encrypted = builder.encrypted;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume size, in GiB. For <code>standard</code> volumes, specify a value from 1 to 1,024. For <code>io1</code>
     * volumes, specify a value from 4 to 16,384. For <code>gp2</code> volumes, specify a value from 1 to 16,384. If you
     * specify a snapshot, the volume size must be equal to or larger than the snapshot size.
     * </p>
     * <p>
     * Default: If you create a volume from a snapshot and you don't specify a volume size, the default is the snapshot
     * size.
     * </p>
     * 
     * @return The volume size, in GiB. For <code>standard</code> volumes, specify a value from 1 to 1,024. For
     *         <code>io1</code> volumes, specify a value from 4 to 16,384. For <code>gp2</code> volumes, specify a value
     *         from 1 to 16,384. If you specify a snapshot, the volume size must be equal to or larger than the snapshot
     *         size.</p>
     *         <p>
     *         Default: If you create a volume from a snapshot and you don't specify a volume size, the default is the
     *         snapshot size.
     */
    public Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Valid values: <code>standard</code> | <code>io1</code> | <code>gp2</code>
     * </p>
     * 
     * @return The volume type. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a>
     *         in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *         <p>
     *         Valid values: <code>standard</code> | <code>io1</code> | <code>gp2</code>
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * Indicates whether the volume is deleted on instance termination. The default is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the volume is deleted on instance termination. The default is <code>true</code>.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) to provision for the volume.
     * </p>
     * <p>
     * Constraint: Required when the volume type is <code>io1</code>.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS) to provision for the volume.</p>
     *         <p>
     *         Constraint: Required when the volume type is <code>io1</code>.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Indicates whether the volume should be encrypted. Encrypted EBS volumes must be attached to instances that
     * support Amazon EBS encryption. Volumes that are created from encrypted snapshots are automatically encrypted.
     * There is no way to create an encrypted volume from an unencrypted snapshot or an unencrypted volume from an
     * encrypted snapshot. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether the volume should be encrypted. Encrypted EBS volumes must be attached to instances
     *         that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are automatically
     *         encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or an unencrypted
     *         volume from an encrypted snapshot. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ebs)) {
            return false;
        }
        Ebs other = (Ebs) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeType(), other.volumeType())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(iops(), other.iops())
                && Objects.equals(encrypted(), other.encrypted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Ebs").add("SnapshotId", snapshotId()).add("VolumeSize", volumeSize())
                .add("VolumeType", volumeType()).add("DeleteOnTermination", deleteOnTermination()).add("Iops", iops())
                .add("Encrypted", encrypted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ebs, T> g) {
        return obj -> g.apply((Ebs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ebs> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume size, in GiB. For <code>standard</code> volumes, specify a value from 1 to 1,024. For
         * <code>io1</code> volumes, specify a value from 4 to 16,384. For <code>gp2</code> volumes, specify a value
         * from 1 to 16,384. If you specify a snapshot, the volume size must be equal to or larger than the snapshot
         * size.
         * </p>
         * <p>
         * Default: If you create a volume from a snapshot and you don't specify a volume size, the default is the
         * snapshot size.
         * </p>
         * 
         * @param volumeSize
         *        The volume size, in GiB. For <code>standard</code> volumes, specify a value from 1 to 1,024. For
         *        <code>io1</code> volumes, specify a value from 4 to 16,384. For <code>gp2</code> volumes, specify a
         *        value from 1 to 16,384. If you specify a snapshot, the volume size must be equal to or larger than the
         *        snapshot size.</p>
         *        <p>
         *        Default: If you create a volume from a snapshot and you don't specify a volume size, the default is
         *        the snapshot size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>standard</code> | <code>io1</code> | <code>gp2</code>
         * </p>
         * 
         * @param volumeType
         *        The volume type. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume
         *        Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
         *        <p>
         *        Valid values: <code>standard</code> | <code>io1</code> | <code>gp2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Indicates whether the volume is deleted on instance termination. The default is <code>true</code>.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the volume is deleted on instance termination. The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) to provision for the volume.
         * </p>
         * <p>
         * Constraint: Required when the volume type is <code>io1</code>.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) to provision for the volume.</p>
         *        <p>
         *        Constraint: Required when the volume type is <code>io1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Indicates whether the volume should be encrypted. Encrypted EBS volumes must be attached to instances that
         * support Amazon EBS encryption. Volumes that are created from encrypted snapshots are automatically encrypted.
         * There is no way to create an encrypted volume from an unencrypted snapshot or an unencrypted volume from an
         * encrypted snapshot. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the volume should be encrypted. Encrypted EBS volumes must be attached to instances
         *        that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are
         *        automatically encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or
         *        an unencrypted volume from an encrypted snapshot. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private Integer volumeSize;

        private String volumeType;

        private Boolean deleteOnTermination;

        private Integer iops;

        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(Ebs model) {
            snapshotId(model.snapshotId);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
            deleteOnTermination(model.deleteOnTermination);
            iops(model.iops);
            encrypted(model.encrypted);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public Ebs build() {
            return new Ebs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
