/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 instance associated with an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingInstanceDetails.Builder, AutoScalingInstanceDetails> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingInstanceDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingInstanceDetails::autoScalingGroupName)).setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingInstanceDetails::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingInstanceDetails::lifecycleState)).setter(setter(Builder::lifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleState").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingInstanceDetails::healthStatus)).setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingInstanceDetails::launchConfigurationName)).setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(AutoScalingInstanceDetails::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<Boolean> PROTECTED_FROM_SCALE_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AutoScalingInstanceDetails::protectedFromScaleIn)).setter(setter(Builder::protectedFromScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedFromScaleIn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            AUTO_SCALING_GROUP_NAME_FIELD, AVAILABILITY_ZONE_FIELD, LIFECYCLE_STATE_FIELD, HEALTH_STATUS_FIELD,
            LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, PROTECTED_FROM_SCALE_IN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String autoScalingGroupName;

    private final String availabilityZone;

    private final String lifecycleState;

    private final String healthStatus;

    private final String launchConfigurationName;

    private final LaunchTemplateSpecification launchTemplate;

    private final Boolean protectedFromScaleIn;

    private AutoScalingInstanceDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.availabilityZone = builder.availabilityZone;
        this.lifecycleState = builder.lifecycleState;
        this.healthStatus = builder.healthStatus;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the Auto Scaling group for the instance.
     * </p>
     * 
     * @return The name of the Auto Scaling group for the instance.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Availability Zone for the instance.
     * </p>
     * 
     * @return The Availability Zone for the instance.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The lifecycle state for the instance. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
     * Lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The lifecycle state for the instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
     *         Lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public String lifecycleState() {
        return lifecycleState;
    }

    /**
     * <p>
     * The last reported health status of this instance. "Healthy" means that the instance is healthy and should remain
     * in service. "Unhealthy" means that the instance is unhealthy and Amazon EC2 Auto Scaling should terminate and
     * replace it.
     * </p>
     * 
     * @return The last reported health status of this instance. "Healthy" means that the instance is healthy and should
     *         remain in service. "Unhealthy" means that the instance is unhealthy and Amazon EC2 Auto Scaling should
     *         terminate and replace it.
     */
    public String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * The launch configuration used to launch the instance. This value is not available if you attached the instance to
     * the Auto Scaling group.
     * </p>
     * 
     * @return The launch configuration used to launch the instance. This value is not available if you attached the
     *         instance to the Auto Scaling group.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The launch template for the instance.
     * </p>
     * 
     * @return The launch template for the instance.
     */
    public LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     * >Instance Protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
     *         in.</p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     *         >Instance Protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public Boolean protectedFromScaleIn() {
        return protectedFromScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(protectedFromScaleIn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingInstanceDetails)) {
            return false;
        }
        AutoScalingInstanceDetails other = (AutoScalingInstanceDetails) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(lifecycleState(), other.lifecycleState())
                && Objects.equals(healthStatus(), other.healthStatus())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(protectedFromScaleIn(), other.protectedFromScaleIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoScalingInstanceDetails").add("InstanceId", instanceId())
                .add("AutoScalingGroupName", autoScalingGroupName()).add("AvailabilityZone", availabilityZone())
                .add("LifecycleState", lifecycleState()).add("HealthStatus", healthStatus())
                .add("LaunchConfigurationName", launchConfigurationName()).add("LaunchTemplate", launchTemplate())
                .add("ProtectedFromScaleIn", protectedFromScaleIn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "LifecycleState":
            return Optional.ofNullable(clazz.cast(lifecycleState()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatus()));
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "ProtectedFromScaleIn":
            return Optional.ofNullable(clazz.cast(protectedFromScaleIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingInstanceDetails, T> g) {
        return obj -> g.apply((AutoScalingInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingInstanceDetails> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the Auto Scaling group for the instance.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Availability Zone for the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The lifecycle state for the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
         * Lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param lifecycleState
         *        The lifecycle state for the instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Auto
         *        Scaling Lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * The last reported health status of this instance. "Healthy" means that the instance is healthy and should
         * remain in service. "Unhealthy" means that the instance is unhealthy and Amazon EC2 Auto Scaling should
         * terminate and replace it.
         * </p>
         * 
         * @param healthStatus
         *        The last reported health status of this instance. "Healthy" means that the instance is healthy and
         *        should remain in service. "Unhealthy" means that the instance is unhealthy and Amazon EC2 Auto Scaling
         *        should terminate and replace it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The launch configuration used to launch the instance. This value is not available if you attached the
         * instance to the Auto Scaling group.
         * </p>
         * 
         * @param launchConfigurationName
         *        The launch configuration used to launch the instance. This value is not available if you attached the
         *        instance to the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The launch template for the instance.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The launch template for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateSpecification.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         * >Instance Protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param protectedFromScaleIn
         *        Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
         *        in.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         *        >Instance Protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedFromScaleIn(Boolean protectedFromScaleIn);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String autoScalingGroupName;

        private String availabilityZone;

        private String lifecycleState;

        private String healthStatus;

        private String launchConfigurationName;

        private LaunchTemplateSpecification launchTemplate;

        private Boolean protectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingInstanceDetails model) {
            instanceId(model.instanceId);
            autoScalingGroupName(model.autoScalingGroupName);
            availabilityZone(model.availabilityZone);
            lifecycleState(model.lifecycleState);
            healthStatus(model.healthStatus);
            launchConfigurationName(model.launchConfigurationName);
            launchTemplate(model.launchTemplate);
            protectedFromScaleIn(model.protectedFromScaleIn);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final Boolean getProtectedFromScaleIn() {
            return protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        @Override
        public AutoScalingInstanceDetails build() {
            return new AutoScalingInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
